#include "expat_module.h"

static int read_external_dtd;

/*
  These are the external interfaces
*/
char PyParse_doc[] = "\
parse(isrc, readExtDtd[, parseAsEntity]) -> Document";

PyObject *PyParse(PyObject *self, PyObject *args) {
  PyObject *_argc0, *result;
  int readExtDtd, parseAsEntity;

  if(!PyArg_ParseTuple(args, "Oi|i:parse", &_argc0, &readExtDtd, &parseAsEntity))
    return NULL;
#ifdef DEBUG_PARSER
  fprintf(stderr, "Start parsing.\n");
#endif

  result = beginParse(_argc0, readExtDtd, parseAsEntity);

#ifdef DEBUG_PARSER
  fprintf(stderr,"Finished parsing\n");
#endif

  return result;
}

char NonvalParse_doc[] = "\
nonvalParse(isrc[, readExtDtd[, parseAsEntity]]) -> Document";

PyObject *Domlette_NonvalParse(PyObject *self, PyObject *args, PyObject *kw)
{
  PyObject *isrc, *readExtDtd=NULL, *parseAsEntity=NULL;
  static char *kwlist[] = {"isrc", "readExtDtd", "parseAsEntity", NULL};
  int read_ext_dtd=read_external_dtd, parse_as_entity=0;
  PyObject *result;

  if (!PyArg_ParseTupleAndKeywords(args, kw, "O|OO:nonvalParse", kwlist, 
                                   &isrc, &readExtDtd, &parseAsEntity))
    return NULL;

  if (readExtDtd) {
    read_ext_dtd = PyObject_IsTrue(readExtDtd);
    if (read_ext_dtd == -1) return NULL;
  }
  if (parseAsEntity) {
    parse_as_entity = PyObject_IsTrue(parseAsEntity);
    if (parse_as_entity == -1) return NULL;
  }

#ifdef DEBUG_PARSER
  fprintf(stderr, "Start parsing.\n");
#endif

  result = beginParse(isrc, read_ext_dtd, parse_as_entity);

#ifdef DEBUG_PARSER
  fprintf(stderr,"Finished parsing\n");
#endif

  return result;
}


int DomletteReader_Init(void)
{
  PyObject *module;
  PyObject *constant;

  module = PyImport_ImportModule("Ft.Xml");
  if (module == NULL) return -1;

  constant = PyObject_GetAttrString(module, "READ_EXTERNAL_DTD");
  if (constant == NULL) return -1;

  read_external_dtd = PyObject_IsTrue(constant);
  if (read_external_dtd == -1) return -1;

  return 0;
}

void DomletteReader_Fini(void)
{
  /* no cleanup to perform */
}
