#include "expat_module.h"
#include "parse_event_handler.h"
#include "xptr.h"

#undef DEBUG_XPTR

#define ELEMENT_MATCH 1
#define ELEMENT_COUNT 2
#define ATTRIBUTE_MATCH 3

static void xptrStartElementHandler(void *userState, void *params);
static void xptrEndElementHandler(void *userState, void *params);


/* StateTableEntry destructor for PyObjects */
static void free_object(void *ptr) { Py_DECREF((PyObject *)ptr); }


/* Returns the start state number for the XPointer or 0 for failure */
unsigned long handle_xpointer(ParserState *state, PyObject *xptr_spec)
{
  int i, length, new_start_state=0;
  PyObject *states;

    /* Set up base state (equivalent of PARSE_STREAM_STATE for this XInclude) */
    states = PyObject_GetAttrString(xptr_spec, "states");
    length = PySequence_Length(states);
    for (i=0; i < length; i++){
      PyObject *tuple = PySequence_GetItem(states, i);
      short prev_base = (short)PyInt_AsLong(PySequence_GetItem(tuple, 0));
      short prev_start = prev_base == PARSE_STREAM_STATE ? PARSE_STREAM_STATE : prev_base + 1;
      short prev_end = prev_start + 1;
      short base = (short)PyInt_AsLong(PySequence_GetItem(tuple, 1));
      short start = (short)PyInt_AsLong(PySequence_GetItem(tuple, 2));
      short end = (short)PyInt_AsLong(PySequence_GetItem(tuple, 3));
      PyObject *params = PySequence_GetItem(tuple, 4);
      short *state_id;

      if (new_start_state == 0) new_start_state = base;

      if (StateTable_AddState(state, base) == 0)
        return 0;

      /* Set up start element handler */
      if (StateTable_AddStateWithHandlerParams(state, start,
                                               xptrStartElementHandler,
                                               params, free_object) == 0)
        return 0;

      if (i == length - 1) {
        /* Final state */
        if (StateTable_AddTransition(state, start, XPTR_MATCH_EVENT,
                                     START_ELEMENT_CALLBACK) == 0)
          return 0;
      }
      if (!StateTable_AddTransition(state, prev_start, XPTR_MATCH_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, START_NS_SCOPE_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, COMMENT_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, PI_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, CHARACTER_DATA_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, START_ELEMENT_EVENT, start))
        return 0;
      if (!StateTable_AddTransition(state, base, PARSE_RESUME_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, start, PARSE_RESUME_EVENT, base))
        return 0;

      /* Set up end element handler */
      state_id = (short *)malloc(sizeof(short));
      if (state_id == NULL) {
        PyErr_NoMemory();
        return 0;
      }
      *state_id = (short)(i ? base : prev_base);

      if (StateTable_AddStateWithHandlerParams(state, end,
                                               xptrEndElementHandler,
                                               state_id, free) == 0) {
        free(state_id);
        return 0;
      }

      if (!StateTable_AddTransition(state, base, END_ELEMENT_EVENT, base))
        return 0;
      if (!StateTable_AddTransition(state, base, XPTR_CLOSE_EVENT, prev_end))
        return 0;

      if (i == length - 1) {
        /* Final state */
        if (StateTable_AddTransition(state, END_ELEMENT_CALLBACK,
                                     XPTR_CLOSE_EVENT, base) == 0)
          return 0;
      }
    }
    return new_start_state;
}


void xptrStartElementHandler(void *userState, void *params)
{
  ParserState *state = (ParserState *)userState;
  PyObject *criterion, *criterion_code, *criteria = (PyObject *)params;
  PyObject *test_uri, *test_local, *test_value, *value;
  PyObject *target_count, *counter_list, *counter, *one=PyInt_FromLong(1);
  UniversalName *un;
  int i, length, match=1;
  Py_INCREF(one);

  length = PySequence_Length(criteria);
  for (i=0; i < length && match; i++) {
    criterion = PySequence_GetItem(criteria, i);
    criterion_code = PySequence_GetItem(criterion, 0);
    switch (PyInt_AsLong(criterion_code)) {

    case ELEMENT_MATCH:
      test_uri = PySequence_GetItem(criterion, 1);  /* new reference */
      test_local = PySequence_GetItem(criterion, 2); /* new reference */

      /* Call build universal name to get the current NS. */
      un = buildUniversalName(state->expat_name);
      if (un == NULL) {
        Py_DECREF(test_uri);
        Py_DECREF(test_local);
        Py_DECREF(criterion_code);
        Py_DECREF(criterion);
        StateTable_SignalError(state);
        return;
      }
#ifdef DEBUG_XPTR
	fprintf(stderr, "ELEMENT_MATCH:\n  test_uri: ");
	PyObject_Print(test_uri, stderr, Py_PRINT_RAW);
	fprintf(stderr, "\n  test_local: ");
	PyObject_Print(test_local, stderr, Py_PRINT_RAW);
	fprintf(stderr, "\n  un->uri: ");
	PyObject_Print(un->uri, stderr, Py_PRINT_RAW);
	fprintf(stderr, "\n  un->local: ");
	PyObject_Print(un->local, stderr, Py_PRINT_RAW);
	fprintf(stderr, "\n");
#endif
      if (PyObject_Compare(un->uri, test_uri) ||
          PyObject_Compare(un->local, test_local)){
        match = 0;
      }

      Py_DECREF(test_uri);
      Py_DECREF(test_local);
      destroyUniversalName(un);
      break;

    case ELEMENT_COUNT:
      target_count = PySequence_GetItem(criterion, 1); /* new reference */
      counter_list = PySequence_GetItem(criterion, 2); /* new reference */
      counter = PySequence_GetItem(counter_list, 0); /* new reference */

      if (PyObject_Compare(counter, target_count)){
        match = 0;
      }
      Py_DECREF(counter);

      counter = PyNumber_InPlaceAdd(counter, one); /* new reference */
      PyList_SetItem(counter_list, 0, counter);

      Py_DECREF(target_count);
      Py_DECREF(counter_list);
      Py_DECREF(counter);
      break;

    case ATTRIBUTE_MATCH:
      test_uri = PySequence_GetItem(criterion, 1);
      test_local = PySequence_GetItem(criterion, 2);
      test_value = PySequence_GetItem(criterion, 3);

      if (test_uri == Py_None) {
        /* bare name; OK to find the attribute directly */
        value = PyDict_GetItem(state->expat_atts, test_local); /* borrowed */
      } else {
        int pos = 0;
        PyObject *nssep = PyUnicode_FromUnicode(NULL, 1);
        PyObject *expat_name;

        /* Create the unicode object separator character for contains */
        if (!nssep) {
          Py_DECREF(test_uri);
          Py_DECREF(test_local);
          Py_DECREF(test_value);
          Py_DECREF(criterion_code);
          Py_DECREF(criterion);
          StateTable_SignalError(state);
          return;
        }

        PyUnicode_AS_UNICODE(nssep)[0] = EXPAT_NSSEP;

        while (PyDict_Next(state->expat_atts, &pos, &expat_name, &value)) {
          /* only test attribute names that have a namespace */
          if (PyUnicode_Contains(expat_name, nssep) > 0) {
            un = buildUniversalName(expat_name);
            if (un == NULL) {
              Py_DECREF(nssep);
              Py_DECREF(test_uri);
              Py_DECREF(test_local);
              Py_DECREF(test_value);
              Py_DECREF(criterion_code);
              Py_DECREF(criterion);
              StateTable_SignalError(state);
              return;
            }
            if (!PyObject_Compare(un->uri, test_uri) &&
                !PyObject_Compare(un->local, test_local)) {
              /* we found the attribute */
              destroyUniversalName(un);
              break;
            }
            destroyUniversalName(un);
          }
        }

        Py_DECREF(nssep);
        if (pos == PyDict_Size(state->expat_atts)) {
          /* we made it all the way through without a match */
          value = NULL;
        }
      }

      if (!value || PyObject_Compare(value, test_value)) {
        match = 0;
      }
      Py_DECREF(test_uri);
      Py_DECREF(test_local);
      Py_DECREF(test_value);
      break;

    default:
      PyErr_Format(PyExc_ValueError, "Bad typecode: %ld",
                   PyInt_AsLong(criterion_code));
      Py_DECREF(criterion_code);
      Py_DECREF(criterion);
      StateTable_SignalError(state);
      return;
    }
    Py_DECREF(criterion_code);
    Py_DECREF(criterion);
  }

  if (match) {
    *state->curr_elem_depth_event = XPTR_CLOSE_EVENT;
    StateTable_Transit(state, XPTR_MATCH_EVENT);
  }
}


/* simply transition to a new state, */
static void xptrEndElementHandler(void *userState, void *params)
{
  short *state_id = (short *)params;
  StateTable_Transit(userState, *state_id);
}


/* unused function -- removed 2003-07-23 JK -- */
/*
static void endXptrStartElemHandler(void *userState, void *params)
{
  ParserState *state = (ParserState *)userState;
  PyObject *xptr_params = (PyObject *)params;
  PyObject *code;
  PyObject *test_uri;
  PyObject *test_local;
  UniversalName *un;

  code = PySequence_GetItem(xptr_params, 0);
  switch (PyInt_AsLong(code)) {
  case ELEMENT_MATCH:
    test_uri = PySequence_GetItem(xptr_params, 1);
    test_local = PySequence_GetItem(xptr_params, 2);
    / * Call build universal name to get the current NS. * /
    un = buildUniversalName(state->expat_name);
    if (!un) {
      Py_DECREF(test_local);
      Py_DECREF(test_uri);
      Py_DECREF(code);
      StateTable_SignalError(state);
      return;
    }
    if (!PyObject_Compare(un->uri, test_uri) &&
        !PyObject_Compare(un->local, test_local)){
      StateTable_Transit(state, XPTR_MATCH_EVENT);
    }
    destroyUniversalName(un);
    Py_DECREF(test_local);
    Py_DECREF(test_uri);
    break;
  default:
    PyErr_Format(PyExc_ValueError, "Bad typecode: %d",
                 PyInt_AsLong(criterion_code));
    Py_DECREF(code);
    StateTable_SignalError(state);
    return;
  }

  Py_DECREF(code);
}


*/
