'''An example of 4RDF schema support'''

from Ft.Rdf.RdfsHandler import RdfsConstraintViolation
from Ft.Xml.Domlette import NonvalidatingReader
from Ft.Lib import Uri


def SchemaDemo():
    from Ft.Rdf.Drivers import Memory
    db = Memory.CreateDb('test')
    db.begin()

    from Ft.Rdf import Model, RdfsHandler, Statement
    sh = RdfsHandler.RdfsHandler()
    m = Model.Model(db, sh)

    #The model should start out with all the RDF meta-model
    print "New model seeded with RDF meta-model statements\n"
    print m.complete(None, None, None)

    #Read in the schema just as any other RDF
    file_uri = Uri.OsPathToUri('spamschema.rdfs', attemptAbsolute=1)
    schemadoc = NonvalidatingReader.parseUri(file_uri)

    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    
    #When we do a batch add like this, turn off schema so that we can add them all more quickly
    #Then check them
    m.suspendSchema()
    serializer.deserialize(m, schemadoc, 'http://schema.spam.com')
    m.resumeSchema()
    m.checkConsistency()
    
    print "Model with user's RDF schema read in\n"
    print m.complete(None, None, None)

    #Read in the RDF data, here we won't suspend schema.
    file_uri = Uri.OsPathToUri('spamdata.rdfs', attemptAbsolute=1)
    doc = NonvalidatingReader.parseUri(file_uri)
    serializer.deserialize(m, doc, 'http://spam.com/data')


    print "Model with user's RDF data read in\n"
    print m.complete(None, None, None)

    print sh.isInstance('http://rblrebels.com/~robelee', 'http://schema.spam.com#Person')
    print sh.isInstance('http://rblrebels.com/~spartacus', 'http://schema.spam.com#Person')
    print sh.isSubClass('http://schema.spam.com#Moderator', 'http://schema.spam.com#Person')

    #Try to add a statement that violates constraints
    #represents has a range of http://schema.spam.com#Organization
    s = Statement.Statement('http://rblrebels.com/~robelee', 'http://schema.spam.com#represents', 'ILLEGAL')
    print m.complete('http://rblrebels.com/~spartacus', 'http://schema.spam.com#represents', None)
    print m.complete('http://schema.spam.com#represents', None, None)

    print "--------------------------------------------------"
    print "If schemas are truely working, then this line should raise an exception"
    print "--------------------------------------------------"
    try:
       m.add(s)
    
       #This will never get called
       db.commit()
    except RdfsConstraintViolation, e:
       print "RdfsConstraintViolation exception raised as expected:"
       print e
    return


if __name__ == '__main__':
    SchemaDemo()
