#!/usr/bin/env python

from Ft.Xml.Xslt import Processor, StylesheetReader, DomWriter
from Ft.Xml import Domlette
from Ft.Xml.Lib import Print
from xml.dom import Node
import string

GETPATH_XSLT = 'paths.xsl'
CONTROL_FILE = 'ftdocs.xml'

def getRelativePath(src, target):
    if type(src) in (type(''), type(u'')):
        src = string.split(src,'/')
    if type(target) in (type(''), type(u'')):
        target = string.split(target,'/')
        print 'split target:', target
    if src[0] == target[0]:
        return getRelativePath(src[1:],target[1:])
    else:
        for i in range(len(src) - 1):
            try:
                target.insert(0,'..')
            except AttributeError:
                pass
        return string.join(target,'/')

## Obtain a list of paths as a DOM document fragment
proc = Processor.Processor()
proc.appendStylesheetUri(GETPATH_XSLT)
wri = DomWriter.DomWriter()
inputdom = proc.runUri(CONTROL_FILE,writer=wri)

pathtable = []
inputroot = inputdom.firstChild
for n in inputroot.childNodes:
    if n.nodeType == Node.ELEMENT_NODE and n.nodeName == 'doc':
        id = n.getAttributeNS(None,'id')
        path = n.getAttributeNS(None,'path')
        pathtable.append((id,path))

dimple = Domlette.implementation
pathdom = dimple.createDocument(None,'paths',None)
outputroot = pathdom.documentElement

for i in range(len(pathtable)):
    sid, spath = pathtable[i]
    others = pathtable[:i] + pathtable[i+1:]
    srcelt = pathdom.createElementNS(None,'src')
    outputroot.appendChild(srcelt)
    srcelt.setAttributeNS(None,'srcid', sid)
    srcelt.setAttributeNS(None,'path', spath)
    for tid, tpath in others:
        targetelt = pathdom.createElementNS(None,'target')
        srcelt.appendChild(targetelt)
        targetelt.setAttributeNS(None,'targetid',tid)
        targetelt.setAttributeNS(None,'path',getRelativePath(spath,tpath))

Print.PrettyPrint(pathdom)
