########################################################################
#
# File Name: 	       Attribute.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Attribute.py.html
#
"""
Implements the Attribute meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import Property
from Ft.Ods.MetaData import MetaKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Attribute(Property.Property):
    def __init__(self,db,data):
        Property.Property.__init__(self, db,data, MetaKind.mk_attribute)

        if data is None:
            self.__dict__['is_read_only'] = 0


    def _4ods_getOdl(self,indent):
        ro = ''
        if self.is_read_only:
            ro = 'readonly '

        if self.type.meta_kind == MetaKind.mk_collection:
            return indent+'%sattribute %s %s'  % (ro,self.type._4ods_getOdl(''),self.name)
        else:
            return indent+'%sattribute %s %s' % (ro,self.type.absolute_name(),self.name)

    def _4ods_checkRemove(self):
        return 1

    def _4ods_getGeneratedMetaClasses(self,found,checked):
        if self in checked: return
        checked.append(self)
        self.type._4ods_getGeneratedMetaClasses(found,checked)


    _tupleNames = (('is_read_only',),)

    _tupleDefinitions = {'is_read_only':{td.TYPE:Constants.Types.BOOLEAN,
                                         },
                         }

    _localExtents = ()
