########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Create/__init__.py,v 1.9 2004/10/21 15:06:15 uogbuji Exp $
"""
Implementation of '4ss create' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command will create a resource in a 4Suite repository. \
It requires a subcommand specifying which type of resource to create. \
See the help message for one of the subcommands for specific usage info."""

# command modules to register as subcommands
import Alias
import Container
import Document
import Group
import RawFile
import UriReference
import User
import Server

g_subCommands = [Alias,
                 Container,
                 Document,
                 Group,
                 RawFile,
                 UriReference,
                 User,
                 Server,
                 ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('create',
                          "Create a resource in a repository",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )
    return cmd
