<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc rdf bbschema">
  <!-- don't exclude bb prefix -->

  <!--
File:  submit-customer.xslt

Description:

    This stylesheet uses form data submitted from the add/edit customer
    page in order to either generate a new customer XML document in the
    repo, or to produce an XUpdate document that is applied to an
    existing customer document.

    This stylesheet can be applied to any XML source document, as long
    as the necessary form data comes in through the top-level params.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:output method="xml"/>

  <xsl:param name="id"/>
  <xsl:param name="fullname"/>
  <xsl:param name="employer"/>
  <xsl:param name="profession"/>
  <xsl:param name="email"/>
  <xsl:param name="address"/>
  <xsl:param name="city"/>
  <xsl:param name="state"/>
  <xsl:param name="zip"/>
  <xsl:param name="homePhone"/>
  <xsl:param name="workPhone"/>
  <xsl:param name="actionToDo"/>
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="fres:absolute-path"/>

  <xsl:variable name="new-id" select="f:generate-uuid()"/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="fcore:has-session()">
        <fhttp:response-uri uri='/buyerbase/?xslt=index.xslt'/>
        <xsl:choose>
          <xsl:when test="$actionToDo = 'xupdate'">
            <xsl:call-template name="update"/>
          </xsl:when>
          <xsl:when test="$actionToDo = 'delete'">
            <fcore:delete-resource/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="new"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="update">
    <fcore:x-update>
      <xupdate:modifications version="1.0" xmlns:xupdate="http://www.xmldb.org/xupdate">
        <xupdate:update select="/bb:customer/bb:fullname"><xsl:value-of select="$fullname"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:email"><xsl:value-of select="$email"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:employer"><xsl:value-of select="$employer"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:profession"><xsl:value-of select="$profession"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:phone[@desc='home']"><xsl:value-of select="$homePhone"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:phone[@desc='work']"><xsl:value-of select="$workPhone"/></xupdate:update>
        <xupdate:update select="/bb:customer/bb:address"><xsl:value-of select="$address"/></xupdate:update>
        <xupdate:append select="/bb:customer/bb:address">
          <xupdate:element name="city" namespace="&bb;">
            <xsl:value-of select="$city"/>
          </xupdate:element>
          <xupdate:element name="state" namespace="&bb;">
            <xsl:value-of select="$state"/>
          </xupdate:element>
          <xupdate:element name="zip" namespace="&bb;">
            <xsl:value-of select="$zip"/>
          </xupdate:element>
        </xupdate:append>
      </xupdate:modifications>
    </fcore:x-update>
  </xsl:template>

  <xsl:template name="new">
    <fcore:create-document path='{$new-id}' base-path='data' docdef="../customer-dd">
      <bb:customer id="{$new-id}">
        <bb:fullname><xsl:value-of select="$fullname"/></bb:fullname>
        <bb:address>
          <xsl:value-of select="$address"/>
          <bb:city><xsl:value-of select="$city"/></bb:city>
          <bb:state><xsl:value-of select="$state"/></bb:state>
          <bb:zip><xsl:value-of select="$zip"/></bb:zip>
        </bb:address>
        <bb:phone desc="home"><xsl:value-of select="$homePhone"/></bb:phone>
        <bb:phone desc="work"><xsl:value-of select="$workPhone"/></bb:phone>
        <bb:email><xsl:value-of select="$email"/></bb:email>
        <bb:employer><xsl:value-of select="$employer"/></bb:employer>
        <bb:profession><xsl:value-of select="$profession"/></bb:profession>
      </bb:customer>
    </fcore:create-document>
  </xsl:template>

</xsl:stylesheet>
