import sys, os
p = os.path.join("..","..")
sys.path.append(p)
import profile_util


def do_delete():
    repo = profile_util.GetRepo()
    repo.deleteResource('/profile/cont')
    repo.txCommit()


NUM_CHILDREN = 2500
XML_SRC = """<docelem><one>Foo</one>%s<two>Bar</two></docelem>""" % ("<child/>"*NUM_CHILDREN)



def do_profile():

    #Init
    repo = profile_util.GetRepo()
    if repo.hasResource('/profile'):
        repo.deleteResource('/profile')
    repo.createContainer('/profile',1)
    repo.createContainer('/profile/cont',1)
    repo.createDocument('/profile/cont/doc',XML_SRC)
    repo.txCommit()

    profile_util.run("do_delete()",globals(),locals())



if __name__ == '__main__':
    profile_util.InitRepo()
    do_profile()
