

from Ft.Server.Common import ResourceTypes
import test_helper

def test_create(tester):


    tester.startTest("Create document with a UUID")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.createDocument('',DOC1,forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)
    tester.compare(ResourceTypes.ResourceType.XML_DOCUMENT,test.hasResource(doc.getAbsolutePath()))
    global uuid
    uuid = doc.getPath()
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    tester.compare(ResourceTypes.ResourceType.XML_DOCUMENT,test.hasResource(uuid.absolutePath))
    repo.txRollback()

    tester.testDone()
    return



def test_access(tester):

    tester.startTest("UUID Document Access")

    repo = test_helper.GetRepo(tester)
    sheet = repo.fetchResource(uuid.absolutePath)
    tester.compare('text/xml',sheet.getImt())
    tester.compare(DOC1,sheet.getContent())
    repo.txRollback()
    tester.testDone()


def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()


DOC1="""<docelem v='foo'/>"""



def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)


