import os
from Server import Core
from Server.Protocols.CORBA import FtOmniorb

def getFiles(module):
    files = []
    for file in os.listdir(os.path.dirname(module.__file__)):
        if not os.path.isfile(file):
            # ignore directories
            continue
        if file[-3:] != os.sep + 'py':
            # ignore non-python files
            continue

        file = file[:-3]
        if file != '__init__':
            files.append(file[:-3])

    dirs, files = module.PreprocessFiles([], files)
    return files

def Test(tester):
    # Do a check of files in Core to see what is missing
    tester.startTest('CORBA wrapper files')

    omniorb_files = getFiles(FtOmniorb)
    core_files = getFiles(Core)
    
    for file in core_files:
        if file not in omniorb_files:
            tester.warning("test %s does not have a CORBA wrapper" % file)
    tester.testDone()
    return
