import copy

_setups_defaults = {
    'minimal': {
        'K': '_pv',
        'Ca': '_pv',
        'Rb': '_pv',
        'Sr': '_sv',
        'Y': '_sv',
        'Zr': '_sv',
        'Nb': '_pv',
        'Cs': '_sv',
        'Ba': '_sv',
        'Fr': '_sv',
        'Ra': '_sv',
        'Sc': '_sv'
    },

    # VASP recommended
    'recommended': {
        'Li': '_sv',
        'Na': '_pv',
        'K': '_sv',
        'Ca': '_sv',
        'Sc': '_sv',
        'Ti': '_sv',
        'V': '_sv',
        'Cr': '_pv',
        'Mn': '_pv',
        'Ga': '_d',
        'Ge': '_d',
        'Rb': '_sv',
        'Sr': '_sv',
        'Y': '_sv',
        'Zr': '_sv',
        'Nb': '_sv',
        'Mo': '_sv',
        'Tc': '_pv',
        'Ru': '_pv',
        'Rh': '_pv',
        'In': '_d',
        'Sn': '_d',
        'Cs': '_sv',
        'Ba': '_sv',
        'Pr': '_3',
        'Nd': '_3',
        'Pm': '_3',
        'Sm': '_3',
        'Eu': '_2',
        'Gd': '_3',
        'Tb': '_3',
        'Dy': '_3',
        'Ho': '_3',
        'Er': '_3',
        'Tm': '_3',
        'Yb': '_2',
        'Lu': '_3',
        'Hf': '_pv',
        'Ta': '_pv',
        'W': '_sv',
        'Tl': '_d',
        'Pb': '_d',
        'Bi': '_d',
        'Po': '_d',
        'At': '_d',
        'Fr': '_sv',
        'Ra': '_sv'
    },

    # https://wiki.materialsproject.org/Pseudopotentials_Choice
    'materialsproject':
    # Alkali and alkali-earth
    {
        'Li': '_sv',
        'Na': '_pv',
        'K': '_sv',
        'Cs': '_sv',
        'Rb': '_sv',
        'Be': '_sv',
        'Mg': '_pv',
        'Ca': '_sv',
        'Sr': '_sv',
        'Ba': '_sv',
        # d-elements, transition metals
        'Sc': '_sv',
        'Y': '_sv',
        'Ti': '_pv',
        'Zr': '_sv',
        'Hf': '_pv',
        'V': '_sv',
        'Nb': '_pv',
        'Ta': '_pv',
        'Cr': '_pv',
        'Mo': '_pv',
        'W': '_sv',  # updated from W_pv
        'Mn': '_pv',
        'Tc': '_pv',
        'Re': '_pv',
        'Fe': '_pv',
        'Co': '',
        'Ni': '_pv',
        'Cu': '_pv',
        'Zn': '',
        'Ru': '_pv',
        'Rh': '_pv',
        'Pd': '',
        'Ag': '',
        'Cd': '',
        'Hg': '',
        'Ir': '',
        'Pt': '',
        'Os': '_pv',
        # Main group
        'Ga': '_d',
        'Ge': '_d',
        'Al': '',
        'As': '',
        'Se': '',
        'Br': '',
        'In': '_d',
        'Sn': '_d',
        'Tl': '_d',
        'Pb': '_d',
        'Bi': '_d',  # ?
        'Po': '',
        'At': '_d',
        # Rare-earth, f-electrons
        'La': '',
        'Ce': '',
        'Pr': '_3',
        'Nd': '_3',
        'Pm': '_3',
        'Sm': '_3',
        'Eu': '',
        'Gd': '',
        'Tb': '_3',
        'Dy': '_3',
        'Ho': '_3',
        'Er': '_3',
        'Tm': '_3',
        'Yb': '',
        'Lu': '_3'
    },

    #
    'gw': {
        'H': '_GW',
        'He': '_GW',
        'Li': '_sv_GW',
        'Be': '_sv_GW',
        'B': '_GW',
        'C': '_GW',
        'N': '_GW',
        'O': '_GW',
        'F': '_GW',
        'Ne': '_GW',
        'Na': '_sv_GW',
        'Mg': '_sv_GW',
        'Al': '_GW',
        'Si': '_GW',
        'P': '_GW',
        'S': '_GW',
        'Cl': '_GW',
        'Ar': '_GW',
        'K': '_sv_GW',
        'Ca': '_sv_GW',
        'Sc': '_sv_GW',
        'Ti': '_sv_GW',
        'V': '_sv_GW',
        'Cr': '_sv_GW',
        'Mn': '_sv_GW',
        'Fe': '_sv_GW',
        'Co': '_sv_GW',
        'Ni': '_sv_GW',
        'Cu': '_sv_GW',
        'Zn': '_sv_GW',
        'Ga': '_d_GW',
        'Ge': '_d_GW',
        'As': '_GW',
        'Se': '_GW',
        'Br': '_GW',
        'Kr': '_GW',
        'Rb': '_sv_GW',
        'Sr': '_sv_GW',
        'Y': '_sv_GW',
        'Zr': '_sv_GW',
        'Nb': '_sv_GW',
        'Mo': '_sv_GW',
        'Tc': '_sv_GW',
        'Ru': '_sv_GW',
        'Rh': '_sv_GW',
        'Pd': '_sv_GW',
        'Ag': '_sv_GW',
        'Cd': '_sv_GW',
        'In': '_d_GW',
        'Sn': '_d_GW',
        'Sb': '_d_GW',
        'Te': '_GW',
        'I': '_GW',
        'Xe': '_GW',
        'Cs': '_sv_GW',
        'Ba': '_sv_GW',
        'La': '_GW',
        'Ce': '_GW',
        'Hf': '_sv_GW',
        'Ta': '_sv_GW',
        'W': '_sv_GW',
        'Re': '_sv_GW',
        'Os': '_sv_GW',
        'Ir': '_sv_GW',
        'Pt': '_sv_GW',
        'Au': '_sv_GW',
        'Hg': '_sv_GW',
        'Tl': '_d_GW',
        'Pb': '_d_GW',
        'Bi': '_d_GW',
        'Po': '_d_GW',
        'At': '_d_GW',
        'Rn': '_d_GW'
    }
}


def get_default_setups():
    # Avoid mutating the module dictionary, so we use a copy instead
    # Note, it is a nested dict, so a regular copy is not enough
    return copy.deepcopy(_setups_defaults)


# Compatibility
setups_defaults = get_default_setups()
