"""
Experimental ionization energies from CCCBDB at
http://srdata.nist.gov/cccbdb/default.htm

Information presented on these pages is considered public information
and may be distributed or copied http://www.nist.gov/public_affairs/disclaimer.cfm
"""
IP = {# System     IE    IE_vert
    'H'         : (13.60,  None),
    'Li'        : ( 5.39,  None),
    'Be'        : ( 9.32,  None),
    'B'         : ( 8.30,  None),
    'C'         : (11.26,  None),
    'N'         : (14.53,  None),
    'O'         : (13.62,  None),
    'F'         : (17.42,  None),
    'Na'        : ( 5.14,  None),
    'Mg'        : ( 7.65,  None),
    'Al'        : ( 5.99,  None),
    'Si'        : ( 8.15,  None),
    'P'         : (10.49,  None),
    'S'         : (10.36,  None),
    'Cl'        : (12.97,  None),
    'LiH'       : ( 7.90,  None),
    'BeH'       : ( 8.21,  None),
    'CH'        : (10.64,  None),
    'CH2_s3B1d' : (10.40,  None),
    'CH3'       : ( 9.84,  None),
    'CH4'       : (12.61, 13.60),
    'NH'        : (13.10, 13.49),
    'NH2'       : (10.78, 12.00),
    'NH3'       : (10.07, 10.82),
    'OH'        : (13.02,  None),
    'H2O'       : (12.62,  None),
    'HF'        : (16.03, 16.12),
    'SiH2_s1A1d': ( 8.92,  None),
    'SiH3'      : ( 8.14,  8.74),
    'SiH4'      : (11.00, 12.30),
    'PH2'       : ( 9.82,  None),
    'PH3'       : ( 9.87, 10.95),
    'SH2'       : (10.46, 10.50),
    'HCl'       : (12.74,  None),
    'Li2'       : ( 5.11,  None),
    'LiF'       : (11.30,  None),
    'C2H2'      : (11.40, 11.49),
    'C2H4'      : (10.51, 10.68),
    'CN'        : (13.60,  None),
    'HCN'       : (13.60, 13.61),
    'CO'        : (14.01, 14.01),
    'HCO'       : ( 8.12,  9.31),
    'H2CO'      : (10.88, 10.88),
    'CH3OH'     : (10.84, 10.96),
    'N2'        : (15.58, 15.58),
    'N2H4'      : ( 8.10,  8.98),
    'NO'        : ( 9.26,  9.26),
    'O2'        : (12.07, 12.30),
    'H2O2'      : (10.58, 11.70),
    'F2'        : (15.70, 15.70),
    'CO2'       : (13.78, 13.78),
    'Na2'       : ( 4.89,  None),
    'Si2'       : ( 7.90,  None),
    'P2'        : (10.53, 10.62),
    'S2'        : ( 9.36,  9.55),
    'Cl2'       : (11.48, 11.49),
    'NaCl'      : ( 9.20,  9.80),
    'SiO'       : (11.49,  None),
    'CS'        : (11.33,  None),
    'SO'        : (11.29,  None),
    'ClO'       : (10.89, 11.01),
    'ClF'       : (12.66, 12.77),
    'Si2H6'     : ( 9.74, 10.53),
    'CH3Cl'     : (11.26, 11.29),
    'CH3SH'     : ( 9.44,  9.44),
    'HOCl'      : (11.12,  None),
    'SO2'       : (12.35, 12.50),
    'C6H6'      : ( 9.24,  9.25),
    'C12H10'    : ( 8.16,  None), # Biphenyl
    'C10H8'     : ( 8.14,  None), # Naphthalene
    }
