# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
import uuid

from .. import models


class FileSystemOperations(object):
    """FileSystemOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    :ivar transfer_encoding: Indicates the data being sent to the server is being streamed in chunks. Constant value: "chunked".
    :ivar append: The constant value for the operation. Constant value: "true".
    :ivar write: The constant value for the operation. Constant value: "true".
    :ivar read: The constant value for the operation. Constant value: "true".
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.transfer_encoding = "chunked"
        self.append = "true"
        self.write = "true"
        self.read = "true"

        self.config = config

    def concurrent_append(
            self, account_name, file_path, stream_contents, append_mode=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Appends to the specified file. This method supports multiple
        concurrent appends to the file. NOTE: Concurrent append and normal
        (serial) append CANNOT be used interchangeably. Once a file has been
        appended to using either append option, it can only be appended to
        using that append option.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param file_path: The Data Lake Store path (starting with '/') of the
         file to which to append using concurrent append.
        :type file_path: str
        :param stream_contents: The file contents to include when appending
         to the file.
        :type stream_contents: Generator
        :param append_mode: Indicates the concurrent append call should
         create the file if it doesn't exist or just open the existing file
         for append. Possible values include: 'autocreate'
        :type append_mode: str or :class:`AppendModeType
         <azure.mgmt.datalake.store.filesystem.models.AppendModeType>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "CONCURRENTAPPEND"

        # Construct URL
        url = '/WebHdfsExt/{filePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'filePath': self._serialize.url("file_path", file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if append_mode is not None:
            query_parameters['appendMode'] = self._serialize.query("append_mode", append_mode, 'AppendModeType')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/octet-stream'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Transfer-Encoding'] = self._serialize.header("self.transfer_encoding", self.transfer_encoding, 'str')
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._client.stream_upload(stream_contents, callback)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def set_file_expiry(
            self, account_name, file_path, expiry_option, expire_time=None, custom_headers=None, raw=False, **operation_config):
        """Sets or removes the expiration time on the specified file. This
        operation can only be executed against files. Folders are not
        supported.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param file_path: The Data Lake Store path (starting with '/') of the
         file on which to set or remove the expiration time.
        :type file_path: str
        :param expiry_option: Indicates the type of expiration to use for the
         file: 1. NeverExpire: ExpireTime is ignored. 2. RelativeToNow:
         ExpireTime is an integer in milliseconds representing the expiration
         date relative to when file expiration is updated. 3.
         RelativeToCreationDate: ExpireTime is an integer in milliseconds
         representing the expiration date relative to file creation. 4.
         Absolute: ExpireTime is an integer in milliseconds, as a Unix
         timestamp relative to 1/1/1970 00:00:00. Possible values include:
         'NeverExpire', 'RelativeToNow', 'RelativeToCreationDate', 'Absolute'
        :type expiry_option: str or :class:`ExpiryOptionType
         <azure.mgmt.datalake.store.filesystem.models.ExpiryOptionType>`
        :param expire_time: The time that the file will expire, corresponding
         to the ExpiryOption that was set.
        :type expire_time: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "SETEXPIRY"

        # Construct URL
        url = '/WebHdfsExt/{filePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'filePath': self._serialize.url("file_path", file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['expiryOption'] = self._serialize.query("expiry_option", expiry_option, 'ExpiryOptionType')
        if expire_time is not None:
            query_parameters['expireTime'] = self._serialize.query("expire_time", expire_time, 'long')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def check_access(
            self, account_name, path, fsaction=None, custom_headers=None, raw=False, **operation_config):
        """Checks if the specified access is available at the given path.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param path: The Data Lake Store path (starting with '/') of the file
         or directory for which to check access.
        :type path: str
        :param fsaction: File system operation read/write/execute in string
         form, matching regex pattern '[rwx-]{3}'
        :type fsaction: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "CHECKACCESS"

        # Construct URL
        url = '/webhdfs/v1/{path}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'path': self._serialize.url("path", path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if fsaction is not None:
            query_parameters['fsaction'] = self._serialize.query("fsaction", fsaction, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def mkdirs(
            self, account_name, path, custom_headers=None, raw=False, **operation_config):
        """Creates a directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param path: The Data Lake Store path (starting with '/') of the
         directory to create.
        :type path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`FileOperationResult
         <azure.mgmt.datalake.store.filesystem.models.FileOperationResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MKDIRS"

        # Construct URL
        url = '/webhdfs/v1/{path}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'path': self._serialize.url("path", path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileOperationResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def concat(
            self, account_name, destination_path, sources, custom_headers=None, raw=False, **operation_config):
        """Concatenates the list of source files into the destination file,
        removing all source files upon success.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param destination_path: The Data Lake Store path (starting with '/')
         of the destination file resulting from the concatenation.
        :type destination_path: str
        :param sources: A list of comma seperated Data Lake Store paths
         (starting with '/') of the files to concatenate, in the order in
         which they should be concatenated.
        :type sources: list of str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "CONCAT"

        # Construct URL
        url = '/webhdfs/v1/{destinationPath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'destinationPath': self._serialize.url("destination_path", destination_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['sources'] = self._serialize.query("sources", sources, '[str]', div=',')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def ms_concat(
            self, account_name, ms_concat_destination_path, stream_contents, delete_source_directory=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Concatenates the list of source files into the destination file,
        deleting all source files upon success. This method accepts more
        source file paths than the Concat method. This method and the
        parameters it accepts are subject to change for usability in an
        upcoming version.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param ms_concat_destination_path: The Data Lake Store path (starting
         with '/') of the destination file resulting from the concatenation.
        :type ms_concat_destination_path: str
        :param stream_contents: A list of Data Lake Store paths (starting
         with '/') of the source files. Must be in the format: sources=<comma
         separated list>
        :type stream_contents: Generator
        :param delete_source_directory: Indicates that as an optimization
         instead of deleting each individual source stream, delete the source
         stream folder if all streams are in the same folder instead. This
         results in a substantial performance improvement when the only
         streams in the folder are part of the concatenation operation.
         WARNING: This includes the deletion of any other files that are not
         source files. Only set this to true when source files are the only
         files in the source directory.
        :type delete_source_directory: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MSCONCAT"

        # Construct URL
        url = '/webhdfs/v1/{msConcatDestinationPath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'msConcatDestinationPath': self._serialize.url("ms_concat_destination_path", ms_concat_destination_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if delete_source_directory is not None:
            query_parameters['deleteSourceDirectory'] = self._serialize.query("delete_source_directory", delete_source_directory, 'bool')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/octet-stream'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._client.stream_upload(stream_contents, callback)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def list_file_status(
            self, account_name, list_file_path, list_size=None, list_after=None, list_before=None, custom_headers=None, raw=False, **operation_config):
        """Get the list of file status objects specified by the file path, with
        optional pagination parameters.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param list_file_path: The Data Lake Store path (starting with '/')
         of the directory to list.
        :type list_file_path: str
        :param list_size: Gets or sets the number of items to return.
         Optional.
        :type list_size: int
        :param list_after: Gets or sets the item or lexographical index after
         which to begin returning results. For example, a file list of
         'a','b','d' and listAfter='b' will return 'd', and a listAfter='c'
         will also return 'd'. Optional.
        :type list_after: str
        :param list_before: Gets or sets the item or lexographical index
         before which to begin returning results. For example, a file list of
         'a','b','d' and listBefore='d' will return 'a','b', and a
         listBefore='c' will also return 'a','b'. Optional.
        :type list_before: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`FileStatusesResult
         <azure.mgmt.datalake.store.filesystem.models.FileStatusesResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MSLISTSTATUS"

        # Construct URL
        url = '/webhdfs/v1/{listFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'listFilePath': self._serialize.url("list_file_path", list_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if list_size is not None:
            query_parameters['listSize'] = self._serialize.query("list_size", list_size, 'int')
        if list_after is not None:
            query_parameters['listAfter'] = self._serialize.query("list_after", list_after, 'str')
        if list_before is not None:
            query_parameters['listBefore'] = self._serialize.query("list_before", list_before, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileStatusesResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_content_summary(
            self, account_name, get_content_summary_file_path, custom_headers=None, raw=False, **operation_config):
        """Gets the file content summary object specified by the file path.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param get_content_summary_file_path: The Data Lake Store path
         (starting with '/') of the file for which to retrieve the summary.
        :type get_content_summary_file_path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`ContentSummaryResult
         <azure.mgmt.datalake.store.filesystem.models.ContentSummaryResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "GETCONTENTSUMMARY"

        # Construct URL
        url = '/webhdfs/va/{getContentSummaryFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'getContentSummaryFilePath': self._serialize.url("get_content_summary_file_path", get_content_summary_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ContentSummaryResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def get_file_status(
            self, account_name, get_file_path, custom_headers=None, raw=False, **operation_config):
        """Get the file status object specified by the file path.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param get_file_path: The Data Lake Store path (starting with '/') of
         the file or directory for which to retrieve the status.
        :type get_file_path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`FileStatusResult
         <azure.mgmt.datalake.store.filesystem.models.FileStatusResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MSGETFILESTATUS"

        # Construct URL
        url = '/webhdfs/v1/{getFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'getFilePath': self._serialize.url("get_file_path", get_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileStatusResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def append(
            self, account_name, direct_file_path, stream_contents, offset=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Appends to the specified file. This method does not support multiple
        concurrent appends to the file. NOTE: Concurrent append and normal
        (serial) append CANNOT be used interchangeably. Once a file has been
        appended to using either append option, it can only be appended to
        using that append option. Use the ConcurrentAppend option if you
        would like support for concurrent appends.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param direct_file_path: The Data Lake Store path (starting with '/')
         of the file to which to append.
        :type direct_file_path: str
        :param stream_contents: The file contents to include when appending
         to the file.
        :type stream_contents: Generator
        :param offset: The optional offset in the stream to begin the append
         operation. Default is to append at the end of the stream.
        :type offset: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "APPEND"

        # Construct URL
        url = '/webhdfs/v1/{directFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'directFilePath': self._serialize.url("direct_file_path", direct_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if offset is not None:
            query_parameters['offset'] = self._serialize.query("offset", offset, 'long')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['append'] = self._serialize.query("self.append", self.append, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/octet-stream'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Transfer-Encoding'] = self._serialize.header("self.transfer_encoding", self.transfer_encoding, 'str')
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._client.stream_upload(stream_contents, callback)

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def create(
            self, account_name, direct_file_path, stream_contents=None, overwrite=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Creates a file with optionally specified content.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param direct_file_path: The Data Lake Store path (starting with '/')
         of the file to create.
        :type direct_file_path: str
        :param stream_contents: The file contents to include when creating
         the file. This parameter is optional, resulting in an empty file if
         not specified.
        :type stream_contents: Generator
        :param overwrite: The indication of if the file should be overwritten.
        :type overwrite: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "CREATE"

        # Construct URL
        url = '/webhdfs/v1/{directFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'directFilePath': self._serialize.url("direct_file_path", direct_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if overwrite is not None:
            query_parameters['overwrite'] = self._serialize.query("overwrite", overwrite, 'bool')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['write'] = self._serialize.query("self.write", self.write, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/octet-stream'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        header_parameters['Transfer-Encoding'] = self._serialize.header("self.transfer_encoding", self.transfer_encoding, 'str')
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._client.stream_upload(stream_contents, callback)

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def open(
            self, account_name, direct_file_path, length=None, offset=None, custom_headers=None, raw=False, callback=None, **operation_config):
        """Opens and reads from the specified file.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param direct_file_path: The Data Lake Store path (starting with '/')
         of the file to open.
        :type direct_file_path: str
        :param length:
        :type length: long
        :param offset:
        :type offset: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param callback: When specified, will be called with each chunk of
         data that is streamed. The callback should take two arguments, the
         bytes of the current chunk of data and the response object. If the
         data is uploading, response will be None.
        :type callback: Callable[Bytes, response=None]
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: Generator
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "OPEN"

        # Construct URL
        url = '/webhdfs/v1/{directFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'directFilePath': self._serialize.url("direct_file_path", direct_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if length is not None:
            query_parameters['length'] = self._serialize.query("length", length, 'long')
        if offset is not None:
            query_parameters['offset'] = self._serialize.query("offset", offset, 'long')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['read'] = self._serialize.query("self.read", self.read, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._client.stream_download(response, callback)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def set_acl(
            self, account_name, set_acl_file_path, aclspec, custom_headers=None, raw=False, **operation_config):
        """Sets the Access Control List (ACL) for a file or folder.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param set_acl_file_path: The Data Lake Store path (starting with
         '/') of the file or directory on which to set the ACL.
        :type set_acl_file_path: str
        :param aclspec: The ACL spec included in ACL creation operations in
         the format '[default:]user|group|other::r|-w|-x|-'
        :type aclspec: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "SETACL"

        # Construct URL
        url = '/webhdfs/v1/{setAclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'setAclFilePath': self._serialize.url("set_acl_file_path", set_acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['aclspec'] = self._serialize.query("aclspec", aclspec, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def modify_acl_entries(
            self, account_name, modify_acl_file_path, aclspec, custom_headers=None, raw=False, **operation_config):
        """Modifies existing Access Control List (ACL) entries on a file or
        folder.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param modify_acl_file_path: The Data Lake Store path (starting with
         '/') of the file or directory with the ACL being modified.
        :type modify_acl_file_path: str
        :param aclspec: The ACL specification included in ACL modification
         operations in the format '[default:]user|group|other::r|-w|-x|-'
        :type aclspec: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MODIFYACLENTRIES"

        # Construct URL
        url = '/webhdfs/v1/{modifyAclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'modifyAclFilePath': self._serialize.url("modify_acl_file_path", modify_acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['aclspec'] = self._serialize.query("aclspec", aclspec, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def remove_acl_entries(
            self, account_name, remove_acl_file_path, aclspec, custom_headers=None, raw=False, **operation_config):
        """Removes existing Access Control List (ACL) entries for a file or
        folder.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param remove_acl_file_path: The Data Lake Store path (starting with
         '/') of the file or directory with the ACL being removed.
        :type remove_acl_file_path: str
        :param aclspec: The ACL spec included in ACL removal operations in
         the format '[default:]user|group|other'
        :type aclspec: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "REMOVEACLENTRIES"

        # Construct URL
        url = '/webhdfs/v1/{removeAclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'removeAclFilePath': self._serialize.url("remove_acl_file_path", remove_acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['aclspec'] = self._serialize.query("aclspec", aclspec, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def remove_default_acl(
            self, account_name, default_acl_file_path, custom_headers=None, raw=False, **operation_config):
        """Removes the existing Default Access Control List (ACL) of the
        specified directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param default_acl_file_path: The Data Lake Store path (starting with
         '/') of the directory with the default ACL being removed.
        :type default_acl_file_path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "REMOVEDEFAULTACL"

        # Construct URL
        url = '/webhdfs/v1/{defaultAclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'defaultAclFilePath': self._serialize.url("default_acl_file_path", default_acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def remove_acl(
            self, account_name, acl_file_path, custom_headers=None, raw=False, **operation_config):
        """Removes the existing Access Control List (ACL) of the specified file
        or directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param acl_file_path: The Data Lake Store path (starting with '/') of
         the file or directory with the ACL being removed.
        :type acl_file_path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "REMOVEACL"

        # Construct URL
        url = '/webhdfs/v1/{aclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'aclFilePath': self._serialize.url("acl_file_path", acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def get_acl_status(
            self, account_name, acl_file_path, custom_headers=None, raw=False, **operation_config):
        """Gets Access Control List (ACL) entries for the specified file or
        directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param acl_file_path: The Data Lake Store path (starting with '/') of
         the file or directory for which to get the ACL.
        :type acl_file_path: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`AclStatusResult
         <azure.mgmt.datalake.store.filesystem.models.AclStatusResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "MSGETACLSTATUS"

        # Construct URL
        url = '/webhdfs/v1/{aclFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'aclFilePath': self._serialize.url("acl_file_path", acl_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AclStatusResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def delete(
            self, account_name, file_path, recursive=None, custom_headers=None, raw=False, **operation_config):
        """Deletes the requested file or directory, optionally recursively.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param file_path: The Data Lake Store path (starting with '/') of the
         file or directory to delete.
        :type file_path: str
        :param recursive: The optional switch indicating if the delete should
         be recursive
        :type recursive: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`FileOperationResult
         <azure.mgmt.datalake.store.filesystem.models.FileOperationResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "DELETE"

        # Construct URL
        url = '/webhdfs/v1/{filePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'filePath': self._serialize.url("file_path", file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if recursive is not None:
            query_parameters['recursive'] = self._serialize.query("recursive", recursive, 'bool')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileOperationResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def rename(
            self, account_name, rename_file_path, destination, custom_headers=None, raw=False, **operation_config):
        """Rename a file or directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param rename_file_path: The Data Lake Store path (starting with '/')
         of the file or directory to move/rename.
        :type rename_file_path: str
        :param destination: The path to move/rename the file or folder to
        :type destination: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`FileOperationResult
         <azure.mgmt.datalake.store.filesystem.models.FileOperationResult>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "RENAME"

        # Construct URL
        url = '/webhdfs/v1/{renameFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'renameFilePath': self._serialize.url("rename_file_path", rename_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['destination'] = self._serialize.query("destination", destination, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileOperationResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized

    def set_owner(
            self, account_name, set_owner_file_path, owner=None, group=None, custom_headers=None, raw=False, **operation_config):
        """Sets the owner of a file or directory.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param set_owner_file_path: The Data Lake Store path (starting with
         '/') of the file or directory for which to set the owner.
        :type set_owner_file_path: str
        :param owner: The AAD Object ID of the user owner of the file or
         directory. If empty, the property will remain unchanged.
        :type owner: str
        :param group: The AAD Object ID of the group owner of the file or
         directory. If empty, the property will remain unchanged.
        :type group: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "SETOWNER"

        # Construct URL
        url = '/webhdfs/v1/{setOwnerFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'setOwnerFilePath': self._serialize.url("set_owner_file_path", set_owner_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if owner is not None:
            query_parameters['owner'] = self._serialize.query("owner", owner, 'str')
        if group is not None:
            query_parameters['group'] = self._serialize.query("group", group, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    def set_permission(
            self, account_name, set_permission_file_path, permission=None, custom_headers=None, raw=False, **operation_config):
        """Sets the permission of the file or folder.

        :param account_name: The Azure Data Lake Store account to execute
         filesystem operations on.
        :type account_name: str
        :param set_permission_file_path: The Data Lake Store path (starting
         with '/') of the file or directory for which to set the permission.
        :type set_permission_file_path: str
        :param permission: A string representation of the permission (i.e
         'rwx'). If empty, this property remains unchanged.
        :type permission: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        op = "SETPERMISSION"

        # Construct URL
        url = '/webhdfs/v1/{setPermissionFilePath}'
        path_format_arguments = {
            'accountName': self._serialize.url("account_name", account_name, 'str', skip_quote=True),
            'adlsFileSystemDnsSuffix': self._serialize.url("self.config.adls_file_system_dns_suffix", self.config.adls_file_system_dns_suffix, 'str', skip_quote=True),
            'setPermissionFilePath': self._serialize.url("set_permission_file_path", set_permission_file_path, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if permission is not None:
            query_parameters['permission'] = self._serialize.query("permission", permission, 'str')
        query_parameters['op'] = self._serialize.query("op", op, 'str')
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.AdlsErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response
