# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import DataBoxManagementClientConfiguration
from .operations import Operations
from .operations import JobsOperations
from .operations import ServiceOperations
from . import models


class DataBoxManagementClient(SDKClient):
    """DataBoxManagementClient

    :ivar config: Configuration for client.
    :vartype config: DataBoxManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.databox.operations.Operations
    :ivar jobs: Jobs operations
    :vartype jobs: azure.mgmt.databox.operations.JobsOperations
    :ivar service: Service operations
    :vartype service: azure.mgmt.databox.operations.ServiceOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The Subscription Id
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = DataBoxManagementClientConfiguration(credentials, subscription_id, base_url)
        super(DataBoxManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-09-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.jobs = JobsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.service = ServiceOperations(
            self._client, self.config, self._serialize, self._deserialize)
