# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import HanaManagementClientConfiguration
from .operations import Operations
from .operations import SapMonitorsOperations
from .operations import ProviderInstancesOperations
from . import models


class HanaManagementClient(SDKClient):
    """HANA on Azure Client

    :ivar config: Configuration for client.
    :vartype config: HanaManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hanaonazure.operations.Operations
    :ivar sap_monitors: SapMonitors operations
    :vartype sap_monitors: azure.mgmt.hanaonazure.operations.SapMonitorsOperations
    :ivar provider_instances: ProviderInstances operations
    :vartype provider_instances: azure.mgmt.hanaonazure.operations.ProviderInstancesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription ID which uniquely identify Microsoft
     Azure subscription. The subscription ID forms part of the URI for every
     service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = HanaManagementClientConfiguration(credentials, subscription_id, base_url)
        super(HanaManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-02-07-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.sap_monitors = SapMonitorsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.provider_instances = ProviderInstancesOperations(
            self._client, self.config, self._serialize, self._deserialize)
