# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class Dimension(Model):
    """Specifications of the Dimension of metrics.

    :param name: The public facing name of the dimension.
    :type name: str
    :param display_name: Localized friendly display name of the dimension.
    :type display_name: str
    :param internal_name: Name of the dimension as it appears in MDM.
    :type internal_name: str
    :param to_be_exported_for_shoebox: A Boolean flag indicating whether this
     dimension should be included for the shoebox export scenario.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.internal_name = kwargs.get('internal_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class ErrorResponse(Model):
    """Contains information about an API error.

    :param error: Describes a particular API error with an error code and a
     message.
    :type error: ~azure.mgmt.signalr.models.ErrorResponseBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponseBody'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ErrorResponseBody(Model):
    """Describes a particular API error with an error code and a message.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An error code that describes the error condition
     more precisely than an HTTP status code.
     Can be used to programmatically handle specific error cases.
    :type code: str
    :param message: Required. A message that describes the error in detail and
     provides debugging information.
    :type message: str
    :param target: The target of the particular error (for example, the name
     of the property in error).
    :type target: str
    :param details: Contains nested errors that are related to this error.
    :type details: list[~azure.mgmt.signalr.models.ErrorResponseBody]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponseBody]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class LogSpecification(Model):
    """Specifications of the Logs for Azure Monitoring.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized friendly display name of the log.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class MetricSpecification(Model):
    """Specifications of the Metrics for Azure Monitoring.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Localized friendly display name of the metric.
    :type display_name: str
    :param display_description: Localized friendly description of the metric.
    :type display_description: str
    :param unit: The unit that makes sense for the metric.
    :type unit: str
    :param aggregation_type: Only provide one value for this field. Valid
     values: Average, Minimum, Maximum, Total, Count.
    :type aggregation_type: str
    :param fill_gap_with_zero: Optional. If set to true, then zero will be
     returned for time duration where no metric is emitted/published.
     Ex. a metric that returns the number of times a particular error code was
     emitted. The error code may not appear
     often, instead of the RP publishing 0, Shoebox can auto fill in 0s for
     time periods where nothing was emitted.
    :type fill_gap_with_zero: str
    :param category: The name of the metric category that the metric belongs
     to. A metric can only belong to a single category.
    :type category: str
    :param dimensions: The dimensions of the metrics.
    :type dimensions: list[~azure.mgmt.signalr.models.Dimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
    }

    def __init__(self, **kwargs):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.category = kwargs.get('category', None)
        self.dimensions = kwargs.get('dimensions', None)


class NameAvailability(Model):
    """Result of the request to check name availability. It contains a flag and
    possible reason of failure.

    :param name_available: Indicates whether the name is available or not.
    :type name_available: bool
    :param reason: The reason of the availability. Required if name is not
     available.
    :type reason: str
    :param message: The message of the operation.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAvailability, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class NameAvailabilityParameters(Model):
    """Data POST-ed to the nameAvailability action.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The resource type. Should be always
     "Microsoft.SignalRService/SignalR".
    :type type: str
    :param name: Required. The SignalR service name to validate.
     e.g."my-signalR-name-here"
    :type name: str
    """

    _validation = {
        'type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameAvailabilityParameters, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)


class NetworkACL(Model):
    """Network ACL.

    :param allow: Allowed request types. The value can be one or more of:
     ClientConnection, ServerConnection, RESTAPI.
    :type allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :param deny: Denied request types. The value can be one or more of:
     ClientConnection, ServerConnection, RESTAPI.
    :type deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    """

    _attribute_map = {
        'allow': {'key': 'allow', 'type': '[str]'},
        'deny': {'key': 'deny', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(NetworkACL, self).__init__(**kwargs)
        self.allow = kwargs.get('allow', None)
        self.deny = kwargs.get('deny', None)


class Operation(Model):
    """REST API operation supported by SignalR resource provider.

    :param name: Name of the operation with format:
     {provider}/{resource}/{operation}
    :type name: str
    :param is_data_action: If the operation is a data action. (for data plane
     rbac)
    :type is_data_action: bool
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.signalr.models.OperationDisplay
    :param origin: Optional. The intended executor of the operation; governs
     the display of the operation in the RBAC UX and the audit logs UX.
    :type origin: str
    :param properties: Extra properties for the operation.
    :type properties: ~azure.mgmt.signalr.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(Model):
    """The object that describes a operation.

    :param provider: Friendly name of the resource provider
    :type provider: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param operation: The localized friendly name for the operation.
    :type operation: str
    :param description: The localized friendly description for the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationProperties(Model):
    """Extra Operation properties.

    :param service_specification: The service specifications.
    :type service_specification:
     ~azure.mgmt.signalr.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(self, **kwargs):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class PrivateEndpoint(Model):
    """Private endpoint.

    :param id: Full qualified Id of the private endpoint
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateEndpointACL(NetworkACL):
    """ACL for a private endpoint.

    All required parameters must be populated in order to send to Azure.

    :param allow: Allowed request types. The value can be one or more of:
     ClientConnection, ServerConnection, RESTAPI.
    :type allow: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :param deny: Denied request types. The value can be one or more of:
     ClientConnection, ServerConnection, RESTAPI.
    :type deny: list[str or ~azure.mgmt.signalr.models.SignalRRequestType]
    :param name: Required. Name of the private endpoint connection
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'allow': {'key': 'allow', 'type': '[str]'},
        'deny': {'key': 'deny', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointACL, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class Resource(Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection to SignalR resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the private endpoint
     connection. Possible values include: 'Unknown', 'Succeeded', 'Failed',
     'Canceled', 'Running', 'Creating', 'Updating', 'Deleting', 'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.signalr.models.ProvisioningState
    :param private_endpoint: Private endpoint associated with the private
     endpoint connection
    :type private_endpoint: ~azure.mgmt.signalr.models.PrivateEndpoint
    :param private_link_service_connection_state: Connection state
    :type private_link_service_connection_state:
     ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateLinkResource(ProxyResource):
    """Private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    :param group_id: Group Id of the private link resource
    :type group_id: str
    :param required_members: Required members of the private link resource
    :type required_members: list[str]
    :param required_zone_names: Required private DNS zone names
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkServiceConnectionState(Model):
    """Connection state of the private endpoint connection.

    :param status: Indicates whether the connection has been
     Approved/Rejected/Removed by the owner of the service. Possible values
     include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.signalr.models.PrivateLinkServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class RegenerateKeyParameters(Model):
    """Parameters describes the request to regenerate access keys.

    :param key_type: The keyType to regenerate. Must be either 'primary' or
     'secondary'(case-insensitive). Possible values include: 'Primary',
     'Secondary'
    :type key_type: str or ~azure.mgmt.signalr.models.KeyType
    """

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegenerateKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', None)


class ResourceSku(Model):
    """The billing information of the SignalR resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Required.
     Allowed values: Standard_S1, Free_F1
    :type name: str
    :param tier: Optional tier of this particular SKU. 'Standard' or 'Free'.
     `Basic` is deprecated, use `Standard` instead. Possible values include:
     'Free', 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.signalr.models.SignalRSkuTier
    :param size: Optional string. For future use.
    :type size: str
    :param family: Optional string. For future use.
    :type family: str
    :param capacity: Optional, integer. The unit count of SignalR resource. 1
     by default.
     If present, following values are allowed:
     Free: 1
     Standard: 1,2,5,10,20,50,100
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ResourceSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)


class ServerlessUpstreamSettings(Model):
    """The settings for the Upstream when the Azure SignalR is in server-less
    mode.

    :param templates: Gets or sets the list of Upstream URL templates. Order
     matters, and the first matching template takes effects.
    :type templates: list[~azure.mgmt.signalr.models.UpstreamTemplate]
    """

    _attribute_map = {
        'templates': {'key': 'templates', 'type': '[UpstreamTemplate]'},
    }

    def __init__(self, **kwargs):
        super(ServerlessUpstreamSettings, self).__init__(**kwargs)
        self.templates = kwargs.get('templates', None)


class ServiceSpecification(Model):
    """An object that describes a specification.

    :param metric_specifications: Specifications of the Metrics for Azure
     Monitoring.
    :type metric_specifications:
     list[~azure.mgmt.signalr.models.MetricSpecification]
    :param log_specifications: Specifications of the Logs for Azure
     Monitoring.
    :type log_specifications:
     list[~azure.mgmt.signalr.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(self, **kwargs):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class SignalRCorsSettings(Model):
    """Cross-Origin Resource Sharing (CORS) settings.

    :param allowed_origins: Gets or sets the list of origins that should be
     allowed to make cross-origin calls (for example:
     http://example.com:12345). Use "*" to allow all. If omitted, allow all by
     default.
    :type allowed_origins: list[str]
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SignalRCorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)


class SignalRCreateOrUpdateProperties(Model):
    """Settings used to provision or configure the resource.

    :param host_name_prefix: Prefix for the hostName of the SignalR service.
     Retained for future use.
     The hostname will be of format:
     &lt;hostNamePrefix&gt;.service.signalr.net.
    :type host_name_prefix: str
    :param features: List of SignalR featureFlags. e.g. ServiceMode.
     FeatureFlags that are not included in the parameters for the update
     operation will not be modified.
     And the response will only include featureFlags that are explicitly set.
     When a featureFlag is not explicitly set, SignalR service will use its
     globally default value.
     But keep in mind, the default value doesn't mean "false". It varies in
     terms of different FeatureFlags.
    :type features: list[~azure.mgmt.signalr.models.SignalRFeature]
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.signalr.models.SignalRCorsSettings
    :param upstream: Upstream settings when the Azure SignalR is in
     server-less mode.
    :type upstream: ~azure.mgmt.signalr.models.ServerlessUpstreamSettings
    :param network_ac_ls: Network ACLs
    :type network_ac_ls: ~azure.mgmt.signalr.models.SignalRNetworkACLs
    """

    _attribute_map = {
        'host_name_prefix': {'key': 'hostNamePrefix', 'type': 'str'},
        'features': {'key': 'features', 'type': '[SignalRFeature]'},
        'cors': {'key': 'cors', 'type': 'SignalRCorsSettings'},
        'upstream': {'key': 'upstream', 'type': 'ServerlessUpstreamSettings'},
        'network_ac_ls': {'key': 'networkACLs', 'type': 'SignalRNetworkACLs'},
    }

    def __init__(self, **kwargs):
        super(SignalRCreateOrUpdateProperties, self).__init__(**kwargs)
        self.host_name_prefix = kwargs.get('host_name_prefix', None)
        self.features = kwargs.get('features', None)
        self.cors = kwargs.get('cors', None)
        self.upstream = kwargs.get('upstream', None)
        self.network_ac_ls = kwargs.get('network_ac_ls', None)


class SignalRFeature(Model):
    """Feature of a SignalR resource, which controls the SignalR runtime behavior.

    All required parameters must be populated in order to send to Azure.

    :param flag: Required. FeatureFlags is the supported features of Azure
     SignalR service.
     - ServiceMode: Flag for backend server for SignalR service. Values
     allowed: "Default": have your own backend server; "Serverless": your
     application doesn't have a backend server; "Classic": for backward
     compatibility. Support both Default and Serverless mode but not
     recommended; "PredefinedOnly": for future use.
     - EnableConnectivityLogs: "true"/"false", to enable/disable the
     connectivity log category respectively. Possible values include:
     'ServiceMode', 'EnableConnectivityLogs', 'EnableMessagingLogs'
    :type flag: str or ~azure.mgmt.signalr.models.FeatureFlags
    :param value: Required. Value of the feature flag. See Azure SignalR
     service document https://docs.microsoft.com/azure/azure-signalr/ for
     allowed values.
    :type value: str
    :param properties: Optional properties related to this feature.
    :type properties: dict[str, str]
    """

    _validation = {
        'flag': {'required': True},
        'value': {'required': True, 'max_length': 128, 'min_length': 1},
    }

    _attribute_map = {
        'flag': {'key': 'flag', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(SignalRFeature, self).__init__(**kwargs)
        self.flag = kwargs.get('flag', None)
        self.value = kwargs.get('value', None)
        self.properties = kwargs.get('properties', None)


class SignalRKeys(Model):
    """A class represents the access keys of SignalR service.

    :param primary_key: The primary access key.
    :type primary_key: str
    :param secondary_key: The secondary access key.
    :type secondary_key: str
    :param primary_connection_string: SignalR connection string constructed
     via the primaryKey
    :type primary_connection_string: str
    :param secondary_connection_string: SignalR connection string constructed
     via the secondaryKey
    :type secondary_connection_string: str
    """

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SignalRKeys, self).__init__(**kwargs)
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.primary_connection_string = kwargs.get('primary_connection_string', None)
        self.secondary_connection_string = kwargs.get('secondary_connection_string', None)


class SignalRNetworkACLs(Model):
    """Network ACLs for SignalR.

    :param default_action: Default action when no other rule matches. Possible
     values include: 'Allow', 'Deny'
    :type default_action: str or ~azure.mgmt.signalr.models.ACLAction
    :param public_network: ACL for requests from public network
    :type public_network: ~azure.mgmt.signalr.models.NetworkACL
    :param private_endpoints: ACLs for requests from private endpoints
    :type private_endpoints:
     list[~azure.mgmt.signalr.models.PrivateEndpointACL]
    """

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'public_network': {'key': 'publicNetwork', 'type': 'NetworkACL'},
        'private_endpoints': {'key': 'privateEndpoints', 'type': '[PrivateEndpointACL]'},
    }

    def __init__(self, **kwargs):
        super(SignalRNetworkACLs, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', None)
        self.public_network = kwargs.get('public_network', None)
        self.private_endpoints = kwargs.get('private_endpoints', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    :param location: The GEO location of the SignalR service. e.g. West US |
     East US | North Central US | South Central US.
    :type location: str
    :param tags: Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class SignalRResource(TrackedResource):
    """A class represent a SignalR service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource - e.g.
     "Microsoft.SignalRService/SignalR"
    :vartype type: str
    :param location: The GEO location of the SignalR service. e.g. West US |
     East US | North Central US | South Central US.
    :type location: str
    :param tags: Tags of the service which is a list of key value pairs that
     describe the resource.
    :type tags: dict[str, str]
    :param sku: The billing information of the resource.(e.g. Free, Standard)
    :type sku: ~azure.mgmt.signalr.models.ResourceSku
    :param host_name_prefix: Prefix for the hostName of the SignalR service.
     Retained for future use.
     The hostname will be of format:
     &lt;hostNamePrefix&gt;.service.signalr.net.
    :type host_name_prefix: str
    :param features: List of SignalR featureFlags. e.g. ServiceMode.
     FeatureFlags that are not included in the parameters for the update
     operation will not be modified.
     And the response will only include featureFlags that are explicitly set.
     When a featureFlag is not explicitly set, SignalR service will use its
     globally default value.
     But keep in mind, the default value doesn't mean "false". It varies in
     terms of different FeatureFlags.
    :type features: list[~azure.mgmt.signalr.models.SignalRFeature]
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.signalr.models.SignalRCorsSettings
    :param upstream: Upstream settings when the Azure SignalR is in
     server-less mode.
    :type upstream: ~azure.mgmt.signalr.models.ServerlessUpstreamSettings
    :param network_ac_ls: Network ACLs
    :type network_ac_ls: ~azure.mgmt.signalr.models.SignalRNetworkACLs
    :ivar provisioning_state: Provisioning state of the resource. Possible
     values include: 'Unknown', 'Succeeded', 'Failed', 'Canceled', 'Running',
     'Creating', 'Updating', 'Deleting', 'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.signalr.models.ProvisioningState
    :ivar external_ip: The publicly accessible IP of the SignalR service.
    :vartype external_ip: str
    :ivar host_name: FQDN of the SignalR service instance. Format:
     xxx.service.signalr.net
    :vartype host_name: str
    :ivar public_port: The publicly accessible port of the SignalR service
     which is designed for browser/client side usage.
    :vartype public_port: int
    :ivar server_port: The publicly accessible port of the SignalR service
     which is designed for customer server side usage.
    :vartype server_port: int
    :ivar version: Version of the SignalR resource. Probably you need the same
     or higher version of client SDKs.
    :vartype version: str
    :ivar private_endpoint_connections: Private endpoint connections to the
     SignalR resource.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.signalr.models.PrivateEndpointConnection]
    :param kind: The kind of the service - e.g. "SignalR", or "RawWebSockets"
     for "Microsoft.SignalRService/SignalR". Possible values include:
     'SignalR', 'RawWebSockets'
    :type kind: str or ~azure.mgmt.signalr.models.ServiceKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'external_ip': {'readonly': True},
        'host_name': {'readonly': True},
        'public_port': {'readonly': True},
        'server_port': {'readonly': True},
        'version': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'host_name_prefix': {'key': 'properties.hostNamePrefix', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[SignalRFeature]'},
        'cors': {'key': 'properties.cors', 'type': 'SignalRCorsSettings'},
        'upstream': {'key': 'properties.upstream', 'type': 'ServerlessUpstreamSettings'},
        'network_ac_ls': {'key': 'properties.networkACLs', 'type': 'SignalRNetworkACLs'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'external_ip': {'key': 'properties.externalIP', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'public_port': {'key': 'properties.publicPort', 'type': 'int'},
        'server_port': {'key': 'properties.serverPort', 'type': 'int'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SignalRResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.host_name_prefix = kwargs.get('host_name_prefix', None)
        self.features = kwargs.get('features', None)
        self.cors = kwargs.get('cors', None)
        self.upstream = kwargs.get('upstream', None)
        self.network_ac_ls = kwargs.get('network_ac_ls', None)
        self.provisioning_state = None
        self.external_ip = None
        self.host_name = None
        self.public_port = None
        self.server_port = None
        self.version = None
        self.private_endpoint_connections = None
        self.kind = kwargs.get('kind', None)


class SignalRUsage(Model):
    """Object that describes a specific usage of SignalR resources.

    :param id: Fully qualified ARM resource id
    :type id: str
    :param current_value: Current value for the usage quota.
    :type current_value: long
    :param limit: The maximum permitted value for the usage quota. If there is
     no limit, this value will be -1.
    :type limit: long
    :param name: Localizable String object containing the name and a localized
     value.
    :type name: ~azure.mgmt.signalr.models.SignalRUsageName
    :param unit: Representing the units of the usage quota. Possible values
     are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond.
    :type unit: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'SignalRUsageName'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SignalRUsage, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)


class SignalRUsageName(Model):
    """Localizable String object containing the name and a localized value.

    :param value: The identifier of the usage.
    :type value: str
    :param localized_value: Localized name of the usage.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SignalRUsageName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class UpstreamTemplate(Model):
    """Upstream template item settings. It defines the Upstream URL of the
    incoming requests.
    The template defines the pattern of the event, the hub or the category of
    the incoming request that matches current URL template.

    All required parameters must be populated in order to send to Azure.

    :param hub_pattern: Gets or sets the matching pattern for hub names. If
     not set, it matches any hub.
     There are 3 kind of patterns supported:
     1. "*", it to matches any hub name
     2. Combine multiple hubs with ",", for example "hub1,hub2", it matches
     "hub1" and "hub2"
     3. The single hub name, for example, "hub1", it matches "hub1"
    :type hub_pattern: str
    :param event_pattern: Gets or sets the matching pattern for event names.
     If not set, it matches any event.
     There are 3 kind of patterns supported:
     1. "*", it to matches any event name
     2. Combine multiple events with ",", for example "connect,disconnect", it
     matches event "connect" and "disconnect"
     3. The single event name, for example, "connect", it matches "connect"
    :type event_pattern: str
    :param category_pattern: Gets or sets the matching pattern for category
     names. If not set, it matches any category.
     There are 3 kind of patterns supported:
     1. "*", it to matches any category name
     2. Combine multiple categories with ",", for example
     "connections,messages", it matches category "connections" and "messages"
     3. The single category name, for example, "connections", it matches the
     category "connections"
    :type category_pattern: str
    :param url_template: Required. Gets or sets the Upstream URL template. You
     can use 3 predefined parameters {hub}, {category} {event} inside the
     template, the value of the Upstream URL is dynamically calculated when the
     client request comes in.
     For example, if the urlTemplate is `http://example.com/{hub}/api/{event}`,
     with a client request from hub `chat` connects, it will first POST to this
     URL: `http://example.com/chat/api/connect`.
    :type url_template: str
    """

    _validation = {
        'url_template': {'required': True},
    }

    _attribute_map = {
        'hub_pattern': {'key': 'hubPattern', 'type': 'str'},
        'event_pattern': {'key': 'eventPattern', 'type': 'str'},
        'category_pattern': {'key': 'categoryPattern', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpstreamTemplate, self).__init__(**kwargs)
        self.hub_pattern = kwargs.get('hub_pattern', None)
        self.event_pattern = kwargs.get('event_pattern', None)
        self.category_pattern = kwargs.get('category_pattern', None)
        self.url_template = kwargs.get('url_template', None)
