# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar, Union
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_search_available_phone_numbers_request_initial(
    country_code,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/availablePhoneNumbers/countries/{countryCode}/:search')
    path_format_arguments = {
        "countryCode": _SERIALIZER.url("country_code", country_code, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_search_result_request(
    search_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/availablePhoneNumbers/searchResults/{searchId}')
    path_format_arguments = {
        "searchId": _SERIALIZER.url("search_id", search_id, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_purchase_phone_numbers_request_initial(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/availablePhoneNumbers/:purchase')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_operation_request(
    operation_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers/operations/{operationId}')
    path_format_arguments = {
        "operationId": _SERIALIZER.url("operation_id", operation_id, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_cancel_operation_request(
    operation_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers/operations/{operationId}')
    path_format_arguments = {
        "operationId": _SERIALIZER.url("operation_id", operation_id, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_update_capabilities_request_initial(
    phone_number,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers/{phoneNumber}/capabilities')
    path_format_arguments = {
        "phoneNumber": _SERIALIZER.url("phone_number", phone_number, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_by_number_request(
    phone_number,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers/{phoneNumber}')
    path_format_arguments = {
        "phoneNumber": _SERIALIZER.url("phone_number", phone_number, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_release_phone_number_request_initial(
    phone_number,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers/{phoneNumber}')
    path_format_arguments = {
        "phoneNumber": _SERIALIZER.url("phone_number", phone_number, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_phone_numbers_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
    skip = kwargs.pop('skip', 0)  # type: Optional[int]
    top = kwargs.pop('top', 100)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/phoneNumbers')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if skip is not None:
        query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if top is not None:
        query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class PhoneNumbersOperations(object):
    """PhoneNumbersOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.communication.phonenumbers.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def _search_available_phone_numbers_initial(
        self,
        country_code,  # type: str
        body,  # type: "_models.PhoneNumberSearchRequest"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.PhoneNumberSearchResult"
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PhoneNumberSearchResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'PhoneNumberSearchRequest')

        request = build_search_available_phone_numbers_request_initial(
            country_code=country_code,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._search_available_phone_numbers_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
        response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
        response_headers['search-id']=self._deserialize('str', response.headers.get('search-id'))

        deserialized = self._deserialize('PhoneNumberSearchResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _search_available_phone_numbers_initial.metadata = {'url': '/availablePhoneNumbers/countries/{countryCode}/:search'}  # type: ignore


    @distributed_trace
    def begin_search_available_phone_numbers(
        self,
        country_code,  # type: str
        body,  # type: "_models.PhoneNumberSearchRequest"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller["_models.PhoneNumberSearchResult"]
        """Search for available phone numbers to purchase.

        Search for available phone numbers to purchase.

        :param country_code: The ISO 3166-2 country code, e.g. US.
        :type country_code: str
        :param body: The phone number search request.
        :type body: ~azure.communication.phonenumbers.models.PhoneNumberSearchRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either PhoneNumberSearchResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.communication.phonenumbers.models.PhoneNumberSearchResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PhoneNumberSearchResult"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._search_available_phone_numbers_initial(
                country_code=country_code,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
            response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
            response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
            response_headers['search-id']=self._deserialize('str', response.headers.get('search-id'))
            
            deserialized = self._deserialize('PhoneNumberSearchResult', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)
            return deserialized


        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_search_available_phone_numbers.metadata = {'url': '/availablePhoneNumbers/countries/{countryCode}/:search'}  # type: ignore

    @distributed_trace
    def get_search_result(
        self,
        search_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.PhoneNumberSearchResult"
        """Gets a phone number search result by search id.

        Gets a phone number search result by search id.

        :param search_id: The search Id.
        :type search_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PhoneNumberSearchResult, or the result of cls(response)
        :rtype: ~azure.communication.phonenumbers.models.PhoneNumberSearchResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PhoneNumberSearchResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        
        request = build_get_search_result_request(
            search_id=search_id,
            api_version=api_version,
            template_url=self.get_search_result.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PhoneNumberSearchResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_search_result.metadata = {'url': '/availablePhoneNumbers/searchResults/{searchId}'}  # type: ignore


    def _purchase_phone_numbers_initial(
        self,
        search_id=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _body = _models.PhoneNumberPurchaseRequest(search_id=search_id)
        _json = self._serialize.body(_body, 'PhoneNumberPurchaseRequest')

        request = build_purchase_phone_numbers_request_initial(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._purchase_phone_numbers_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
        response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
        response_headers['purchase-id']=self._deserialize('str', response.headers.get('purchase-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    _purchase_phone_numbers_initial.metadata = {'url': '/availablePhoneNumbers/:purchase'}  # type: ignore


    @distributed_trace
    def begin_purchase_phone_numbers(
        self,
        search_id=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Purchases phone numbers.

        Purchases phone numbers.

        :param search_id: The search id.
        :type search_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._purchase_phone_numbers_initial(
                search_id=search_id,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_purchase_phone_numbers.metadata = {'url': '/availablePhoneNumbers/:purchase'}  # type: ignore

    @distributed_trace
    def get_operation(
        self,
        operation_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.PhoneNumberOperation"
        """Gets an operation by its id.

        Gets an operation by its id.

        :param operation_id: The id of the operation.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PhoneNumberOperation, or the result of cls(response)
        :rtype: ~azure.communication.phonenumbers.models.PhoneNumberOperation
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PhoneNumberOperation"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        
        request = build_get_operation_request(
            operation_id=operation_id,
            api_version=api_version,
            template_url=self.get_operation.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Location']=self._deserialize('str', response.headers.get('Location'))

        deserialized = self._deserialize('PhoneNumberOperation', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    get_operation.metadata = {'url': '/phoneNumbers/operations/{operationId}'}  # type: ignore


    @distributed_trace
    def cancel_operation(
        self,
        operation_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Cancels an operation by its id.

        Cancels an operation by its id.

        :param operation_id: The id of the operation.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        
        request = build_cancel_operation_request(
            operation_id=operation_id,
            api_version=api_version,
            template_url=self.cancel_operation.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    cancel_operation.metadata = {'url': '/phoneNumbers/operations/{operationId}'}  # type: ignore


    def _update_capabilities_initial(
        self,
        phone_number,  # type: str
        calling=None,  # type: Optional[Union[str, "_models.PhoneNumberCapabilityType"]]
        sms=None,  # type: Optional[Union[str, "_models.PhoneNumberCapabilityType"]]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.PurchasedPhoneNumber"
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PurchasedPhoneNumber"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/merge-patch+json")  # type: Optional[str]

        _body = _models.PhoneNumberCapabilitiesRequest(calling=calling, sms=sms)
        if _body is not None:
            _json = self._serialize.body(_body, 'PhoneNumberCapabilitiesRequest')
        else:
            _json = None

        request = build_update_capabilities_request_initial(
            phone_number=phone_number,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._update_capabilities_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
        response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
        response_headers['capabilities-id']=self._deserialize('str', response.headers.get('capabilities-id'))

        deserialized = self._deserialize('PurchasedPhoneNumber', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _update_capabilities_initial.metadata = {'url': '/phoneNumbers/{phoneNumber}/capabilities'}  # type: ignore


    @distributed_trace
    def begin_update_capabilities(
        self,
        phone_number,  # type: str
        calling=None,  # type: Optional[Union[str, "_models.PhoneNumberCapabilityType"]]
        sms=None,  # type: Optional[Union[str, "_models.PhoneNumberCapabilityType"]]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller["_models.PurchasedPhoneNumber"]
        """Updates the capabilities of a phone number.

        Updates the capabilities of a phone number.

        :param phone_number: The phone number id in E.164 format. The leading plus can be either + or
         encoded as %2B, e.g. +11234567890.
        :type phone_number: str
        :param calling: Capability value for calling.
        :type calling: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        :param sms: Capability value for SMS.
        :type sms: str or ~azure.communication.phonenumbers.models.PhoneNumberCapabilityType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either PurchasedPhoneNumber or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.communication.phonenumbers.models.PurchasedPhoneNumber]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        content_type = kwargs.pop('content_type', "application/merge-patch+json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PurchasedPhoneNumber"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_capabilities_initial(
                phone_number=phone_number,
                calling=calling,
                sms=sms,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
            response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
            response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
            response_headers['capabilities-id']=self._deserialize('str', response.headers.get('capabilities-id'))
            
            deserialized = self._deserialize('PurchasedPhoneNumber', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, response_headers)
            return deserialized


        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_update_capabilities.metadata = {'url': '/phoneNumbers/{phoneNumber}/capabilities'}  # type: ignore

    @distributed_trace
    def get_by_number(
        self,
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.PurchasedPhoneNumber"
        """Gets the details of the given purchased phone number.

        Gets the details of the given purchased phone number.

        :param phone_number: The purchased phone number whose details are to be fetched in E.164
         format, e.g. +11234567890.
        :type phone_number: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PurchasedPhoneNumber, or the result of cls(response)
        :rtype: ~azure.communication.phonenumbers.models.PurchasedPhoneNumber
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PurchasedPhoneNumber"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        
        request = build_get_by_number_request(
            phone_number=phone_number,
            api_version=api_version,
            template_url=self.get_by_number.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PurchasedPhoneNumber', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_by_number.metadata = {'url': '/phoneNumbers/{phoneNumber}'}  # type: ignore


    def _release_phone_number_initial(
        self,
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        
        request = build_release_phone_number_request_initial(
            phone_number=phone_number,
            api_version=api_version,
            template_url=self._release_phone_number_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
        response_headers['operation-id']=self._deserialize('str', response.headers.get('operation-id'))
        response_headers['release-id']=self._deserialize('str', response.headers.get('release-id'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    _release_phone_number_initial.metadata = {'url': '/phoneNumbers/{phoneNumber}'}  # type: ignore


    @distributed_trace
    def begin_release_phone_number(
        self,
        phone_number,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Releases a purchased phone number.

        Releases a purchased phone number.

        :param phone_number: Phone number to be released, e.g. +11234567890.
        :type phone_number: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._release_phone_number_initial(
                phone_number=phone_number,
                api_version=api_version,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_release_phone_number.metadata = {'url': '/phoneNumbers/{phoneNumber}'}  # type: ignore

    @distributed_trace
    def list_phone_numbers(
        self,
        skip=0,  # type: Optional[int]
        top=100,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PurchasedPhoneNumbers"]
        """Gets the list of all purchased phone numbers.

        Gets the list of all purchased phone numbers.

        :param skip: An optional parameter for how many entries to skip, for pagination purposes. The
         default value is 0.
        :type skip: int
        :param top: An optional parameter for how many entries to return, for pagination purposes. The
         default value is 100.
        :type top: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PurchasedPhoneNumbers or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.communication.phonenumbers.models.PurchasedPhoneNumbers]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2022-01-11-preview2")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PurchasedPhoneNumbers"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_phone_numbers_request(
                    api_version=api_version,
                    skip=skip,
                    top=top,
                    template_url=self.list_phone_numbers.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_phone_numbers_request(
                    api_version=api_version,
                    skip=skip,
                    top=top,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PurchasedPhoneNumbers", pipeline_response)
            list_of_elem = deserialized.phone_numbers
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_phone_numbers.metadata = {'url': '/phoneNumbers'}  # type: ignore
