# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import _model_base, models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ..._vendor import prepare_multipart_form_data
from ...operations._operations import (
    build_discovery_auto_complete_request,
    build_discovery_query_request,
    build_discovery_suggest_request,
    build_entity_add_classification_request,
    build_entity_add_classifications_by_unique_attribute_request,
    build_entity_add_classifications_request,
    build_entity_add_label_request,
    build_entity_add_labels_by_unique_attribute_request,
    build_entity_add_or_update_business_metadata_attributes_request,
    build_entity_add_or_update_business_metadata_request,
    build_entity_batch_create_or_update_request,
    build_entity_batch_delete_request,
    build_entity_batch_get_by_unique_attributes_request,
    build_entity_batch_set_classifications_request,
    build_entity_create_or_update_request,
    build_entity_delete_by_unique_attribute_request,
    build_entity_delete_request,
    build_entity_get_business_metadata_template_request,
    build_entity_get_by_ids_request,
    build_entity_get_by_unique_attribute_request,
    build_entity_get_classification_request,
    build_entity_get_classifications_request,
    build_entity_get_header_request,
    build_entity_get_request,
    build_entity_import_business_metadata_request,
    build_entity_move_entities_to_collection_request,
    build_entity_remove_business_metadata_attributes_request,
    build_entity_remove_business_metadata_request,
    build_entity_remove_classification_by_unique_attribute_request,
    build_entity_remove_classification_request,
    build_entity_remove_labels_by_unique_attribute_request,
    build_entity_remove_labels_request,
    build_entity_set_labels_by_unique_attribute_request,
    build_entity_set_labels_request,
    build_entity_update_attribute_by_id_request,
    build_entity_update_by_unique_attribute_request,
    build_entity_update_classifications_request,
    build_entity_update_classifications_unique_by_attribute_request,
    build_glossary_assign_term_to_entities_request,
    build_glossary_batch_get_request,
    build_glossary_create_categories_request,
    build_glossary_create_category_request,
    build_glossary_create_request,
    build_glossary_create_term_request,
    build_glossary_create_terms_request,
    build_glossary_delete_category_request,
    build_glossary_delete_request,
    build_glossary_delete_term_assignment_from_entities_request,
    build_glossary_delete_term_request,
    build_glossary_get_categories_headers_request,
    build_glossary_get_categories_request,
    build_glossary_get_category_request,
    build_glossary_get_category_terms_request,
    build_glossary_get_detailed_request,
    build_glossary_get_entities_assigned_with_term_request,
    build_glossary_get_related_categories_request,
    build_glossary_get_related_terms_request,
    build_glossary_get_request,
    build_glossary_get_term_headers_request,
    build_glossary_get_term_request,
    build_glossary_get_terms_request,
    build_glossary_partial_update_category_request,
    build_glossary_partial_update_request,
    build_glossary_partial_update_term_request,
    build_glossary_update_category_request,
    build_glossary_update_request,
    build_glossary_update_term_request,
    build_lineage_get_by_unique_attribute_request,
    build_lineage_get_next_page_request,
    build_lineage_get_request,
    build_relationship_create_request,
    build_relationship_delete_request,
    build_relationship_get_request,
    build_relationship_update_request,
    build_type_definition_batch_create_request,
    build_type_definition_batch_delete_request,
    build_type_definition_batch_update_request,
    build_type_definition_delete_request,
    build_type_definition_get_business_metadata_by_id_request,
    build_type_definition_get_business_metadata_by_name_request,
    build_type_definition_get_by_id_request,
    build_type_definition_get_by_name_request,
    build_type_definition_get_classification_by_id_request,
    build_type_definition_get_classification_by_name_request,
    build_type_definition_get_entity_by_id_request,
    build_type_definition_get_entity_by_name_request,
    build_type_definition_get_enum_by_id_request,
    build_type_definition_get_enum_by_name_request,
    build_type_definition_get_headers_request,
    build_type_definition_get_relationship_by_id_request,
    build_type_definition_get_relationship_by_name_request,
    build_type_definition_get_request,
    build_type_definition_get_struct_by_id_request,
    build_type_definition_get_struct_by_name_request,
    build_type_definition_get_term_template_by_id_request,
    build_type_definition_get_term_template_by_name_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class EntityOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`entity` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update(
        self,
        body: _models.AtlasEntityWithExtInfo,
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array:code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def create_or_update(
        self,
        body: JSON,
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array:code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Required.
        :type body: JSON
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def create_or_update(
        self,
        body: IO[bytes],
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array:code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Required.
        :type body: IO[bytes]
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        body: Union[_models.AtlasEntityWithExtInfo, JSON, IO[bytes]],
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array:code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Is one of the following types: AtlasEntityWithExtInfo, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo or JSON or IO[bytes]
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_create_or_update_request(
            business_attribute_update_behavior=business_attribute_update_behavior,
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_by_ids(
        self,
        *,
        guid: List[str],
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasEntitiesWithExtInfo:
        # pylint: disable=line-too-long
        """List entities in bulk identified by its GUIDs.

        :keyword guid: An array of GUIDs of entities to list. Required.
        :paramtype guid: list[str]
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :return: AtlasEntitiesWithExtInfo. The AtlasEntitiesWithExtInfo is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntitiesWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_by_ids_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntitiesWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def batch_create_or_update(
        self,
        body: _models.AtlasEntitiesWithExtInfo,
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def batch_create_or_update(
        self,
        body: JSON,
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Required.
        :type body: JSON
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def batch_create_or_update(
        self,
        body: IO[bytes],
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Required.
        :type body: IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def batch_create_or_update(
        self,
        body: Union[_models.AtlasEntitiesWithExtInfo, JSON, IO[bytes]],
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array:code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Is one of the following types: AtlasEntitiesWithExtInfo, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo or JSON or IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_batch_create_or_update_request(
            collection_id=collection_id,
            business_attribute_update_behavior=business_attribute_update_behavior,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def batch_delete(self, *, guid: List[str], **kwargs: Any) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Delete a list of entities in bulk identified by their GUIDs or unique
        attributes.

        :keyword guid: An array of GUIDs of entities to delete. Required.
        :paramtype guid: list[str]
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_batch_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_classification(  # pylint: disable=inconsistent-return-statements
        self, body: _models.ClassificationAssociateOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Associate a classification to multiple entities in bulk.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.ClassificationAssociateOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "classification": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    },
                    "entityGuids": [
                        "str"  # Optional. The GUID of the entity.
                    ]
                }
        """

    @overload
    async def add_classification(  # pylint: disable=inconsistent-return-statements
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_classification(  # pylint: disable=inconsistent-return-statements
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classification(  # pylint: disable=inconsistent-return-statements
        self, body: Union[_models.ClassificationAssociateOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Associate a classification to multiple entities in bulk.

        :param body: Is one of the following types: ClassificationAssociateOptions, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.ClassificationAssociateOptions or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "classification": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    },
                    "entityGuids": [
                        "str"  # Optional. The GUID of the entity.
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classification_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        guid: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasEntityWithExtInfo:
        # pylint: disable=line-too-long
        """Get complete definition of an entity given its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :return: AtlasEntityWithExtInfo. The AtlasEntityWithExtInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def update_attribute_by_id(
        self, guid: str, body: Any, *, name: str, **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Update entity partially - create or update entity attribute identified by its
        GUID.
        Supports only primitive attribute type and entity references.
        It does not support updating complex types like arrays, and maps.
        Null updates are not possible.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: The value of the attribute. Required.
        :type body: any
        :keyword name: The name of the attribute. Required.
        :paramtype name: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_attribute_by_id_request(
            guid=guid,
            name=name,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, guid: str, **kwargs: Any) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Delete an entity identified by its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_classification(
        self, guid: str, classification_name: str, **kwargs: Any
    ) -> _models.AtlasClassification:
        # pylint: disable=line-too-long
        """Get classification for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :return: AtlasClassification. The AtlasClassification is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassification
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "entityGuid": "str",  # Optional. The GUID of the entity.
                    "entityStatus": "str",  # Optional. Status of the entity - can be active or
                      deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                      "DELETED".
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                      propagations will be removed on entity deletion.
                    "typeName": "str",  # Optional. The name of the type.
                    "validityPeriods": [
                        {
                            "endTime": "str",  # Optional. The end of the time boundary.
                            "startTime": "str",  # Optional. The start of the time
                              boundary.
                            "timeZone": "str"  # Optional. The timezone of the time
                              boundary.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassification] = kwargs.pop("cls", None)

        _request = build_entity_get_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassification, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_classification(  # pylint: disable=inconsistent-return-statements
        self, guid: str, classification_name: str, **kwargs: Any
    ) -> None:
        """Delete a given classification from an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_entity_remove_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_classifications(self, guid: str, **kwargs: Any) -> _models.AtlasClassifications:
        # pylint: disable=line-too-long
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: AtlasClassifications. The AtlasClassifications is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassifications
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "list": [
                        {}  # Optional. An array of objects.
                    ],
                    "pageSize": 0,  # Optional. The size of the page.
                    "sortBy": "str",  # Optional. The sorted by field.
                    "sortType": "str",  # Optional. to specify whether the result should be
                      sorted? If yes, whether asc or desc. Known values are: "NONE", "ASC", and "DESC".
                    "startIndex": 0,  # Optional. The start index of the page.
                    "totalCount": 0  # Optional. The total count of items.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassifications] = kwargs.pop("cls", None)

        _request = build_entity_get_classifications_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassifications, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_classifications(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: List[_models.AtlasClassification],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """

    @overload
    async def add_classifications(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classifications(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Union[List[_models.AtlasClassification], IO[bytes]], **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Is either a [AtlasClassification] type or
         a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classifications_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_classifications(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: List[_models.AtlasClassification],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """

    @overload
    async def update_classifications(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_classifications(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Union[List[_models.AtlasClassification], IO[bytes]], **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Is either a [AtlasClassification] type
         or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_classifications_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_by_unique_attribute(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AtlasEntityWithExtInfo:
        # pylint: disable=line-too-long
        """Get complete definition of an entity given its type and unique attribute.

        In
        addition to the typeName path parameter, attribute key-value pair(s) can be
        provided in the following format:
        attr:\:code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The
        attrName and attrValue should be unique across entities, eg.
        qualifiedName.

        The REST request would look something like this:
        GET
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: AtlasEntityWithExtInfo. The AtlasEntityWithExtInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_by_unique_attribute_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: _models.AtlasEntityWithExtInfo,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: JSON,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Required.
        :type body: JSON
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: Union[_models.AtlasEntityWithExtInfo, JSON, IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr::code:`<attrName>`=:code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Is one of the following types: AtlasEntityWithExtInfo, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo or JSON or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entity": {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "businessAttributes": {
                            "str": {}  # Optional. Business attributes.
                        },
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "collectionId": "str",  # Optional. The collection ID of the entity.
                        "contacts": {
                            "str": [
                                {
                                    "id": "str",  # Optional. Azure Active
                                      Directory object Id.
                                    "info": "str"  # Optional. additional
                                      information to describe this contact.
                                }
                            ]
                        },
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "customAttributes": {
                            "str": "str"  # Optional. Custom Attribute.
                        },
                        "guid": "str",  # Optional. The GUID of the entity.
                        "homeId": "str",  # Optional. The home ID of the entity.
                        "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                        "labels": [
                            "str"  # Optional. labels.
                        ],
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "meanings": [
                            {
                                "confidence": 0,  # Optional. The confidence of the
                                  term assignment.
                                "createdBy": "str",  # Optional. The user who created
                                  the record.
                                "description": "str",  # Optional. The description of
                                  the term assignment.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term assignment.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of terms
                                  assignment. Known values are: "DISCOVERED", "PROPOSED", "IMPORTED",
                                  "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "provenanceType": 0,  # Optional. Used to record the provenance of an
                          instance of an entity or relationship.
                        "proxy": bool,  # Optional. Determines if there's a proxy.
                        "relationshipAttributes": {
                            "str": {}  # Optional. The attributes of relationship.
                        },
                        "status": "str",  # Optional. Status of the entity - can be active or
                          deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                          "DELETED".
                        "typeName": "str",  # Optional. The name of the type.
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "version": 0  # Optional. The version of the entity.
                    },
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_by_unique_attribute(
        self, type_name: str, *, attribute: Optional[str] = None, **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Delete an entity identified by its type and unique attributes.
        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\:code:`<attrName>`=\:code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_delete_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_classification_by_unique_attribute(  # pylint: disable=inconsistent-return-statements,name-too-long
        self, type_name: str, classification_name: str, *, attribute: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Delete a given classification from an entity identified by its type and unique
        attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_entity_remove_classification_by_unique_attribute_request(
            type_name=type_name,
            classification_name=classification_name,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_classifications_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: List[_models.AtlasClassification],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """

    @overload
    async def add_classifications_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classifications_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Union[List[_models.AtlasClassification], IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Is either a [AtlasClassification] type or
         a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classifications_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_classifications_unique_by_attribute(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        type_name: str,
        body: List[_models.AtlasClassification],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "attributes": {
                            "str": {}  # Optional. The attributes of the struct.
                        },
                        "entityGuid": "str",  # Optional. The GUID of the entity.
                        "entityStatus": "str",  # Optional. Status of the entity - can be
                          active or deleted. Deleted entities are not removed. Known values are:
                          "ACTIVE" and "DELETED".
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "removePropagationsOnEntityDelete": bool,  # Optional. Determines if
                          propagations will be removed on entity deletion.
                        "typeName": "str",  # Optional. The name of the type.
                        "validityPeriods": [
                            {
                                "endTime": "str",  # Optional. The end of the time
                                  boundary.
                                "startTime": "str",  # Optional. The start of the
                                  time boundary.
                                "timeZone": "str"  # Optional. The timezone of the
                                  time boundary.
                            }
                        ]
                    }
                ]
        """

    @overload
    async def update_classifications_unique_by_attribute(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_classifications_unique_by_attribute(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        type_name: str,
        body: Union[List[_models.AtlasClassification], IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Is either a [AtlasClassification] type
         or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_classifications_unique_by_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def batch_set_classifications(
        self, body: _models.AtlasEntityHeaders, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        # pylint: disable=line-too-long
        """Set classifications on entities in bulk.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityHeaders
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "guidHeaderMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    }
                }

                # response body for status code(s): 200
                response == [
                    "str"  # Optional.
                ]
        """

    @overload
    async def batch_set_classifications(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    "str"  # Optional.
                ]
        """

    @overload
    async def batch_set_classifications(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    "str"  # Optional.
                ]
        """

    @distributed_trace_async
    async def batch_set_classifications(
        self, body: Union[_models.AtlasEntityHeaders, JSON, IO[bytes]], **kwargs: Any
    ) -> List[str]:
        # pylint: disable=line-too-long
        """Set classifications on entities in bulk.

        :param body: Is one of the following types: AtlasEntityHeaders, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityHeaders or JSON or IO[bytes]
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "guidHeaderMap": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    }
                }

                # response body for status code(s): 200
                response == [
                    "str"  # Optional.
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[str]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_batch_set_classifications_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[str], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def batch_get_by_unique_attributes(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        attr_n_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AtlasEntitiesWithExtInfo:
        # pylint: disable=line-too-long
        """Bulk API to retrieve list of entities identified by its unique attributes.
        In
        addition to the typeName path parameter, attribute key-value pair(s) can be
        provided in the following
        format

        typeName=\:code:`<typeName>`&attr_1:\:code:`<attrName>`=\:code:`<attrValue>`&attr_2:\:code:`<attrName>`=\:code:`<attrValue>`&attr_3:\:code:`<attrName>`=\:code:`<attrValue>`

        NOTE:
        The attrName should be an unique attribute for the given entity-type.
        The REST
        request would look something like this

        GET
        /v2/entity/bulk/uniqueAttribute/type/hive_db?attr_1:qualifiedName=db1@cl1&attr_2:qualifiedName=db2@cl1

        Note:
        at least one unique attribute must be provided.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :keyword attr_n_qualified_name: Qualified name of an entity. E.g. to find 2 entities you can
         set
         attrs_1:qualifiedName=db1@cl1&attrs_2:qualifiedName=db2@cl1. (This is only an
         example. qualifiedName can be changed to other unique attributes). Default value is None.
        :paramtype attr_n_qualified_name: str
        :return: AtlasEntitiesWithExtInfo. The AtlasEntitiesWithExtInfo is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "entities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    ],
                    "referredEntities": {
                        "str": {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "businessAttributes": {
                                "str": {}  # Optional. Business attributes.
                            },
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "collectionId": "str",  # Optional. The collection ID of the
                              entity.
                            "contacts": {
                                "str": [
                                    {
                                        "id": "str",  # Optional. Azure
                                          Active Directory object Id.
                                        "info": "str"  # Optional. additional
                                          information to describe this contact.
                                    }
                                ]
                            },
                            "createTime": 0,  # Optional. The created time of the record.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "customAttributes": {
                                "str": "str"  # Optional. Custom Attribute.
                            },
                            "guid": "str",  # Optional. The GUID of the entity.
                            "homeId": "str",  # Optional. The home ID of the entity.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "provenanceType": 0,  # Optional. Used to record the
                              provenance of an instance of an entity or relationship.
                            "proxy": bool,  # Optional. Determines if there's a proxy.
                            "relationshipAttributes": {
                                "str": {}  # Optional. The attributes of
                                  relationship.
                            },
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str",  # Optional. The name of the type.
                            "updateTime": 0,  # Optional. The update time of the record.
                            "updatedBy": "str",  # Optional. The user who updated the
                              record.
                            "version": 0  # Optional. The version of the entity.
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntitiesWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_batch_get_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_n_qualified_name=attr_n_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntitiesWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_header(self, guid: str, **kwargs: Any) -> _models.AtlasEntityHeader:
        # pylint: disable=line-too-long
        """Get entity header given its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: AtlasEntityHeader. The AtlasEntityHeader is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityHeader
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attributes": {
                        "str": {}  # Optional. The attributes of the struct.
                    },
                    "classificationNames": [
                        "str"  # Optional. An array of classification names.
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "displayText": "str",  # Optional. The display text.
                    "guid": "str",  # Optional. The GUID of the record.
                    "isIncomplete": bool,  # Optional. Whether it is a shell entity.
                    "labels": [
                        "str"  # Optional. labels.
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "meaningNames": [
                        "str"  # Optional. An array of meanings.
                    ],
                    "meanings": [
                        {
                            "confidence": 0,  # Optional. The confidence of the term
                              assignment.
                            "createdBy": "str",  # Optional. The user who created the
                              record.
                            "description": "str",  # Optional. The description of the
                              term assignment.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term
                              assignment.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of terms assignment.
                              Known values are: "DISCOVERED", "PROPOSED", "IMPORTED", "VALIDATED",
                              "DEPRECATED", "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "status": "str",  # Optional. Status of the entity - can be active or
                      deleted. Deleted entities are not removed. Known values are: "ACTIVE" and
                      "DELETED".
                    "typeName": "str"  # Optional. The name of the type.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityHeader] = kwargs.pop("cls", None)

        _request = build_entity_get_header_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityHeader, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove_business_metadata(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Dict[str, Dict[str, Any]], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Required.
        :type body: dict[str, dict[str, any]]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {
                        "str": {}  # Optional.
                    }
                }
        """

    @overload
    async def remove_business_metadata(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_business_metadata(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Union[Dict[str, Dict[str, Any]], IO[bytes]], **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Is either a {str: {str: Any}} type or a IO[bytes] type.
         Required.
        :type body: dict[str, dict[str, any]] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_remove_business_metadata_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_or_update_business_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Dict[str, Dict[str, Any]],
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Required.
        :type body: dict[str, dict[str, any]]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {
                        "str": {}  # Optional.
                    }
                }
        """

    @overload
    async def add_or_update_business_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: IO[bytes],
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Required.
        :type body: IO[bytes]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_or_update_business_metadata(  # pylint: disable=inconsistent-return-statements
        self,
        guid: str,
        body: Union[Dict[str, Dict[str, Any]], IO[bytes]],
        *,
        overwrite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Is either a {str: {str: Any}} type or a IO[bytes] type.
         Required.
        :type body: dict[str, dict[str, any]] or IO[bytes]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_or_update_business_metadata_request(
            guid=guid,
            overwrite=overwrite,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def remove_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements
        self,
        business_metadata_name: str,
        guid: str,
        body: Dict[str, Any],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: dict[str, any]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """

    @overload
    async def remove_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements
        self,
        business_metadata_name: str,
        guid: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements
        self, business_metadata_name: str, guid: str, body: Union[Dict[str, Any], IO[bytes]], **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Is either a {str: Any} type or a IO[bytes]
         type. Required.
        :type body: dict[str, any] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_remove_business_metadata_attributes_request(
            business_metadata_name=business_metadata_name,
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_or_update_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        business_metadata_name: str,
        guid: str,
        body: Dict[str, Any],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: dict[str, any]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": {}  # Optional.
                }
        """

    @overload
    async def add_or_update_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements,name-too-long
        self,
        business_metadata_name: str,
        guid: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_or_update_business_metadata_attributes(  # pylint: disable=inconsistent-return-statements,name-too-long
        self, business_metadata_name: str, guid: str, body: Union[Dict[str, Any], IO[bytes]], **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Is either a {str: Any} type or a IO[bytes]
         type. Required.
        :type body: dict[str, any] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_or_update_business_metadata_attributes_request(
            business_metadata_name=business_metadata_name,
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_business_metadata_template(self, **kwargs: Any) -> bytes:
        """Get the sample Template for uploading/creating bulk BusinessMetaData.

        :return: bytes
        :rtype: bytes
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[bytes] = kwargs.pop("cls", None)

        _request = build_entity_get_business_metadata_template_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = await response.read()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def import_business_metadata(
        self, body: _models.BusinessMetadataOptions, **kwargs: Any
    ) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.BusinessMetadataOptions
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "file": filetype
                }

                # response body for status code(s): 200
                response == {
                    "failedImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ],
                    "successImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ]
                }
        """

    @overload
    async def import_business_metadata(self, body: JSON, **kwargs: Any) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Required.
        :type body: JSON
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "failedImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ],
                    "successImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def import_business_metadata(
        self, body: Union[_models.BusinessMetadataOptions, JSON], **kwargs: Any
    ) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Is either a BusinessMetadataOptions type or a JSON type. Required.
        :type body: ~azure.purview.datamap.models.BusinessMetadataOptions or JSON
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "file": filetype
                }

                # response body for status code(s): 200
                response == {
                    "failedImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ],
                    "successImportInfoList": [
                        {
                            "childObjectName": "str",  # Optional. childObjectName.
                            "importStatus": "str",  # Optional. importStatus. Known
                              values are: "SUCCESS" and "FAILED".
                            "parentObjectName": "str",  # Optional. parentObjectName.
                            "remarks": "str"  # Optional. remarks.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BulkImportResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["file"]
        _data_fields: List[str] = []
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_entity_import_business_metadata_request(
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BulkImportResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def remove_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_remove_labels_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def set_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def set_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_labels(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Is either a [str] type or a IO[bytes] type.
         Default value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_set_labels_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_label(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def add_label(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_label(  # pylint: disable=inconsistent-return-statements
        self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any
    ) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_add_label_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def remove_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def remove_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr::code:`<attrName>`=:code:`<attrValue>`. NOTE: The attrName and attrValue should be unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_remove_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def set_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def set_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Is either a [str] type or a IO[bytes] type. Default value
         is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_set_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    "str"  # Optional.
                ]
        """

    @overload
    async def add_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_labels_by_unique_attribute(  # pylint: disable=inconsistent-return-statements
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr::code:`<attrName>`=:code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_add_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def move_entities_to_collection(
        self,
        body: _models.MoveEntitiesOptions,
        *,
        collection_id: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Move existing entities to the target collection.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.MoveEntitiesOptions
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entityGuids": [
                        "str"  # Optional. An array of entity guids to be moved to target
                          collection.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def move_entities_to_collection(
        self, body: JSON, *, collection_id: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Move existing entities to the target collection.

        :param body: Required.
        :type body: JSON
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @overload
    async def move_entities_to_collection(
        self, body: IO[bytes], *, collection_id: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Move existing entities to the target collection.

        :param body: Required.
        :type body: IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def move_entities_to_collection(
        self, body: Union[_models.MoveEntitiesOptions, JSON, IO[bytes]], *, collection_id: str, **kwargs: Any
    ) -> _models.EntityMutationResult:
        # pylint: disable=line-too-long
        """Move existing entities to the target collection.

        :param body: Is one of the following types: MoveEntitiesOptions, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.MoveEntitiesOptions or JSON or IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "entityGuids": [
                        "str"  # Optional. An array of entity guids to be moved to target
                          collection.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "guidAssignments": {
                        "str": "str"  # Optional. A map of GUID assignments with entities.
                    },
                    "mutatedEntities": {
                        "str": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "classificationNames": [
                                    "str"  # Optional. An array of classification
                                      names.
                                ],
                                "classifications": [
                                    {
                                        "attributes": {
                                            "str": {}  # Optional. The
                                              attributes of the struct.
                                        },
                                        "entityGuid": "str",  # Optional. The
                                          GUID of the entity.
                                        "entityStatus": "str",  # Optional.
                                          Status of the entity - can be active or deleted. Deleted
                                          entities are not removed. Known values are: "ACTIVE" and
                                          "DELETED".
                                        "lastModifiedTS": "str",  # Optional.
                                          ETag for concurrency control.
                                        "removePropagationsOnEntityDelete":
                                          bool,  # Optional. Determines if propagations will be removed
                                          on entity deletion.
                                        "typeName": "str",  # Optional. The
                                          name of the type.
                                        "validityPeriods": [
                                            {
                                                "endTime": "str",  #
                                                  Optional. The end of the time boundary.
                                                "startTime": "str",
                                                  # Optional. The start of the time boundary.
                                                "timeZone": "str"  #
                                                  Optional. The timezone of the time boundary.
                                            }
                                        ]
                                    }
                                ],
                                "displayText": "str",  # Optional. The display text.
                                "guid": "str",  # Optional. The GUID of the record.
                                "isIncomplete": bool,  # Optional. Whether it is a
                                  shell entity.
                                "labels": [
                                    "str"  # Optional. labels.
                                ],
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "meaningNames": [
                                    "str"  # Optional. An array of meanings.
                                ],
                                "meanings": [
                                    {
                                        "confidence": 0,  # Optional. The
                                          confidence of the term assignment.
                                        "createdBy": "str",  # Optional. The
                                          user who created the record.
                                        "description": "str",  # Optional.
                                          The description of the term assignment.
                                        "displayText": "str",  # Optional.
                                          The display text.
                                        "expression": "str",  # Optional. The
                                          expression of the term assignment.
                                        "relationGuid": "str",  # Optional.
                                          The GUID of the relationship.
                                        "status": "str",  # Optional. The
                                          status of terms assignment. Known values are: "DISCOVERED",
                                          "PROPOSED", "IMPORTED", "VALIDATED", "DEPRECATED",
                                          "OBSOLETE", and "OTHER".
                                        "steward": "str",  # Optional. The
                                          steward of the term.
                                        "termGuid": "str"  # Optional. The
                                          GUID of the term.
                                    }
                                ],
                                "status": "str",  # Optional. Status of the entity -
                                  can be active or deleted. Deleted entities are not removed. Known
                                  values are: "ACTIVE" and "DELETED".
                                "typeName": "str"  # Optional. The name of the type.
                            }
                        ]
                    },
                    "partialUpdatedEntities": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "classificationNames": [
                                "str"  # Optional. An array of classification names.
                            ],
                            "classifications": [
                                {
                                    "attributes": {
                                        "str": {}  # Optional. The attributes
                                          of the struct.
                                    },
                                    "entityGuid": "str",  # Optional. The GUID of
                                      the entity.
                                    "entityStatus": "str",  # Optional. Status of
                                      the entity - can be active or deleted. Deleted entities are not
                                      removed. Known values are: "ACTIVE" and "DELETED".
                                    "lastModifiedTS": "str",  # Optional. ETag
                                      for concurrency control.
                                    "removePropagationsOnEntityDelete": bool,  #
                                      Optional. Determines if propagations will be removed on entity
                                      deletion.
                                    "typeName": "str",  # Optional. The name of
                                      the type.
                                    "validityPeriods": [
                                        {
                                            "endTime": "str",  #
                                              Optional. The end of the time boundary.
                                            "startTime": "str",  #
                                              Optional. The start of the time boundary.
                                            "timeZone": "str"  #
                                              Optional. The timezone of the time boundary.
                                        }
                                    ]
                                }
                            ],
                            "displayText": "str",  # Optional. The display text.
                            "guid": "str",  # Optional. The GUID of the record.
                            "isIncomplete": bool,  # Optional. Whether it is a shell
                              entity.
                            "labels": [
                                "str"  # Optional. labels.
                            ],
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "meaningNames": [
                                "str"  # Optional. An array of meanings.
                            ],
                            "meanings": [
                                {
                                    "confidence": 0,  # Optional. The confidence
                                      of the term assignment.
                                    "createdBy": "str",  # Optional. The user who
                                      created the record.
                                    "description": "str",  # Optional. The
                                      description of the term assignment.
                                    "displayText": "str",  # Optional. The
                                      display text.
                                    "expression": "str",  # Optional. The
                                      expression of the term assignment.
                                    "relationGuid": "str",  # Optional. The GUID
                                      of the relationship.
                                    "status": "str",  # Optional. The status of
                                      terms assignment. Known values are: "DISCOVERED", "PROPOSED",
                                      "IMPORTED", "VALIDATED", "DEPRECATED", "OBSOLETE", and "OTHER".
                                    "steward": "str",  # Optional. The steward of
                                      the term.
                                    "termGuid": "str"  # Optional. The GUID of
                                      the term.
                                }
                            ],
                            "status": "str",  # Optional. Status of the entity - can be
                              active or deleted. Deleted entities are not removed. Known values are:
                              "ACTIVE" and "DELETED".
                            "typeName": "str"  # Optional. The name of the type.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_move_entities_to_collection_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class GlossaryOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`glossary` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def batch_get(
        self,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        ignore_terms_and_categories: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.AtlasGlossary]:
        # pylint: disable=line-too-long
        """Get all glossaries. Recommend using limit/offset to get pagination result.
        Recommend using 'ignoreTermsAndCategories=true' and fetch terms/categories
        separately using

         'GET /datamap/api/atlas/v2/glossary/{glossaryId}/terms'
        and

         'GET '/datamap/api/atlas/v2/glossary/{glossaryId}/categories'.

        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :return: list of AtlasGlossary
        :rtype: list[~azure.purview.datamap.models.AtlasGlossary]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "categories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the object.
                        "language": "str",  # Optional. The language of the glossary.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str",  # Optional. The user who updated the record.
                        "usage": "str"  # Optional. The usage of the glossary.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasGlossary]] = kwargs.pop("cls", None)

        _request = build_glossary_batch_get_request(
            limit=limit,
            offset=offset,
            sort=sort,
            ignore_terms_and_categories=ignore_terms_and_categories,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossary], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self, body: _models.AtlasGlossary, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        # pylint: disable=line-too-long
        """Create a glossary.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        # pylint: disable=line-too-long
        """Create a glossary.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        # pylint: disable=line-too-long
        """Create a glossary.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """

    @distributed_trace_async
    async def create(self, body: Union[_models.AtlasGlossary, JSON, IO[bytes]], **kwargs: Any) -> _models.AtlasGlossary:
        # pylint: disable=line-too-long
        """Create a glossary.

        :param body: Is one of the following types: AtlasGlossary, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary or JSON or IO[bytes]
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }

                # response body for status code(s): 200
                response == {
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "language": "str",  # Optional. The language of the glossary.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str"  # Optional. The usage of the glossary.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossary, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_categories(
        self, body: List[_models.AtlasGlossaryCategory], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        # pylint: disable=line-too-long
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str"  # Optional. The user who updated the record.
                    }
                ]

                # response body for status code(s): 200
                response == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str"  # Optional. The user who updated the record.
                    }
                ]
        """

    @overload
    async def create_categories(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        # pylint: disable=line-too-long
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str"  # Optional. The user who updated the record.
                    }
                ]
        """

    @distributed_trace_async
    async def create_categories(
        self, body: Union[List[_models.AtlasGlossaryCategory], IO[bytes]], **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        # pylint: disable=line-too-long
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Is either a
         [AtlasGlossaryCategory] type or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryCategory] or IO[bytes]
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "anchor": {
                            "displayText": "str",  # Optional. The display text.
                            "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "childrenCategories": [
                            {
                                "categoryGuid": "str",  # Optional. The GUID of the
                                  category.
                                "description": "str",  # Optional. The description of
                                  the category header.
                                "displayText": "str",  # Optional. The display text.
                                "parentCategoryGuid": "str",  # Optional. The GUID of
                                  the parent category.
                                "relationGuid": "str"  # Optional. The GUID of the
                                  relationship.
                            }
                        ],
                        "classifications": [
                            {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "entityGuid": "str",  # Optional. The GUID of the
                                  entity.
                                "entityStatus": "str",  # Optional. Status of the
                                  entity - can be active or deleted. Deleted entities are not removed.
                                  Known values are: "ACTIVE" and "DELETED".
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "removePropagationsOnEntityDelete": bool,  #
                                  Optional. Determines if propagations will be removed on entity
                                  deletion.
                                "typeName": "str",  # Optional. The name of the type.
                                "validityPeriods": [
                                    {
                                        "endTime": "str",  # Optional. The
                                          end of the time boundary.
                                        "startTime": "str",  # Optional. The
                                          start of the time boundary.
                                        "timeZone": "str"  # Optional. The
                                          timezone of the time boundary.
                                    }
                                ]
                            }
                        ],
                        "createTime": 0,  # Optional. The created time of the record.
                        "createdBy": "str",  # Optional. The user who created the record.
                        "guid": "str",  # Optional. The GUID of the object.
                        "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                        "longDescription": "str",  # Optional. The long version description.
                        "name": "str",  # Optional. The name of the glossary object.
                        "parentCategory": {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        },
                        "qualifiedName": "str",  # Optional. The qualified name of the
                          glossary object.
                        "shortDescription": "str",  # Optional. The short version of
                          description.
                        "terms": [
                            {
                                "description": "str",  # Optional. The description of
                                  the related term.
                                "displayText": "str",  # Optional. The display text.
                                "expression": "str",  # Optional. The expression of
                                  the term.
                                "relationGuid": "str",  # Optional. The GUID of the
                                  relationship.
                                "status": "str",  # Optional. The status of term
                                  relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                                  "OBSOLETE", and "OTHER".
                                "steward": "str",  # Optional. The steward of the
                                  term.
                                "termGuid": "str"  # Optional. The GUID of the term.
                            }
                        ],
                        "updateTime": 0,  # Optional. The update time of the record.
                        "updatedBy": "str"  # Optional. The user who updated the record.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.AtlasGlossaryCategory]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_categories_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossaryCategory], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_category(
        self, body: _models.AtlasGlossaryCategory, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Create a glossary category.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @overload
    async def create_category(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Create a glossary category.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @overload
    async def create_category(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Create a glossary category.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @distributed_trace_async
    async def create_category(
        self, body: Union[_models.AtlasGlossaryCategory, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Create a glossary category.

        :param body: Is one of the following types: AtlasGlossaryCategory, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory or JSON or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_category_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_category(self, category_id: str, **kwargs: Any) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Get specific glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        _request = build_glossary_get_category_request(
            category_id=category_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_category(
        self,
        category_id: str,
        body: _models.AtlasGlossaryCategory,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @overload
    async def update_category(
        self, category_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @overload
    async def update_category(
        self, category_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @distributed_trace_async
    async def update_category(
        self, category_id: str, body: Union[_models.AtlasGlossaryCategory, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Is one of the following types: AtlasGlossaryCategory, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory or JSON or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_update_category_request(
            category_id=category_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_category(  # pylint: disable=inconsistent-return-statements
        self, category_id: str, **kwargs: Any
    ) -> None:
        """Delete a glossary category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_glossary_delete_category_request(
            category_id=category_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def partial_update_category(
        self, category_id: str, body: Dict[str, str], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Required.
        :type body: dict[str, str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @overload
    async def partial_update_category(
        self, category_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """

    @distributed_trace_async
    async def partial_update_category(
        self, category_id: str, body: Union[Dict[str, str], IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        # pylint: disable=line-too-long
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Is either a {str: str} type or a IO[bytes] type. Required.
        :type body: dict[str, str] or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "childrenCategories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "guid": "str",  # Optional. The GUID of the object.
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "parentCategory": {
                        "categoryGuid": "str",  # Optional. The GUID of the category.
                        "description": "str",  # Optional. The description of the category
                          header.
                        "displayText": "str",  # Optional. The display text.
                        "parentCategoryGuid": "str",  # Optional. The GUID of the parent
                          category.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "shortDescription": "str",  # Optional. The short version of description.
                    "terms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str"  # Optional. The user who updated the record.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_partial_update_category_request(
            category_id=category_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_related_categories(
        self,
        category_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> Dict[str, List[_models.AtlasRelatedCategoryHeader]]:
        """Get all related categories (parent and children). Limit, offset, and sort
        parameters are currently not being enabled and won't work even they are passed.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: dict mapping str to list of AtlasRelatedCategoryHeader
        :rtype: dict[str, list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "str": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              category header.
                            "displayText": "str",  # Optional. The display text.
                            "parentCategoryGuid": "str",  # Optional. The GUID of the
                              parent category.
                            "relationGuid": "str"  # Optional. The GUID of the
                              relationship.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[_models.AtlasRelatedCategoryHeader]]] = kwargs.pop("cls", None)

        _request = build_glossary_get_related_categories_request(
            category_id=category_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(Dict[str, List[_models.AtlasRelatedCategoryHeader]], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_category_terms(
        self,
        category_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasRelatedTermHeader]:
        # pylint: disable=line-too-long
        """Get all terms associated with the specific category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasRelatedTermHeader
        :rtype: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "description": "str",  # Optional. The description of the related
                          term.
                        "displayText": "str",  # Optional. The display text.
                        "expression": "str",  # Optional. The expression of the term.
                        "relationGuid": "str",  # Optional. The GUID of the relationship.
                        "status": "str",  # Optional. The status of term relationship. Known
                          values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and "OTHER".
                        "steward": "str",  # Optional. The steward of the term.
                        "termGuid": "str"  # Optional. The GUID of the term.
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasRelatedTermHeader]] = kwargs.pop("cls", None)

        _request = build_glossary_get_category_terms_request(
            category_id=category_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasRelatedTermHeader], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_term(
        self,
        body: _models.AtlasGlossaryTerm,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Create a glossary term.

        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @overload
    async def create_term(
        self,
        body: JSON,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Create a glossary term.

        :param body: Required.
        :type body: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @overload
    async def create_term(
        self,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Create a glossary term.

        :param body: Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def create_term(
        self,
        body: Union[_models.AtlasGlossaryTerm, JSON, IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Create a glossary term.

        :param body: Is one of the following types: AtlasGlossaryTerm, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm or JSON or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_term_request(
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_term(self, term_id: str, **kwargs: Any) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Get a specific glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        _request = build_glossary_get_term_request(
            term_id=term_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_term(
        self,
        term_id: str,
        body: _models.AtlasGlossaryTerm,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @overload
    async def update_term(
        self,
        term_id: str,
        body: JSON,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Required.
        :type body: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @overload
    async def update_term(
        self,
        term_id: str,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def update_term(
        self,
        term_id: str,
        body: Union[_models.AtlasGlossaryTerm, JSON, IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Is one of the following types: AtlasGlossaryTerm, JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm or JSON or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "assignedEntities": [
                        {
                            "displayText": "str",  # Optional. The display text.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "guid": "str",  # Optional. The GUID of the object.
                            "relationshipAttributes": {
                                "attributes": {
                                    "str": {}  # Optional. The attributes of the
                                      struct.
                                },
                                "lastModifiedTS": "str",  # Optional. ETag for
                                  concurrency control.
                                "typeName": "str"  # Optional. The name of the type.
                            },
                            "relationshipGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "relationshipStatus": "str",  # Optional. The enum of
                              relationship status. Known values are: "ACTIVE" and "DELETED".
                            "relationshipType": "str",  # Optional. Relationship type.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "attributes": {
                        "str": {
                            "str": {}  # Optional. The custom attributes of the term,
                              which is map<string,map<string,object>>. The key of the first layer map
                              is term template name.
                        }
                    },
                    "categories": [
                        {
                            "categoryGuid": "str",  # Optional. The GUID of the category.
                            "description": "str",  # Optional. The description of the
                              record.
                            "displayText": "str",  # Optional. The display text.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str"  # Optional. The status of term relationship.
                              Known values are: "DRAFT", "ACTIVE", "DEPRECATED", "OBSOLETE", and
                              "OTHER".
                        }
                    ],
                    "classifications": [
                        {
                            "attributes": {
                                "str": {}  # Optional. The attributes of the struct.
                            },
                            "entityGuid": "str",  # Optional. The GUID of the entity.
                            "entityStatus": "str",  # Optional. Status of the entity -
                              can be active or deleted. Deleted entities are not removed. Known values
                              are: "ACTIVE" and "DELETED".
                            "lastModifiedTS": "str",  # Optional. ETag for concurrency
                              control.
                            "removePropagationsOnEntityDelete": bool,  # Optional.
                              Determines if propagations will be removed on entity deletion.
                            "typeName": "str",  # Optional. The name of the type.
                            "validityPeriods": [
                                {
                                    "endTime": "str",  # Optional. The end of the
                                      time boundary.
                                    "startTime": "str",  # Optional. The start of
                                      the time boundary.
                                    "timeZone": "str"  # Optional. The timezone
                                      of the time boundary.
                                }
                            ]
                        }
                    ],
                    "classifies": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "contacts": {
                        "str": [
                            {
                                "id": "str",  # Optional. Azure Active Directory
                                  object Id.
                                "info": "str"  # Optional. additional information to
                                  describe this contact.
                            }
                        ]
                    },
                    "createTime": 0,  # Optional. The created time of the record.
                    "createdBy": "str",  # Optional. The user who created the record.
                    "examples": [
                        "str"  # Optional. An array of examples.
                    ],
                    "guid": "str",  # Optional. The GUID of the object.
                    "hierarchyInfo": [
                        {
                            "displayText": "str",  # Optional. Display text.
                            "guid": "str",  # Optional. The GUID of the object.
                            "itemPath": "str",  # Optional. Item path.
                            "name": "str",  # Optional. Name.
                            "properties": {
                                "str": {}  # Optional. Dictionary of :code:`<any>`.
                            },
                            "resourceId": "str",  # Optional. Resource Id.
                            "typeName": "str",  # Optional. The name of the type.
                            "uniqueAttributes": {
                                "str": {}  # Optional. The unique attributes of the
                                  object.
                            }
                        }
                    ],
                    "isA": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "lastModifiedTS": "str",  # Optional. ETag for concurrency control.
                    "longDescription": "str",  # Optional. The long version description.
                    "name": "str",  # Optional. The name of the glossary object.
                    "nickName": "str",  # Optional. The nick name of the term.
                    "preferredTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "preferredToTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "qualifiedName": "str",  # Optional. The qualified name of the glossary
                      object.
                    "replacedBy": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "replacementTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "resources": [
                        {
                            "displayName": "str",  # Optional. Display name for url.
                            "url": "str"  # Optional. web url. http or https.
                        }
                    ],
                    "seeAlso": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "shortDescription": "str",  # Optional. The short version of description.
                    "status": "str",  # Optional. Status of the AtlasGlossaryTerm. Known values
                      are: "Draft", "Approved", "Alert", and "Expired".
                    "synonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "templateName": [
                        {}  # Optional. The name of the template.
                    ],
                    "translatedTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "translationTerms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "updateTime": 0,  # Optional. The update time of the record.
                    "updatedBy": "str",  # Optional. The user who updated the record.
                    "usage": "str",  # Optional. The usage of the term.
                    "validValues": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ],
                    "validValuesFor": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                            "relationGuid": "str",  # Optional. The GUID of the
                              relationship.
                            "status": "str",  # Optional. The status of term
                              relationship. Known values are: "DRAFT", "ACTIVE", "DEPRECATED",
                              "OBSOLETE", and "OTHER".
                            "steward": "str",  # Optional. The steward of the term.
                            "termGuid": "str"  # Optional. The GUID of the term.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_update_term_request(
            term_id=term_id,
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_term(self, term_id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Delete a glossary term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_glossary_delete_term_request(
            term_id=term_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def partial_update_term(
        self,
        term_id: str,
        body: Dict[str, str],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        # pylint: disable=line-too-long
        """Update the glossary term partially. So far we only supports partial updating
        shortDescription, longDescription, abbreviation, usage and status for term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values to be updated. Required.
        :type body: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "str": "str"  # Optional.
                }

                # response body for status code(s): 200
                response == {
                    "abbreviation": "str",  # Optional. The abbreviation of the term.
                    "anchor": {
                        "displayText": "str",  # Optional. The display text.
                        "glossaryGuid": "str",  # Optional. The GUID of the glossary.
                        "relationGuid": "str"  # Optional. The GUID of the relationship.
                    },
                    "antonyms": [
                        {
                            "description": "str",  # Optional. The description of the
                              related term.
                            "displayText": "str",  # Optional. The display text.
                            "expression": "str",  # Optional. The expression of the term.
                           