#
# $Id: make.inc,v 1.4 2001/11/01 20:43:17 mrnolta Exp $
#
# Copyright (C) 2001 Mike Nolta <mrnolta@users.sourceforge.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#

PYTHON			= python
CC			= gcc
CFLAGS			= -ansi -Wall -O2 -fpic

## compile flags for the libplot library (part of GNU plotutils)

LIBPLOT_PREFIX		= /usr/local
LIBPLOT_CPPFLAGS	= -I$(LIBPLOT_PREFIX)/include
LIBPLOT_LDFLAGS		= -L$(LIBPLOT_PREFIX)/lib -lplot \
		-L/usr/X11R6/lib -lXaw -lXmu -lXt -lSM -lICE -lXext -lX11

## uncomment this line if there isn't a Numeric include subdirectory
#NUMERIC_CPPFLAGS = -DNO_NUMERIC_INCDIR

## these options probably don't need to be changed

PYPREFIX	= $(shell $(PYTHON) -c 'import sys; print sys.prefix')
PYVERSION	= $(shell $(PYTHON) -c 'import sys; print sys.version[:3]')
PYINCLUDE	= $(PYPREFIX)/include/python$(PYVERSION)
PYSITEPKGS	= $(PYPREFIX)/lib/python$(PYVERSION)/site-packages
BIGGLESDIR	= $(PYSITEPKGS)/biggles
BASE_CPPFLAGS	= -I$(PYINCLUDE)
BASE_LDFLAGS	= -lm

