# This file is part of django-ca (https://github.com/mathiasertl/django-ca).
#
# django-ca is free software: you can redistribute it and/or modify it under the terms of the GNU General
# Public License as published by the Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# django-ca is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along with django-ca. If not, see
# <http://www.gnu.org/licenses/>.

"""Command to clean all files generated by various processes.

This module takes care not to require any external imports, because it is also used in (minimal) Docker
environments.
"""
import argparse
import importlib

from devscripts import config
from devscripts.commands import DevCommand


class Command(DevCommand):
    """Remove files generated by various build processes."""

    def add_arguments(self, parser: argparse.ArgumentParser) -> None:
        parser.add_argument(
            "-d",
            "--dry",
            action="store_true",
            default=False,
            help="Output files that would be removed, don't actually remove them.",
        )

    def handle(self, args: argparse.Namespace) -> None:
        mod = importlib.import_module("devscripts.standalone.clean")
        mod.cleanup(root=config.ROOT_DIR, dry=args.dry)
