
/*****************************************************************************
*
* Copyright (c) 2003-2016 by The University of Queensland
* http://www.uq.edu.au
*
* Primary Business: Queensland, Australia
* Licensed under the Apache License, version 2.0
* http://www.apache.org/licenses/LICENSE-2.0
*
* Development until 2012 by Earth Systems Science Computational Center (ESSCC)
* Development 2012-2013 by School of Earth Sciences
* Development from 2014 by Centre for Geoscience Computing (GeoComp)
*
*****************************************************************************/


#ifndef blocktimer_h
#define blocktimer_h

#include <stdio.h>
#include <search.h>
#include "system_dep.h"

/* Enable the block timer (or remove this and use -DBLOCKTIMER) */
/* # define BLOCKTIMER */

# define NUM_TIMERS 1024

ESYSUTILS_DLL_API
void blocktimer_initialize();
ESYSUTILS_DLL_API
void blocktimer_increment(__const char *name, double start_time);
ESYSUTILS_DLL_API
int blocktimer_getOrCreateTimerId(__const char *name);
ESYSUTILS_DLL_API
void blocktimer_reportSortByName();
ESYSUTILS_DLL_API
void blocktimer_reportSortByTime();
ESYSUTILS_DLL_API
double blocktimer_time();


#endif
