#!/usr/bin/env python
"""
setup.py for installing F2PY

Usage:
   python setup.py install

Copyright 2001 Pearu Peterson all rights reserved,
Pearu Peterson <pearu@cens.ioc.ee>          
Permission to use, modify, and distribute this software is given under the
terms of the LGPL.  See http://www.fsf.org

NO WARRANTY IS EXPRESSED OR IMPLIED.  USE AT YOUR OWN RISK.
$Revision: 1.31 $
$Date: 2004/10/11 13:11:51 $
Pearu Peterson
"""

__version__ = "$Id: setup.py,v 1.31 2004/10/11 13:11:51 pearu Exp $"

import sys,os

with_scipy_distutils = 0
try:
    i = sys.argv.index('--with-scipy_distutils')
    with_scipy_distutils = 1
    del sys.argv[i]
except ValueError:
    pass

from distutils.core import setup
from distutils.command.install_data import install_data

from __version__ import version

class my_install_data (install_data):
    def finalize_options (self):
        self.set_undefined_options ('install',
                                    ('install_lib', 'install_dir'),
                                    ('root', 'root'),
                                    ('force', 'force'),
                                    )

def need_scipy_distutils():
    return 0
    required_scipy_distutils_version = '0.2.0_alpha_2.229'
    _path = os.path.abspath(os.getcwd())
    fl = 0
    try:
        os.chdir('other')
        try:
            from scipy_distutils.scipy_distutils_version import \
                 scipy_distutils_version
            print 'Found scipy_distutils Version',scipy_distutils_version
            if scipy_distutils_version<required_scipy_distutils_version:
                print 'This f2py version needs scipy_distutils %s or newer'\
                      % (required_scipy_distutils_version)
                while 1:
                    r = raw_input('-> Let f2py to upgrade scipy_distutils? [y]/n: ')
                    if not r or r[0] in 'yY':
                        fl = 1
                        print 'Adding scipy_distutils to packages'
                        break
                    elif r[0] in 'nN':
                        break
        except ImportError:
            print sys.exc_value
            print 'Adding scipy_distutils to packages'
            fl = 1
    finally:
        os.chdir(_path)
    return fl

def f2py_bat():
    file = '''\
@echo off
rem See http://cens.ioc.ee/projects/f2py2e/
set sys_argv=
:Loop
if "%%1"=="" GOTO Continue 
set sys_argv=%%sys_argv%% %%1
SHIFT
GOTO Loop
:Continue
%s -c "import f2py2e;f2py2e.main()" %%sys_argv%%
'''%(sys.executable)
    return file

def f2py_py():
    import os
    file = '''#!/usr/bin/env %s
# See http://cens.ioc.ee/projects/f2py2e/
import f2py2e
f2py2e.main()
'''%(os.path.basename(sys.executable))
    return file

if 0 and os.name=='nt':
    # dos is treating '=' as spaces, so --switch=value would not work :(.
    f2py_exe = 'f2py.bat'
    f2py_template = f2py_bat
else:
    f2py_exe = 'f2py'+os.path.basename(sys.executable)[6:]
    if f2py_exe[-4:]=='.exe':
        f2py_exe = f2py_exe[:-4] + '.py'
    if 'bdist_wininst' in sys.argv and f2py_exe[-3:] != '.py':
        f2py_exe = f2py_exe + '.py'
    f2py_template = f2py_py

if not os.path.exists(f2py_exe):
    f = open(f2py_exe,'w')
    f.write(f2py_template())
    f.close()

if with_scipy_distutils and not os.path.exists('other/scipy_distutils'):
    scipy_cvs = ':pserver:anonymous@scipy.org:/home/cvsroot'
    print 'Press Enter for password'
    os.system('cvs -d %s login'%(scipy_cvs))
    os.system('cvs -d %s checkout scipy_core/scipy_distutils'%(scipy_cvs))
    os.system('mkdir -pv other')
    os.system('mv -v scipy_core/scipy_distutils other/scipy_distutils')
    os.system('rm -rvf scipy')
    os.system('chmod -R a-x other/scipy_distutils/{*,*/*}.py')

if __name__ == "__main__":

    print 'F2PY Version',version

    packages = ['f2py2e']
    package_dir = {'f2py2e':'.'}

    if 'install' in sys.argv and need_scipy_distutils():
        if os.path.exists('other/scipy_distutils'):
            packages.extend(['scipy_distutils','scipy_distutils.command'])
            package_dir['scipy_distutils'] = 'other/scipy_distutils'
        else:
            print 'F2PY setup: other/scipy_distutils does not exist '\
                  'or need newer scipy_distutils. Run:'
            print '  python setup.py install --with-scipy_distutils'
    config = {}
    if sys.version[:3]>='2.3':
        config['download_url'] = "http://cens.ioc.ee/projects/f2py2e/2.x"\
                                 "/F2PY-2-latest.tar.gz"
        config['classifiers'] = [
            'Development Status :: 5 - Production/Stable',
            'Intended Audience :: Developers',
            'Intended Audience :: Science/Research',
            'License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)',
            'Natural Language :: English',
            'Operating System :: OS Independent',
            'Programming Language :: C',
            'Programming Language :: Fortran',
            'Programming Language :: Python',
            'Topic :: Scientific/Engineering',
            'Topic :: Software Development :: Code Generators',
            ]
    setup(name="F2PY",
          version=version,
          description       = "F2PY - Fortran to Python Interface Generaton",
          author            = "Pearu Peterson",
          author_email      = "pearu@cens.ioc.ee",
          maintainer        = "Pearu Peterson",
          maintainer_email  = "pearu@cens.ioc.ee",
          license           = "LGPL",
          platforms         = "Unix, Windows (mingw|cygwin), Mac OS",
          long_description  = """\
The Fortran to Python Interface Generator, or F2PY for short, is a
command line tool (f2py) for generating Python C/API modules for
wrapping Fortran 77/90/95 subroutines, accessing common blocks from
Python, and calling Python functions from Fortran (call-backs).
Interfacing subroutines/data from Fortran 90/95 modules is supported.""",
          url               = "http://cens.ioc.ee/projects/f2py2e/",
          cmdclass          = {'install_data': my_install_data},
          scripts           = [f2py_exe],
          packages          = packages,
          package_dir       = package_dir,
          data_files        = [('f2py2e/src',
                                ['src/fortranobject.c','src/fortranobject.h'])],
          keywords          = ['Fortran','f2py'],
          **config
          )
