
__usage__ = """
Run:
  python callback.py [<f2py options>]
Examples:
  python callback.py --fcompiler=Gnu --no-wrap-functions
  python callback.py --quiet
"""

import f2py2e
from Numeric import array

def build(f2py_opts):
    try:
        import f77_ext_callback
    except ImportError:
        assert not f2py2e.compile('''\
       subroutine t(fun,a)
       integer a
cf2py  intent(out) a
       external fun
       call fun(a)
       end

''','f77_ext_callback',f2py_opts,source_fn='f77_callback.f')

    from f77_ext_callback import t
    test_functions = [t]
    return test_functions

def runtest(t):
    r = t(lambda : 4)
    assert r==4,`r`
    r = t(lambda a:5,fun_extra_args=(6,))
    assert r==5,`r`
    r = t(lambda a:a,fun_extra_args=(6,))
    assert r==6,`r`
    r = t(lambda a:5+a,fun_extra_args=(7,))
    assert r==12,`r`

if __name__=='__main__':
    #import libwadpy
    status = 1
    try:
        repeat,f2py_opts = f2py2e.f2py_testing.cmdline()
        test_functions = build(f2py_opts)
        f2py2e.f2py_testing.run(runtest,test_functions,repeat)
        print 'ok'
        status = 0
    finally:
        if status:
            print '*'*20
            print 'Running f2py2e.diagnose'
            import f2py2e.diagnose
            f2py2e.diagnose.run()
