 # Copyright 2016 Hewlett Packard Enterprise Development LP
 #
 # Licensed under the Apache License, Version 2.0 (the "License"); you may
 # not use this file except in compliance with the License. You may obtain
 # a copy of the License at
 #
 #      http://www.apache.org/licenses/LICENSE-2.0
 #
 # Unless required by applicable law or agreed to in writing, software
 # distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 # WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 # License for the specific language governing permissions and limitations
 # under the License.

import sys
from _redfishobject import RedfishObject
from redfish.rest.v1 import ServerDownOrUnreachableError

def ex53_update_ilo_firmware(redfishobj, fw_url=None, tpm_flag=None):
    sys.stdout.write("\nEXAMPLE 53: Update iLO Firmware\n")
    if redfishobj.typepath.defs.isgen9:
        instances = redfishobj.search_for_type("Manager.")
    else:
        instances = redfishobj.search_for_type("UpdateService.")

    for instance in instances:
        response = redfishobj.redfish_get(instance["@odata.id"])
        body = dict()

        if redfishobj.typepath.defs.isgen9:
            body["Action"] = "InstallFromURI"
            body["FirmwareURI"] = fw_url
            body["TPMOverrideFlag"] = tpm_flag
            response = redfishobj.redfish_post(response.dict["Oem"]\
                                         ["Hp"]["Links"]["UpdateService"]\
                                         ["@odata.id"], body)
        else:
            body["ImageURI"] = fw_url
            response = redfishobj.redfish_post(response.dict["Actions"]\
										 ["#UpdateService.SimpleUpdate"]\
										 ["target"], body)

        redfishobj.error_handler(response)

if __name__ == "__main__":
    # When running on the server locally use the following commented values
    # iLO_https_url = "blobstore://."
    # iLO_account = "None"
    # iLO_password = "None"

    # When running remotely connect using the iLO secured (https://) address, 
    # iLO account name, and password to send https requests
    # iLO_https_url acceptable examples:
    # "https://10.0.0.100"
    # "https://ilo.hostname"
    iLO_https_url = "https://10.0.0.100"
    iLO_account = "admin"
    iLO_password = "password"

    # Create a REDFISH object
    try:
        REDFISH_OBJ = RedfishObject(iLO_https_url, iLO_account, iLO_password)
    except ServerDownOrUnreachableError as excp:
        sys.stderr.write("ERROR: server not reachable or doesn't support " \
                                                                "RedFish.\n")
        sys.exit()
    except Exception as excp:
        raise excp

    ex53_update_ilo_firmware(REDFISH_OBJ, "http://test.com/ilo5_115.bin", False)
    REDFISH_OBJ.redfish_client.logout()
