"""
"""

# Created on 2014.10.21
#
# Author: Giovanni Cannata
#
# Copyright 2014, 2015, 2016, 2017 Giovanni Cannata
#
# This file is part of ldap3.
#
# ldap3 is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# ldap3 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with ldap3 in the COPYING and COPYING.LESSER files.
# If not, see <http://www.gnu.org/licenses/>.

ad_2012_r2_schema = """
{
    "raw": {
        "attributeTypes": [
            "( 1.2.840.113556.1.4.149 NAME 'attributeSecurityGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1703 NAME 'msDS-FilterContainers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.655 NAME 'legacyExchangeDN' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.21 NAME 'cOMProgID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2147 NAME 'msDNS-PropagationTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.301 NAME 'msSFU30KeyAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.686 NAME 'domainID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.23 NAME 'msDFSR-ReplicationGroupGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.818 NAME 'productCode' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.18 NAME 'oncRpcNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.221 NAME 'sAMAccountName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.375 NAME 'systemFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.814 NAME 'msiScript' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.880 NAME 'fRSTimeLastCommand' SYNTAX '1.3.6.1.4.1.1466.115.121.1.53' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1850 NAME 'msDS-TopQuotaUsage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2052 NAME 'msDS-OIDToGroupLinkBl' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.965 NAME 'mSMQSiteName' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1373 NAME 'mS-SQL-Clustered' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.624 NAME 'ipsecOwnersReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1353 NAME 'localizationDisplayId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1637 NAME 'msWMI-StringValidValues' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2103 NAME 'msDS-MembersOfResourcePropertyList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.480 NAME 'defaultGroup' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.55 NAME 'dBCSPwd' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1330 NAME 'pKICriticalExtensions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.93 NAME 'pwdProperties' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1840 NAME 'msDS-ObjectReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.7 NAME 'subRefs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.845 NAME 'msiScriptName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2242 NAME 'msDS-MaximumRegistrationInactivityPeriod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.7 NAME 'photo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.713 NAME 'optionsLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.942 NAME 'mSMQVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2138 NAME 'msDNS-NSEC3Iterations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.471 NAME 'trustParent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1237 NAME 'mSMQRoutingService' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.649 NAME 'primaryInternationalISDNNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1627 NAME 'msWMI-ID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2006 NAME 'msTSExpireDate4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2003 NAME 'msTSExpireDate3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2000 NAME 'msTSExpireDate2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.12 NAME 'documentTitle' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113549.1.9.8 NAME 'unstructuredAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.340 NAME 'msSFU30Domains' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.2069 NAME 'msDS-EnabledFeatureBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.3.6.1.1.1.1.6 NAME 'shadowMin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1412 NAME 'primaryGroupToken' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.358 NAME 'netbootInitialization' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2136 NAME 'msDNS-NSEC3HashAlgorithm' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.1 NAME 'instanceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.846 NAME 'msiScriptSize' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.20 NAME 'msDFSR-RdcMinFileSizeInKb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.663 NAME 'partialAttributeDeletionList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2078 NAME 'msTSSecondaryDesktopBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1995 NAME 'msTSManagingLS' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.371 NAME 'rIDAllocationPool' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.677 NAME 'replTopologyStayOfExecution' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.3 NAME 'replPropertyMetaData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2036 NAME 'msDFS-Commentv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.329 NAME 'versionNumberLo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.234 NAME 'printEndTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1673 NAME 'msPKI-OID-User-Notice' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.684 NAME 'certificateAuthorityObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.290 NAME 'printNumberUp' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1625 NAME 'msWMI-ClassDefinition' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1784 NAME 'msDS-LogonTimeSyncInterval' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1910 NAME 'unixUserPassword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.129 NAME 'trustAuthIncoming' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1319 NAME 'aCSNonReservedTokenSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1628 NAME 'msWMI-IntDefault' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1249 NAME 'proxiedObjectName' SYNTAX '1.2.840.113556.1.4.903' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2173 NAME 'msKds-PublicKeyLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 2.5.4.27 NAME 'destinationIndicator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.2187 NAME 'msDS-ValueTypeReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.897 NAME 'aCSMaxAggregatePeakRatePerUser' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1335 NAME 'pKIEnrollmentAccess' SYNTAX '1.2.840.113556.1.4.907' )",
            "( 1.2.840.113556.1.4.1708 NAME 'msDS-ReplValueMetaData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1690 NAME 'adminMultiselectPropertyPages' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.35 NAME 'userPassword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2200 NAME 'msDS-GroupMSAMembership' SYNTAX '1.2.840.113556.1.4.907' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.500 NAME 'fRSServiceCommand' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.16.840.1.113730.3.1.1 NAME 'carLicense' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2038 NAME 'msDFS-TargetListv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.27 NAME 'msDFSR-DeletedSizeInMb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1648 NAME 'msWMI-TargetPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.5 NAME 'shadowLastChange' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1793 NAME 'msDS-NonMembers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.3.6.1.1.1.1.22 NAME 'macAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.265 NAME 'notes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2274 NAME 'msDS-CloudIssuerPublicCertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1982 NAME 'msTSMaxConnectionTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1959 NAME 'msDS-isGC' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1424 NAME 'msCOM-PartitionSetLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.516 NAME 'serverReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1977 NAME 'msTSHomeDirectory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1369 NAME 'mS-SQL-ServiceAccount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.530 NAME 'nonSecurityMember' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.506 NAME 'objectCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1386 NAME 'mS-SQL-GPSLongitude' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1437 NAME 'msPKI-Supersede-Templates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1707 NAME 'msDS-ReplAttributeMetaData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.652 NAME 'assistant' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1644 NAME 'msWMI-SourceOrganization' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1443 NAME 'msDS-Site-Affinity' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.286 NAME 'printRateUnit' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1444 NAME 'msDS-Preferred-GC-Site' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.589 NAME 'meetingBandwidth' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.1706 NAME 'msDS-NCReplOutboundNeighbors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1709 NAME 'msDS-HasInstantiatedNCs' SYNTAX '1.2.840.113556.1.4.903' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.79 NAME 'minPwdLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1952 NAME 'ms-net-ieee-80211-GP-PolicyData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.865 NAME 'pekList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 2.5.4.26 NAME 'registeredAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2179 NAME 'msKds-CreateTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2149 NAME 'msDNS-NSEC3CurrentSalt' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1815 NAME 'msDS-TasksForAzRoleBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2148 NAME 'msDNS-NSEC3UserSalt' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2197 NAME 'msDS-ManagedPasswordId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1407 NAME 'mS-SQL-ThirdParty' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.510 NAME 'serviceBindingInformation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1416 NAME 'mSMQSiteNameEx' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1426 NAME 'msCOM-UserPartitionSetLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1303 NAME 'tokenGroupsNoGCAcceptable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.596 NAME 'msExchHouseIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2233 NAME 'msDS-cloudExtensionAttribute20' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.335 NAME 'currentLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.20 NAME 'homePhone' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1441 NAME 'msDS-Cached-Membership' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.14 NAME 'msDFSR-Schedule' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.622 NAME 'ipsecDataType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.645 NAME 'userCert' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.367 NAME 'rpcNsCodeset' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.223 NAME 'serverName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.950 NAME 'mSMQServices' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2250 NAME 'msDS-DeviceOSVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.332 NAME 'birthLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1440 NAME 'msDs-Schema-Extensions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1348 NAME 'gPCMachineExtensionNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1833 NAME 'msDS-ExternalKey' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.858 NAME 'netbootTools' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1717 NAME 'msDS-AdditionalDnsHostName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.770 NAME 'aCSEnableACSService' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.170 NAME 'systemOnly' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.32 NAME 'domainPolicyObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.766 NAME 'aCSAllocableRSVPBandwidth' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.9 NAME 'helpData32' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1805 NAME 'msDS-AzGenerateAudits' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.276 NAME 'driverVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1317 NAME 'aCSMinimumDelayVariation' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.302 NAME 'sAMAccountType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.610 NAME 'employeeNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.30 NAME 'attributeID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.3.6.1.4.1.1466.101.119.3 NAME 'entryTTL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1843 NAME 'msDRM-IdentityCertificate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.6.13.3.103 NAME 'msDFSR-ComputerReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1989 NAME 'msTSWorkDirectory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1674 NAME 'msPKI-Certificate-Application-Policy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.716 NAME 'mscopeId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.514 NAME 'physicalLocationObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.570 NAME 'meetingProtocol' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.2.370 NAME 'objectClassCategory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.15 NAME 'msDFSR-Keywords' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.812 NAME 'createWizardExt' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.61 NAME 'lockOutObservationWindow' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.750 NAME 'groupType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1459 NAME 'msDS-Behavior-Version' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.937 NAME 'mSMQSignKey' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.913 NAME 'allowedAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.120 NAME 'uSNChanged' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.340 NAME 'rightsGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.277 NAME 'otherHomePhone' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1309 NAME 'mSMQInterval2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1439 NAME 'msPKI-Certificate-Policy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1308 NAME 'mSMQInterval1' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1383 NAME 'mS-SQL-ConnectionURL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2176 NAME 'msKds-Version' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.859 NAME 'netbootLocallyInstalledOSes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.967 NAME 'mSMQSignCertificatesMig' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2232 NAME 'msDS-cloudExtensionAttribute19' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2231 NAME 'msDS-cloudExtensionAttribute18' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2230 NAME 'msDS-cloudExtensionAttribute17' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2229 NAME 'msDS-cloudExtensionAttribute16' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2228 NAME 'msDS-cloudExtensionAttribute15' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2227 NAME 'msDS-cloudExtensionAttribute14' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2226 NAME 'msDS-cloudExtensionAttribute13' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2225 NAME 'msDS-cloudExtensionAttribute12' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2142 NAME 'msDNS-SecureDelegationPollingPeriod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2224 NAME 'msDS-cloudExtensionAttribute11' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.718 NAME 'dhcpProperties' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2223 NAME 'msDS-cloudExtensionAttribute10' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.157 NAME 'serverRole' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1394 NAME 'mS-SQL-AllowAnonymousSubscription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.563 NAME 'shellPropertyPages' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1315 NAME 'aCSMinimumPolicedSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.273 NAME 'printStatus' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.644 NAME 'showInAddressBook' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.626 NAME 'ipsecISAKMPReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1925 NAME 'msDS-hasFullReplicaNCs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.940 NAME 'mSMQCSPName' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.30 NAME 'msDFSR-MinDurationCacheInMin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.243 NAME 'printColor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2193 NAME 'msDS-TDOIngressBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.3.6.1.1.1.1.1 NAME 'gidNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1993 NAME 'msTSExpireDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 2.5.4.2 NAME 'knowledgeInformation' SYNTAX '1.2.840.113556.1.4.905' )",
            "( 1.2.840.113556.1.4.908 NAME 'extendedClassInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.953 NAME 'mSMQSiteID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2040 NAME 'msDFS-LinkSecurityDescriptorv2' SYNTAX '1.2.840.113556.1.4.907' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1343 NAME 'dSUIAdminNotification' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1700 NAME 'msTAPI-ConferenceBlob' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.486 NAME 'fRSWorkingPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.62 NAME 'scriptPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1810 NAME 'msDS-TasksForAzTask' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.6.13.3.31 NAME 'msDFSR-MaxAgeInCacheInMin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.19 NAME 'cOMClassID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.16.840.1.113730.3.1.216 NAME 'userPKCS12' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.108 NAME 'remoteSourceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.704 NAME 'dhcpServers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.876 NAME 'fRSMemberReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2261 NAME 'msDS-DeviceLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.82 NAME 'moniker' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.289 NAME 'printMediaReady' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.3.6.1.1.1.1.17 NAME 'ipProtocolNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1209 NAME 'shortServerName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.910 NAME 'fromEntry' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.636 NAME 'privilegeAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2025 NAME 'msDS-IsUserCachableAtRodc' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1715 NAME 'msDS-SPNSuffixes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.562 NAME 'adminPropertyPages' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 0.9.2342.19200300.100.1.10 NAME 'manager' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 2.5.4.49 NAME 'distinguishedName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1356 NAME 'validAccesses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2053 NAME 'msImaging-PSPIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.459 NAME 'machineWidePolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1403 NAME 'mS-SQL-AllowKnownPullSubscription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.283 NAME 'assetNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.885 NAME 'terminalServer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2012 NAME 'msDS-MinimumPasswordAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.7 NAME 'msDFSR-ConflictPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1831 NAME 'msDS-ByteArray' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.135 NAME 'trustAuthOutgoing' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2258 NAME 'msDS-RegisteredOwner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.608 NAME 'queryPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.109 NAME 'replicaSource' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2296 NAME 'msDS-AssignedAuthNPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.402 NAME 'helpData16' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.232 NAME 'defaultPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1388 NAME 'mS-SQL-Version' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.364 NAME 'operatingSystemVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2284 NAME 'msDS-ServiceTGTLifetime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1460 NAME 'msDS-User-Account-Control-Computed' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.75 NAME 'maxRenewAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.285 NAME 'printRate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.911 NAME 'allowedChildClasses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.615 NAME 'personalTitle' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1225 NAME 'mSMQPrevSiteGates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.2131 NAME 'msDNS-SignWithNSEC3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2007 NAME 'msTSLicenseVersion4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.13 NAME 'documentVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 0.9.2342.19200300.100.1.3 NAME 'mail' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2004 NAME 'msTSLicenseVersion3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2001 NAME 'msTSLicenseVersion2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.507 NAME 'volumeCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.137 NAME 'uNCName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2022 NAME 'msDS-ResultantPSO' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.168 NAME 'modifiedCount' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1809 NAME 'msDS-OperationsForAzTaskBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.328 NAME 'versionNumberHi' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2099 NAME 'msDS-ClaimAttributeSource' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.754 NAME 'rpcNsEntryFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.778 NAME 'aCSDSBMDeadTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.917 NAME 'mSMQQueueType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.326 NAME 'packageName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.422 NAME 'domainPolicyReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2241 NAME 'msDS-RegistrationQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.3 NAME 'msDFSR-RootPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1817 NAME 'msDS-AzApplicationVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.436 NAME 'directReports' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.240 NAME 'printOrientationsSupported' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.574 NAME 'meetingLanguage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.43 NAME 'fRSVersionGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 2.5.4.30 NAME 'supportedApplicationContext' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.26 NAME 'rDNAttID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1409 NAME 'masteredBy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.752 NAME 'userSharedFolderOther' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2199 NAME 'msDS-ManagedPasswordInterval' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1932 NAME 'msDS-IsFullReplicaFor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.22 NAME 'msDFSR-RootFence' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.789 NAME 'transportDLLName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.499 NAME 'contextMenu' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.202 NAME 'auditingPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.11 NAME 'msDFSR-TombstoneExpiryInMin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1364 NAME 'mS-SQL-RegisteredOwner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.8 NAME 'userClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.775 NAME 'aCSMaxSizeOfRSVPLogFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.144 NAME 'operatorCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1238 NAME 'mSMQDsService' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1984 NAME 'msTSReconnectionAction' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2286 NAME 'msDS-AssignedAuthNPolicySiloBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2180 NAME 'msImaging-ThumbprintHash' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.68 NAME 'machineArchitecture' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.1311 NAME 'printDuplexSupported' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1795 NAME 'msDS-AzDomainTimeout' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1992 NAME 'msTSProperty02' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.583 NAME 'meetingURL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1991 NAME 'msTSProperty01' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.635 NAME 'privilegeValue' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2100 NAME 'msDS-ClaimTypeAppliesToClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.115 NAME 'invocationId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2288 NAME 'msDS-AuthNPolicySiloMembersBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1681 NAME 'msWMI-intFlags4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1680 NAME 'msWMI-intFlags3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1679 NAME 'msWMI-intFlags2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1678 NAME 'msWMI-intFlags1' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.100 NAME 'msDFSR-MemberReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.100 NAME 'priorValue' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1379 NAME 'mS-SQL-Vines' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1377 NAME 'mS-SQL-TCPIP' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2172 NAME 'msKds-SecretAgreementParam' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2222 NAME 'msDS-cloudExtensionAttribute9' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2221 NAME 'msDS-cloudExtensionAttribute8' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2220 NAME 'msDS-cloudExtensionAttribute7' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2219 NAME 'msDS-cloudExtensionAttribute6' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2218 NAME 'msDS-cloudExtensionAttribute5' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.661 NAME 'isDefunct' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2217 NAME 'msDS-cloudExtensionAttribute4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.653 NAME 'managedBy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2216 NAME 'msDS-cloudExtensionAttribute3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2215 NAME 'msDS-cloudExtensionAttribute2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2214 NAME 'msDS-cloudExtensionAttribute1' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.588 NAME 'meetingEndTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.53' )",
            "( 1.2.840.113556.1.4.498 NAME 'creationWizard' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1915 NAME 'msRADIUS-FramedIpv6Prefix' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.12 NAME 'msDFSR-FileFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.24 NAME 'x121Address' SYNTAX '1.3.6.1.4.1.1466.115.121.1.36' )",
            "( 1.2.840.113556.1.4.637 NAME 'privilegeHolder' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.214 NAME 'originalDisplayTableMSDOS' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.211 NAME 'schedule' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1228 NAME 'mSMQDsServices' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.64 NAME 'logonHours' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.883 NAME 'msRRASVendorAttributeEntry' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.58 NAME 'localeID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.97 NAME 'preferredOU' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2033 NAME 'msDFS-NamespaceIdentityGUIDv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1334 NAME 'pKIDefaultCSPs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1411 NAME 'ms-DS-MachineAccountQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.891 NAME 'gPLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.617 NAME 'homePostalAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.320 NAME 'implementedCategories' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.19 NAME 'uSNCreated' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.651 NAME 'otherMailbox' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.345 NAME 'msSFU30NSMAPFieldPosition' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.618 NAME 'wellKnownObjects' SYNTAX '1.2.840.113556.1.4.903' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2160 NAME 'msDS-ClaimIsSingleValued' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.1 NAME 'msDFSR-Version' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.874 NAME 'fRSFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1713 NAME 'MSMQ-SecuredSource' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.825 NAME 'enrollmentProviders' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.666 NAME 'syncAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.665 NAME 'syncMembership' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.48 NAME 'keywords' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2169 NAME 'msKds-KDFAlgorithmID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.370 NAME 'rIDAvailablePool' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.214 NAME 'nextLevelStore' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1145 NAME 'msRADIUSCallbackNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.303 NAME 'msSFU30IntraFieldSeparator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.346 NAME 'desktopProfile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.20 NAME 'cOMInterfaceID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.279 NAME 'printMinXExtent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1213 NAME 'assocNTAccount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.671 NAME 'msiFileList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2032 NAME 'msDFS-GenerationGUIDv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2279 NAME 'msDS-UserTGTLifetime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.10 NAME 'msDFSR-ReplicationGroupType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1790 NAME 'msDS-PerUserTrustTombstonesQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1124 NAME 'msNPCallingStationID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 0.9.2342.19200300.100.1.2 NAME 'textEncodedORAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.487 NAME 'fRSRootPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1807 NAME 'msDS-MembersForAzRoleBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1823 NAME 'msieee80211-ID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.791 NAME 'transportType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.674 NAME 'rootTrust' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1641 NAME 'msWMI-PropertyName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.25 NAME 'mayContain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' )",
            "( 1.2.840.113556.1.4.1438 NAME 'msPKI-RA-Policies' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.769 NAME 'aCSEventLogLevel' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.0 NAME 'uidNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.9 NAME 'shadowInactive' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.945 NAME 'mSMQSiteGates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 2.5.4.25 NAME 'internationalISDNNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.36' )",
            "( 1.2.840.113556.1.4.1979 NAME 'msTSAllowLogon' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.274 NAME 'printSpooling' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.242 NAME 'printCollate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1345 NAME 'dSUIShellMaximum' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.693 NAME 'pendingCACertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2257 NAME 'msDS-DeviceObjectVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.852 NAME 'netbootCurrentClientCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.534 NAME 'fRSLevelLimit' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1685 NAME 'msWMI-Parm4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1684 NAME 'msWMI-Parm3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1988 NAME 'msTSDefaultToMainPrinter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1913 NAME 'msRADIUS-FramedInterfaceId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.353 NAME 'displayNamePrintable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1696 NAME 'lastLogonTimestamp' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1683 NAME 'msWMI-Parm2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.330 NAME 'lastUpdateSequence' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.696 NAME 'currentParentCA' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.689 NAME 'cRLObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1682 NAME 'msWMI-Parm1' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.22 NAME 'governsID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1632 NAME 'msWMI-Int8Default' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.169 NAME 'logonCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.772 NAME 'aCSPolicyName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.38 NAME 'authorityRevocationList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1212 NAME 'isEphemeral' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.324 NAME 'packageType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1435 NAME 'msPKI-Template-Minor-Revision' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2010 NAME 'msTSLSProperty02' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1961 NAME 'msDS-SiteName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2009 NAME 'msTSLSProperty01' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1336 NAME 'replInterval' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2066 NAME 'msDS-RequiredDomainBehaviorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2185 NAME 'msDS-GeoCoordinatesLongitude' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2182 NAME 'msDS-AllowedToActOnBehalfOfOtherIdentity' SYNTAX '1.2.840.113556.1.4.907' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.3.6.1.1.1.1.11 NAME 'shadowFlag' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.8 NAME 'msDFSR-ConflictSizeInMb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.357 NAME 'nTMixedDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2191 NAME 'msDS-IngressClaimsTransformationPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1892 NAME 'msPKIRoamingTimeStamp' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2174 NAME 'msKds-PrivateKeyLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.324 NAME 'addressEntryDisplayTable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.218 NAME 'applicationName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1318 NAME 'aCSNonReservedPeakRate' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2023 NAME 'msDS-PasswordSettingsPrecedence' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.99 NAME 'priorSetTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.914 NAME 'allowedAttributesEffective' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.271 NAME 'printOwner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1996 NAME 'msDS-UserPasswordExpiryTimeComputed' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.930 NAME 'mSMQServiceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1780 NAME 'hideFromAB' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.578 NAME 'meetingContactInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2020 NAME 'msDS-PSOAppliesTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1944 NAME 'msDS-PhoneticDepartment' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1792 NAME 'msDS-AzLDAPQuery' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.251 NAME 'cOMTreatAsClassId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.14 NAME 'builtinModifiedCount' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.7 NAME 'shadowMax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.325 NAME 'setupCommand' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1647 NAME 'msWMI-TargetObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.420 NAME 'publicKeyPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1714 NAME 'MSMQ-MulticastAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1677 NAME 'msWMI-Genus' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2281 NAME 'msDS-ComputerTGTLifetime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1671 NAME 'msPKI-OID-Attribute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.36 NAME 'dMDLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.810 NAME 'createDialog' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2140 NAME 'msDNS-DSRecordSetTTL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1358 NAME 'schemaInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1624 NAME 'msWMI-ChangeDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1975 NAME 'msDS-RevealedListBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1962 NAME 'msDS-PromotionSettings' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.229 NAME 'driverName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.378 NAME 'dnsAllowDynamic' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1246 NAME 'interSiteTopologyGenerator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.817 NAME 'localizedDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2235 NAME 'msDS-ReplValueMetaDataExt' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1933 NAME 'msDS-IsDomainFor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2213 NAME 'msDS-RIDPoolAllocationEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.73 NAME 'lockoutThreshold' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.50 NAME 'lastContentIndexed' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.824 NAME 'signatureAlgorithms' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.860 NAME 'netbootServer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.40 NAME 'msDFSR-StagingCleanupTriggerInPercent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1695 NAME 'msMQ-Recipient-FormatName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1966 NAME 'msTPM-OwnerInformation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.156 NAME 'comment' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.650 NAME 'mhsORAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.929 NAME 'mSMQInRoutingServers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1787 NAME 'msDS-AllowedToDelegateTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1389 NAME 'mS-SQL-Language' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.18 NAME 'msDFSR-ContentSetGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.8 NAME 'possSuperiors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' )",
            "( 1.2.840.113556.1.4.912 NAME 'allowedChildClassesEffective' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2132 NAME 'msDNS-NSEC3OptOut' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.136 NAME 'trustType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1879 NAME 'msDS-SourceObjectDN' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.533 NAME 'fRSReplicaSetGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1434 NAME 'msPKI-Template-Schema-Version' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.241 NAME 'printMaxCopies' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.961 NAME 'mSMQSiteForeign' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' )",
            "( 1.2.840.113556.1.4.1808 NAME 'msDS-OperationsForAzTask' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1242 NAME 'dNReferenceUpdate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 0.9.2342.19200300.100.1.5 NAME 'drink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1923 NAME 'msDS-KrbTgtLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1402 NAME 'mS-SQL-Publisher' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2018 NAME 'msDS-LockoutDuration' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.688 NAME 'cAWEBURL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.23 NAME 'bootParameter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.536 NAME 'fRSExtensions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.233 NAME 'printStartTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1788 NAME 'msDS-PerUserTrustQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.159 NAME 'accountExpires' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.14 NAME 'nisNetgroupTriple' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1390 NAME 'mS-SQL-Description' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.224 NAME 'defaultSecurityDescriptor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113549.1.9.2 NAME 'unstructuredName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.695 NAME 'pendingParentCA' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1375 NAME 'mS-SQL-MultiProtocol' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2152 NAME 'msAuthz-LastEffectiveSecurityPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.56 NAME 'localPolicyFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1392 NAME 'mS-SQL-InformationDirectory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2159 NAME 'msDS-ClaimIsValueSpaceRestricted' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.708 NAME 'dhcpSites' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.717 NAME 'dhcpState' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.762 NAME 'aCSServiceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.132 NAME 'trustDirection' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.312 NAME 'rpcNsObjectID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1395 NAME 'mS-SQL-Alias' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.18.2 NAME 'modifyTimeStamp' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2145 NAME 'msDNS-DNSKEYRecords' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.301 NAME 'wbemPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.0 NAME 'objectClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.21 NAME 'msDFSR-DfsPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1429 NAME 'msPKI-RA-Signature' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1699 NAME 'msTAPI-ProtocolId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2086 NAME 'msSPP-PhoneLicense' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.120 NAME 'schemaFlagsEx' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1945 NAME 'msDS-PhoneticCompanyName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.916 NAME 'canonicalName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.702 NAME 'dhcpObjName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2238 NAME 'msds-memberTransitive' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.133 NAME 'trustPartner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.927 NAME 'mSMQSites' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.867 NAME 'altSecurityIdentities' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.615 NAME 'shellContextMenu' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.866 NAME 'pekKeyChangeInterval' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2046 NAME 'addressBookRoots2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.27 NAME 'currentValue' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.166 NAME 'groupMembershipSAM' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1926 NAME 'msDS-NeverRevealGroup' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.6.13.3.28 NAME 'msDFSR-ReadOnly' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1314 NAME 'aCSMaximumSDUSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.457 NAME 'localPolicyReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1189 NAME 'msRASSavedCallbackNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1918 NAME 'msRADIUS-SavedFramedIpv6Route' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 2.5.21.2 NAME 'dITContentRules' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.895 NAME 'transportAddressAttribute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1418 NAME 'tokenGroupsGlobalAndUniversal' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.850 NAME 'netbootLimitClients' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 2.16.840.1.113730.3.1.2 NAME 'departmentNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.944 NAME 'mSMQSite2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.943 NAME 'mSMQSite1' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1664 NAME 'msDS-Replication-Notify-Subsequent-DSA-Delay' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.537 NAME 'dynamicLDAPServer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2249 NAME 'msDS-DeviceOSType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.35 NAME 'employeeID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2137 NAME 'msDNS-NSEC3RandomSaltLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2151 NAME 'msAuthz-ProposedSecurityPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.267 NAME 'uSNDSALastObjRemoved' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.963 NAME 'mSMQQueueJournalQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.607 NAME 'queryPolicyObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1978 NAME 'msTSHomeDrive' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.593 NAME 'msExchLabeledURI' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1329 NAME 'pKIMaxIssuingDepth' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2061 NAME 'msDS-EnabledFeature' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.278 NAME 'printMaxYExtent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.16 NAME 'codePage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1802 NAME 'msDS-AzBizRuleLanguage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.363 NAME 'operatingSystem' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.761 NAME 'aCSMaxDurationPerFlow' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.921 NAME 'mSMQJournalQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2106 NAME 'msSPP-CSVLKPartialProductKey' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1190 NAME 'msRASSavedFramedIPAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2171 NAME 'msKds-SecretAgreementAlgorithmID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.703 NAME 'dhcpObjDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.890 NAME 'uPNSuffixes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1720 NAME 'msDS-ReplicationEpoch' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.24 NAME 'bootFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.614 NAME 'adminContextMenu' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.2.231 NAME 'oMSyntax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.8 NAME 'userAccountControl' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.621 NAME 'ipsecID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.511 NAME 'flatName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.784 NAME 'aCSIdentityName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.15 NAME 'msiScriptPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.125 NAME 'supplementalCredentials' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2287 NAME 'msDS-AuthNPolicySiloMembers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.199 NAME 'serviceInstanceVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1347 NAME 'sPNMappings' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.933 NAME 'mSMQComputerType' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.780 NAME 'aCSNonReservedTxLimit' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1227 NAME 'mSMQRoutingServices' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2074 NAME 'msTSPrimaryDesktopBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 2.5.18.1 NAME 'createTimeStamp' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.3.6.1.1.1.1.19 NAME 'ipHostNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1130 NAME 'msNPSavedCallingStationID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.700 NAME 'dhcpFlags' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.629 NAME 'ipsecFilterReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.40 NAME 'fromServer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.568 NAME 'meetingKeyword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2178 NAME 'msKds-UseStartTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1321 NAME 'aCSNonReservedMinPolicedSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.246 NAME 'printLanguage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.2.54 NAME 'tombstoneLifetime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.765 NAME 'aCSPermissionBits' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.8 NAME 'shadowWarning' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1398 NAME 'mS-SQL-LastBackupDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2 NAME 'objectGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.146 NAME 'company' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1710 NAME 'msDS-AllowedDNSSuffixes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1841 NAME 'msDS-ObjectReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 2.5.4.8 NAME 'st' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.341 NAME 'msSFU30YpServers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 2.5.4.4 NAME 'sn' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.707 NAME 'dhcpRanges' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.282 NAME 'printMemory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.924 NAME 'mSMQPrivacyLevel' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.333 NAME 'oMTIndxGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.205 NAME 'pKTGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2251 NAME 'msDS-DevicePhysicalIDs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1410 NAME 'mS-DS-CreatorSID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.345 NAME 'groupPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2030 NAME 'msDFS-SchemaMajorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.513 NAME 'siteObjectBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.87 NAME 'nETBIOSName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2175 NAME 'msKds-RootKeyData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.24 NAME 'mustContain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' )",
            "( 2.5.4.51 NAME 'houseIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.3.6.1.1.1.1.26 NAME 'nisMapName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1917 NAME 'msRADIUS-FramedIpv6Route' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.6.18.1.307 NAME 'msSFU30MasterServerName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.98 NAME 'primaryGroupID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1837 NAME 'msDs-masteredBy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.200 NAME 'controlAccessRights' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1158 NAME 'msRADIUSFramedRoute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.107 NAME 'remoteSource' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1971 NAME 'msDS-LastFailedInteractiveLogonTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1958 NAME 'msDS-AuthenticatedAtDC' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 2.5.4.5 NAME 'serialNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.509 NAME 'serviceClassName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2050 NAME 'msPKI-CredentialRoamingTokens' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.4.2008 NAME 'msTSManagingLS4' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2005 NAME 'msTSManagingLS3' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2002 NAME 'msTSManagingLS2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1363 NAME 'mS-SQL-Name' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.41 NAME 'mobile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2108 NAME 'msTPM-OwnerInformationTemp' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.886 NAME 'purportedSearch' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1384 NAME 'mS-SQL-PublicationURL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2271 NAME 'msDS-CloudIsManaged' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.41 NAME 'generatedConnection' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.864 NAME 'netbootSCPBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1396 NAME 'mS-SQL-Size' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.115 NAME 'rpcNsInterfaceID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.56 NAME 'documentPublisher' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.619 NAME 'dNSHostName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2273 NAME 'msDS-CloudAnchor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.939 NAME 'mSMQNameStyle' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.882 NAME 'fRSVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.777 NAME 'aCSDSBMRefresh' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.80 NAME 'minTicketAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1310 NAME 'mSMQSiteGatesMig' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.83 NAME 'monikerDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2150 NAME 'msAuthz-EffectiveSecurityPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.15 NAME 'hasPartialReplicaNCs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2194 NAME 'msDS-TDOEgressBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1811 NAME 'msDS-TasksForAzTaskBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1987 NAME 'msTSConnectPrinterDrives' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1953 NAME 'ms-net-ieee-80211-GP-PolicyReserved' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1313 NAME 'aCSMaxTokenBucketPerFlow' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.579 NAME 'meetingOwner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.12 NAME 'badPwdCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.39 NAME 'forceLogoff' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.326 NAME 'perRecipDialogDisplayTable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.51 NAME 'lastLogoff' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1796 NAME 'msDS-AzScriptEngineCacheMax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2269 NAME 'msDS-IssuerPublicCertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1639 NAME 'msWMI-Name' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.4 NAME 'replUpToDateVector' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.470 NAME 'trustAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.515 NAME 'serverReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.308 NAME 'msSFU30OrderNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1669 NAME 'msDS-Approx-Immed-Subordinates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2141 NAME 'msDNS-SignatureInceptionOffset' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2186 NAME 'msDS-IsPossibleValuesPresent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.78 NAME 'minPwdAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.339 NAME 'msSFU30NisDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1701 NAME 'msTAPI-IpAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.249 NAME 'cOMCLSID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.774 NAME 'aCSMaxNoOfLogFiles' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.494 NAME 'siteServer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.849 NAME 'netbootAllowNewClients' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1931 NAME 'msDS-KrbTgtLinkBl' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1789 NAME 'msDS-AllUsersTrustQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2156 NAME 'msAuthz-MemberRulesInCentralAccessPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.721 NAME 'ipPhone' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.613 NAME 'employeeType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1634 NAME 'msWMI-Int8Min' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2248 NAME 'msDS-IsEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1950 NAME 'msDS-AzGenericData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1646 NAME 'msWMI-TargetNameSpace' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.816 NAME 'fileExtPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.712 NAME 'optionDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.321 NAME 'requiredCategories' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.255 NAME 'addressSyntax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2110 NAME 'msTPM-TpmInformationForComputerBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1785 NAME 'msIIS-FTPRoot' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.518 NAME 'defaultHidingValue' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.946 NAME 'mSMQCost' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 2.5.4.44 NAME 'generationQualifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.681 NAME 'indexedScopes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.3.6.1.1.1.1.27 NAME 'nisMapEntry' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1865 NAME 'msDS-PrincipalName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2073 NAME 'msTSPrimaryDesktop' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.697 NAME 'cACertificateDN' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1354 NAME 'scopeFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1942 NAME 'msDS-PhoneticFirstName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.21 NAME 'ipNetmaskNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1997 NAME 'msDS-HABSeniorityIndex' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1307 NAME 'accountNameHistory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.893 NAME 'gPCFunctionalityVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2203 NAME 'msDS-parentdistname' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1687 NAME 'extraColumns' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1834 NAME 'msDS-ExternalStore' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1983 NAME 'msTSMaxIdleTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.687 NAME 'cAConnect' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2048 NAME 'templateRoots2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.154 NAME 'serverState' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1224 NAME 'parentGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.926 NAME 'mSMQTransactional' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.925 NAME 'mSMQOwnerID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2035 NAME 'msDFS-Ttlv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.150 NAME 'adminCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2041 NAME 'msDFS-LinkIdentityGUIDv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.490 NAME 'fRSDSPoll' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2015 NAME 'msDS-PasswordComplexityEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.105 NAME 'remoteServerName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.531 NAME 'nonSecurityMemberBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 2.16.840.1.113730.3.1.36 NAME 'thumbnailLogo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.586 NAME 'meetingRecurrence' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1643 NAME 'msWMI-QueryLanguage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.962 NAME 'mSMQQueueQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1415 NAME 'mSMQLabelEx' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.16 NAME 'nCName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2170 NAME 'msKds-KDFParam' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.567 NAME 'meetingDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1704 NAME 'msDS-NCReplCursors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.23 NAME 'facsimileTelephoneNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.851 NAME 'netbootMaxClients' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2016 NAME 'msDS-PasswordReversibleEncryptionEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1635 NAME 'msWMI-Int8ValidValues' SYNTAX '1.2.840.113556.1.4.906' )",
            "( 1.2.840.113556.1.4.719 NAME 'dhcpMaxKey' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1835 NAME 'msDS-Integer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.1208 NAME 'aNR' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1393 NAME 'mS-SQL-Database' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.42 NAME 'pager' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1914 NAME 'msRADIUS-SavedFramedInterfaceId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1391 NAME 'mS-SQL-Type' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.566 NAME 'meetingName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.123 NAME 'serviceClassInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.26 NAME 'creationTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.103 NAME 'proxyLifetime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.660 NAME 'treeName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.892 NAME 'gPOptions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.923 NAME 'mSMQAuthenticate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1432 NAME 'msPKI-Certificate-Name-Flag' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.206 NAME 'pKT' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.287 NAME 'printNetworkAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1431 NAME 'msPKI-Private-Key-Flag' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1346 NAME 'templateRoots' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.657 NAME 'serviceDNSName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.868 NAME 'isCriticalSystemObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.301 NAME 'garbageCollPeriod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.288 NAME 'printMACAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1304 NAME 'sDRightsEffective' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.380 NAME 'extendedCharsAllowed' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.86 NAME 'userWorkstations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1360 NAME 'mS-DS-ConsistencyGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1712 NAME 'msPKI-OIDLocalizedName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.21.5 NAME 'attributeTypes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.31 NAME 'fRSReplicaSetType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.4.1.250.1.57 NAME 'labeledURI' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.341 NAME 'appliesTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.11 NAME 'ou' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2293 NAME 'msDS-ServiceAuthNPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.346 NAME 'msSFU30PosixMember' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1973 NAME 'msDS-FailedInteractiveLogonCountAtLastSuccessfulLogon' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 2.5.18.10 NAME 'subSchemaSubEntry' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2262 NAME 'msDS-ApproximateLastLogonTimeStamp' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.222 NAME 'location' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.854 NAME 'netbootAnswerOnlyValidClients' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1949 NAME 'msDS-AzObjectGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 2.16.840.1.113730.3.1.34 NAME 'middleName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2158 NAME 'msDS-ClaimSourceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.6 NAME 'roomNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.706 NAME 'dhcpMask' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.2109 NAME 'msTPM-TpmInformationForComputer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.623 NAME 'ipsecData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1171 NAME 'msRADIUSServiceType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.705 NAME 'dhcpSubnets' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.1999 NAME 'msFVE-KeyPackage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1968 NAME 'msDS-NC-RO-Replica-Locations-BL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.36 NAME 'enabledConnection' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.472 NAME 'domainCrossRef' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.52 NAME 'lastLogon' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.28 NAME 'dnsRoot' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.966 NAME 'mSMQDigestsMig' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.878 NAME 'fRSPrimaryMember' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1848 NAME 'msDS-QuotaEffective' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1372 NAME 'mS-SQL-UnicodeSortOrder' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.639 NAME 'isMemberOfPartialAttributeSet' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.464 NAME 'wWWHomePage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.711 NAME 'superScopeDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1631 NAME 'msWMI-IntValidValues' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.3.6.1.1.1.1.2 NAME 'gecos' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2063 NAME 'msDS-OptionalFeatureFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.38 NAME 'flags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1240 NAME 'netbootSIFFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.690 NAME 'cAUsages' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 0.9.2342.19200300.100.1.60 NAME 'jpegPhoto' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2104 NAME 'msDS-MembersOfResourcePropertyListBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.66 NAME 'lSACreationTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.709 NAME 'dhcpReservations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.4.934 NAME 'mSMQForeign' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1963 NAME 'msDS-SupportedEncryptionTypes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1401 NAME 'mS-SQL-Keywords' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1705 NAME 'msDS-NCReplInboundNeighbors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2128 NAME 'msDNS-KeymasterZones' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.19 NAME 'physicalDeliveryOfficeName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1694 NAME 'gPCWQLFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.195 NAME 'systemPossSuperiors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.218 NAME 'oMObjectClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1226 NAME 'mSMQDependentClientServices' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1676 NAME 'msWMI-Class' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2144 NAME 'msDNS-SigningKeys' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1630 NAME 'msWMI-IntMin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.372 NAME 'rIDPreviousAllocationPool' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.848 NAME 'appSchemaVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1981 NAME 'msTSMaxDisconnectionTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1645 NAME 'msWMI-TargetClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.535 NAME 'fRSRootSecurity' SYNTAX '1.2.840.113556.1.4.907' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1423 NAME 'msCOM-PartitionLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 2.5.4.32 NAME 'owner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1436 NAME 'msPKI-Cert-Template-OID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1716 NAME 'msDS-IntId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.18.1.309 NAME 'msSFU30Name' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.254 NAME 'cOMTypelibId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1642 NAME 'msWMI-Query' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.155 NAME 'uASCompat' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1623 NAME 'msWMI-Author' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1964 NAME 'msFVE-RecoveryPassword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.37 NAME 'associatedDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.764 NAME 'aCSPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.571 NAME 'meetingType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.783 NAME 'defaultObjectCategory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1365 NAME 'mS-SQL-Contact' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.679 NAME 'creator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.39 NAME 'certificateRevocationList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.699 NAME 'dhcpType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1405 NAME 'mS-SQL-AllowQueuedUpdatingSubscription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.915 NAME 'possibleInferiors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2234 NAME 'netbootDUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.899 NAME 'aCSEnableRSVPAccounting' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.881 NAME 'fRSTimeLastConfigChange' SYNTAX '1.3.6.1.4.1.1466.115.121.1.53' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.55 NAME 'audio' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.3.6.1.1.1.1.13 NAME 'memberNisNetgroup' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.898 NAME 'aCSNonReservedTxSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.771 NAME 'servicePrincipalName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1820 NAME 'msDS-HasDomainNCs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2070 NAME 'msTSEndpointData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.620 NAME 'ipsecName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.458 NAME 'qualityOfService' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2042 NAME 'msDFS-ShortNameLinkPathv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1688 NAME 'msDS-Security-Group-Extra-Classes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2289 NAME 'msDS-UserAuthNPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.83 NAME 'repsTo' SYNTAX 'OctetString' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1357 NAME 'dSCorePropagationData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2196 NAME 'msDS-ManagedPassword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.647 NAME 'otherMobile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2072 NAME 'msTSEndpointPlugin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.749 NAME 'url' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.701 NAME 'dhcpIdentification' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.122 NAME 'serviceClassID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2058 NAME 'isRecycled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.213 NAME 'defaultClassStore' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.2252 NAME 'msDS-DeviceID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.633 NAME 'policyReplicationFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1693 NAME 'msFRS-Hub-Member' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1328 NAME 'pKIKeyUsage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.459 NAME 'networkAddress' SYNTAX '1.2.840.113556.1.4.905' )",
            "( 1.2.840.113556.1.4.1786 NAME 'msIIS-FTPDir' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.806 NAME 'treatAsLeaf' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.820 NAME 'bridgeheadServerListBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 0.9.2342.19200300.100.1.15 NAME 'documentLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.13.3.36 NAME 'msDFSR-OnDemandExclusionDirectoryFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.640 NAME 'partialAttributeSet' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.853 NAME 'netbootAnswerRequests' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 2.5.4.31 NAME 'member' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.6.18.1.323 NAME 'msSFU30Aliases' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1243 NAME 'mSMQQueueNameExt' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1370 NAME 'mS-SQL-CharacterSet' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1622 NAME 'msDS-Entry-Time-To-Die' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.460 NAME 'lDAPDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2031 NAME 'msDFS-SchemaMinorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.12 NAME 'memberUid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1800 NAME 'msDS-AzOperationID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.322 NAME 'categoryId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.60 NAME 'lockoutDuration' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.870 NAME 'frsComputerReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 2.5.4.45 NAME 'x500uniqueIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.6.13.3.25 NAME 'msDFSR-Priority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.847 NAME 'installUiLevel' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1842 NAME 'msDs-MaxValues' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 2.5.4.9 NAME 'street' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2154 NAME 'msAuthz-CentralAccessPolicyID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.3 NAME 'whenChanged' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1433 NAME 'msPKI-Minimal-Key-Size' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1814 NAME 'msDS-TasksForAzRole' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.6.13.3.101 NAME 'msDFSR-ComputerReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.580 NAME 'meetingIP' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.539 NAME 'initialAuthIncoming' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.356 NAME 'foreignIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.565 NAME 'meetingID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.3 NAME 'unixHomeDirectory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1721 NAME 'msDS-UpdateScript' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.557 NAME 'parentCA' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.255 NAME 'vendor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.900 NAME 'aCSRSVPAccountFilesLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1320 NAME 'aCSNonReservedMaxSDUSize' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1956 NAME 'ms-net-ieee-8023-GP-PolicyReserved' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.773 NAME 'aCSRSVPLogFilesLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.951 NAME 'mSMQQMID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.102 NAME 'memberOf' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1397 NAME 'mS-SQL-CreationDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2146 NAME 'msDNS-ParentHasSecureDelegation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.113 NAME 'rpcNsBindings' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.656 NAME 'userPrincipalName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1934 NAME 'msDS-IsPartialReplicaFor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2167 NAME 'msDS-PrimaryComputer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.469 NAME 'USNIntersite' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1803 NAME 'msDS-AzLastImportedBizRulePath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2295 NAME 'msDS-AssignedAuthNPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 2.5.4.13 NAME 'description' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.922 NAME 'mSMQLabel' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2024 NAME 'msDS-NcType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2011 NAME 'msDS-MaximumPasswordAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2291 NAME 'msDS-ComputerAuthNPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1832 NAME 'msDS-DateTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' )",
            "( 1.2.840.113556.1.2.281 NAME 'nTSecurityDescriptor' SYNTAX '1.2.840.113556.1.4.907' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.722 NAME 'otherIpPhone' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1368 NAME 'mS-SQL-Build' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.219 NAME 'iconPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1417 NAME 'mSMQComputerTypeEx' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.38 NAME 'associatedName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1986 NAME 'msTSConnectClientDrives' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2285 NAME 'msDS-AssignedAuthNPolicySilo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1638 NAME 'msWMI-Mof' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.314 NAME 'rpcNsTransferSyntax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1702 NAME 'msDS-TrustForestTrustInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.557 NAME 'Enabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.21 NAME 'subClassOf' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 0.9.2342.19200300.100.1.44 NAME 'uniqueIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1845 NAME 'msDS-QuotaAmount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1119 NAME 'msNPAllowDialin' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.33 NAME 'isSingleValued' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.782 NAME 'objectCategory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2177 NAME 'msKds-DomainID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2195 NAME 'msDS-AppliesToResourceTypes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.152 NAME 'groupAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.334 NAME 'volTableIdxGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.272 NAME 'printNotify' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.334 NAME 'searchFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2298 NAME 'msDS-AuthNPolicySiloEnforced' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1428 NAME 'msCOM-ObjectId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.400 NAME 'addressEntryDisplayTableMSDOS' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.81 NAME 'modifiedCountAtLastProm' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.71 NAME 'machineRole' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1123 NAME 'msNPCalledStationID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.654 NAME 'managedObjects' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.638 NAME 'isPrivilegeHolder' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.197 NAME 'systemMustContain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.91 NAME 'otherLoginWorkstations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.13.3.32 NAME 'msDFSR-DisablePacketPrivacy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2297 NAME 'msDS-AuthNPolicyEnforced' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.576 NAME 'meetingMaxParticipants' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.4 NAME 'loginShell' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.779 NAME 'aCSCacheTimeout' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.751 NAME 'userSharedFolder' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.342 NAME 'msSFU30MaxGidNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1380 NAME 'mS-SQL-Status' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.13 NAME 'builtinCreationTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.277 NAME 'printMaxXExtent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.230 NAME 'printSeparatorFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1387 NAME 'mS-SQL-GPSHeight' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2054 NAME 'msImaging-PSPString' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.235 NAME 'printFormName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.20 NAME 'telephoneNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1621 NAME 'msDS-Other-Settings' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.304 NAME 'msSFU30SearchAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.21.9 NAME 'structuralObjectClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' )",
            "( 1.2.840.113556.1.4.659 NAME 'serviceDNSNameType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.902 NAME 'aCSMaxSizeOfRSVPAccountFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.569 NAME 'meetingLocation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.261 NAME 'division' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1640 NAME 'msWMI-NormalizedClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.300 NAME 'printerName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1960 NAME 'msDS-isRODC' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.268 NAME 'eFSPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1824 NAME 'msDS-AzMajorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2134 NAME 'msDNS-DSRecordAlgorithms' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.270 NAME 'printShareName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1400 NAME 'mS-SQL-Applications' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1312 NAME 'aCSServerList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1376 NAME 'mS-SQL-SPX' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.368 NAME 'rIDManagerReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1371 NAME 'mS-SQL-SortOrder' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.118 NAME 'otherPager' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1894 NAME 'msPKIAccountCredentials' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.6.13.3.16 NAME 'msDFSR-Flags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1301 NAME 'tokenGroups' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1626 NAME 'msWMI-CreationDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.14 NAME 'hasMasterNCs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.153 NAME 'rid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2084 NAME 'msSPP-ConfirmationId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.2 NAME 'msDFSR-Extension' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1846 NAME 'msDS-DefaultQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.35 NAME 'rangeUpper' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1633 NAME 'msWMI-Int8Max' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.48 NAME 'isDeleted' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1327 NAME 'pKIDefaultKeySpec' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1408 NAME 'mS-DS-ReplicatesNCReason' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.4.1816 NAME 'msDS-AzClassId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2088 NAME 'msSPP-IssuanceLicense' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1672 NAME 'msPKI-OID-CPS' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.590 NAME 'meetingBlob' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.72 NAME 'marshalledInterface' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1385 NAME 'mS-SQL-GPSLatitude' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2097 NAME 'msDS-ClaimPossibleValues' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.26 NAME 'msDFSR-DeletedPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1826 NAME 'msDS-RetiredReplNCSignatures' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2143 NAME 'msDNS-SigningKeyDescriptors' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.491 NAME 'fRSFaultCondition' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2278 NAME 'msDS-UserAllowedToAuthenticateFrom' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2017 NAME 'msDS-LockoutObservationWindow' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2130 NAME 'msDNS-IsSigned' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2057 NAME 'msDS-HostServiceAccountBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.683 NAME 'cRLPartitionedRevocationList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.481 NAME 'schemaUpdate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1332 NAME 'pKIOverlapPeriod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.692 NAME 'previousCACertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.573 NAME 'meetingApplication' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1849 NAME 'msDS-QuotaUsed' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.20 NAME 'ipNetworkNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.517 NAME 'ipsecPolicyReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1822 NAME 'msieee80211-DataType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.664 NAME 'syncWithObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2183 NAME 'msDS-GeoCoordinatesAltitude' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.284 NAME 'bytesPerMinute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.139 NAME 'profilePath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.40 NAME 'crossCertificatePair' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1929 NAME 'msDS-SecondaryKrbTgtNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2294 NAME 'msDS-ServiceAuthNPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1414 NAME 'dNSTombstoned' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.104 NAME 'ownerBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1930 NAME 'msDS-RevealedDSAs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2240 NAME 'msDS-IssuerCertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1692 NAME 'msFRS-Topology-Pref' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.158 NAME 'domainReplica' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.2 NAME 'whenCreated' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.76 NAME 'maxStorage' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.484 NAME 'fRSDirectoryFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1916 NAME 'msRADIUS-SavedFramedIpv6Prefix' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2087 NAME 'msSPP-ConfigLicense' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.627 NAME 'ipsecNFAReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.351 NAME 'auxiliaryClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' )",
            "( 1.2.840.113556.1.2.50 NAME 'linkID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1718 NAME 'msDS-AdditionalSamAccountName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.35 NAME 'msDFSR-OnDemandExclusionFileFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.577 NAME 'meetingOriginator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.169 NAME 'showInAdvancedViewOnly' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.582 NAME 'meetingAdvertiseScope' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.48 NAME 'buildingName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2181 NAME 'msImaging-HashAlgorithm' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2101 NAME 'msDS-ClaimSharesPossibleValuesWith' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.24 NAME 'contentIndexingAllowed' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.39 NAME 'msDFSR-CommonStagingSizeInMb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2135 NAME 'msDNS-RFC5011KeyRollovers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.682 NAME 'friendlyNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2071 NAME 'msTSEndpointType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2263 NAME 'msDS-RegisteredUsers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2062 NAME 'msDS-OptionalFeatureGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.767 NAME 'aCSMaxPeakBandwidth' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 2.5.4.28 NAME 'preferredDeliveryMethod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.919 NAME 'mSMQQuota' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.327 NAME 'packageFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.382 NAME 'dnsRecord' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.755 NAME 'domainIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.872 NAME 'fRSControlInboundBacklog' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.928 NAME 'mSMQOutRoutingServers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.768 NAME 'aCSEnableRSVPMessageLogging' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.585 NAME 'meetingIsEncrypted' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.34 NAME 'rangeLower' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1361 NAME 'mS-DS-ConsistencyChildCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2192 NAME 'msDS-EgressClaimsTransformationPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2292 NAME 'msDS-ComputerAuthNPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.843 NAME 'lDAPAdminLimits' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1847 NAME 'msDS-TombstoneQuotaFactor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1355 NAME 'queryFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.16 NAME 'postalAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.307 NAME 'options' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.74 NAME 'dSASignature' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.380 NAME 'dnsSecureSecondaries' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.634 NAME 'privilegeDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.598 NAME 'dmdName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1399 NAME 'mS-SQL-LastDiagnosticDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2280 NAME 'msDS-ComputerAllowedToAuthenticateTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.350 NAME 'addressType' SYNTAX '1.2.840.113556.1.4.905' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.38 NAME 'msDFSR-CommonStagingPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.672 NAME 'categories' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1675 NAME 'msPKI-RA-Application-Policies' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1244 NAME 'addressBookRoots' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.336 NAME 'volTableGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.65 NAME 'logonWorkstation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2153 NAME 'msAuthz-ResourceCondition' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.34 NAME 'msDFSR-DefaultCompressionExclusionFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.756 NAME 'aCSTimeOfDay' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2276 NAME 'msDS-SyncServerUrl' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.710 NAME 'superScopes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.44' )",
            "( 1.2.840.113556.1.2.210 NAME 'proxyAddresses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.348 NAME 'msSFU30NetgroupHostAtDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1306 NAME 'dNSProperty' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.141 NAME 'department' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.871 NAME 'fRSControlDataCreation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.253 NAME 'cOMOtherProgId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1337 NAME 'mSMQUserSid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 0.9.2342.19200300.100.1.14 NAME 'documentAuthor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 2.5.4.37 NAME 'cACertificate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.698 NAME 'dhcpUniqueKey' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1980 NAME 'msTSRemoteControl' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.9 NAME 'host' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2081 NAME 'msSPP-CSVLKSkuId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.483 NAME 'fRSFileFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2168 NAME 'msDS-IsPrimaryComputerFor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.74 NAME 'maxPwdAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1374 NAME 'mS-SQL-NamedPipe' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1972 NAME 'msDS-FailedInteractiveLogonCount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1649 NAME 'msWMI-TargetType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.668 NAME 'domainCAs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.2021 NAME 'msDS-PSOApplied' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.25 NAME 'countryCode' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.160 NAME 'lmPwdHistory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.275 NAME 'printKeepPrintedJobs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2014 NAME 'msDS-PasswordHistoryLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1836 NAME 'msDS-hasMasterNCs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1813 NAME 'msDS-OperationsForAzRoleBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.212 NAME 'dSHeuristics' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.877 NAME 'fRSPartnerAuthLevel' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.13 NAME 'displayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.269 NAME 'linkTrackSecret' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1239 NAME 'mSMQDependentClientService' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.238 NAME 'printMaxResolutionSupported' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.325 NAME 'perMsgDialogDisplayTable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.819 NAME 'bridgeheadTransportList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.540 NAME 'initialAuthOutgoing' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.523 NAME 'proxyGenerationEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.760 NAME 'aCSAggregateTokenRatePerUser' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.381 NAME 'dnsNotifySecondaries' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 2.5.4.21 NAME 'telexNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.117 NAME 'rpcNsPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.6.18.1.300 NAME 'msSFU30SearchContainer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.960 NAME 'mSMQNt4Stub' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.4.844 NAME 'lDAPIPDenyList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.918 NAME 'mSMQJournal' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.343 NAME 'msSFU30MaxUidNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1442 NAME 'msDS-Cached-Membership-Time-Stamp' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1458 NAME 'msDS-Auxiliary-Classes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.821 NAME 'siteList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1782 NAME 'msDS-KeyVersionNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 2.5.4.50 NAME 'uniqueMember' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1797 NAME 'msDS-AzScriptTimeout' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1812 NAME 'msDS-OperationsForAzRole' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.809 NAME 'remoteStorageGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.231 NAME 'priority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.37 NAME 'msDFSR-Options2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2083 NAME 'msSPP-InstallationId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.58 NAME 'attributeCertificateAttribute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.6.18.1.302 NAME 'msSFU30FieldSeparator' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.532 NAME 'superiorDNSRoot' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.822 NAME 'siteLinkList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1366 NAME 'mS-SQL-Location' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.94 NAME 'ntPwdHistory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1 NAME 'name' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1629 NAME 'msWMI-IntMax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.118 NAME 'rpcNsProfileEntry' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2049 NAME 'msDS-BridgeHeadServersUsed' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.4.1969 NAME 'samDomainUpdates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.889 NAME 'additionalTrustedServiceNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.77 NAME 'maxTicketAge' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1661 NAME 'msDS-NC-Replica-Locations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1783 NAME 'msDS-ExecuteScriptPassword' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.49 NAME 'mAPIID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.9 NAME 'msDFSR-Enabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.250 NAME 'cOMUniqueLIBID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.18 NAME 'postOfficeBox' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2067 NAME 'msDS-LastKnownRDN' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1344 NAME 'dSUIAdminMaximum' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1153 NAME 'msRADIUSFramedIPAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1799 NAME 'msDS-AzScopeName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2013 NAME 'msDS-MinimumPasswordLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.114 NAME 'rpcNsGroup' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.146 NAME 'objectSid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.6 NAME 'msDFSR-StagingSizeInMb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.365 NAME 'operatingSystemServicePack' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.21.6 NAME 'objectClasses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1698 NAME 'msTAPI-uid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.256 NAME 'streetAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1191 NAME 'msRASSavedFramedRoute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1965 NAME 'msFVE-RecoveryGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2166 NAME 'msDS-GenerationId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1359 NAME 'otherWellKnownObjects' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.4.1940 NAME 'msDS-RevealedList' SYNTAX '1.2.840.113556.1.4.904' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2282 NAME 'msDS-ServiceAllowedToAuthenticateTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.379 NAME 'dnsAllowXFR' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.628 NAME 'ipsecNegotiationPolicyReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1976 NAME 'msTSProfilePath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2076 NAME 'msPKI-Enrollment-Servers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.53 NAME 'deltaRevocationList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.18 NAME 'otherTelephone' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2077 NAME 'msPKI-Site-Name' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1316 NAME 'aCSMinimumLatency' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2157 NAME 'msDS-ClaimSource' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1970 NAME 'msDS-LastSuccessfulInteractiveLogonTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.280 NAME 'printMinYExtent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.415 NAME 'operatingSystemHotfix' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.306 NAME 'msSFU30MapFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.610 NAME 'classDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1381 NAME 'mS-SQL-LastUpdatedDate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1957 NAME 'msDS-AuthenticatedToAccountlist' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1825 NAME 'msDS-AzMinorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2198 NAME 'msDS-ManagedPasswordPreviousId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2068 NAME 'msDS-DeletedObjectLifetime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2095 NAME 'msDS-IsUsedAsResourceSecurityAttribute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.786 NAME 'mailAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.373 NAME 'rIDUsedPool' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.19 NAME 'msDFSR-RdcEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.44 NAME 'homeDirectory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.538 NAME 'prefixMap' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2034 NAME 'msDFS-LastModifiedv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2155 NAME 'msAuthz-MemberRulesInCentralAccessPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.947 NAME 'mSMQSignCertificates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.714 NAME 'dhcpOptions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2060 NAME 'msDS-LocalEffectiveRecycleTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.675 NAME 'catalogs' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.134 NAME 'trustPosixOffset' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1404 NAME 'mS-SQL-AllowImmediateUpdatingSubscription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2047 NAME 'globalAddressList2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.135 NAME 'cost' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1331 NAME 'pKIExpirationPeriod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.45 NAME 'organizationalStatus' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.5.4.15 NAME 'businessCategory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.13.3.4 NAME 'msDFSR-RootSizeInMb' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.869 NAME 'frsComputerReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1893 NAME 'msPKIDPAPIMasterKeys' SYNTAX '1.2.840.113556.1.4.903' )",
            "( 1.2.840.113556.1.4.1430 NAME 'msPKI-Enrollment-Flag' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.45 NAME 'homeDrive' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2085 NAME 'msSPP-OnlineLicense' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.196 NAME 'systemMayContain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.90 NAME 'unicodePwd' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.763 NAME 'aCSTotalNoOfFlows' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1806 NAME 'msDS-MembersForAzRole' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.873 NAME 'fRSControlOutboundBacklog' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.89 NAME 'nTGroupMembers' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.815 NAME 'canUpgradeScript' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.96 NAME 'pwdLastSet' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.228 NAME 'portName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1821 NAME 'msieee80211-Data' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.720 NAME 'dhcpUpdateTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 2.5.4.33 NAME 'roleOccupant' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1818 NAME 'msDS-AzTaskIsRoleDefinition' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.16 NAME 'ipServiceProtocol' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.488 NAME 'fRSStagingPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.25 NAME 'dc' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.502 NAME 'timeVolChange' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.303 NAME 'notificationList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.952 NAME 'mSMQMigrated' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2290 NAME 'msDS-UserAuthNPolicyBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.53 NAME 'lastSetTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.894 NAME 'gPCFileSysPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.22 NAME 'teletexTerminalIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.471 NAME 'schemaVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' )",
            "( 1.2.840.113556.1.2.91 NAME 'repsFrom' SYNTAX 'OctetString' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.5 NAME 'msDFSR-StagingPath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.3.6.1.1.1.1.15 NAME 'ipServicePort' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.781 NAME 'lastKnownParent' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 2.5.4.43 NAME 'initials' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.901 NAME 'aCSMaxNoOfAccountFiles' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1928 NAME 'msDS-RevealOnDemandGroup' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1689 NAME 'msDS-Non-Security-Group-Extra-Classes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.344 NAME 'groupsToIgnore' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.896 NAME 'uSNSource' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.964 NAME 'mSMQNt4Flags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2102 NAME 'msDS-ClaimSharesPossibleValuesWithBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 2.5.4.29 NAME 'presentationAddress' SYNTAX '1.3.6.1.4.1.1466.115.121.1.43' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2051 NAME 'msDS-OIDToGroupLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.369 NAME 'fSMORoleOwner' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1954 NAME 'ms-net-ieee-8023-GP-PolicyGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.648 NAME 'primaryTelexNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2283 NAME 'msDS-ServiceAllowedToAuthenticateFrom' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 2.5.4.12 NAME 'title' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.1 NAME 'uid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1247 NAME 'interSiteTopologyRenew' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1697 NAME 'msDS-Settings' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.247 NAME 'printAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2188 NAME 'msDS-ValueTypeReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2133 NAME 'msDNS-MaintainTrustAnchor' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.324 NAME 'msSFU30KeyValues' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.1378 NAME 'mS-SQL-AppleTalk' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1663 NAME 'msDS-Replication-Notify-First-DSA-Delay' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.121 NAME 'securityIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.748 NAME 'attributeDisplayNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.16.840.1.113730.3.1.35 NAME 'thumbnailPhoto' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2082 NAME 'msSPP-KMSIds' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.758 NAME 'aCSMaxTokenRatePerFlow' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.121 NAME 'uSNLastObjRem' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.875 NAME 'fRSMemberReference' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1349 NAME 'gPCUserExtensionNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.138 NAME 'userParameters' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.36 NAME 'userCertificate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.6.13.3.102 NAME 'msDFSR-MemberReferenceBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.131 NAME 'co' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.3 NAME 'cn' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.936 NAME 'mSMQEncryptKey' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.226 NAME 'adminDescription' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.34 NAME 'seeAlso' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.444 NAME 'msExchAssistantName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.667 NAME 'syncWithSID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1998 NAME 'msFVE-VolumeGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2107 NAME 'msTPM-SrkPubThumbprint' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.81 NAME 'info' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1686 NAME 'msWMI-ScopeGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.151 NAME 'oEMInformation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.935 NAME 'mSMQOSType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.374 NAME 'rIDNextRID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2039 NAME 'msDFS-LinkPathv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.141 NAME 'versionNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.505 NAME 'oMTGuid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.88 NAME 'nextRid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2037 NAME 'msDFS-Propertiesv2' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1994 NAME 'msTSLicenseVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.16.840.1.113730.3.140 NAME 'userSMIMECertificate' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1985 NAME 'msTSBrokenConnectionAction' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.281 NAME 'printStaplingSupported' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.17 NAME 'msDFSR-Options' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.485 NAME 'fRSUpdateTimeout' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1967 NAME 'msDS-NC-RO-Replica-Locations' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1819 NAME 'msDS-AzApplicationData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.347 NAME 'msSFU30PosixMemberOf' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1425 NAME 'msCOM-UserLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.6.13.3.24 NAME 'msDFSR-DfsLinkTarget' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.512 NAME 'siteObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.584 NAME 'meetingRating' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1794 NAME 'msDS-NonMembersBL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.776 NAME 'aCSDSBMPriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.520 NAME 'machinePasswordChangeInterval' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.669 NAME 'rIDSetReferences' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.941 NAME 'mSMQLongLived' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1241 NAME 'netbootMirrorDataFile' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.305 NAME 'msSFU30ResultAttributes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2236 NAME 'msds-memberOfTransitive' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1427 NAME 'msCOM-DefaultPartitionLink' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.519 NAME 'lastBackupRestorationTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.337 NAME 'currMachineId' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.32 NAME 'attributeSyntax' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.362 NAME 'siteGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.823 NAME 'certificateTemplates' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 2.16.840.1.113730.3.1.39 NAME 'preferredLanguage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.352 NAME 'msSFU30CryptMethod' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1946 NAME 'msDS-PhoneticDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.14 NAME 'searchGuide' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2270 NAME 'msDS-IsManaged' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.581 NAME 'meetingScope' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.673 NAME 'retiredReplDSASignatures' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.855 NAME 'netbootNewMachineNamingPolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1245 NAME 'globalAddressList' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.2.227 NAME 'extensionName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.884 NAME 'msRRASAttribute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.6.18.1.349 NAME 'msSFU30NetgroupUserAtDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.26' )",
            "( 1.2.840.113556.1.4.680 NAME 'queryPoint' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.888 NAME 'iPSECNegotiationPolicyAction' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.29 NAME 'msDFSR-CachePolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.299 NAME 'printMediaSupported' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.503 NAME 'timeRefresh' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.11 NAME 'authenticationOptions' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.198 NAME 'systemAuxiliaryClass' SYNTAX '1.3.6.1.4.1.1466.115.121.1.38' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.857 NAME 'netbootIntelliMirrorOSes' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1406 NAME 'mS-SQL-AllowSnapshotFilesFTPDownloading' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1333 NAME 'pKIExtendedKeyUsage' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.2019 NAME 'msDS-LockoutThreshold' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1844 NAME 'msDS-QuotaTrustee' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.18.1.350 NAME 'msSFU30IsValidContainer' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.359 NAME 'netbootGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1719 NAME 'msDS-DnsRootAlias' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.909 NAME 'extendedAttributeInfo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' NO-USER-MODIFICATION )",
            "( 1.3.6.1.1.1.1.10 NAME 'shadowExpire' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1248 NAME 'interSiteTopologyFailover' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2275 NAME 'msDS-CloudIsEnabled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.7' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.887 NAME 'iPSECNegotiationPolicyType' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2059 NAME 'msDS-LocalEffectiveDeletionTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.24' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.587 NAME 'meetingStartTime' SYNTAX '1.3.6.1.4.1.1466.115.121.1.53' )",
            "( 2.5.4.17 NAME 'postalCode' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.2.445 NAME 'originalDisplayTable' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1990 NAME 'msTSInitialProgram' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.662 NAME 'lockoutTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.21 NAME 'secretary' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.95 NAME 'pwdHistoryLength' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.759 NAME 'aCSMaxPeakBandwidthPerFlow' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.753 NAME 'nameServiceFlags' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.694 NAME 'previousParentCA' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.142 NAME 'winsockAddresses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.2075 NAME 'msTSSecondaryDesktops' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.2105 NAME 'msSPP-CSVLKPid' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.49 NAME 'badPasswordTime' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2184 NAME 'msDS-GeoCoordinatesLatitude' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2079 NAME 'msDS-RequiredForestBehaviorVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1955 NAME 'ms-net-ieee-8023-GP-PolicyData' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.237 NAME 'printBinNames' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1382 NAME 'mS-SQL-InformationURL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.6.13.3.13 NAME 'msDFSR-DirectoryFilter' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.148 NAME 'schemaIDGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.2189 NAME 'msDS-TransformationRules' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 2.5.4.10 NAME 'o' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.504 NAME 'seqNotification' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 2.5.4.7 NAME 'l' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.57 NAME 'defaultLocalPolicyObject' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1801 NAME 'msDS-AzBizRule' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.948 NAME 'mSMQDigests' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.2.327 NAME 'helpFileName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.421 NAME 'domainWidePolicy' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 2.5.4.6 NAME 'c' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2139 NAME 'msDNS-DNSKEYRecordSetTTL' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 0.9.2342.19200300.100.1.11 NAME 'documentIdentifier' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.609 NAME 'sIDHistory' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1711 NAME 'msDS-SDReferenceDomain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1367 NAME 'mS-SQL-Memory' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.715 NAME 'dhcpClasses' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1305 NAME 'moveTreeState' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.757 NAME 'aCSDirection' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.631 NAME 'printPagesPerMinute' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.145 NAME 'revision' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.646 NAME 'otherFacsimileTelephoneNumber' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' )",
            "( 1.2.840.113556.1.4.1798 NAME 'msDS-AzApplicationName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.366 NAME 'rpcNsAnnotation' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2190 NAME 'msDS-TransformationRulesCompiled' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.4.1636 NAME 'msWMI-StringDefault' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.813 NAME 'upgradeProductCode' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' )",
            "( 1.2.840.113556.1.4.1951 NAME 'ms-net-ieee-80211-GP-PolicyGUID' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2098 NAME 'msDS-ClaimValueType' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.194 NAME 'adminDisplayName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.879 NAME 'fRSServiceCommandStatus' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.361 NAME 'netbootMachineFilePath' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.67 NAME 'lSAModifiedCount' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.920 NAME 'mSMQBasePriority' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2277 NAME 'msDS-UserAllowedToAuthenticateTo' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2056 NAME 'msDS-HostServiceAccount' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' )",
            "( 1.2.840.113556.1.4.1943 NAME 'msDS-PhoneticLastName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.2055 NAME 'msDS-USNLastSyncSuccess' SYNTAX '1.2.840.113556.1.4.906' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.101 NAME 'privateKey' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 2.5.4.42 NAME 'givenName' SYNTAX '1.3.6.1.4.1.1466.115.121.1.15' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.685 NAME 'parentCACertificateChain' SYNTAX '1.3.6.1.4.1.1466.115.121.1.40' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.1924 NAME 'msDS-RevealedUsers' SYNTAX '1.2.840.113556.1.4.903' NO-USER-MODIFICATION )",
            "( 1.2.840.113556.1.2.76 NAME 'objectVersion' SYNTAX '1.3.6.1.4.1.1466.115.121.1.27' SINGLE-VALUE )",
            "( 1.2.840.113556.1.4.856 NAME 'netbootNewMachineOU' SYNTAX '1.3.6.1.4.1.1466.115.121.1.12' SINGLE-VALUE )"
        ],
        "cn": [
            "Aggregate"
        ],
        "dITContentRules": [
            "( 1.2.840.113556.1.6.13.4.6 NAME 'msDFSR-Content' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.14 NAME 'device' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MAY (uid $ manager $ ipHostNumber $ macAddress $ bootParameter $ bootFile ))",
            "( 1.2.840.113556.1.5.205 NAME 'msWMI-IntRangeParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.5 NAME 'samServer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.196 NAME 'msPKI-Enterprise-Oid' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.7000.53 NAME 'crossRefContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.7 NAME 'ipNetwork' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.5 NAME 'organizationalUnit' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.152 NAME 'intellimirrorGroup' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.253 NAME 'msFVE-RecoveryInformation' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.262 NAME 'msImaging-PSPs' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.251 NAME 'ms-net-ieee-80211-GroupPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.138 NAME 'aCSSubnet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.43 NAME 'fTDfs' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.27 NAME 'rpcEntry')",
            "( 1.2.840.113556.1.5.85 NAME 'dnsZone' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.4.2163 NAME 'msAuthz-CentralAccessRule' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.194 NAME 'msCOM-PartitionSet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.242 NAME 'msDS-QuotaContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.281 NAME 'msDS-ClaimsTransformationPolicies' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.146 NAME 'remoteStorageServicePoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.2 NAME 'samDomainBase')",
            "( 1.2.840.113556.1.5.132 NAME 'dHCPClass' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.283 NAME 'msDS-CloudExtensions')",
            "( 1.2.840.113556.1.5.89 NAME 'nTFRSSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.24 NAME 'remoteMailRecipient' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (cn ) MAY (telephoneNumber $ userCertificate $ info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ showInAddressBook $ userCert $ legacyExchangeDN $ msDS-PhoneticDisplayName $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ userSMIMECertificate $ textEncodedORAddress $ secretary $ labeledURI ))",
            "( 1.2.840.113556.1.5.221 NAME 'msTAPI-RtConference' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.201 NAME 'msWMI-SimplePolicyTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.18.2.212 NAME 'msSFU30NetId' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.49 NAME 'packageRegistration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.139 NAME 'lostAndFound' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.14 NAME 'connectionPoint')",
            "( 1.2.840.113556.1.5.6 NAME 'securityPrincipal')",
            "( 1.2.840.113556.1.5.147 NAME 'siteLink' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.255 NAME 'msDS-PasswordSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.4.2162 NAME 'msAuthz-CentralAccessRules' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.30 NAME 'serviceInstance' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.156 NAME 'rRASAdministrationDictionary' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.4.2164 NAME 'msAuthz-CentralAccessPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.16.840.1.113730.3.2.2 NAME 'inetOrgPerson' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag ))",
            "( 1.2.840.113556.1.5.52 NAME 'fileLinkTracking' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.18 NAME 'domainPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.18.2.216 NAME 'msSFU30NetworkUser' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.19 NAME 'simpleSecurityObject')",
            "( 1.2.840.113556.1.5.177 NAME 'pKICertificateTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.293 NAME 'msDS-AuthNPolicies' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.2 NAME 'msDFSR-Subscriber' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.31 NAME 'site' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.222 NAME 'msTAPI-RtPerson' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.68 NAME 'applicationSiteSettings')",
            "( 1.2.840.113556.1.3.14 NAME 'attributeSchema' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.267 NAME 'msSPP-ActivationObject' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.220 NAME 'msDS-App-Configuration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.23 NAME 'container' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.10 NAME 'msDFSR-Connection' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.207 NAME 'msWMI-UintRangeParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.23 NAME 'printQueue' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.260 NAME 'msDFS-DeletedLinkv2' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.140 NAME 'interSiteTransportContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.130 NAME 'indexServerCatalog' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.98 NAME 'ipsecPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.0 NAME 'top')",
            "( 1.2.840.113556.1.5.36 NAME 'volume' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.236 NAME 'msDS-AzOperation' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.9 NAME 'groupOfNames' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.12 NAME 'configuration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.78 NAME 'licensingSiteSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.69 NAME 'nTDSSiteSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.269 NAME 'msDS-ClaimTypePropertyBase')",
            "( 1.2.840.113556.1.5.273 NAME 'msDS-ResourceProperty' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.239 NAME 'msDS-AzRole' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.12 NAME 'bootableDevice')",
            "( 1.2.840.113556.1.5.294 NAME 'msDS-AuthNPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.86 NAME 'dnsNode' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.210 NAME 'msWMI-StringSetParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.264 NAME 'msDS-ManagedServiceAccount' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag $ ipHostNumber ))",
            "( 1.2.840.113556.1.5.15 NAME 'contact' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MAY (userCertificate $ info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ showInAddressBook $ userCert $ legacyExchangeDN $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ userSMIMECertificate $ textEncodedORAddress $ secretary $ labeledURI ))",
            "( 1.3.6.1.1.1.2.0 NAME 'posixAccount')",
            "( 1.2.840.113556.1.5.266 NAME 'msSPP-ActivationObjectsContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.217 NAME 'msWMI-ObjectEncoding' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.33 NAME 'storage' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.67 NAME 'domainDNS' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MAY (cACertificate $ builtinCreationTime $ builtinModifiedCount $ creationTime $ domainPolicyObject $ forceLogoff $ defaultLocalPolicyObject $ lockoutDuration $ lockOutObservationWindow $ lSACreationTime $ lSAModifiedCount $ lockoutThreshold $ maxPwdAge $ minPwdAge $ minPwdLength $ modifiedCountAtLastProm $ nETBIOSName $ nextRid $ pwdProperties $ pwdHistoryLength $ privateKey $ replicaSource $ objectSid $ oEMInformation $ serverState $ uASCompat $ serverRole $ domainReplica $ modifiedCount $ controlAccessRights $ auditingPolicy $ eFSPolicy $ desktopProfile $ nTMixedDomain $ rIDManagerReference $ treeName $ pekList $ pekKeyChangeInterval $ gPLink $ gPOptions $ ms-DS-MachineAccountQuota $ msDS-LogonTimeSyncInterval $ msDS-PerUserTrustQuota $ msDS-AllUsersTrustQuota $ msDS-PerUserTrustTombstonesQuota ))",
            "( 1.2.840.113556.1.5.92 NAME 'linkTrackVolEntry' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.11 NAME 'ieee802Device')",
            "( 0.9.2342.19200300.100.4.17 NAME 'domainRelatedObject')",
            "( 1.2.840.113556.1.5.235 NAME 'msDS-AzApplication' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.107 NAME 'sitesContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.263 NAME 'msImaging-PostScanProcess' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.240 NAME 'msieee80211-Policy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.95 NAME 'subnetContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.6 NAME 'document' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.6 NAME 'person' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.274 NAME 'msDS-ResourcePropertyList' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.270 NAME 'msDS-ClaimTypes' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.1 NAME 'shadowAccount')",
            "( 1.2.840.113556.1.5.179 NAME 'mSMQMigratedUser' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.185 NAME 'mS-SQL-OLAPServer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.4.1.1466.101.119.2 NAME 'dynamicObject')",
            "( 1.2.840.113556.1.5.155 NAME 'nTFRSSubscriber' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.129 NAME 'rIDSet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.58 NAME 'addressTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.154 NAME 'nTFRSSubscriptions' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.7000.47 NAME 'nTDSDSA' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.175 NAME 'infrastructureUpdate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.18.2.215 NAME 'msSFU30DomainInfo' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.213 NAME 'msWMI-Som' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.82 NAME 'rpcProfile' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.164 NAME 'mSMQSiteLink' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.184 NAME 'mS-SQL-SQLServer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.106 NAME 'queryPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.162 NAME 'mSMQConfiguration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.257 NAME 'msDFS-NamespaceAnchor' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.7 NAME 'msDFSR-ContentSet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.276 NAME 'msTPM-InformationObjectsContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.209 NAME 'msWMI-RealRangeParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.7 NAME 'organizationalPerson' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.176 NAME 'msExchConfigurationContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.278 NAME 'msKds-ProvRootKey' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.238 NAME 'msDS-AzTask' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.282 NAME 'msDS-GroupManagedServiceAccount' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag $ ipHostNumber ))",
            "( 1.3.6.1.1.1.2.9 NAME 'nisMap' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.10 NAME 'nisObject' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.277 NAME 'msKds-ProvServerConfiguration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.18.2.217 NAME 'msSFU30NISMapConfig' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.7000.48 NAME 'serversContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.90 NAME 'linkTrackVolumeTable' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.188 NAME 'mS-SQL-SQLDatabase' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.211 NAME 'msWMI-PolicyType' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.183 NAME 'dSUISettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.157 NAME 'groupPolicyContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.3 NAME 'samDomain' MAY (forceLogoff $ objectSid $ oEMInformation $ serverState $ uASCompat $ serverRole $ domainReplica $ modifiedCount ))",
            "( 1.2.840.113556.1.5.234 NAME 'msDS-AzAdminManager' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.214 NAME 'msWMI-Rule' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.254 NAME 'nTDSDSARO' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.286 NAME 'msDS-Device' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.34 NAME 'trustedDomain' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.7 NAME 'room' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.4 NAME 'organization' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.272 NAME 'msDS-ClaimType' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.3 NAME 'ipService' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.4 NAME 'ipProtocol' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.80 NAME 'rpcGroup' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.17 NAME 'server' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.28 NAME 'secret' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.163 NAME 'mSMQEnterpriseSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.202 NAME 'msWMI-MergeablePolicyTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.195 NAME 'msPKI-Key-Recovery-Agent' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag ))",
            "( 0.9.2342.19200300.100.4.18 NAME 'friendlyCountry' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.258 NAME 'msDFS-Namespacev2' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.96 NAME 'subnet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.216 NAME 'applicationVersion' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.10 NAME 'residentialPerson' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.19 NAME 'cRLDistributionPoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.137 NAME 'aCSPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.77 NAME 'controlAccessRight' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.219 NAME 'msMQ-Group' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.8 NAME 'group' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (cn $ objectSid $ sAMAccountName ) MAY (telephoneNumber $ userPassword $ userCertificate $ info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-PhoneticDisplayName $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ userSMIMECertificate $ textEncodedORAddress $ secretary $ labeledURI $ gidNumber $ memberUid ))",
            "( 1.2.840.113556.1.6.23.2 NAME 'msPrint-ConnectionPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.11 NAME 'crossRef' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.9 NAME 'msDFSR-Member' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.59 NAME 'displayTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.13 NAME 'classSchema' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.200 NAME 'msWMI-PolicyTemplate' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.165 NAME 'mSMQSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.5 NAME 'oncRpc' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.126 NAME 'serviceConnectionPoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.4 NAME 'builtinDomain' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MAY (creationTime $ forceLogoff $ lockoutDuration $ lockOutObservationWindow $ lockoutThreshold $ maxPwdAge $ minPwdAge $ minPwdLength $ modifiedCountAtLastProm $ nextRid $ pwdProperties $ pwdHistoryLength $ objectSid $ oEMInformation $ serverState $ uASCompat $ serverRole $ domainReplica $ modifiedCount ))",
            "( 1.2.840.113556.1.5.241 NAME 'msDS-AppData' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.73 NAME 'rpcServerElement' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.150 NAME 'rRASAdministrationConnectionPoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.191 NAME 'aCSResourceLimits' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.3 NAME 'locality' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.6 NAME 'ipHost')",
            "( 1.2.840.113556.1.5.275 NAME 'msTPM-InformationObject' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.289 NAME 'msDS-DeviceContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.4.2129 NAME 'msDNS-ServerSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.76 NAME 'foreignSecurityPrincipal' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.44 NAME 'classStore' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.5 NAME 'account' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.26 NAME 'rpcProfileElement' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.215 NAME 'msWMI-WMIGPO' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.243 NAME 'msDS-QuotaControl' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.256 NAME 'msDS-PasswordSettingsContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.187 NAME 'mS-SQL-SQLPublication' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.9 NAME 'user' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag ))",
            "( 1.2.840.113556.1.5.259 NAME 'msDFS-Linkv2' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.141 NAME 'interSiteTransport' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.4 NAME 'msDFSR-GlobalSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.29 NAME 'serviceClass' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.189 NAME 'mS-SQL-OLAPDatabase' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.16 NAME 'certificationAuthority' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.104 NAME 'meeting' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.287 NAME 'msDS-DeviceRegistrationServiceContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.71 NAME 'nTDSConnection' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.291 NAME 'msDS-AuthNPolicySilos' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.218 NAME 'msMQ-Custom-Recipient' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.72 NAME 'nTDSService' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.9 NAME 'dMD' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.280 NAME 'msDS-ClaimsTransformationPolicyType' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.14 NAME 'rFC822LocalPart' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.190 NAME 'mS-SQL-OLAPCube' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.208 NAME 'msWMI-UintSetParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.3.6.1.1.1.2.2 NAME 'posixGroup')",
            "( 2.5.6.17 NAME 'groupOfUniqueNames' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.252 NAME 'ms-net-ieee-8023-GroupPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.119 NAME 'ipsecNegotiationPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.292 NAME 'msDS-AuthNPolicySilo' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.121 NAME 'ipsecNFA' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.42 NAME 'dfsConfiguration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 0.9.2342.19200300.100.4.9 NAME 'documentSeries' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.271 NAME 'msDS-ResourceProperties' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.91 NAME 'linkTrackObjectMoveTable' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.136 NAME 'rpcContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.83 NAME 'rIDManager' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.206 NAME 'msWMI-IntSetParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.5 NAME 'msDFSR-ReplicationGroup' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.125 NAME 'addressBookContainer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.7000.49 NAME 'applicationSettings')",
            "( 1.2.840.113556.1.5.265 NAME 'msDS-OptionalFeature' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.94 NAME 'serviceAdministrationPoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.102 NAME 'nTFRSReplicaSet' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.203 NAME 'msWMI-RangeParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.7000.56 NAME 'ipsecBase')",
            "( 1.2.840.113556.1.6.13.4.3 NAME 'msDFSR-Subscription' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.223 NAME 'msPKI-PrivateKeyRecoveryAgent' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.178 NAME 'pKIEnrollmentService' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.18.2.211 NAME 'msSFU30MailAliases' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.53 NAME 'typeLibrary' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.8 NAME 'msDFSR-Topology' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.237 NAME 'msDS-AzScope' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.74 NAME 'categoryRegistration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.11 NAME 'comConnectionPoint' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.93 NAME 'linkTrackOMTEntry' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.10 NAME 'classRegistration' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.148 NAME 'siteLinkBridge' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.81 NAME 'rpcServer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.46 NAME 'mailRecipient')",
            "( 1.2.840.113556.1.5.1 NAME 'securityObject')",
            "( 1.2.840.113556.1.5.20 NAME 'leaf')",
            "( 1.2.840.113556.1.5.151 NAME 'intellimirrorSCP' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.6.13.4.1 NAME 'msDFSR-LocalSettings' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.186 NAME 'mS-SQL-SQLRepository' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.8 NAME 'organizationalRole' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.20.1 NAME 'subSchema' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.284 NAME 'msDS-DeviceRegistrationService' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.84 NAME 'displaySpecifier' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.212 NAME 'msWMI-ShadowObject' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.59 NAME 'fileLinkTrackingEntry' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.4.2161 NAME 'msAuthz-CentralAccessPolicies' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.161 NAME 'mSMQQueue' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.193 NAME 'msCOM-Partition' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.118 NAME 'ipsecFilter' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.2 NAME 'country' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.97 NAME 'physicalLocation' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.3.30 NAME 'computer' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ) MUST (objectSid $ sAMAccountName ) MAY (info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ showInAddressBook $ userCert $ legacyExchangeDN $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber $ unixUserPassword $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 $ textEncodedORAddress $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag $ ipHostNumber ))",
            "( 1.3.6.1.1.1.2.8 NAME 'nisNetgroup' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.153 NAME 'nTFRSMember' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.12 NAME 'applicationEntity' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 2.5.6.11 NAME 'applicationProcess' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.279 NAME 'msDS-ValueType' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.204 NAME 'msWMI-UnknownRangeParam' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.66 NAME 'domain')",
            "( 2.5.6.13 NAME 'dSA' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))",
            "( 1.2.840.113556.1.5.120 NAME 'ipsecISAKMPPolicy' AUX ( mailRecipient $ posixGroup $ ipHost $ samDomain $ dynamicObject $ shadowAccount $ domainRelatedObject $ ieee802Device $ posixAccount $ bootableDevice $ simpleSecurityObject $ securityPrincipal $ msDS-CloudExtensions $ samDomainBase ))"
        ],
        "dSCorePropagationData": [
            "16010101000000.0Z"
        ],
        "distinguishedName": [
            "CN=Aggregate,CN=Schema,CN=Configuration,DC=FOREST,DC=LAB"
        ],
        "instanceType": [
            "4"
        ],
        "modifyTimeStamp": [
            "20141006121949.0Z"
        ],
        "name": [
            "Aggregate"
        ],
        "objectCategory": [
            "CN=SubSchema,CN=Schema,CN=Configuration,DC=FOREST,DC=LAB"
        ],
        "objectClass": [
            "top",
            "subSchema"
        ],
        "objectClasses": [
            "( 1.2.840.113556.1.6.13.4.6 NAME 'msDFSR-Content' SUP top STRUCTURAL MAY (msDFSR-Extension $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 ) )",
            "( 2.5.6.14 NAME 'device' SUP top STRUCTURAL MUST (cn ) MAY (serialNumber $ l $ o $ ou $ owner $ seeAlso $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.2.840.113556.1.5.205 NAME 'msWMI-IntRangeParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-IntDefault ) MAY (msWMI-IntMax $ msWMI-IntMin ) )",
            "( 1.2.840.113556.1.5.5 NAME 'samServer' SUP securityObject STRUCTURAL MAY (samDomainUpdates ) )",
            "( 1.2.840.113556.1.5.196 NAME 'msPKI-Enterprise-Oid' SUP top STRUCTURAL MAY (msPKI-Cert-Template-OID $ msPKI-OID-Attribute $ msPKI-OID-CPS $ msPKI-OID-User-Notice $ msPKI-OIDLocalizedName $ msDS-OIDToGroupLink ) )",
            "( 1.2.840.113556.1.5.7000.53 NAME 'crossRefContainer' SUP top STRUCTURAL MAY (uPNSuffixes $ msDS-Behavior-Version $ msDS-SPNSuffixes $ msDS-UpdateScript $ msDS-ExecuteScriptPassword $ msDS-EnabledFeature ) )",
            "( 1.3.6.1.1.1.2.7 NAME 'ipNetwork' SUP top STRUCTURAL MUST (cn $ ipNetworkNumber ) MAY (l $ description $ uid $ manager $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ ipNetmaskNumber $ nisMapName ) )",
            "( 2.5.6.5 NAME 'organizationalUnit' SUP top STRUCTURAL MUST (ou ) MAY (c $ l $ st $ street $ searchGuide $ businessCategory $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telephoneNumber $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod $ seeAlso $ userPassword $ co $ countryCode $ desktopProfile $ defaultGroup $ managedBy $ uPNSuffixes $ gPLink $ gPOptions $ msCOM-UserPartitionSetLink $ thumbnailLogo ) )",
            "( 1.2.840.113556.1.5.152 NAME 'intellimirrorGroup' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.253 NAME 'msFVE-RecoveryInformation' SUP top STRUCTURAL MUST (msFVE-RecoveryPassword $ msFVE-RecoveryGuid ) MAY (msFVE-VolumeGuid $ msFVE-KeyPackage ) )",
            "( 1.2.840.113556.1.5.262 NAME 'msImaging-PSPs' SUP container STRUCTURAL )",
            "( 1.2.840.113556.1.5.251 NAME 'ms-net-ieee-80211-GroupPolicy' SUP top STRUCTURAL MAY (ms-net-ieee-80211-GP-PolicyGUID $ ms-net-ieee-80211-GP-PolicyData $ ms-net-ieee-80211-GP-PolicyReserved ) )",
            "( 1.2.840.113556.1.5.138 NAME 'aCSSubnet' SUP top STRUCTURAL MAY (aCSMaxTokenRatePerFlow $ aCSMaxPeakBandwidthPerFlow $ aCSMaxDurationPerFlow $ aCSAllocableRSVPBandwidth $ aCSMaxPeakBandwidth $ aCSEnableRSVPMessageLogging $ aCSEventLogLevel $ aCSEnableACSService $ aCSRSVPLogFilesLocation $ aCSMaxNoOfLogFiles $ aCSMaxSizeOfRSVPLogFile $ aCSDSBMPriority $ aCSDSBMRefresh $ aCSDSBMDeadTime $ aCSCacheTimeout $ aCSNonReservedTxLimit $ aCSNonReservedTxSize $ aCSEnableRSVPAccounting $ aCSRSVPAccountFilesLocation $ aCSMaxNoOfAccountFiles $ aCSMaxSizeOfRSVPAccountFile $ aCSServerList $ aCSNonReservedPeakRate $ aCSNonReservedTokenSize $ aCSNonReservedMaxSDUSize $ aCSNonReservedMinPolicedSize ) )",
            "( 1.2.840.113556.1.5.43 NAME 'fTDfs' SUP top STRUCTURAL MUST (remoteServerName $ pKTGuid $ pKT ) MAY (keywords $ uNCName $ managedBy ) )",
            "( 1.2.840.113556.1.5.27 NAME 'rpcEntry' SUP connectionPoint ABSTRACT )",
            "( 1.2.840.113556.1.5.85 NAME 'dnsZone' SUP top STRUCTURAL MUST (dc ) MAY (dnsAllowDynamic $ dnsAllowXFR $ dnsSecureSecondaries $ dnsNotifySecondaries $ managedBy $ dNSProperty $ msDNS-IsSigned $ msDNS-SignWithNSEC3 $ msDNS-NSEC3OptOut $ msDNS-MaintainTrustAnchor $ msDNS-DSRecordAlgorithms $ msDNS-RFC5011KeyRollovers $ msDNS-NSEC3HashAlgorithm $ msDNS-NSEC3RandomSaltLength $ msDNS-NSEC3Iterations $ msDNS-DNSKEYRecordSetTTL $ msDNS-DSRecordSetTTL $ msDNS-SignatureInceptionOffset $ msDNS-SecureDelegationPollingPeriod $ msDNS-SigningKeyDescriptors $ msDNS-SigningKeys $ msDNS-DNSKEYRecords $ msDNS-ParentHasSecureDelegation $ msDNS-PropagationTime $ msDNS-NSEC3UserSalt $ msDNS-NSEC3CurrentSalt ) )",
            "( 1.2.840.113556.1.4.2163 NAME 'msAuthz-CentralAccessRule' SUP top STRUCTURAL MAY (Enabled $ msAuthz-EffectiveSecurityPolicy $ msAuthz-ProposedSecurityPolicy $ msAuthz-LastEffectiveSecurityPolicy $ msAuthz-ResourceCondition $ msAuthz-MemberRulesInCentralAccessPolicyBL ) )",
            "( 1.2.840.113556.1.5.194 NAME 'msCOM-PartitionSet' SUP top STRUCTURAL MAY (msCOM-PartitionLink $ msCOM-DefaultPartitionLink $ msCOM-ObjectId ) )",
            "( 1.2.840.113556.1.5.242 NAME 'msDS-QuotaContainer' SUP top STRUCTURAL MUST (cn ) MAY (msDS-DefaultQuota $ msDS-TombstoneQuotaFactor $ msDS-QuotaEffective $ msDS-QuotaUsed $ msDS-TopQuotaUsage ) )",
            "( 1.2.840.113556.1.5.281 NAME 'msDS-ClaimsTransformationPolicies' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.146 NAME 'remoteStorageServicePoint' SUP serviceAdministrationPoint STRUCTURAL MAY (remoteStorageGUID ) )",
            "( 1.2.840.113556.1.5.2 NAME 'samDomainBase' SUP top AUXILIARY MAY (nTSecurityDescriptor $ creationTime $ forceLogoff $ lockoutDuration $ lockOutObservationWindow $ lockoutThreshold $ maxPwdAge $ minPwdAge $ minPwdLength $ modifiedCountAtLastProm $ nextRid $ pwdProperties $ pwdHistoryLength $ revision $ objectSid $ oEMInformation $ serverState $ uASCompat $ serverRole $ domainReplica $ modifiedCount ) )",
            "( 1.2.840.113556.1.5.132 NAME 'dHCPClass' SUP top STRUCTURAL MUST (dhcpUniqueKey $ dhcpType $ dhcpFlags $ dhcpIdentification ) MAY (networkAddress $ dhcpObjName $ dhcpObjDescription $ dhcpServers $ dhcpSubnets $ dhcpMask $ dhcpRanges $ dhcpSites $ dhcpReservations $ superScopes $ superScopeDescription $ optionDescription $ optionsLocation $ dhcpOptions $ dhcpClasses $ mscopeId $ dhcpState $ dhcpProperties $ dhcpMaxKey $ dhcpUpdateTime ) )",
            "( 1.2.840.113556.1.5.283 NAME 'msDS-CloudExtensions' SUP top AUXILIARY MAY (msDS-cloudExtensionAttribute1 $ msDS-cloudExtensionAttribute2 $ msDS-cloudExtensionAttribute3 $ msDS-cloudExtensionAttribute4 $ msDS-cloudExtensionAttribute5 $ msDS-cloudExtensionAttribute6 $ msDS-cloudExtensionAttribute7 $ msDS-cloudExtensionAttribute8 $ msDS-cloudExtensionAttribute9 $ msDS-cloudExtensionAttribute10 $ msDS-cloudExtensionAttribute11 $ msDS-cloudExtensionAttribute12 $ msDS-cloudExtensionAttribute13 $ msDS-cloudExtensionAttribute14 $ msDS-cloudExtensionAttribute15 $ msDS-cloudExtensionAttribute16 $ msDS-cloudExtensionAttribute17 $ msDS-cloudExtensionAttribute18 $ msDS-cloudExtensionAttribute19 $ msDS-cloudExtensionAttribute20 ) )",
            "( 1.2.840.113556.1.5.89 NAME 'nTFRSSettings' SUP applicationSettings STRUCTURAL MAY (fRSExtensions $ managedBy ) )",
            "( 1.2.840.113556.1.5.24 NAME 'remoteMailRecipient' SUP top STRUCTURAL MAY (remoteSource $ remoteSourceType $ managedBy ) )",
            "( 1.2.840.113556.1.5.221 NAME 'msTAPI-RtConference' SUP top STRUCTURAL MUST (msTAPI-uid ) MAY (msTAPI-ProtocolId $ msTAPI-ConferenceBlob ) )",
            "( 1.2.840.113556.1.5.201 NAME 'msWMI-SimplePolicyTemplate' SUP msWMI-PolicyTemplate STRUCTURAL MUST (msWMI-TargetObject ) )",
            "( 1.2.840.113556.1.6.18.2.212 NAME 'msSFU30NetId' SUP top STRUCTURAL MAY (msSFU30Name $ msSFU30KeyValues $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.2.840.113556.1.5.49 NAME 'packageRegistration' SUP top STRUCTURAL MAY (msiScriptPath $ cOMClassID $ cOMInterfaceID $ cOMProgID $ localeID $ machineArchitecture $ iconPath $ cOMTypelibId $ vendor $ packageType $ setupCommand $ packageName $ packageFlags $ versionNumberHi $ versionNumberLo $ lastUpdateSequence $ managedBy $ msiFileList $ categories $ upgradeProductCode $ msiScript $ canUpgradeScript $ fileExtPriority $ productCode $ msiScriptName $ msiScriptSize $ installUiLevel ) )",
            "( 1.2.840.113556.1.5.139 NAME 'lostAndFound' SUP top STRUCTURAL MAY (moveTreeState ) )",
            "( 1.2.840.113556.1.5.14 NAME 'connectionPoint' SUP leaf ABSTRACT MUST (cn ) MAY (keywords $ managedBy $ msDS-Settings ) )",
            "( 1.2.840.113556.1.5.6 NAME 'securityPrincipal' SUP top AUXILIARY MUST (objectSid $ sAMAccountName ) MAY (nTSecurityDescriptor $ securityIdentifier $ supplementalCredentials $ rid $ sAMAccountType $ sIDHistory $ altSecurityIdentities $ tokenGroups $ tokenGroupsNoGCAcceptable $ accountNameHistory $ tokenGroupsGlobalAndUniversal $ msDS-KeyVersionNumber ) )",
            "( 1.2.840.113556.1.5.147 NAME 'siteLink' SUP top STRUCTURAL MUST (siteList ) MAY (cost $ schedule $ options $ replInterval ) )",
            "( 1.2.840.113556.1.5.255 NAME 'msDS-PasswordSettings' SUP top STRUCTURAL MUST (msDS-MaximumPasswordAge $ msDS-MinimumPasswordAge $ msDS-MinimumPasswordLength $ msDS-PasswordHistoryLength $ msDS-PasswordComplexityEnabled $ msDS-PasswordReversibleEncryptionEnabled $ msDS-LockoutObservationWindow $ msDS-LockoutDuration $ msDS-LockoutThreshold $ msDS-PasswordSettingsPrecedence ) MAY (msDS-PSOAppliesTo ) )",
            "( 1.2.840.113556.1.4.2162 NAME 'msAuthz-CentralAccessRules' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.30 NAME 'serviceInstance' SUP connectionPoint STRUCTURAL MUST (displayName $ serviceClassID ) MAY (winsockAddresses $ serviceInstanceVersion ) )",
            "( 1.2.840.113556.1.5.156 NAME 'rRASAdministrationDictionary' SUP top STRUCTURAL MAY (msRRASVendorAttributeEntry ) )",
            "( 1.2.840.113556.1.4.2164 NAME 'msAuthz-CentralAccessPolicy' SUP top STRUCTURAL MAY (msAuthz-CentralAccessPolicyID $ msAuthz-MemberRulesInCentralAccessPolicy ) )",
            "( 2.16.840.1.113730.3.2.2 NAME 'inetOrgPerson' SUP user STRUCTURAL MAY (o $ businessCategory $ userCertificate $ givenName $ initials $ x500uniqueIdentifier $ displayName $ employeeNumber $ employeeType $ homePostalAddress $ userSMIMECertificate $ uid $ mail $ roomNumber $ photo $ manager $ homePhone $ secretary $ mobile $ pager $ audio $ jpegPhoto $ carLicense $ departmentNumber $ preferredLanguage $ userPKCS12 $ labeledURI ) )",
            "( 1.2.840.113556.1.5.52 NAME 'fileLinkTracking' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.18 NAME 'domainPolicy' SUP leaf STRUCTURAL MAY (authenticationOptions $ forceLogoff $ defaultLocalPolicyObject $ lockoutDuration $ lockOutObservationWindow $ lockoutThreshold $ maxPwdAge $ maxRenewAge $ maxTicketAge $ minPwdAge $ minPwdLength $ minTicketAge $ pwdProperties $ pwdHistoryLength $ proxyLifetime $ eFSPolicy $ publicKeyPolicy $ domainWidePolicy $ domainPolicyReference $ qualityOfService $ ipsecPolicyReference $ managedBy $ domainCAs ) )",
            "( 1.2.840.113556.1.6.18.2.216 NAME 'msSFU30NetworkUser' SUP top STRUCTURAL MAY (msSFU30Name $ msSFU30KeyValues $ msSFU30NisDomain $ nisMapName ) )",
            "( 0.9.2342.19200300.100.4.19 NAME 'simpleSecurityObject' SUP top AUXILIARY MAY (userPassword ) )",
            "( 1.2.840.113556.1.5.177 NAME 'pKICertificateTemplate' SUP top STRUCTURAL MAY (displayName $ flags $ pKIDefaultKeySpec $ pKIKeyUsage $ pKIMaxIssuingDepth $ pKICriticalExtensions $ pKIExpirationPeriod $ pKIOverlapPeriod $ pKIExtendedKeyUsage $ pKIDefaultCSPs $ pKIEnrollmentAccess $ msPKI-RA-Signature $ msPKI-Enrollment-Flag $ msPKI-Private-Key-Flag $ msPKI-Certificate-Name-Flag $ msPKI-Minimal-Key-Size $ msPKI-Template-Schema-Version $ msPKI-Template-Minor-Revision $ msPKI-Cert-Template-OID $ msPKI-Supersede-Templates $ msPKI-RA-Policies $ msPKI-Certificate-Policy $ msPKI-Certificate-Application-Policy $ msPKI-RA-Application-Policies ) )",
            "( 1.2.840.113556.1.5.293 NAME 'msDS-AuthNPolicies' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.6.13.4.2 NAME 'msDFSR-Subscriber' SUP top STRUCTURAL MUST (msDFSR-ReplicationGroupGuid $ msDFSR-MemberReference ) MAY (msDFSR-Extension $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.31 NAME 'site' SUP top STRUCTURAL MAY (location $ notificationList $ managedBy $ gPLink $ gPOptions $ mSMQSiteID $ mSMQNt4Stub $ mSMQSiteForeign $ mSMQInterval1 $ mSMQInterval2 $ msDS-BridgeHeadServersUsed ) )",
            "( 1.2.840.113556.1.5.222 NAME 'msTAPI-RtPerson' SUP top STRUCTURAL MAY (msTAPI-uid $ msTAPI-IpAddress ) )",
            "( 1.2.840.113556.1.5.68 NAME 'applicationSiteSettings' SUP top ABSTRACT MAY (applicationName $ notificationList ) )",
            "( 1.2.840.113556.1.3.14 NAME 'attributeSchema' SUP top STRUCTURAL MUST (cn $ attributeID $ attributeSyntax $ isSingleValued $ oMSyntax $ lDAPDisplayName $ schemaIDGUID ) MAY (rangeLower $ rangeUpper $ mAPIID $ linkID $ oMObjectClass $ searchFlags $ extendedCharsAllowed $ schemaFlagsEx $ attributeSecurityGUID $ systemOnly $ classDisplayName $ isMemberOfPartialAttributeSet $ isDefunct $ isEphemeral $ msDs-Schema-Extensions $ msDS-IntId ) )",
            "( 1.2.840.113556.1.5.267 NAME 'msSPP-ActivationObject' SUP top STRUCTURAL MUST (msSPP-CSVLKSkuId $ msSPP-KMSIds $ msSPP-CSVLKPid $ msSPP-CSVLKPartialProductKey ) MAY (msSPP-InstallationId $ msSPP-ConfirmationId $ msSPP-OnlineLicense $ msSPP-PhoneLicense $ msSPP-ConfigLicense $ msSPP-IssuanceLicense ) )",
            "( 1.2.840.113556.1.5.220 NAME 'msDS-App-Configuration' SUP applicationSettings STRUCTURAL MAY (owner $ keywords $ managedBy $ msDS-ByteArray $ msDS-DateTime $ msDS-Integer $ msDS-ObjectReference ) )",
            "( 1.2.840.113556.1.3.23 NAME 'container' SUP top STRUCTURAL MUST (cn ) MAY (schemaVersion $ defaultClassStore $ msDS-ObjectReference ) )",
            "( 1.2.840.113556.1.6.13.4.10 NAME 'msDFSR-Connection' SUP top STRUCTURAL MUST (fromServer ) MAY (msDFSR-Extension $ msDFSR-Enabled $ msDFSR-Schedule $ msDFSR-Keywords $ msDFSR-Flags $ msDFSR-Options $ msDFSR-RdcEnabled $ msDFSR-RdcMinFileSizeInKb $ msDFSR-Priority $ msDFSR-DisablePacketPrivacy $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.207 NAME 'msWMI-UintRangeParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-IntDefault ) MAY (msWMI-IntMax $ msWMI-IntMin ) )",
            "( 1.2.840.113556.1.5.23 NAME 'printQueue' SUP connectionPoint STRUCTURAL MUST (uNCName $ versionNumber $ serverName $ printerName $ shortServerName ) MAY (location $ portName $ driverName $ printSeparatorFile $ priority $ defaultPriority $ printStartTime $ printEndTime $ printFormName $ printBinNames $ printMaxResolutionSupported $ printOrientationsSupported $ printMaxCopies $ printCollate $ printColor $ printLanguage $ printAttributes $ printShareName $ printOwner $ printNotify $ printStatus $ printSpooling $ printKeepPrintedJobs $ driverVersion $ printMaxXExtent $ printMaxYExtent $ printMinXExtent $ printMinYExtent $ printStaplingSupported $ printMemory $ assetNumber $ bytesPerMinute $ printRate $ printRateUnit $ printNetworkAddress $ printMACAddress $ printMediaReady $ printNumberUp $ printMediaSupported $ operatingSystem $ operatingSystemVersion $ operatingSystemServicePack $ operatingSystemHotfix $ physicalLocationObject $ printPagesPerMinute $ printDuplexSupported ) )",
            "( 1.2.840.113556.1.5.260 NAME 'msDFS-DeletedLinkv2' SUP top STRUCTURAL MUST (msDFS-NamespaceIdentityGUIDv2 $ msDFS-LastModifiedv2 $ msDFS-LinkPathv2 $ msDFS-LinkIdentityGUIDv2 ) MAY (msDFS-Commentv2 $ msDFS-ShortNameLinkPathv2 ) )",
            "( 1.2.840.113556.1.5.140 NAME 'interSiteTransportContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.130 NAME 'indexServerCatalog' SUP connectionPoint STRUCTURAL MUST (creator ) MAY (uNCName $ queryPoint $ indexedScopes $ friendlyNames ) )",
            "( 1.2.840.113556.1.5.98 NAME 'ipsecPolicy' SUP ipsecBase STRUCTURAL MAY (ipsecISAKMPReference $ ipsecNFAReference ) )",
            "( 2.5.6.0 NAME 'top'  ABSTRACT MUST (objectClass $ instanceType $ nTSecurityDescriptor $ objectCategory ) MAY (cn $ description $ distinguishedName $ whenCreated $ whenChanged $ subRefs $ displayName $ uSNCreated $ isDeleted $ dSASignature $ objectVersion $ repsTo $ repsFrom $ memberOf $ ownerBL $ uSNChanged $ uSNLastObjRem $ showInAdvancedViewOnly $ adminDisplayName $ proxyAddresses $ adminDescription $ extensionName $ uSNDSALastObjRemoved $ displayNamePrintable $ directReports $ wWWHomePage $ USNIntersite $ name $ objectGUID $ replPropertyMetaData $ replUpToDateVector $ flags $ revision $ wbemPath $ fSMORoleOwner $ systemFlags $ siteObjectBL $ serverReferenceBL $ nonSecurityMemberBL $ queryPolicyBL $ wellKnownObjects $ isPrivilegeHolder $ partialAttributeSet $ managedObjects $ partialAttributeDeletionList $ url $ lastKnownParent $ bridgeheadServerListBL $ netbootSCPBL $ isCriticalSystemObject $ frsComputerReferenceBL $ fRSMemberReferenceBL $ uSNSource $ fromEntry $ allowedChildClasses $ allowedChildClassesEffective $ allowedAttributes $ allowedAttributesEffective $ possibleInferiors $ canonicalName $ proxiedObjectName $ sDRightsEffective $ dSCorePropagationData $ otherWellKnownObjects $ mS-DS-ConsistencyGuid $ mS-DS-ConsistencyChildCount $ masteredBy $ msCOM-PartitionSetLink $ msCOM-UserLink $ msDS-Approx-Immed-Subordinates $ msDS-NCReplCursors $ msDS-NCReplInboundNeighbors $ msDS-NCReplOutboundNeighbors $ msDS-ReplAttributeMetaData $ msDS-ReplValueMetaData $ msDS-NonMembersBL $ msDS-MembersForAzRoleBL $ msDS-OperationsForAzTaskBL $ msDS-TasksForAzTaskBL $ msDS-OperationsForAzRoleBL $ msDS-TasksForAzRoleBL $ msDs-masteredBy $ msDS-ObjectReferenceBL $ msDS-PrincipalName $ msDS-RevealedDSAs $ msDS-KrbTgtLinkBl $ msDS-IsFullReplicaFor $ msDS-IsDomainFor $ msDS-IsPartialReplicaFor $ msDS-AuthenticatedToAccountlist $ msDS-NC-RO-Replica-Locations-BL $ msDS-RevealedListBL $ msDS-PSOApplied $ msDS-NcType $ msDS-OIDToGroupLinkBl $ msDS-HostServiceAccountBL $ isRecycled $ msDS-LocalEffectiveDeletionTime $ msDS-LocalEffectiveRecycleTime $ msDS-LastKnownRDN $ msDS-EnabledFeatureBL $ msDS-ClaimSharesPossibleValuesWithBL $ msDS-MembersOfResourcePropertyListBL $ msDS-IsPrimaryComputerFor $ msDS-ValueTypeReferenceBL $ msDS-TDOIngressBL $ msDS-TDOEgressBL $ msDS-parentdistname $ msDS-ReplValueMetaDataExt $ msds-memberOfTransitive $ msds-memberTransitive $ structuralObjectClass $ createTimeStamp $ modifyTimeStamp $ subSchemaSubEntry $ msSFU30PosixMemberOf $ msDFSR-MemberReferenceBL $ msDFSR-ComputerReferenceBL ) )",
            "( 1.2.840.113556.1.5.36 NAME 'volume' SUP connectionPoint STRUCTURAL MUST (uNCName ) MAY (contentIndexingAllowed $ lastContentIndexed ) )",
            "( 1.2.840.113556.1.5.236 NAME 'msDS-AzOperation' SUP top STRUCTURAL MUST (msDS-AzOperationID ) MAY (description $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 2.5.6.9 NAME 'groupOfNames' SUP top STRUCTURAL MUST (cn $ member ) MAY (o $ ou $ businessCategory $ owner $ seeAlso ) )",
            "( 1.2.840.113556.1.5.12 NAME 'configuration' SUP top STRUCTURAL MUST (cn ) MAY (gPLink $ gPOptions $ msDS-USNLastSyncSuccess ) )",
            "( 1.2.840.113556.1.5.78 NAME 'licensingSiteSettings' SUP applicationSiteSettings STRUCTURAL MAY (siteServer ) )",
            "( 1.2.840.113556.1.5.69 NAME 'nTDSSiteSettings' SUP applicationSiteSettings STRUCTURAL MAY (schedule $ options $ queryPolicyObject $ managedBy $ interSiteTopologyGenerator $ interSiteTopologyRenew $ interSiteTopologyFailover $ msDS-Preferred-GC-Site ) )",
            "( 1.2.840.113556.1.5.269 NAME 'msDS-ClaimTypePropertyBase' SUP top ABSTRACT MAY (Enabled $ msDS-ClaimPossibleValues $ msDS-ClaimSharesPossibleValuesWith ) )",
            "( 1.2.840.113556.1.5.273 NAME 'msDS-ResourceProperty' SUP msDS-ClaimTypePropertyBase STRUCTURAL MUST (msDS-ValueTypeReference ) MAY (msDS-IsUsedAsResourceSecurityAttribute $ msDS-AppliesToResourceTypes ) )",
            "( 1.2.840.113556.1.5.239 NAME 'msDS-AzRole' SUP top STRUCTURAL MAY (description $ msDS-MembersForAzRole $ msDS-OperationsForAzRole $ msDS-TasksForAzRole $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 1.3.6.1.1.1.2.12 NAME 'bootableDevice' SUP top AUXILIARY MAY (cn $ bootParameter $ bootFile ) )",
            "( 1.2.840.113556.1.5.294 NAME 'msDS-AuthNPolicy' SUP top STRUCTURAL MAY (msDS-UserAllowedToAuthenticateTo $ msDS-UserAllowedToAuthenticateFrom $ msDS-UserTGTLifetime $ msDS-ComputerAllowedToAuthenticateTo $ msDS-ComputerTGTLifetime $ msDS-ServiceAllowedToAuthenticateTo $ msDS-ServiceAllowedToAuthenticateFrom $ msDS-ServiceTGTLifetime $ msDS-UserAuthNPolicyBL $ msDS-ComputerAuthNPolicyBL $ msDS-ServiceAuthNPolicyBL $ msDS-AssignedAuthNPolicyBL $ msDS-AuthNPolicyEnforced ) )",
            "( 1.2.840.113556.1.5.86 NAME 'dnsNode' SUP top STRUCTURAL MUST (dc ) MAY (dnsRecord $ dNSProperty $ dNSTombstoned ) )",
            "( 1.2.840.113556.1.5.210 NAME 'msWMI-StringSetParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-StringDefault ) MAY (msWMI-StringValidValues ) )",
            "( 1.2.840.113556.1.5.264 NAME 'msDS-ManagedServiceAccount' SUP computer STRUCTURAL )",
            "( 1.2.840.113556.1.5.15 NAME 'contact' SUP organizationalPerson STRUCTURAL MUST (cn ) MAY (notes $ msDS-SourceObjectDN ) )",
            "( 1.3.6.1.1.1.2.0 NAME 'posixAccount' SUP top AUXILIARY MAY (cn $ description $ userPassword $ homeDirectory $ unixUserPassword $ uid $ uidNumber $ gidNumber $ gecos $ unixHomeDirectory $ loginShell ) )",
            "( 1.2.840.113556.1.5.266 NAME 'msSPP-ActivationObjectsContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.217 NAME 'msWMI-ObjectEncoding' SUP top STRUCTURAL MUST (msWMI-ID $ msWMI-TargetObject $ msWMI-Class $ msWMI-Genus $ msWMI-intFlags1 $ msWMI-intFlags2 $ msWMI-intFlags3 $ msWMI-intFlags4 $ msWMI-Parm1 $ msWMI-Parm2 $ msWMI-Parm3 $ msWMI-Parm4 $ msWMI-ScopeGuid ) )",
            "( 1.2.840.113556.1.5.33 NAME 'storage' SUP connectionPoint STRUCTURAL MAY (moniker $ monikerDisplayName $ iconPath ) )",
            "( 1.2.840.113556.1.5.67 NAME 'domainDNS' SUP domain STRUCTURAL MAY (managedBy $ msDS-Behavior-Version $ msDS-AllowedDNSSuffixes $ msDS-USNLastSyncSuccess $ msDS-EnabledFeature ) )",
            "( 1.2.840.113556.1.5.92 NAME 'linkTrackVolEntry' SUP leaf STRUCTURAL MAY (linkTrackSecret $ volTableIdxGUID $ volTableGUID $ currMachineId $ timeVolChange $ timeRefresh $ seqNotification $ objectCount ) )",
            "( 1.3.6.1.1.1.2.11 NAME 'ieee802Device' SUP top AUXILIARY MAY (cn $ macAddress ) )",
            "( 0.9.2342.19200300.100.4.17 NAME 'domainRelatedObject' SUP top AUXILIARY MAY (associatedDomain ) )",
            "( 1.2.840.113556.1.5.235 NAME 'msDS-AzApplication' SUP top STRUCTURAL MAY (description $ msDS-AzApplicationName $ msDS-AzGenerateAudits $ msDS-AzClassId $ msDS-AzApplicationVersion $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 1.2.840.113556.1.5.107 NAME 'sitesContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.263 NAME 'msImaging-PostScanProcess' SUP top STRUCTURAL MUST (displayName $ msImaging-PSPIdentifier ) MAY (serverName $ msImaging-PSPString ) )",
            "( 1.2.840.113556.1.5.240 NAME 'msieee80211-Policy' SUP top STRUCTURAL MAY (msieee80211-Data $ msieee80211-DataType $ msieee80211-ID ) )",
            "( 1.2.840.113556.1.5.95 NAME 'subnetContainer' SUP top STRUCTURAL )",
            "( 0.9.2342.19200300.100.4.6 NAME 'document' SUP top STRUCTURAL MAY (cn $ l $ o $ ou $ description $ seeAlso $ documentIdentifier $ documentTitle $ documentVersion $ documentAuthor $ documentLocation $ documentPublisher ) )",
            "( 2.5.6.6 NAME 'person' SUP top STRUCTURAL MUST (cn ) MAY (sn $ serialNumber $ telephoneNumber $ seeAlso $ userPassword $ attributeCertificateAttribute ) )",
            "( 1.2.840.113556.1.5.274 NAME 'msDS-ResourcePropertyList' SUP top STRUCTURAL MAY (msDS-MembersOfResourcePropertyList ) )",
            "( 1.2.840.113556.1.5.270 NAME 'msDS-ClaimTypes' SUP top STRUCTURAL )",
            "( 1.3.6.1.1.1.2.1 NAME 'shadowAccount' SUP top AUXILIARY MAY (description $ userPassword $ uid $ shadowLastChange $ shadowMin $ shadowMax $ shadowWarning $ shadowInactive $ shadowExpire $ shadowFlag ) )",
            "( 1.2.840.113556.1.5.179 NAME 'mSMQMigratedUser' SUP top STRUCTURAL MAY (objectSid $ mSMQSignCertificates $ mSMQDigests $ mSMQDigestsMig $ mSMQSignCertificatesMig $ mSMQUserSid ) )",
            "( 1.2.840.113556.1.5.185 NAME 'mS-SQL-OLAPServer' SUP serviceConnectionPoint STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-RegisteredOwner $ mS-SQL-Contact $ mS-SQL-Build $ mS-SQL-ServiceAccount $ mS-SQL-Status $ mS-SQL-InformationURL $ mS-SQL-PublicationURL $ mS-SQL-Version $ mS-SQL-Language $ mS-SQL-Keywords ) )",
            "( 1.3.6.1.4.1.1466.101.119.2 NAME 'dynamicObject' SUP top AUXILIARY MAY (msDS-Entry-Time-To-Die $ entryTTL ) )",
            "( 1.2.840.113556.1.5.155 NAME 'nTFRSSubscriber' SUP top STRUCTURAL MUST (fRSRootPath $ fRSStagingPath ) MAY (schedule $ fRSUpdateTimeout $ fRSFaultCondition $ fRSServiceCommand $ fRSExtensions $ fRSFlags $ fRSMemberReference $ fRSServiceCommandStatus $ fRSTimeLastCommand $ fRSTimeLastConfigChange ) )",
            "( 1.2.840.113556.1.5.129 NAME 'rIDSet' SUP top STRUCTURAL MUST (rIDAllocationPool $ rIDPreviousAllocationPool $ rIDUsedPool $ rIDNextRID ) )",
            "( 1.2.840.113556.1.3.58 NAME 'addressTemplate' SUP displayTemplate STRUCTURAL MUST (displayName ) MAY (addressSyntax $ perMsgDialogDisplayTable $ perRecipDialogDisplayTable $ addressType $ proxyGenerationEnabled ) )",
            "( 1.2.840.113556.1.5.154 NAME 'nTFRSSubscriptions' SUP top STRUCTURAL MAY (fRSWorkingPath $ fRSExtensions $ fRSVersion ) )",
            "( 1.2.840.113556.1.5.7000.47 NAME 'nTDSDSA' SUP applicationSettings STRUCTURAL MAY (hasMasterNCs $ hasPartialReplicaNCs $ dMDLocation $ invocationId $ networkAddress $ options $ fRSRootPath $ serverReference $ lastBackupRestorationTime $ queryPolicyObject $ managedBy $ retiredReplDSASignatures $ msDS-Behavior-Version $ msDS-HasInstantiatedNCs $ msDS-ReplicationEpoch $ msDS-HasDomainNCs $ msDS-RetiredReplNCSignatures $ msDS-hasMasterNCs $ msDS-RevealedUsers $ msDS-hasFullReplicaNCs $ msDS-NeverRevealGroup $ msDS-RevealOnDemandGroup $ msDS-isGC $ msDS-isRODC $ msDS-SiteName $ msDS-IsUserCachableAtRodc $ msDS-EnabledFeature ) )",
            "( 1.2.840.113556.1.5.175 NAME 'infrastructureUpdate' SUP top STRUCTURAL MAY (dNReferenceUpdate ) )",
            "( 1.2.840.113556.1.6.18.2.215 NAME 'msSFU30DomainInfo' SUP top STRUCTURAL MAY (msSFU30SearchContainer $ msSFU30MasterServerName $ msSFU30OrderNumber $ msSFU30Domains $ msSFU30YpServers $ msSFU30MaxGidNumber $ msSFU30MaxUidNumber $ msSFU30IsValidContainer $ msSFU30CryptMethod ) )",
            "( 1.2.840.113556.1.5.213 NAME 'msWMI-Som' SUP top STRUCTURAL MUST (msWMI-ID $ msWMI-Name ) MAY (msWMI-Author $ msWMI-ChangeDate $ msWMI-CreationDate $ msWMI-SourceOrganization $ msWMI-intFlags1 $ msWMI-intFlags2 $ msWMI-intFlags3 $ msWMI-intFlags4 $ msWMI-Parm1 $ msWMI-Parm2 $ msWMI-Parm3 $ msWMI-Parm4 ) )",
            "( 1.2.840.113556.1.5.82 NAME 'rpcProfile' SUP rpcEntry STRUCTURAL )",
            "( 1.2.840.113556.1.5.164 NAME 'mSMQSiteLink' SUP top STRUCTURAL MUST (mSMQSite1 $ mSMQSite2 $ mSMQCost ) MAY (mSMQSiteGates $ mSMQSiteGatesMig ) )",
            "( 1.2.840.113556.1.5.184 NAME 'mS-SQL-SQLServer' SUP serviceConnectionPoint STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-RegisteredOwner $ mS-SQL-Contact $ mS-SQL-Location $ mS-SQL-Memory $ mS-SQL-Build $ mS-SQL-ServiceAccount $ mS-SQL-CharacterSet $ mS-SQL-SortOrder $ mS-SQL-UnicodeSortOrder $ mS-SQL-Clustered $ mS-SQL-NamedPipe $ mS-SQL-MultiProtocol $ mS-SQL-SPX $ mS-SQL-TCPIP $ mS-SQL-AppleTalk $ mS-SQL-Vines $ mS-SQL-Status $ mS-SQL-LastUpdatedDate $ mS-SQL-InformationURL $ mS-SQL-GPSLatitude $ mS-SQL-GPSLongitude $ mS-SQL-GPSHeight $ mS-SQL-Keywords ) )",
            "( 1.2.840.113556.1.5.106 NAME 'queryPolicy' SUP top STRUCTURAL MAY (lDAPAdminLimits $ lDAPIPDenyList ) )",
            "( 1.2.840.113556.1.5.162 NAME 'mSMQConfiguration' SUP top STRUCTURAL MAY (mSMQQuota $ mSMQJournalQuota $ mSMQOwnerID $ mSMQSites $ mSMQOutRoutingServers $ mSMQInRoutingServers $ mSMQServiceType $ mSMQComputerType $ mSMQForeign $ mSMQOSType $ mSMQEncryptKey $ mSMQSignKey $ mSMQDependentClientServices $ mSMQRoutingServices $ mSMQDsServices $ mSMQComputerTypeEx ) )",
            "( 1.2.840.113556.1.5.257 NAME 'msDFS-NamespaceAnchor' SUP top STRUCTURAL MUST (msDFS-SchemaMajorVersion ) )",
            "( 1.2.840.113556.1.6.13.4.7 NAME 'msDFSR-ContentSet' SUP top STRUCTURAL MAY (description $ msDFSR-Extension $ msDFSR-RootSizeInMb $ msDFSR-StagingSizeInMb $ msDFSR-ConflictSizeInMb $ msDFSR-FileFilter $ msDFSR-DirectoryFilter $ msDFSR-Flags $ msDFSR-Options $ msDFSR-DfsPath $ msDFSR-Priority $ msDFSR-DeletedSizeInMb $ msDFSR-DefaultCompressionExclusionFilter $ msDFSR-OnDemandExclusionFileFilter $ msDFSR-OnDemandExclusionDirectoryFilter $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.276 NAME 'msTPM-InformationObjectsContainer' SUP top STRUCTURAL MUST (cn ) )",
            "( 1.2.840.113556.1.5.209 NAME 'msWMI-RealRangeParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-Int8Default ) MAY (msWMI-Int8Max $ msWMI-Int8Min ) )",
            "( 2.5.6.7 NAME 'organizationalPerson' SUP person STRUCTURAL MAY (c $ l $ st $ street $ o $ ou $ title $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod $ givenName $ initials $ generationQualifier $ houseIdentifier $ otherTelephone $ otherPager $ co $ department $ company $ streetAddress $ otherHomePhone $ msExchHouseIdentifier $ personalTitle $ homePostalAddress $ countryCode $ employeeID $ comment $ division $ otherFacsimileTelephoneNumber $ otherMobile $ primaryTelexNumber $ primaryInternationalISDNNumber $ mhsORAddress $ otherMailbox $ assistant $ ipPhone $ otherIpPhone $ msDS-AllowedToDelegateTo $ msDS-PhoneticFirstName $ msDS-PhoneticLastName $ msDS-PhoneticDepartment $ msDS-PhoneticCompanyName $ msDS-PhoneticDisplayName $ msDS-HABSeniorityIndex $ msDS-AllowedToActOnBehalfOfOtherIdentity $ mail $ manager $ homePhone $ mobile $ pager $ middleName $ thumbnailPhoto $ thumbnailLogo ) )",
            "( 1.2.840.113556.1.5.176 NAME 'msExchConfigurationContainer' SUP container STRUCTURAL MAY (addressBookRoots $ globalAddressList $ templateRoots $ addressBookRoots2 $ globalAddressList2 $ templateRoots2 ) )",
            "( 1.2.840.113556.1.5.278 NAME 'msKds-ProvRootKey' SUP top STRUCTURAL MUST (cn $ msKds-KDFAlgorithmID $ msKds-SecretAgreementAlgorithmID $ msKds-PublicKeyLength $ msKds-PrivateKeyLength $ msKds-RootKeyData $ msKds-Version $ msKds-DomainID $ msKds-UseStartTime $ msKds-CreateTime ) MAY (msKds-KDFParam $ msKds-SecretAgreementParam ) )",
            "( 1.2.840.113556.1.5.238 NAME 'msDS-AzTask' SUP top STRUCTURAL MAY (description $ msDS-AzBizRule $ msDS-AzBizRuleLanguage $ msDS-AzLastImportedBizRulePath $ msDS-OperationsForAzTask $ msDS-TasksForAzTask $ msDS-AzTaskIsRoleDefinition $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 1.2.840.113556.1.5.282 NAME 'msDS-GroupManagedServiceAccount' SUP computer STRUCTURAL MUST (msDS-ManagedPasswordInterval ) MAY (msDS-ManagedPassword $ msDS-ManagedPasswordId $ msDS-ManagedPasswordPreviousId $ msDS-GroupMSAMembership ) )",
            "( 1.3.6.1.1.1.2.9 NAME 'nisMap' SUP top STRUCTURAL MUST (cn $ nisMapName ) MAY (description ) )",
            "( 1.3.6.1.1.1.2.10 NAME 'nisObject' SUP top STRUCTURAL MUST (cn $ nisMapName $ nisMapEntry ) MAY (description $ msSFU30Name $ msSFU30NisDomain ) )",
            "( 1.2.840.113556.1.5.277 NAME 'msKds-ProvServerConfiguration' SUP top STRUCTURAL MUST (msKds-Version ) MAY (msKds-KDFAlgorithmID $ msKds-KDFParam $ msKds-SecretAgreementAlgorithmID $ msKds-SecretAgreementParam $ msKds-PublicKeyLength $ msKds-PrivateKeyLength ) )",
            "( 1.2.840.113556.1.6.18.2.217 NAME 'msSFU30NISMapConfig' SUP top STRUCTURAL MAY (msSFU30KeyAttributes $ msSFU30FieldSeparator $ msSFU30IntraFieldSeparator $ msSFU30SearchAttributes $ msSFU30ResultAttributes $ msSFU30MapFilter $ msSFU30NSMAPFieldPosition ) )",
            "( 1.2.840.113556.1.5.7000.48 NAME 'serversContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.90 NAME 'linkTrackVolumeTable' SUP fileLinkTracking STRUCTURAL )",
            "( 1.2.840.113556.1.5.188 NAME 'mS-SQL-SQLDatabase' SUP top STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-Contact $ mS-SQL-Status $ mS-SQL-InformationURL $ mS-SQL-Description $ mS-SQL-Alias $ mS-SQL-Size $ mS-SQL-CreationDate $ mS-SQL-LastBackupDate $ mS-SQL-LastDiagnosticDate $ mS-SQL-Applications $ mS-SQL-Keywords ) )",
            "( 1.2.840.113556.1.5.211 NAME 'msWMI-PolicyType' SUP top STRUCTURAL MUST (msWMI-ID $ msWMI-TargetObject ) MAY (msWMI-Author $ msWMI-ChangeDate $ msWMI-CreationDate $ msWMI-SourceOrganization $ msWMI-intFlags1 $ msWMI-intFlags2 $ msWMI-intFlags3 $ msWMI-intFlags4 $ msWMI-Parm1 $ msWMI-Parm2 $ msWMI-Parm3 $ msWMI-Parm4 ) )",
            "( 1.2.840.113556.1.5.183 NAME 'dSUISettings' SUP top STRUCTURAL MAY (dSUIAdminNotification $ dSUIAdminMaximum $ dSUIShellMaximum $ msDS-Security-Group-Extra-Classes $ msDS-Non-Security-Group-Extra-Classes $ msDS-FilterContainers ) )",
            "( 1.2.840.113556.1.5.157 NAME 'groupPolicyContainer' SUP container STRUCTURAL MAY (flags $ versionNumber $ gPCFunctionalityVersion $ gPCFileSysPath $ gPCMachineExtensionNames $ gPCUserExtensionNames $ gPCWQLFilter ) )",
            "( 1.2.840.113556.1.5.3 NAME 'samDomain' SUP top AUXILIARY MAY (description $ cACertificate $ builtinCreationTime $ builtinModifiedCount $ creationTime $ domainPolicyObject $ defaultLocalPolicyObject $ lockoutDuration $ lockOutObservationWindow $ lSACreationTime $ lSAModifiedCount $ lockoutThreshold $ maxPwdAge $ minPwdAge $ minPwdLength $ modifiedCountAtLastProm $ nETBIOSName $ nextRid $ pwdProperties $ pwdHistoryLength $ privateKey $ replicaSource $ controlAccessRights $ auditingPolicy $ eFSPolicy $ desktopProfile $ nTMixedDomain $ rIDManagerReference $ treeName $ pekList $ pekKeyChangeInterval $ gPLink $ gPOptions $ ms-DS-MachineAccountQuota $ msDS-LogonTimeSyncInterval $ msDS-PerUserTrustQuota $ msDS-AllUsersTrustQuota $ msDS-PerUserTrustTombstonesQuota ) )",
            "( 1.2.840.113556.1.5.234 NAME 'msDS-AzAdminManager' SUP top STRUCTURAL MAY (description $ msDS-AzDomainTimeout $ msDS-AzScriptEngineCacheMax $ msDS-AzScriptTimeout $ msDS-AzGenerateAudits $ msDS-AzApplicationData $ msDS-AzMajorVersion $ msDS-AzMinorVersion $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 1.2.840.113556.1.5.214 NAME 'msWMI-Rule' SUP top STRUCTURAL MUST (msWMI-Query $ msWMI-QueryLanguage $ msWMI-TargetNameSpace ) )",
            "( 1.2.840.113556.1.5.254 NAME 'nTDSDSARO' SUP nTDSDSA STRUCTURAL )",
            "( 1.2.840.113556.1.5.286 NAME 'msDS-Device' SUP top STRUCTURAL MUST (displayName $ altSecurityIdentities $ msDS-IsEnabled $ msDS-DeviceID ) MAY (msDS-DeviceOSType $ msDS-DeviceOSVersion $ msDS-DevicePhysicalIDs $ msDS-DeviceObjectVersion $ msDS-RegisteredOwner $ msDS-ApproximateLastLogonTimeStamp $ msDS-RegisteredUsers $ msDS-IsManaged $ msDS-CloudIsManaged $ msDS-CloudAnchor ) )",
            "( 1.2.840.113556.1.5.34 NAME 'trustedDomain' SUP leaf STRUCTURAL MAY (securityIdentifier $ trustAuthIncoming $ trustDirection $ trustPartner $ trustPosixOffset $ trustAuthOutgoing $ trustType $ trustAttributes $ domainCrossRef $ flatName $ initialAuthIncoming $ initialAuthOutgoing $ domainIdentifier $ additionalTrustedServiceNames $ mS-DS-CreatorSID $ msDS-TrustForestTrustInfo $ msDS-SupportedEncryptionTypes $ msDS-IngressClaimsTransformationPolicy $ msDS-EgressClaimsTransformationPolicy ) )",
            "( 0.9.2342.19200300.100.4.7 NAME 'room' SUP top STRUCTURAL MUST (cn ) MAY (description $ telephoneNumber $ seeAlso $ location $ roomNumber ) )",
            "( 2.5.6.4 NAME 'organization' SUP top STRUCTURAL MUST (o ) MAY (l $ st $ street $ searchGuide $ businessCategory $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telephoneNumber $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod $ seeAlso $ userPassword ) )",
            "( 1.2.840.113556.1.5.272 NAME 'msDS-ClaimType' SUP msDS-ClaimTypePropertyBase STRUCTURAL MAY (msDS-ClaimValueType $ msDS-ClaimAttributeSource $ msDS-ClaimTypeAppliesToClass $ msDS-ClaimSource $ msDS-ClaimSourceType $ msDS-ClaimIsValueSpaceRestricted $ msDS-ClaimIsSingleValued ) )",
            "( 1.3.6.1.1.1.2.3 NAME 'ipService' SUP top STRUCTURAL MUST (cn $ ipServicePort $ ipServiceProtocol ) MAY (description $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.3.6.1.1.1.2.4 NAME 'ipProtocol' SUP top STRUCTURAL MUST (cn $ ipProtocolNumber ) MAY (description $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.2.840.113556.1.5.80 NAME 'rpcGroup' SUP rpcEntry STRUCTURAL MAY (rpcNsGroup $ rpcNsObjectID ) )",
            "( 1.2.840.113556.1.5.17 NAME 'server' SUP top STRUCTURAL MAY (serialNumber $ serverReference $ dNSHostName $ managedBy $ mailAddress $ bridgeheadTransportList $ msDS-isGC $ msDS-isRODC $ msDS-SiteName $ msDS-IsUserCachableAtRodc ) )",
            "( 1.2.840.113556.1.5.28 NAME 'secret' SUP leaf STRUCTURAL MAY (currentValue $ lastSetTime $ priorSetTime $ priorValue ) )",
            "( 1.2.840.113556.1.5.163 NAME 'mSMQEnterpriseSettings' SUP top STRUCTURAL MAY (mSMQNameStyle $ mSMQCSPName $ mSMQLongLived $ mSMQVersion $ mSMQInterval1 $ mSMQInterval2 ) )",
            "( 1.2.840.113556.1.5.202 NAME 'msWMI-MergeablePolicyTemplate' SUP msWMI-PolicyTemplate STRUCTURAL )",
            "( 1.2.840.113556.1.5.195 NAME 'msPKI-Key-Recovery-Agent' SUP user STRUCTURAL )",
            "( 0.9.2342.19200300.100.4.18 NAME 'friendlyCountry' SUP country STRUCTURAL MUST (co ) )",
            "( 1.2.840.113556.1.5.258 NAME 'msDFS-Namespacev2' SUP top STRUCTURAL MUST (msDFS-SchemaMajorVersion $ msDFS-SchemaMinorVersion $ msDFS-GenerationGUIDv2 $ msDFS-NamespaceIdentityGUIDv2 $ msDFS-LastModifiedv2 $ msDFS-Ttlv2 $ msDFS-Propertiesv2 $ msDFS-TargetListv2 ) MAY (msDFS-Commentv2 ) )",
            "( 1.2.840.113556.1.5.96 NAME 'subnet' SUP top STRUCTURAL MAY (location $ siteObject $ physicalLocationObject ) )",
            "( 1.2.840.113556.1.5.216 NAME 'applicationVersion' SUP applicationSettings STRUCTURAL MAY (owner $ keywords $ versionNumber $ vendor $ versionNumberHi $ versionNumberLo $ managedBy $ appSchemaVersion ) )",
            "( 2.5.6.10 NAME 'residentialPerson' SUP person STRUCTURAL MAY (l $ st $ street $ ou $ title $ businessCategory $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod ) )",
            "( 2.5.6.19 NAME 'cRLDistributionPoint' SUP top STRUCTURAL MUST (cn ) MAY (authorityRevocationList $ certificateRevocationList $ deltaRevocationList $ cRLPartitionedRevocationList $ certificateAuthorityObject ) )",
            "( 1.2.840.113556.1.5.137 NAME 'aCSPolicy' SUP top STRUCTURAL MAY (aCSTimeOfDay $ aCSDirection $ aCSMaxTokenRatePerFlow $ aCSMaxPeakBandwidthPerFlow $ aCSAggregateTokenRatePerUser $ aCSMaxDurationPerFlow $ aCSServiceType $ aCSTotalNoOfFlows $ aCSPriority $ aCSPermissionBits $ aCSIdentityName $ aCSMaxAggregatePeakRatePerUser $ aCSMaxTokenBucketPerFlow $ aCSMaximumSDUSize $ aCSMinimumPolicedSize $ aCSMinimumLatency $ aCSMinimumDelayVariation ) )",
            "( 1.2.840.113556.1.5.77 NAME 'controlAccessRight' SUP top STRUCTURAL MAY (rightsGuid $ appliesTo $ localizationDisplayId $ validAccesses ) )",
            "( 1.2.840.113556.1.5.219 NAME 'msMQ-Group' SUP top STRUCTURAL MUST (member ) )",
            "( 1.2.840.113556.1.5.8 NAME 'group' SUP top STRUCTURAL MUST (groupType ) MAY (member $ nTGroupMembers $ operatorCount $ adminCount $ groupAttributes $ groupMembershipSAM $ controlAccessRights $ desktopProfile $ nonSecurityMember $ managedBy $ primaryGroupToken $ msDS-AzLDAPQuery $ msDS-NonMembers $ msDS-AzBizRule $ msDS-AzBizRuleLanguage $ msDS-AzLastImportedBizRulePath $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData $ msDS-PrimaryComputer $ mail $ msSFU30Name $ msSFU30NisDomain $ msSFU30PosixMember ) )",
            "( 1.2.840.113556.1.6.23.2 NAME 'msPrint-ConnectionPolicy' SUP top STRUCTURAL MUST (cn ) MAY (uNCName $ serverName $ printAttributes $ printerName ) )",
            "( 1.2.840.113556.1.3.11 NAME 'crossRef' SUP top STRUCTURAL MUST (cn $ nCName $ dnsRoot ) MAY (Enabled $ nETBIOSName $ nTMixedDomain $ trustParent $ superiorDNSRoot $ rootTrust $ msDS-Behavior-Version $ msDS-NC-Replica-Locations $ msDS-Replication-Notify-First-DSA-Delay $ msDS-Replication-Notify-Subsequent-DSA-Delay $ msDS-SDReferenceDomain $ msDS-DnsRootAlias $ msDS-NC-RO-Replica-Locations ) )",
            "( 1.2.840.113556.1.6.13.4.9 NAME 'msDFSR-Member' SUP top STRUCTURAL MUST (msDFSR-ComputerReference ) MAY (serverReference $ msDFSR-Extension $ msDFSR-Keywords $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.3.59 NAME 'displayTemplate' SUP top STRUCTURAL MUST (cn ) MAY (helpData32 $ originalDisplayTableMSDOS $ addressEntryDisplayTable $ helpFileName $ addressEntryDisplayTableMSDOS $ helpData16 $ originalDisplayTable ) )",
            "( 1.2.840.113556.1.3.13 NAME 'classSchema' SUP top STRUCTURAL MUST (cn $ subClassOf $ governsID $ objectClassCategory $ schemaIDGUID $ defaultObjectCategory ) MAY (possSuperiors $ mustContain $ mayContain $ rDNAttID $ auxiliaryClass $ lDAPDisplayName $ schemaFlagsEx $ systemOnly $ systemPossSuperiors $ systemMayContain $ systemMustContain $ systemAuxiliaryClass $ defaultSecurityDescriptor $ defaultHidingValue $ classDisplayName $ isDefunct $ msDs-Schema-Extensions $ msDS-IntId ) )",
            "( 1.2.840.113556.1.5.200 NAME 'msWMI-PolicyTemplate' SUP top STRUCTURAL MUST (msWMI-ID $ msWMI-Name $ msWMI-NormalizedClass $ msWMI-TargetClass $ msWMI-TargetNameSpace $ msWMI-TargetPath ) MAY (msWMI-Author $ msWMI-ChangeDate $ msWMI-CreationDate $ msWMI-SourceOrganization $ msWMI-TargetType $ msWMI-intFlags1 $ msWMI-intFlags2 $ msWMI-intFlags3 $ msWMI-intFlags4 $ msWMI-Parm1 $ msWMI-Parm2 $ msWMI-Parm3 $ msWMI-Parm4 ) )",
            "( 1.2.840.113556.1.5.165 NAME 'mSMQSettings' SUP top STRUCTURAL MAY (mSMQOwnerID $ mSMQServices $ mSMQQMID $ mSMQMigrated $ mSMQNt4Flags $ mSMQSiteName $ mSMQRoutingService $ mSMQDsService $ mSMQDependentClientService $ mSMQSiteNameEx ) )",
            "( 1.3.6.1.1.1.2.5 NAME 'oncRpc' SUP top STRUCTURAL MUST (cn $ oncRpcNumber ) MAY (description $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.2.840.113556.1.5.126 NAME 'serviceConnectionPoint' SUP connectionPoint STRUCTURAL MAY (versionNumber $ vendor $ versionNumberHi $ versionNumberLo $ serviceClassName $ serviceBindingInformation $ serviceDNSName $ serviceDNSNameType $ appSchemaVersion ) )",
            "( 1.2.840.113556.1.5.4 NAME 'builtinDomain' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.241 NAME 'msDS-AppData' SUP applicationSettings STRUCTURAL MAY (owner $ keywords $ managedBy $ msDS-ByteArray $ msDS-DateTime $ msDS-Integer $ msDS-ObjectReference ) )",
            "( 1.2.840.113556.1.5.73 NAME 'rpcServerElement' SUP rpcEntry STRUCTURAL MUST (rpcNsBindings $ rpcNsInterfaceID $ rpcNsTransferSyntax ) )",
            "( 1.2.840.113556.1.5.150 NAME 'rRASAdministrationConnectionPoint' SUP serviceAdministrationPoint STRUCTURAL MAY (msRRASAttribute ) )",
            "( 1.2.840.113556.1.5.191 NAME 'aCSResourceLimits' SUP top STRUCTURAL MAY (aCSMaxTokenRatePerFlow $ aCSMaxPeakBandwidthPerFlow $ aCSServiceType $ aCSAllocableRSVPBandwidth $ aCSMaxPeakBandwidth ) )",
            "( 2.5.6.3 NAME 'locality' SUP top STRUCTURAL MUST (l ) MAY (st $ street $ searchGuide $ seeAlso ) )",
            "( 1.3.6.1.1.1.2.6 NAME 'ipHost' SUP top AUXILIARY MAY (cn $ l $ description $ uid $ manager $ ipHostNumber ) )",
            "( 1.2.840.113556.1.5.275 NAME 'msTPM-InformationObject' SUP top STRUCTURAL MUST (msTPM-OwnerInformation ) MAY (msTPM-SrkPubThumbprint $ msTPM-OwnerInformationTemp ) )",
            "( 1.2.840.113556.1.5.289 NAME 'msDS-DeviceContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.4.2129 NAME 'msDNS-ServerSettings' SUP top STRUCTURAL MAY (msDNS-KeymasterZones ) )",
            "( 1.2.840.113556.1.5.76 NAME 'foreignSecurityPrincipal' SUP top STRUCTURAL MUST (objectSid ) MAY (foreignIdentifier ) )",
            "( 1.2.840.113556.1.5.44 NAME 'classStore' SUP top STRUCTURAL MAY (versionNumber $ nextLevelStore $ lastUpdateSequence $ appSchemaVersion ) )",
            "( 0.9.2342.19200300.100.4.5 NAME 'account' SUP top STRUCTURAL MAY (l $ o $ ou $ description $ seeAlso $ uid $ host ) )",
            "( 1.2.840.113556.1.5.26 NAME 'rpcProfileElement' SUP rpcEntry STRUCTURAL MUST (rpcNsInterfaceID $ rpcNsPriority ) MAY (rpcNsProfileEntry $ rpcNsAnnotation ) )",
            "( 1.2.840.113556.1.5.215 NAME 'msWMI-WMIGPO' SUP top STRUCTURAL MUST (msWMI-TargetClass ) MAY (msWMI-intFlags1 $ msWMI-intFlags2 $ msWMI-intFlags3 $ msWMI-intFlags4 $ msWMI-Parm1 $ msWMI-Parm2 $ msWMI-Parm3 $ msWMI-Parm4 ) )",
            "( 1.2.840.113556.1.5.243 NAME 'msDS-QuotaControl' SUP top STRUCTURAL MUST (cn $ msDS-QuotaTrustee $ msDS-QuotaAmount ) )",
            "( 1.2.840.113556.1.5.256 NAME 'msDS-PasswordSettingsContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.187 NAME 'mS-SQL-SQLPublication' SUP top STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-Status $ mS-SQL-Description $ mS-SQL-Type $ mS-SQL-Database $ mS-SQL-AllowAnonymousSubscription $ mS-SQL-Publisher $ mS-SQL-AllowKnownPullSubscription $ mS-SQL-AllowImmediateUpdatingSubscription $ mS-SQL-AllowQueuedUpdatingSubscription $ mS-SQL-AllowSnapshotFilesFTPDownloading $ mS-SQL-ThirdParty ) )",
            "( 1.2.840.113556.1.5.9 NAME 'user' SUP organizationalPerson STRUCTURAL MAY (o $ businessCategory $ userCertificate $ givenName $ initials $ x500uniqueIdentifier $ displayName $ networkAddress $ employeeNumber $ employeeType $ homePostalAddress $ userAccountControl $ badPwdCount $ codePage $ homeDirectory $ homeDrive $ badPasswordTime $ lastLogoff $ lastLogon $ dBCSPwd $ localeID $ scriptPath $ logonHours $ logonWorkstation $ maxStorage $ userWorkstations $ unicodePwd $ otherLoginWorkstations $ ntPwdHistory $ pwdLastSet $ preferredOU $ primaryGroupID $ userParameters $ profilePath $ operatorCount $ adminCount $ accountExpires $ lmPwdHistory $ groupMembershipSAM $ logonCount $ controlAccessRights $ defaultClassStore $ groupsToIgnore $ groupPriority $ desktopProfile $ dynamicLDAPServer $ userPrincipalName $ lockoutTime $ userSharedFolder $ userSharedFolderOther $ servicePrincipalName $ aCSPolicyName $ terminalServer $ mSMQSignCertificates $ mSMQDigests $ mSMQDigestsMig $ mSMQSignCertificatesMig $ msNPAllowDialin $ msNPCallingStationID $ msNPSavedCallingStationID $ msRADIUSCallbackNumber $ msRADIUSFramedIPAddress $ msRADIUSFramedRoute $ msRADIUSServiceType $ msRASSavedCallbackNumber $ msRASSavedFramedIPAddress $ msRASSavedFramedRoute $ mS-DS-CreatorSID $ msCOM-UserPartitionSetLink $ msDS-Cached-Membership $ msDS-Cached-Membership-Time-Stamp $ msDS-Site-Affinity $ msDS-User-Account-Control-Computed $ lastLogonTimestamp $ msIIS-FTPRoot $ msIIS-FTPDir $ msDRM-IdentityCertificate $ msDS-SourceObjectDN $ msPKIRoamingTimeStamp $ msPKIDPAPIMasterKeys $ msPKIAccountCredentials $ msRADIUS-FramedInterfaceId $ msRADIUS-SavedFramedInterfaceId $ msRADIUS-FramedIpv6Prefix $ msRADIUS-SavedFramedIpv6Prefix $ msRADIUS-FramedIpv6Route $ msRADIUS-SavedFramedIpv6Route $ msDS-SecondaryKrbTgtNumber $ msDS-AuthenticatedAtDC $ msDS-SupportedEncryptionTypes $ msDS-LastSuccessfulInteractiveLogonTime $ msDS-LastFailedInteractiveLogonTime $ msDS-FailedInteractiveLogonCount $ msDS-FailedInteractiveLogonCountAtLastSuccessfulLogon $ msTSProfilePath $ msTSHomeDirectory $ msTSHomeDrive $ msTSAllowLogon $ msTSRemoteControl $ msTSMaxDisconnectionTime $ msTSMaxConnectionTime $ msTSMaxIdleTime $ msTSReconnectionAction $ msTSBrokenConnectionAction $ msTSConnectClientDrives $ msTSConnectPrinterDrives $ msTSDefaultToMainPrinter $ msTSWorkDirectory $ msTSInitialProgram $ msTSProperty01 $ msTSProperty02 $ msTSExpireDate $ msTSLicenseVersion $ msTSManagingLS $ msDS-UserPasswordExpiryTimeComputed $ msTSExpireDate2 $ msTSLicenseVersion2 $ msTSManagingLS2 $ msTSExpireDate3 $ msTSLicenseVersion3 $ msTSManagingLS3 $ msTSExpireDate4 $ msTSLicenseVersion4 $ msTSManagingLS4 $ msTSLSProperty01 $ msTSLSProperty02 $ msDS-ResultantPSO $ msPKI-CredentialRoamingTokens $ msTSPrimaryDesktop $ msTSSecondaryDesktops $ msDS-PrimaryComputer $ msDS-SyncServerUrl $ msDS-AssignedAuthNPolicySilo $ msDS-AuthNPolicySiloMembersBL $ msDS-AssignedAuthNPolicy $ userSMIMECertificate $ uid $ mail $ roomNumber $ photo $ manager $ homePhone $ secretary $ mobile $ pager $ audio $ jpegPhoto $ carLicense $ departmentNumber $ preferredLanguage $ userPKCS12 $ labeledURI $ msSFU30Name $ msSFU30NisDomain ) )",
            "( 1.2.840.113556.1.5.259 NAME 'msDFS-Linkv2' SUP top STRUCTURAL MUST (msDFS-GenerationGUIDv2 $ msDFS-NamespaceIdentityGUIDv2 $ msDFS-LastModifiedv2 $ msDFS-Ttlv2 $ msDFS-Propertiesv2 $ msDFS-TargetListv2 $ msDFS-LinkPathv2 $ msDFS-LinkIdentityGUIDv2 ) MAY (msDFS-Commentv2 $ msDFS-LinkSecurityDescriptorv2 $ msDFS-ShortNameLinkPathv2 ) )",
            "( 1.2.840.113556.1.5.141 NAME 'interSiteTransport' SUP top STRUCTURAL MUST (transportDLLName $ transportAddressAttribute ) MAY (options $ replInterval ) )",
            "( 1.2.840.113556.1.6.13.4.4 NAME 'msDFSR-GlobalSettings' SUP top STRUCTURAL MAY (msDFSR-Extension $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.29 NAME 'serviceClass' SUP leaf STRUCTURAL MUST (displayName $ serviceClassID ) MAY (serviceClassInfo ) )",
            "( 1.2.840.113556.1.5.189 NAME 'mS-SQL-OLAPDatabase' SUP top STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-Contact $ mS-SQL-Status $ mS-SQL-LastUpdatedDate $ mS-SQL-InformationURL $ mS-SQL-ConnectionURL $ mS-SQL-PublicationURL $ mS-SQL-Description $ mS-SQL-Type $ mS-SQL-Size $ mS-SQL-LastBackupDate $ mS-SQL-Applications $ mS-SQL-Keywords ) )",
            "( 2.5.6.16 NAME 'certificationAuthority' SUP top STRUCTURAL MUST (cn $ cACertificate $ authorityRevocationList $ certificateRevocationList ) MAY (searchGuide $ teletexTerminalIdentifier $ supportedApplicationContext $ crossCertificatePair $ deltaRevocationList $ domainPolicyObject $ parentCA $ dNSHostName $ parentCACertificateChain $ domainID $ cAConnect $ cAWEBURL $ cRLObject $ cAUsages $ previousCACertificates $ pendingCACertificates $ previousParentCA $ pendingParentCA $ currentParentCA $ cACertificateDN $ certificateTemplates $ signatureAlgorithms $ enrollmentProviders ) )",
            "( 1.2.840.113556.1.5.104 NAME 'meeting' SUP top STRUCTURAL MUST (meetingName ) MAY (meetingID $ meetingDescription $ meetingKeyword $ meetingLocation $ meetingProtocol $ meetingType $ meetingApplication $ meetingLanguage $ meetingMaxParticipants $ meetingOriginator $ meetingContactInfo $ meetingOwner $ meetingIP $ meetingScope $ meetingAdvertiseScope $ meetingURL $ meetingRating $ meetingIsEncrypted $ meetingRecurrence $ meetingStartTime $ meetingEndTime $ meetingBandwidth $ meetingBlob ) )",
            "( 1.2.840.113556.1.5.287 NAME 'msDS-DeviceRegistrationServiceContainer' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.71 NAME 'nTDSConnection' SUP leaf STRUCTURAL MUST (enabledConnection $ fromServer $ options ) MAY (generatedConnection $ schedule $ transportType $ mS-DS-ReplicatesNCReason ) )",
            "( 1.2.840.113556.1.5.291 NAME 'msDS-AuthNPolicySilos' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.218 NAME 'msMQ-Custom-Recipient' SUP top STRUCTURAL MAY (msMQ-Recipient-FormatName ) )",
            "( 1.2.840.113556.1.5.72 NAME 'nTDSService' SUP top STRUCTURAL MAY (tombstoneLifetime $ dSHeuristics $ garbageCollPeriod $ replTopologyStayOfExecution $ sPNMappings $ msDS-Other-Settings $ msDS-DeletedObjectLifetime ) )",
            "( 1.2.840.113556.1.3.9 NAME 'dMD' SUP top STRUCTURAL MUST (cn ) MAY (dmdName $ schemaUpdate $ prefixMap $ schemaInfo $ msDs-Schema-Extensions $ msDS-IntId $ msDS-USNLastSyncSuccess ) )",
            "( 1.2.840.113556.1.5.280 NAME 'msDS-ClaimsTransformationPolicyType' SUP top STRUCTURAL MAY (msDS-TransformationRules $ msDS-TransformationRulesCompiled ) )",
            "( 0.9.2342.19200300.100.4.14 NAME 'rFC822LocalPart' SUP domain STRUCTURAL MAY (cn $ sn $ street $ description $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telephoneNumber $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod $ seeAlso ) )",
            "( 1.2.840.113556.1.5.190 NAME 'mS-SQL-OLAPCube' SUP top STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-Contact $ mS-SQL-Status $ mS-SQL-LastUpdatedDate $ mS-SQL-InformationURL $ mS-SQL-PublicationURL $ mS-SQL-Description $ mS-SQL-Size $ mS-SQL-Keywords ) )",
            "( 1.2.840.113556.1.5.208 NAME 'msWMI-UintSetParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-IntDefault ) MAY (msWMI-IntValidValues ) )",
            "( 1.3.6.1.1.1.2.2 NAME 'posixGroup' SUP top AUXILIARY MAY (cn $ description $ userPassword $ unixUserPassword $ gidNumber $ memberUid ) )",
            "( 2.5.6.17 NAME 'groupOfUniqueNames' SUP top STRUCTURAL MUST (cn $ uniqueMember ) MAY (o $ ou $ description $ businessCategory $ owner $ seeAlso ) )",
            "( 1.2.840.113556.1.5.252 NAME 'ms-net-ieee-8023-GroupPolicy' SUP top STRUCTURAL MAY (ms-net-ieee-8023-GP-PolicyGUID $ ms-net-ieee-8023-GP-PolicyData $ ms-net-ieee-8023-GP-PolicyReserved ) )",
            "( 1.2.840.113556.1.5.119 NAME 'ipsecNegotiationPolicy' SUP ipsecBase STRUCTURAL MAY (iPSECNegotiationPolicyType $ iPSECNegotiationPolicyAction ) )",
            "( 1.2.840.113556.1.5.292 NAME 'msDS-AuthNPolicySilo' SUP top STRUCTURAL MAY (msDS-AssignedAuthNPolicySiloBL $ msDS-AuthNPolicySiloMembers $ msDS-UserAuthNPolicy $ msDS-ComputerAuthNPolicy $ msDS-ServiceAuthNPolicy $ msDS-AuthNPolicySiloEnforced ) )",
            "( 1.2.840.113556.1.5.121 NAME 'ipsecNFA' SUP ipsecBase STRUCTURAL MAY (ipsecNegotiationPolicyReference $ ipsecFilterReference ) )",
            "( 1.2.840.113556.1.5.42 NAME 'dfsConfiguration' SUP top STRUCTURAL )",
            "( 0.9.2342.19200300.100.4.9 NAME 'documentSeries' SUP top STRUCTURAL MUST (cn ) MAY (l $ o $ ou $ description $ telephoneNumber $ seeAlso ) )",
            "( 1.2.840.113556.1.5.271 NAME 'msDS-ResourceProperties' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.91 NAME 'linkTrackObjectMoveTable' SUP fileLinkTracking STRUCTURAL )",
            "( 1.2.840.113556.1.5.136 NAME 'rpcContainer' SUP container STRUCTURAL MAY (nameServiceFlags ) )",
            "( 1.2.840.113556.1.5.83 NAME 'rIDManager' SUP top STRUCTURAL MUST (rIDAvailablePool ) MAY (msDS-RIDPoolAllocationEnabled ) )",
            "( 1.2.840.113556.1.5.206 NAME 'msWMI-IntSetParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-IntDefault ) MAY (msWMI-IntValidValues ) )",
            "( 1.2.840.113556.1.6.13.4.5 NAME 'msDFSR-ReplicationGroup' SUP top STRUCTURAL MUST (msDFSR-ReplicationGroupType ) MAY (description $ msDFSR-Version $ msDFSR-Extension $ msDFSR-RootSizeInMb $ msDFSR-StagingSizeInMb $ msDFSR-ConflictSizeInMb $ msDFSR-TombstoneExpiryInMin $ msDFSR-FileFilter $ msDFSR-DirectoryFilter $ msDFSR-Schedule $ msDFSR-Flags $ msDFSR-Options $ msDFSR-DeletedSizeInMb $ msDFSR-DefaultCompressionExclusionFilter $ msDFSR-OnDemandExclusionFileFilter $ msDFSR-OnDemandExclusionDirectoryFilter $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.125 NAME 'addressBookContainer' SUP top STRUCTURAL MUST (displayName ) MAY (purportedSearch ) )",
            "( 1.2.840.113556.1.5.7000.49 NAME 'applicationSettings' SUP top ABSTRACT MAY (applicationName $ notificationList $ msDS-Settings ) )",
            "( 1.2.840.113556.1.5.265 NAME 'msDS-OptionalFeature' SUP top STRUCTURAL MUST (msDS-OptionalFeatureGUID $ msDS-OptionalFeatureFlags ) MAY (msDS-RequiredDomainBehaviorVersion $ msDS-RequiredForestBehaviorVersion ) )",
            "( 1.2.840.113556.1.5.94 NAME 'serviceAdministrationPoint' SUP serviceConnectionPoint STRUCTURAL )",
            "( 1.2.840.113556.1.5.102 NAME 'nTFRSReplicaSet' SUP top STRUCTURAL MAY (fRSReplicaSetType $ fRSVersionGUID $ schedule $ fRSFileFilter $ fRSDirectoryFilter $ fRSDSPoll $ fRSServiceCommand $ fRSReplicaSetGUID $ fRSLevelLimit $ fRSRootSecurity $ fRSExtensions $ managedBy $ fRSFlags $ fRSPartnerAuthLevel $ fRSPrimaryMember $ msFRS-Topology-Pref $ msFRS-Hub-Member ) )",
            "( 1.2.840.113556.1.5.203 NAME 'msWMI-RangeParam' SUP top STRUCTURAL MUST (msWMI-PropertyName $ msWMI-TargetClass $ msWMI-TargetType ) )",
            "( 1.2.840.113556.1.5.7000.56 NAME 'ipsecBase' SUP top ABSTRACT MAY (ipsecName $ ipsecID $ ipsecDataType $ ipsecData $ ipsecOwnersReference ) )",
            "( 1.2.840.113556.1.6.13.4.3 NAME 'msDFSR-Subscription' SUP top STRUCTURAL MUST (msDFSR-ContentSetGuid $ msDFSR-ReplicationGroupGuid ) MAY (msDFSR-Extension $ msDFSR-RootPath $ msDFSR-RootSizeInMb $ msDFSR-StagingPath $ msDFSR-StagingSizeInMb $ msDFSR-ConflictPath $ msDFSR-ConflictSizeInMb $ msDFSR-Enabled $ msDFSR-Flags $ msDFSR-Options $ msDFSR-RootFence $ msDFSR-DfsLinkTarget $ msDFSR-DeletedPath $ msDFSR-DeletedSizeInMb $ msDFSR-ReadOnly $ msDFSR-CachePolicy $ msDFSR-MinDurationCacheInMin $ msDFSR-MaxAgeInCacheInMin $ msDFSR-OnDemandExclusionFileFilter $ msDFSR-OnDemandExclusionDirectoryFilter $ msDFSR-Options2 $ msDFSR-StagingCleanupTriggerInPercent ) )",
            "( 1.2.840.113556.1.5.223 NAME 'msPKI-PrivateKeyRecoveryAgent' SUP top STRUCTURAL MUST (userCertificate ) )",
            "( 1.2.840.113556.1.5.178 NAME 'pKIEnrollmentService' SUP top STRUCTURAL MAY (cACertificate $ dNSHostName $ cACertificateDN $ certificateTemplates $ signatureAlgorithms $ enrollmentProviders $ msPKI-Enrollment-Servers $ msPKI-Site-Name ) )",
            "( 1.2.840.113556.1.6.18.2.211 NAME 'msSFU30MailAliases' SUP top STRUCTURAL MAY (msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.2.840.113556.1.5.53 NAME 'typeLibrary' SUP top STRUCTURAL MAY (cOMClassID $ cOMInterfaceID $ cOMUniqueLIBID ) )",
            "( 1.2.840.113556.1.6.13.4.8 NAME 'msDFSR-Topology' SUP top STRUCTURAL MAY (msDFSR-Extension $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 ) )",
            "( 1.2.840.113556.1.5.237 NAME 'msDS-AzScope' SUP top STRUCTURAL MUST (msDS-AzScopeName ) MAY (description $ msDS-AzApplicationData $ msDS-AzObjectGuid $ msDS-AzGenericData ) )",
            "( 1.2.840.113556.1.5.74 NAME 'categoryRegistration' SUP leaf STRUCTURAL MAY (localeID $ categoryId $ managedBy $ localizedDescription ) )",
            "( 1.2.840.113556.1.5.11 NAME 'comConnectionPoint' SUP connectionPoint STRUCTURAL MUST (cn ) MAY (marshalledInterface $ moniker $ monikerDisplayName ) )",
            "( 1.2.840.113556.1.5.93 NAME 'linkTrackOMTEntry' SUP leaf STRUCTURAL MAY (birthLocation $ oMTIndxGuid $ currentLocation $ timeRefresh $ oMTGuid ) )",
            "( 1.2.840.113556.1.5.10 NAME 'classRegistration' SUP leaf STRUCTURAL MAY (cOMInterfaceID $ cOMProgID $ cOMCLSID $ cOMTreatAsClassId $ cOMOtherProgId $ implementedCategories $ requiredCategories $ managedBy ) )",
            "( 1.2.840.113556.1.5.148 NAME 'siteLinkBridge' SUP top STRUCTURAL MUST (siteLinkList ) )",
            "( 1.2.840.113556.1.5.81 NAME 'rpcServer' SUP rpcEntry STRUCTURAL MAY (rpcNsObjectID $ rpcNsCodeset $ rpcNsEntryFlags ) )",
            "( 1.2.840.113556.1.3.46 NAME 'mailRecipient' SUP top AUXILIARY MUST (cn ) MAY (telephoneNumber $ userCertificate $ info $ garbageCollPeriod $ msExchAssistantName $ msExchLabeledURI $ showInAddressBook $ userCert $ legacyExchangeDN $ msDS-PhoneticDisplayName $ msDS-GeoCoordinatesAltitude $ msDS-GeoCoordinatesLatitude $ msDS-GeoCoordinatesLongitude $ userSMIMECertificate $ textEncodedORAddress $ secretary $ labeledURI ) )",
            "( 1.2.840.113556.1.5.1 NAME 'securityObject' SUP top ABSTRACT MUST (cn ) )",
            "( 1.2.840.113556.1.5.20 NAME 'leaf' SUP top ABSTRACT )",
            "( 1.2.840.113556.1.5.151 NAME 'intellimirrorSCP' SUP serviceAdministrationPoint STRUCTURAL MAY (netbootMachineFilePath $ netbootAllowNewClients $ netbootLimitClients $ netbootMaxClients $ netbootCurrentClientCount $ netbootAnswerRequests $ netbootAnswerOnlyValidClients $ netbootNewMachineNamingPolicy $ netbootNewMachineOU $ netbootIntelliMirrorOSes $ netbootTools $ netbootLocallyInstalledOSes $ netbootServer ) )",
            "( 1.2.840.113556.1.6.13.4.1 NAME 'msDFSR-LocalSettings' SUP top STRUCTURAL MAY (msDFSR-Version $ msDFSR-Extension $ msDFSR-Flags $ msDFSR-Options $ msDFSR-Options2 $ msDFSR-CommonStagingPath $ msDFSR-CommonStagingSizeInMb $ msDFSR-StagingCleanupTriggerInPercent ) )",
            "( 1.2.840.113556.1.5.186 NAME 'mS-SQL-SQLRepository' SUP top STRUCTURAL MAY (mS-SQL-Name $ mS-SQL-Contact $ mS-SQL-Build $ mS-SQL-Status $ mS-SQL-Version $ mS-SQL-Description $ mS-SQL-InformationDirectory ) )",
            "( 2.5.6.8 NAME 'organizationalRole' SUP top STRUCTURAL MUST (cn ) MAY (l $ st $ street $ ou $ postalAddress $ postalCode $ postOfficeBox $ physicalDeliveryOfficeName $ telephoneNumber $ telexNumber $ teletexTerminalIdentifier $ facsimileTelephoneNumber $ x121Address $ internationalISDNNumber $ registeredAddress $ destinationIndicator $ preferredDeliveryMethod $ roleOccupant $ seeAlso ) )",
            "( 2.5.20.1 NAME 'subSchema' SUP top STRUCTURAL MAY (extendedClassInfo $ extendedAttributeInfo $ dITContentRules $ attributeTypes $ objectClasses $ modifyTimeStamp ) )",
            "( 1.2.840.113556.1.5.284 NAME 'msDS-DeviceRegistrationService' SUP top STRUCTURAL MUST (msDS-IsEnabled $ msDS-DeviceLocation ) MAY (msDS-IssuerCertificates $ msDS-RegistrationQuota $ msDS-MaximumRegistrationInactivityPeriod $ msDS-IssuerPublicCertificates $ msDS-CloudIssuerPublicCertificates $ msDS-CloudIsEnabled ) )",
            "( 1.2.840.113556.1.5.84 NAME 'displaySpecifier' SUP top STRUCTURAL MAY (iconPath $ creationWizard $ contextMenu $ adminPropertyPages $ shellPropertyPages $ classDisplayName $ adminContextMenu $ shellContextMenu $ attributeDisplayNames $ treatAsLeaf $ createDialog $ createWizardExt $ scopeFlags $ queryFilter $ extraColumns $ adminMultiselectPropertyPages ) )",
            "( 1.2.840.113556.1.5.212 NAME 'msWMI-ShadowObject' SUP top STRUCTURAL MUST (msWMI-TargetObject ) )",
            "( 1.2.840.113556.1.5.59 NAME 'fileLinkTrackingEntry' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.4.2161 NAME 'msAuthz-CentralAccessPolicies' SUP top STRUCTURAL )",
            "( 1.2.840.113556.1.5.161 NAME 'mSMQQueue' SUP top STRUCTURAL MAY (mSMQQueueType $ mSMQJournal $ mSMQBasePriority $ mSMQLabel $ mSMQAuthenticate $ mSMQPrivacyLevel $ mSMQOwnerID $ mSMQTransactional $ mSMQQueueQuota $ mSMQQueueJournalQuota $ mSMQQueueNameExt $ mSMQLabelEx $ MSMQ-SecuredSource $ MSMQ-MulticastAddress ) )",
            "( 1.2.840.113556.1.5.193 NAME 'msCOM-Partition' SUP top STRUCTURAL MAY (msCOM-ObjectId ) )",
            "( 1.2.840.113556.1.5.118 NAME 'ipsecFilter' SUP ipsecBase STRUCTURAL )",
            "( 2.5.6.2 NAME 'country' SUP top STRUCTURAL MUST (c ) MAY (searchGuide $ co ) )",
            "( 1.2.840.113556.1.5.97 NAME 'physicalLocation' SUP locality STRUCTURAL MAY (managedBy ) )",
            "( 1.2.840.113556.1.3.30 NAME 'computer' SUP user STRUCTURAL MAY (cn $ networkAddress $ localPolicyFlags $ defaultLocalPolicyObject $ machineRole $ location $ netbootInitialization $ netbootGUID $ netbootMachineFilePath $ siteGUID $ operatingSystem $ operatingSystemVersion $ operatingSystemServicePack $ operatingSystemHotfix $ volumeCount $ physicalLocationObject $ dNSHostName $ policyReplicationFlags $ managedBy $ rIDSetReferences $ catalogs $ netbootSIFFile $ netbootMirrorDataFile $ msDS-AdditionalDnsHostName $ msDS-AdditionalSamAccountName $ msDS-ExecuteScriptPassword $ msDS-KrbTgtLink $ msDS-RevealedUsers $ msDS-NeverRevealGroup $ msDS-RevealOnDemandGroup $ msDS-RevealedList $ msDS-AuthenticatedAtDC $ msDS-isGC $ msDS-isRODC $ msDS-SiteName $ msDS-PromotionSettings $ msTPM-OwnerInformation $ msTSProperty01 $ msTSProperty02 $ msDS-IsUserCachableAtRodc $ msDS-HostServiceAccount $ msTSEndpointData $ msTSEndpointType $ msTSEndpointPlugin $ msTSPrimaryDesktopBL $ msTSSecondaryDesktopBL $ msTPM-TpmInformationForComputer $ msDS-GenerationId $ msImaging-ThumbprintHash $ msImaging-HashAlgorithm $ netbootDUID $ msSFU30Name $ msSFU30Aliases $ msSFU30NisDomain $ nisMapName ) )",
            "( 1.3.6.1.1.1.2.8 NAME 'nisNetgroup' SUP top STRUCTURAL MUST (cn ) MAY (description $ msSFU30Name $ msSFU30NisDomain $ msSFU30NetgroupHostAtDomain $ msSFU30NetgroupUserAtDomain $ memberNisNetgroup $ nisNetgroupTriple $ nisMapName ) )",
            "( 1.2.840.113556.1.5.153 NAME 'nTFRSMember' SUP top STRUCTURAL MAY (fRSUpdateTimeout $ fRSServiceCommand $ serverReference $ fRSRootSecurity $ fRSExtensions $ frsComputerReference $ fRSControlDataCreation $ fRSControlInboundBacklog $ fRSControlOutboundBacklog $ fRSFlags $ fRSPartnerAuthLevel ) )",
            "( 2.5.6.12 NAME 'applicationEntity' SUP top STRUCTURAL MUST (cn $ presentationAddress ) MAY (l $ o $ ou $ supportedApplicationContext $ seeAlso ) )",
            "( 2.5.6.11 NAME 'applicationProcess' SUP top STRUCTURAL MUST (cn ) MAY (l $ ou $ seeAlso ) )",
            "( 1.2.840.113556.1.5.279 NAME 'msDS-ValueType' SUP top STRUCTURAL MUST (msDS-ClaimValueType $ msDS-ClaimIsValueSpaceRestricted $ msDS-ClaimIsSingleValued $ msDS-IsPossibleValuesPresent ) )",
            "( 1.2.840.113556.1.5.204 NAME 'msWMI-UnknownRangeParam' SUP msWMI-RangeParam STRUCTURAL MUST (msWMI-NormalizedClass $ msWMI-TargetObject ) )",
            "( 1.2.840.113556.1.5.66 NAME 'domain' SUP top ABSTRACT MUST (dc ) )",
            "( 2.5.6.13 NAME 'dSA' SUP applicationEntity STRUCTURAL MAY (knowledgeInformation ) )",
            "( 1.2.840.113556.1.5.120 NAME 'ipsecISAKMPPolicy' SUP ipsecBase STRUCTURAL )"
        ],
        "objectGUID": [
            {
                "encoded": "sr4GScorekOq9Mmm+aY8Ow==",
                "encoding": "base64"
            }
        ],
        "systemFlags": [
            "134217728"
        ],
        "uSNChanged": [
            "5"
        ],
        "uSNCreated": [
            "5"
        ],
        "whenChanged": [
            "20130521164433.0Z"
        ],
        "whenCreated": [
            "20130521164433.0Z"
        ]
    },
    "schema_entry": "CN=Aggregate,CN=Schema,CN=Configuration,DC=AD2012,DC=LAB",
    "type": "SchemaInfo"
}
"""
ad_2012_r2_dsa_info = """
{
    "raw": {
        "configurationNamingContext": [
            "CN=Configuration,DC=AD2012,DC=LAB"
        ],
        "currentTime": [
            "20141111080100.0Z"
        ],
        "defaultNamingContext": [
            "DC=AD2012,DC=LAB"
        ],
        "dnsHostName": [
            "WIN1.AD2012.LAB"
        ],
        "domainControllerFunctionality": [
            "6"
        ],
        "domainFunctionality": [
            "6"
        ],
        "dsServiceName": [
            "CN=NTDS Settings,CN=WIN1,CN=Servers,CN=Default-First-Site-Name,CN=Sites,CN=Configuration,DC=AD2012,DC=LAB"
        ],
        "forestFunctionality": [
            "6"
        ],
        "highestCommittedUSN": [
            "22591"
        ],
        "isGlobalCatalogReady": [
            "TRUE"
        ],
        "isSynchronized": [
            "TRUE"
        ],
        "ldapServiceName": [
            "AD2012.LAB:win1$@AD2012.LAB"
        ],
        "namingContexts": [
            "DC=AD2012,DC=LAB",
            "CN=Configuration,DC=AD2012,DC=LAB",
            "CN=Schema,CN=Configuration,DC=AD2012,DC=LAB",
            "DC=DomainDnsZones,DC=AD2012,DC=LAB",
            "DC=ForestDnsZones,DC=AD2012,DC=LAB"
        ],
        "rootDomainNamingContext": [
            "DC=AD2012,DC=LAB"
        ],
        "schemaNamingContext": [
            "CN=Schema,CN=Configuration,DC=AD2012,DC=LAB"
        ],
        "serverName": [
            "CN=WIN1,CN=Servers,CN=Default-First-Site-Name,CN=Sites,CN=Configuration,DC=AD2012,DC=LAB"
        ],
        "subschemaSubentry": [
            "CN=Aggregate,CN=Schema,CN=Configuration,DC=AD2012,DC=LAB"
        ],
        "supportedCapabilities": [
            "1.2.840.113556.1.4.800",
            "1.2.840.113556.1.4.1670",
            "1.2.840.113556.1.4.1791",
            "1.2.840.113556.1.4.1935",
            "1.2.840.113556.1.4.2080",
            "1.2.840.113556.1.4.2237"
        ],
        "supportedControl": [
            "1.2.840.113556.1.4.319",
            "1.2.840.113556.1.4.801",
            "1.2.840.113556.1.4.473",
            "1.2.840.113556.1.4.528",
            "1.2.840.113556.1.4.417",
            "1.2.840.113556.1.4.619",
            "1.2.840.113556.1.4.841",
            "1.2.840.113556.1.4.529",
            "1.2.840.113556.1.4.805",
            "1.2.840.113556.1.4.521",
            "1.2.840.113556.1.4.970",
            "1.2.840.113556.1.4.1338",
            "1.2.840.113556.1.4.474",
            "1.2.840.113556.1.4.1339",
            "1.2.840.113556.1.4.1340",
            "1.2.840.113556.1.4.1413",
            "2.16.840.1.113730.3.4.9",
            "2.16.840.1.113730.3.4.10",
            "1.2.840.113556.1.4.1504",
            "1.2.840.113556.1.4.1852",
            "1.2.840.113556.1.4.802",
            "1.2.840.113556.1.4.1907",
            "1.2.840.113556.1.4.1948",
            "1.2.840.113556.1.4.1974",
            "1.2.840.113556.1.4.1341",
            "1.2.840.113556.1.4.2026",
            "1.2.840.113556.1.4.2064",
            "1.2.840.113556.1.4.2065",
            "1.2.840.113556.1.4.2066",
            "1.2.840.113556.1.4.2090",
            "1.2.840.113556.1.4.2205",
            "1.2.840.113556.1.4.2204",
            "1.2.840.113556.1.4.2206",
            "1.2.840.113556.1.4.2211",
            "1.2.840.113556.1.4.2239",
            "1.2.840.113556.1.4.2255",
            "1.2.840.113556.1.4.2256"
        ],
        "supportedExtension": [
            "1.3.6.1.4.1.1466.20037",
            "1.3.6.1.4.1.1466.101.119.1",
            "1.2.840.113556.1.4.1781",
            "1.3.6.1.4.1.4203.1.11.3",
            "1.2.840.113556.1.4.2212"
        ],
        "supportedLDAPPolicies": [
            "MaxPoolThreads",
            "MaxPercentDirSyncRequests",
            "MaxDatagramRecv",
            "MaxReceiveBuffer",
            "InitRecvTimeout",
            "MaxConnections",
            "MaxConnIdleTime",
            "MaxPageSize",
            "MaxBatchReturnMessages",
            "MaxQueryDuration",
            "MaxTempTableSize",
            "MaxResultSetSize",
            "MinResultSets",
            "MaxResultSetsPerConn",
            "MaxNotificationPerConn",
            "MaxValRange",
            "MaxValRangeTransitive",
            "ThreadMemoryLimit",
            "SystemMemoryLimitPercent"
        ],
        "supportedLDAPVersion": [
            "3",
            "2"
        ],
        "supportedSASLMechanisms": [
            "GSSAPI",
            "GSS-SPNEGO",
            "EXTERNAL",
            "DIGEST-MD5"
        ]
    },
    "type": "DsaInfo"
}
"""
