from scrapy.item import Field, Item, ItemMeta


class DjangoItemMeta(ItemMeta):

    def  __new__(mcs, class_name, bases, attrs):
        cls = super(DjangoItemMeta, mcs).__new__(mcs, class_name, bases, attrs)
        cls.fields = cls.fields.copy()

        if cls.django_model:
            cls._model_fields = []
            cls._model_meta = cls.django_model._meta
            for model_field in cls._model_meta.fields:
                # XXX: for now we're treating each PK as autogenerated field
                if model_field != cls._model_meta.pk:
                    if model_field.name not in cls.fields:
                        cls.fields[model_field.name] = Field()
                    cls._model_fields.append(model_field.name)
        return cls


class DjangoItem(Item):

    __metaclass__ = DjangoItemMeta

    django_model = None

    def save(self, commit=True):
        modelargs = dict((f, self.get(f, None)) for f in self._model_fields)
        model = self.django_model(**modelargs)
        if commit:
            model.save()
        return model

