#!/usr/bin/env python
#
# Copyright (c) 2008 by Enthought, Inc.
# All rights reserved.
#

"""
Having this package installed adds the following commands to setup.py:

build_docs
dist_docs

build_docs will build documentation i various formats in build/docs if Sphinx
is installed.
dist_docs will create a zip file of html docs in dist/.
dist_docs -c will replace the html.zip in docs/ and check it in.
dist_docs -u will build html and pdf docs, check them in, and update the
website.
"""
from setuptools import setup, find_packages

setup(
    author = "Enthought, Inc.",
    author_email = 'info@enthought.com',
    classifiers = [c.strip() for c in """\
        License :: OSI Approved :: BSD License
        Operating System :: MacOS
        Operating System :: Microsoft :: Windows
        Operating System :: OS Independent
        Operating System :: POSIX
        Operating System :: Unix
        """.splitlines() if len(c.strip()) > 0],
    description = 'setuptools plugin that automates building of docs from '
        'ReST source',
    entry_points = {
        'distutils.commands': [
            'build_docs = setupdocs.setupdocs:BuildDocs',
            'dist_docs = setupdocs.setupdocs:DistDocs',
            'clean = setupdocs.setupdocs:MyClean'
            ],
        'distutils.setup_keywords': [
            'docs_in_egg = setupdocs.setupdocs:check_bool',
            'docs_in_egg_location = setupdocs.setupdocs:check_string',
            'html_doc_repo = setupdocs.setupdocs:check_string',
            'ssh_server = setupdocs.setupdocs:check_string',
            'ssh_username = setupdocs.setupdocs:check_string',
            'ssh_remote_dir = setupdocs.setupdocs:check_string'
            ],
        },
    name = 'setupdocs',
    packages = find_packages(),
    version = "1.0.1"
    )
