#!/usr/bin/env python
""" bank09: Several Counters but a Single Queue"""
from SimPy.Simulation  import *
from random import expovariate, seed

class Source(Process):
    """ Source generates customers randomly"""

    def generate(self,number,interval):       
        for i in range(number):
            c = Customer(name = "Customer%02d"%(i,))
            activate(c,c.visit(timeInBank=12.0))
            t = expovariate(1.0/interval)
            yield hold,self,t

class Customer(Process):
    """ Customer arrives, is served and leaves """
        
    def visit(self,timeInBank=0):       
        arrive=now()
        print "%7.4f %s: Here I am "%(now(),self.name)
        yield request,self,counter
        wait=now()-arrive
        print "%7.4f %s: Waited %6.3f"%(now(),self.name,wait)
        tib = expovariate(1.0/timeInBank)
        yield hold,self,tib
        yield release,self,counter
        print "%7.4f %s: Finished"%(now(),self.name)

def model(theseed):
    global counter
    seed(theseed)
    counter = Resource(name="Clerk",capacity = 2)        

    initialize()
    source = Source('Source')
    activate(source,source.generate(5,interval=10.0),0.0)
    simulate(until=400.0)

model(theseed=12345)
