# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class EventTypeTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.events.v1.event_types.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://events.twilio.com/v1/Types',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "types": [],
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://events.twilio.com/v1/Types?PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://events.twilio.com/v1/Types?PageSize=10&Page=0",
                    "next_page_url": null,
                    "key": "types"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types.list()

        self.assertIsNotNone(actual)

    def test_read_results_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "types": [
                    {
                        "date_created": "2020-08-13T12:50:18Z",
                        "date_updated": "2020-08-13T13:28:48Z",
                        "type": "com.twilio.test.example",
                        "schema_id": "EventStreams.SampleSchema",
                        "description": "A sample event type",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.test.example",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/EventStreams.SampleSchema/Versions"
                        }
                    },
                    {
                        "date_created": "2020-08-13T12:50:19Z",
                        "date_updated": "2020-08-13T13:28:49Z",
                        "type": "com.twilio.test.example2",
                        "schema_id": "EventStreams.SampleSchema",
                        "description": "Another sample event type",
                        "url": "https://events.twilio.com/v1/Types/com.twilio.test.example2",
                        "links": {
                            "schema": "https://events.twilio.com/v1/Schemas/EventStreams.SampleSchema/Versions"
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 20,
                    "first_page_url": "https://events.twilio.com/v1/Types?PageSize=20&Page=0",
                    "previous_page_url": null,
                    "url": "https://events.twilio.com/v1/Types?PageSize=20&Page=0",
                    "next_page_url": null,
                    "key": "types"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.events.v1.event_types("type").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://events.twilio.com/v1/Types/type',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "date_created": "2020-08-13T12:50:18Z",
                "date_updated": "2020-08-13T13:28:48Z",
                "type": "com.twilio.test.example",
                "schema_id": "EventStreams.SampleSchema",
                "description": "A sample subscription",
                "url": "https://events.twilio.com/v1/Types/com.twilio.test.example",
                "links": {
                    "schema": "https://events.twilio.com/v1/Schemas/EventStreams.SampleSchema/Versions"
                }
            }
            '''
        ))

        actual = self.client.events.v1.event_types("type").fetch()

        self.assertIsNotNone(actual)
