
"""
__version__ = "$Revision: 1.14 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class RadioGroupSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'RadioGroup'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.SelectEvent])
        self._attributes.update({ 
            'label' : { 'presence' : 'optional', 'default' : '' },
            'items' : { 'presence' : 'optional', 'default' : [] },
            'selected' : { 'presence' : 'optional', 'default' : None },
            'layout' : { 'presence' : 'optional', 'default' : 'vertical', 'values' : [ 'horizontal', 'vertical' ] },
            'max' : { 'presence' : 'optional', 'default' : 1 }
            # KEA we can't control the border of a wxRadioBox as far as I can tell
            #'border' : { 'presence' : 'optional', 'default' : None }        
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class RadioGroup(widget.Widget, wx.wxRadioBox):
    """
    A group of radio buttons.
    """

    _spec = RadioGroupSpec()

    def __init__( self, aParent, aResource ) :
        attributes = ['_labels', '_layout', '_max']
        self._createAttributes(attributes)
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxRadioBox.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.label, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            aResource.items,
            aResource.max,
            self.__getLayout( aResource.layout ) | wx.wxCLIP_SIBLINGS,
            name=aResource.name
            )

        if not hasattr(self.__class__, '_getLabel'):
            self.__class__._getLabel = self.__class__.GetLabel
        if not hasattr(self.__class__, '_setLabel'):
            self.__class__._setLabel = self.__class__.SetLabel

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        self._labels = aResource.items
        self._layout = aResource.layout
        self._max = aResource.max
        self._setSelection( aResource.selected )

    def _bindEvents(self):
        adapter = RadioGroupEventBinding(self)
        adapter.bindEvents()

    def __getLayout(self, aString):
        if aString == 'vertical':
            return wx.wxRA_SPECIFY_COLS
        elif aString == 'horizontal':
            return wx.wxRA_SPECIFY_ROWS
        else :
            raise 'invalid RadioGroup.layout value: ', aString

    def _getItems( self ) :
        return self._labels

    def _setItems( self, aList ) :
        #self._delegate.SetClientData( aString )
        raise NotImplementedError

    """
    # KEA added to match spec.py 'selected' attribute
    # plus get methods for other attributes
    def _getLabel( self ) :
        return self.GetLabel()

    def _setLabel( self, aString ) :
        self.SetLabel( aString )
    """

    def _getLayout( self ) :
        return self._layout

    def _setLayout( self, aString ) :
        raise AttributeError, "layout attribute is read-only"

    def _getMax( self ) :
        return self._max

    def _setMax( self, aMax ) :
        raise AttributeError, "max attribute is read-only"

    # KEA 2001-08-14
    # temporary fix
    # naming of selected, selection, stringSelection, etc. needs to be clarified
    # and standardized across List, RadioGroup, Choice
    # and then spec.py, debug.py, etc. needs to be updated
    def _getSelected( self ) :
        return self.GetStringSelection()

    def _setSelected(self, s):
        self.SetStringSelection(s)

    def _getSelection(self):
        return self.GetStringSelection()

    def _setSelection(self, s):
        if s is None or s == '':
            return
        elif isinstance(s, int):
            self.SetSelection(s)
        else:
            self.SetStringSelection(s)


class RadioGroupEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.RadioGroup to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.SelectEvent :
            wx.EVT_RADIOBOX( parent, self._component.getId(), self._dispatch )

    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_RADIOBOX_SELECTED :
            evt = self._createEvent( event.SelectEvent, aWxEvent )

        if evt is not None :
            self._component._notifyEventListeners( evt )


registry.getRegistry().register( sys.modules[__name__].RadioGroup )
