
"""
__version__ = "$Revision: 1.7 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class SpinnerSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Spinner'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.KeyPressEvent,
                            event.KeyDownEvent, 
                            event.KeyUpEvent,
                            event.TextEnterEvent,
                            event.TextUpdateEvent,
                            #event.SpinUpEvent,
                            #event.SpinDownEvent
                            ])
        self._attributes.update({ 
            'min' : { 'presence' : 'optional', 'default' : 0 }, 
            'max' : { 'presence' : 'optional', 'default' : 100 }, 
            'value' : { 'presence' : 'optional', 'default' : 0 } 
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Spinner(widget.Widget, wx.wxSpinCtrl):
    """
    A Spinner component.
    """

    _spec = SpinnerSpec()
    
    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxSpinCtrl.__init__(
            self,
            aParent, 
            self.getId(), 
            str(aResource.value),
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            style = wx.wxSP_ARROW_KEYS | wx.wxSP_WRAP | wx.wxCLIP_SIBLINGS,
            min = aResource.min,
            max = aResource.max,
            initial = aResource.value,
            name = aResource.name 
        )

        if not hasattr(self.__class__, '_getValue'):
            self.__class__._getValue = self.__class__.GetValue
        if not hasattr(self.__class__, '_setValue'):
            self.__class__._setValue = self.__class__.SetValue
        if not hasattr(self.__class__, '_getMin'):
            self.__class__._getMin = self.__class__.GetMin
        if not hasattr(self.__class__, '_getMax'):
            self.__class__._getMax = self.__class__.GetMax

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = SpinnerEventBinding(self)
        adapter.bindEvents()
            
    def setRange( self, aMin, aMax ) :
        self.SetRange( aMin, aMax )

    """
    def _getValue( self ) :
        return self.GetValue()

    def _setValue( self, aValue ) :
        self.SetValue( aValue )

    def _getMin( self ) :
        return self.GetMin()
    """

    def _setMin( self, aMin ) :
        self.SetRange( aMin, self.GetMax() )

    """
    def _getMax( self ) :
        return self.GetMax()
    """

    def _setMax( self, aMax ) :
        self.SetRange( self.GetMin(), aMax )


class SpinnerEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.Spinner to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

                        
    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.KeyDownEvent :
            wx.EVT_KEY_DOWN( self._component, self._dispatch )
        elif aEventClass is event.KeyUpEvent :
            wx.EVT_KEY_UP( self._component, self._dispatch )
        elif aEventClass is event.KeyPressEvent :
            wx.EVT_CHAR( self._component, self._dispatch )
        elif aEventClass is event.TextUpdateEvent :
            #wx.EVT_SPINCTRL( parent, self._component.getId(), self._dispatch )
            wx.EVT_TEXT( parent, self._component.getId(), self._dispatch )
        elif aEventClass is event.TextEnterEvent :
            wx.EVT_TEXT_ENTER( parent, self._component.getId(), self._dispatch )
        """
        elif aEventClass is event.SpinUpEvent :
            wx.EVT_SPIN_UP(parent, self._component.getId(), self._dispatch)
        elif aEventClass is event.SpinDownEvent :
            wx.EVT_SPIN_DOWN(parent, self._component.getId(), self._dispatch)
        """


    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_KEY_DOWN :
            evt = self._createEvent( event.KeyDownEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_KEY_UP :
            evt = self._createEvent( event.KeyUpEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_CHAR :
            evt = self._createEvent( event.KeyPressEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TEXT_ENTER :
            evt = self._createEvent( event.TextEnterEvent, aWxEvent )
        """
        if aWxEvent.GetEventType() == wx.wxEVT_SCROLL_LINEUP:
            evt = self._createEvent(event.SpinUpEvent, aWxEvent)
        if aWxEvent.GetEventType() == wx.wxEVT_SCROLL_LINEDOWN:
            evt = self._createEvent(event.SpinDownEvent, aWxEvent)
        """
        #if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_SPINCTRL_UPDATED:
        #    evt = self._createEvent( event.TextUpdateEvent, aWxEvent )
        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TEXT_UPDATED:
            component = self._component
            if component._getCommand() is not None:
                evt = event.CommandEvent(component._getCommand(), component)
                evt.setNativeEvent(aWxEvent)
            else:
                evt = self._createEvent(event.TextUpdateEvent, aWxEvent)

        if evt is not None :
            self._component._notifyEventListeners(evt)
            #if not evt.getUsed():
            #    aWxEvent.Skip()


registry.getRegistry().register( sys.modules[__name__].Spinner )
