"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/03/18 16:06:53 $"
"""

import event

class DispatchEvent( event.Event ) :
    """
    A special Event only sent by EventDispatch.  It wraps
    up an Event that is to be dispatched, indicating
    whether the event was 'used', i.e. a Handler existed
    for it or not.

    - see debug.MessageWatcher for a use of DispatchEvent.
    """
    def __init__( self, aSource, aEvent, aBoolean ) :
        event.Event.__init__( self, aSource )
        self.dispatched = aEvent
        self.used = aBoolean
    
    """
    Get the original Event that was sent to EventDispatch.
    """
    def getDispatchedEvent( self ) :
        return self.dispatched

    """
    Return a boolean indicating whether the Event was
    used or not, i.e. dispatched to a Handler.
    """
    def getEventWasUsed( self ) :
        return self.used

class EventDispatch( event.EventSource, event.EventListener ) :
    """
    Construct with an EventSource that will notify us of any incoming
    Events, and a Scriptable object that will be the starting point
    for looking for Handlers.
    """
    def __init__(self, aEventSource, aScriptable):
        event.EventSource.__init__(self)
        self._scriptable = aScriptable
        aEventSource._addEventListener(self)
        event.EventQueue().listenTo(self)

    def eventOccurred( self, aEvent ) :
        """
        Dispatch an Event to the appropriate Handler.
        """

        # put together a Handler name based on the event's name and source.

        name = aEvent.getHandlerName()

        # Call our Scriptable object, looking for a matching Handler.  If the
        # Scriptable object can't find a Handler matching 'name', then it
        # will ask it's parent Scriptable object, and so on, until parent
        # is None.

        handler = self._scriptable.findHandler( name )

        # Get the function of the Handler and invoke it, passing aEvent
        # as the single parameter.

        used = 0

        if handler is not None :
            used = 1
            aEvent.setUsed(1)
            try:
                nativeEvent = aEvent.getNativeEvent()
                # alias Skip method
                nativeEvent.skip = nativeEvent.Skip
            except:
                # these are not wxPython events
                # openBackground
                #print aEvent
                nativeEvent = aEvent
            #handler.getFunction()(self._scriptable, aEvent.getSource(), nativeEvent)
            # KEA 2002-03-07
            # change to (self, event) event handler dispatch
            handler.getFunction()(self._scriptable, nativeEvent)
        else :
            """
            Depending on the type of handler we're trying to call, we will
            want to do some additional dispatching.

            For example.  If the EventSource is a MenuItem, then we 
            want to look for a generic on_menu_select handler, and call
            it if it exists.
            """
            pass

        # Broadcast a DispatchEvent that carries an Event, and a flag
        # indicating whether the Event was used or not.

        self._notifyEventListeners(DispatchEvent(self, aEvent, used))




