
"""
__version__ = "$Revision: 1.131 $"
__date__ = "$Date: 2004/04/08 18:55:22 $"
"""

import os, sys
# some things might work with lesser
# versions, but this is a reasonable base
assert sys.version_info >= (2, 2, 1)
# sys.modules relative path fix
sys.path[0] = os.path.abspath(sys.path[0])
#sys.path = [os.path.abspath(p) for p in sys.path]

from wxPython import wx
assert wx.__version__ >= "2.4"

import config
import log
import event
import dispatch
import res
import widget
import menu
import statusbar
import debug
import binding
import pom
import util

import types
import UserDict
import new
import locale
import inspect

# KEA 2001-07-27
from wxPython.lib import colourdb

class WidgetDict(UserDict.UserDict, event.Changeable):
    def __init__(self, parent, d=None):
        self.__dict__['parent'] = parent
        self.__dict__['data'] = {}
        self.__dict__['order'] = []
        if d is not None: self.update(d)
        event.Changeable.__init__(self)

    # __getattr__ and __setattr__ need to be cleaned up
    # to support more attributes
    def __getattr__(self, key):
        if key == '_listeners':
            return self.__dict__[key]
        elif key == 'order':
            pass
        else:
            return self.data[key]

    def __setattr__(self, key, item):
        if key == '_listeners':
            self.__dict__[key] = item
        elif key == 'order':
            pass
        else:
            self.__setitem__(key, item)

    """
    def __delattr__(self, key):
        if key == '_listeners':
            pass
        else:
            self.__delitem__(key)
    """

    def __setitem__(self, key, item):
        if isinstance(item, dict):
            item = res.Resource(item)
        control = pom.ComponentFactory().createComponent(self.parent, self.parent.panel, item)
        if key in self.data:
            self.order.remove(key)
        self.order.append(key)
        self.data[key] = control
        # notify listeners
        self.fireChanged(key + "," + control.__class__.__name__)

    def __delitem__(self, key):
        control = self.data[key]
        # KEA 2002-05-20
        # hack for 2.3.3 focus problem?
        visible = control.visible
        control.Show(0)
        wClass = control.__class__.__name__
        focusWin = wx.wxWindow_FindFocus()
        if focusWin is not None and focusWin == control:
            #print "disconnecting wx.wxEVT_KILL_FOCUS", control.name
            focusWin.Disconnect(-1, -1, wx.wxEVT_KILL_FOCUS) 
        if self.data[key].Destroy():
            self.order.remove(key)
            del self.data[key]
            self.fireChanged(key + "," + wClass)
        else:
            # why would Destroy fail?
            # if it does fail we have
            # a problem since we disconnected wx.wxEVT_KILL_FOCUS
            print "destroy failed", control
            control.Show(visible)

    def clear(self):
        for key in self.data.keys():
            self.__delitem__(key)

    def _getAttributeNames(self):
        return self.data.keys()


def internationalResourceName(base):
    aFileName = base + ".rsrc.py"
    try:
        default = locale.getdefaultlocale()
    except:
        default = None
    log.debug('default: ' + str(default))
    if default and default[0] is not None:
        language, country = default[0].split('_')
        languageCountryName = base + '.' + language + '_' + country + ".rsrc.py"
        languageOnlyName = base + '.' + language + ".rsrc.py"
        if os.path.exists(languageCountryName):
            aFileName = languageCountryName
        elif os.path.exists(languageOnlyName):
            aFileName = languageOnlyName
        log.debug(language + ' ' + country + ' ' + languageCountryName + ' ' + \
                  languageOnlyName + ' ' + aFileName)
    return aFileName


# KEA 2002-09-09
# this is derived from the frame loading in
# PythonCardApp below
def childWindow(parent, frameClass, filename=None, resource=None):
    if filename is None:
        if resource is None:
            filename = sys.modules[frameClass.__module__].__file__
            # chop the .pyc or .pyo from the end
            base, ext = os.path.splitext(filename)
            filename = internationalResourceName(base)
            resource = res.ResourceFile(filename).getResource()
        else:
            if isinstance(resource, dict):
                resource = res.Resource(resource)
    else:
        resource = res.ResourceFile(filename).getResource()
        
    return frameClass(parent.stack, parent, resource.stack.backgrounds[0])


# KEA 2002-02-25
# custom event for running a pycrustrc.py file
# after openBackground event
wxEVT_RUN_PYCRUSTRC = wx.wxNewEventType()

def EVT_RUN_PYCRUSTRC(win, func):
    win.Connect(-1, -1, wxEVT_RUN_PYCRUSTRC, func)

class wxRunPycrustrcEvent(wx.wxPyEvent):
    def __init__(self):
        wx.wxPyEvent.__init__(self)
        self.SetEventType(wxEVT_RUN_PYCRUSTRC)

# KEA 2004-04-08
# custom event for hooking up the background events
# after openBackground event
# this means the initial idle, move, size, and activate events
# will not be available to PythonCard user code
wxEVT_LATENT_BACKGROUNDBIND = wx.wxNewEventType()

def EVT_LATENT_BACKGROUNDBIND(win, func):
    win.Connect(-1, -1, wxEVT_LATENT_BACKGROUNDBIND, func)

class wxLatentBackgroundBindEvent(wx.wxPyEvent):
    def __init__(self):
        wx.wxPyEvent.__init__(self)
        self.SetEventType(wxEVT_LATENT_BACKGROUNDBIND)


class PythonCardApp(wx.wxApp):
    """
    The runtime environment for PythonCard Stacks.
    """

    def __init__(self, frameClass, aFileName=None, rsrc=None):
        config.configOptions()
        showProperties = config.getOption('showPropertyEditor')
        showMessages = config.getOption('showMessageWatcher')
        enableLogging = config.getOption('enableLogging')
        showShell = config.getOption('showShell')
        showNamespace = config.getOption('showNamespace')
        showDebugMenu = config.getOption('showDebugMenu')

        if enableLogging:
            log.enable()

        # KEA save the current directory just in case
        self.startingDirectory = os.getcwd()
        # RDS - Need to get the absolute pathname of aFileName before
        # getting the directory name .
        # keep track of the path to prefix with
        self.applicationDirectory = util.dirname(os.path.abspath(sys.argv[0]))
        # always run in the app's directory
        os.chdir(self.applicationDirectory)

        if aFileName is None:
            if rsrc is None:
                filename = os.path.split(sys.argv[0])[-1]
                base, ext = os.path.splitext(filename)
                aFileName = internationalResourceName(base)

                # Load the user-defined resource file, 
                # validating it against spec.py
                self.resource = res.ResourceFile(aFileName).getResource()
            else:
                if isinstance(rsrc, dict):
                    rsrc = res.Resource(rsrc)
                self.resource = rsrc
        else:
            # Load the user-defined resource file, 
            # validating it against spec.py
            self.resource = res.ResourceFile(aFileName).getResource()

        self.debug = 0
        self.frame = None
        self.frameClass = frameClass
        self.pw = None
        self.mw = None
        self.shellFrame = None
        self.shell = None
        self.namespaceFrame = None
        self.namespace = None
        self._showProperties = showProperties 
        self._showMessages = showMessages
        self._showShell = showShell
        self._showNamespace = showNamespace
        # KEA 2001-08-11
        # if any of the debug windows are going to be used then
        # we will have a debug menu and all the windows will be available
        # but only the ones requested at startup will be visible initially
        # this seems like a nice compromise, but we can change the behavior
        # if it seems strange
        self._showDebugMenu = showProperties or showMessages or showShell or showNamespace or showDebugMenu
        ###self._debugMenu = debug.DebugMenu(self)
        # KEA 2004-01-02
        # moved colourdb initialization to work with wxPython 2.5
        # which requires a wxApp instance to exist before using colourdb
        ###colourdb.updateColourDB()   # KEA 2001-07-27
        wx.wxInitAllImageHandlers()
        wx.wxApp.__init__(self, 0)
        colourdb.updateColourDB()   # KEA 2001-07-27

        
    def showPropertyEditor(self):
        if self._showDebugMenu:
            bg = self.getCurrentBackground()
            position = config.getOption('propertyEditorPosition')
            size = config.getOption('propertyEditorSize')
            self.pw = debug.PropertyEditor(bg, -1, "Property Editor",
                              position, size,
                              parentApp=self)
            #self.pw.displayComponents(self._iterator.getCurrentBackground().findAllComponents())
            self.pw.displayComponents(bg.components)
            self.pw.Show(self._showProperties)

    def showMessageWatcher(self):

        if self._showDebugMenu:
            bg = self.getCurrentBackground()
            position = config.getOption('messageWatcherPosition')
            size = config.getOption('messageWatcherSize')
            # KEA frame isn't bound to anything, so I think this is supposed
            # to be debug.MessageWatcher( self._iterator.getCurrentBackground()
            # instead of debug.MessageWatcher( self.frame
            # however I don't know what happens once there are
            # multiple backgrounds ?!
            # perhaps there should always be a hidden parent PythonCard app
            # window that all other windows are children of ?!
            # KEA also changed mw to self.mw
            # KEA 2001-08-06
            # there is a bug in destroying the windows, so mw is still a child
            # of the main window, while shell and pw are not
            self.mw = debug.MessageWatcher(bg, -1, "Message Watcher",
                              position, size,
                              parentApp=self)
            self.mw.Show(self._showMessages)

    def showShell(self):

        # KEA 2002-04-22
        #if debug.PYCRUST_FOUND:
        # KEA 2002-06-27
        # the startup time associated with the shell
        # is noticeable even on a fast machine
        # so I'm going back to making it optional
        # there is a utility routine for an app to be able to
        # make the shell available without having it shown by
        # default
        if debug.PYCRUST_FOUND and self._showDebugMenu:
            # KEA see comments in showMessageWatcher about frames
            bg = self.getCurrentBackground()
            position = config.getOption('shellPosition')
            size = config.getOption('shellSize')
            self.shellFrame = debug.PyCrustFrame(bg, -1, 'Shell',
                                                 position, size,
                                                 parentApp=self)
            self.shellFrame.Show(self._showShell)
            #if self._showDebugMenu:
            #    self.shellFrame.Show(self._showShell)
            EVT_RUN_PYCRUSTRC(self, self.OnRunPycrustrc)
            wx.wxPostEvent(self, wxRunPycrustrcEvent())


    def showNamespace(self):

        if debug.PYCRUST_FOUND and self._showDebugMenu:
            # KEA see comments in showMessageWatcher about frames
            bg = self.getCurrentBackground()
            position = config.getOption('namespacePosition')
            size = config.getOption('namespaceSize')
            self.namespaceFrame = debug.PyCrustNamespaceFrame(bg, -1, 'Namespace Viewer',
                                                 position, size,
                                                 parentApp=self)
            self.namespaceFrame.Show(self._showNamespace)

    # wxWindows calls this method to initialize the application
    def OnInit(self):
        log.debug('Initializing Background...')
        self._stack = Stack(self, self.resource)
        bg = self._stack.getBackgrounds()[0]
        # KEA 2002-04-26
        # moved show to Background
        #bg.Show(1)

        if wx.wxPlatform == "__WXMAC__":
             try:
                 # in case WMAvailable doesn't exist
                 # use a try/except block
                 import MacOS
                 if not MacOS.WMAvailable():
                     print "This program needs access to the screen.\n" + \
                          "Please run with 'pythonw', not 'python', \n" + \
                          "and only when you are logged in on the main display of your mac."
             except:
                 pass

        self.showPropertyEditor()
        self.showMessageWatcher()
        self.showShell()        # KEA pyCrust support
        self.showNamespace()    # KEA pyCrust support
        return 1

    def getCurrentBackground(self):
        #return self._iterator.getCurrentBackground()
        return self._stack.getBackgrounds()[0]

    def OnRunPycrustrc(self, evt):
        #print "OnRunPycrustrc", self.shell
        if self.shell is not None:
            path = os.path.dirname(__file__)
            filename = os.path.join(path, 'pycrustrc.py')
            if os.path.exists(filename):
                try:
                    self.shell.runfile(filename)
                except:
                    pass

            # we will have already changed into the running module
            # directory, so this should be okay
            filename = os.path.join(self.applicationDirectory, 'pycrustrc.py')
            if os.path.exists(filename):
                try:
                    self.shell.runfile(filename)
                except:
                    pass

class Scriptable:
    """
    All classes that may contain PythonCard Handler definitions
    must implement Scriptable.

    A Scriptable object may be specified as the parent of
    this object.  The parent will be searched for Handlers
    if a Handler can't be found in this object.
    """

    def __init__(self, aScriptableParent):
        self._parentScript = aScriptableParent
        self._handlers = {}
        self._parseHandlers()

    # KEA 2002-05-05
    # Patrick, HELP! :)
    def _getObjects(self, object):
        listX = []
        if hasattr(object, '__class__'):
            for o in object.__class__.__dict__.itervalues():
                if self.isPythonCardHandler(o):
                    listX.append(o)
            listX += self._getObjects(object.__class__)
        else:
            for o in object.__dict__.itervalues():
                if self.isPythonCardHandler(o):
                    listX.append(o)
            
        # Also get attributes from any and all parent classes.
        if hasattr(object, '__bases__'):
            for base in object.__bases__:
                listX += self._getObjects(base)
        return listX

    # KEA 2004-03-05
    # this is just a placeholder
    # I think I have _getObjects working again
    # for wxPython 2.5 and recursive, multiple inheritance
    # but since it uses dir() and is radically simpler
    # than the previous code I want o keep track of my experiments
    def _getObjects25(self, object):
        listX = []
        names = dir(object.__class__)
        for name in names:
            a = getattr(object.__class__, name)
            if isinstance(a, types.MethodType) and a.__name__.split('_')[0] == 'on':
                #print "method:", a
                listX.append(a)
        """
        if hasattr(object, '__class__'):
            for o in object.__class__.__dict__.itervalues():
                if self.isPythonCardHandler(o):
                    listX.append(o)
            # KEA 2004-01-02
            # added isinstance check to avoid infinite recursion
            # with wxPython 2.5.x
            #print object.__class__
            print type(object)
            print "object", object
            print "class", object.__class__
            print "isinstance", isinstance(object.__class__, types.TypeType)
            print
            if not isinstance(object.__class__, types.TypeType):
                listX += self._getObjects25(object.__class__)
        else:
            for o in object.__dict__.itervalues():
                if self.isPythonCardHandler(o):
                    listX.append(o)
            
        # Also get attributes from any and all parent classes.
        if hasattr(object, '__bases__'):
            for base in object.__bases__:
                listX += self._getObjects25(base)
        """
        return listX
    
    def _parseHandlers(self):
        """
        Find all of the methods in this object that are
        PythonCard handlers, and register them.
        """
        """
        #objects = self.__class__.__dict__.itervalues()
        # KEA 2004-01-02
        # added isinstance check to avoid infinite recursion
        # with wxPython 2.5.x
        if wx.wxVERSION > (2, 5):
            pythoncardMethods = self._getObjects25(self)
        else:
            pythoncardMethods = self._getObjects(self)
        """
        # KEA 2004-03-05
        # an even slicker way of finding event handlers
        # using the inspect module
        pythoncardMethods = []
        methods = inspect.getmembers(self.__class__, inspect.ismethod)
        for m in methods:
            if m[0].split('_')[0] == 'on':
                pythoncardMethods.append(m[1])

        ##import pprint
        ##print "pprint"
        ##pprint.pprint(pythoncardMethods)
        #print pythoncardMethods
        #pythoncardMethods = filter(self.isPythonCardHandler, objects)
        map(self._addHandler, pythoncardMethods)

    def isPythonCardHandler(self, aObject):
        """
        Return true if the object is a PythonCard handler.
        """
        return isinstance(aObject, types.FunctionType) and aObject.__name__.split('_')[0] == 'on'

    # KEA 2001-09-07
    # I don't see much benefit to caching the handler list, it seems
    # like it would be much simpler to parse the dictionary each time
    # which will have a slight drop in efficiency, but greatly simplifies
    # the code, since the handlers dictionary goes away and doesn't need
    # to be kept in sync
    # I made the change to findLocalHandler below, but left the old _handler
    # code in until we know we don't need it
    
    def _addHandler(self, aMethod):
        # Add the Handler to our Handler list.
        if aMethod.__name__ not in self._handlers:
            log.debug("_addHandler: " + aMethod.__name__)
            self._handlers[aMethod.__name__] = event.Handler(aMethod)

    def addMethod(self, aFunction):
        if isinstance(aFunction, types.FunctionType):
            if self.isPythonCardHandler(aFunction) :
                #aMethod = new.instancemethod(aFunction, self, self.__class__)
                aMethod = new.instancemethod(aFunction, None, self.__class__)
                #print aFunction
                #print self.__class__
                #print aMethod.__name__
                #print aMethod
                self.__class__.__dict__[aMethod.__name__] = aMethod
                # now add the method info to our handler lookup dictionary
                # KEA 2001-11-29 simplified _addHandler
                #handler = event.Handler(aMethod.__name__, aMethod)
                #self._addHandler(aMethod.__name__, handler)
                self._addHandler(aMethod)
        
    def findHandler(self, aString):
        """
        Look for a Handler that matches aString in our 
        list of Handlers.  If a Handler is not found,
        ask our parent script to look for the Handler, 
        continuing up the Scriptable hierarchy until
        either a Handler is found, or None is returned.
        """
        handler = self.findLocalHandler( aString ) 

        if handler is not None :
            return handler

        # We couldn't find a handler, so look in our parent.

        if self._parentScript is not None :
            handler = self._parentScript.findHandler( aString )
        
        # have we found a Handler yet?

        if handler is not None :
            return handler
        

        # Change the handler name to target this Scriptable object
        # and look in our list of Handlers.

        words = aString.split('_')
        #print words, self._getName()
        #if len(words) == 2:
        #    print words
        #    aString = words[ 0 ] + '_' + words[ 1 ]
        #else:
        aString = words[0] + '_' + self._getName() + '_' + words[len(words) - 1]
        temp = self.findLocalHandler( aString )
        if temp is not None:
            return temp
        else:
            # search for Background and Stack handlers like
            # on_mouseClick, on_openBackground
            aString = words[0] + '_' + words[len(words) - 1]
            return self.findLocalHandler( aString )
        
    def findLocalHandler( self, aString ) :
        """
        Look for a Handler in our list of Handlers only.
        KEA 2001-09-07
        This version doesn't use a _handlers dictionary anymore
        it dynamically searches the current dictionary.
        I left the old _handlers initialization above in case
        we need to go back to it.
        """
        """
        aClass = self.__class__
        for key in aClass.__dict__.keys() :
            value = aClass.__dict__[ key ]
            if isinstance(value, types.FunctionType):
                if self._isHandler( value ) :
                    if value.__name__ == aString :
                        return Handler( value.__name__, value )
        
        """

        """
        for key in self._handlers.keys() :
            handler = self._handlers[ key ]
            if handler.getName() == aString :
                return handler
        return None
        """
        # KEA 2001-11-29 this should be equivelant to the above loop
        if aString in self._handlers:
            return self._handlers[aString]
        else:
            return None


class PythonCardObject( event.Changeable ) :
    """
    The superclass of Background and Card classes.  The unique id
    property is never repeated and is globally unique within a Stack?

    The name property is optional.

    The number property is dynamic...
    """

    def __init__( self ) :
        """
        Initialize this instance.
        """
        self.id = wx.wxNewId()
        self.name = ''
        event.Changeable.__init__( self )

    def getId( self ) :
        """
        Get the unique id of this object.
        """
        return self.id 

    def setName( self, name ) :
        """
        Set the name of this object.

        Q. Are we going to enforce unique names?
           Should they be unique to a Background
           or the entire stack?
        """
        oldName = self.name
        self.name = name 
        self.fireChanged( oldName )

    def _getName( self ) :
        """
        Get the name of this object.
        """
        return self.name 

class ObjectMap( event.ChangeListener ) :
    """
    Maintains a mapping of PythonCardObjects by name and
    id.
    """

    def __init__( self ) :
        """
        Initialize this instance.
        """
        self.objects = []
        self.idIndex = {}
        self.nameIndex = {}

    def listenTo( self, aPythonCardObject ) :
        """
        Register this object as a ChangeListener
        with aPythonCardObject.
        """
        aPythonCardObject.addChangeEventListener( self )

    def changed( self, aChangeEvent ) :
        """
        Called by a Changeable object that is referenced
        by this map.  The only current responsibility
        is to update the nameIndex.
        """
        object = aChangeEvent.getChangedObject()
        oldValue = aChangeEvent.getOldValue()
        assert object._getName() not in self.nameIndex, 'duplicate name! ' + oldValue
        del self.nameIndex[ oldValue ]
        self.nameIndex[ object._getName() ] = object

    def append( self, aPythonCardObject ) :
        """
        Append the object to our list of objects, and update
        the id and name indexes.
        """
        self.objects.append( aPythonCardObject )
        self._addToIndexes( aPythonCardObject )
        self.listenTo( aPythonCardObject )

    def insert( self, index, aPythonCardObject ) :
        """
        Insert the object to our list of objects at index, and update
        the id and name indexes.
        """
        assert index > -1 and index < ( len( self.objects ) - 1 ), 'index out of range!'
        self.objects.insert( index, aPythonCardObject )
        self._addToIndexes( aPythonCardObject )
        self.listenTo( aPythonCardObject ) 

    def deleteById( self, aUniqueId ) :
        """
        Delete the object identified by aUniqueId from the
        object list and the id and name indexes.
        """
        target = self.getById( aUniqueId )
        self._deleteFromIndexes( target )
        self._deleteFromObjects( target )

    def deleteByName( self, aString ) :
        """
        Delete the object with name==aString from the
        object list and the id and name indexes.
        """
        target = self.getByName( aString )
        self._deleteFromIndexes( target )
        self._deleteFromObjects( target )
    
    def deleteByNumber( self, aNumber ) :
        """
        Delete the object in the object list at index==aNumber
        from the object list and the id and name indexes.
        """
        aNumber = aNumber - 1 
        target = self.objects[ aNumber ]
        self._deleteFromIndexes( target )
        self._deleteFromObjects( target )

    def getFirstObject( self ) :
        """
        Get the first object in the objects list.
        """
        return self.objects[ 0 ]

    def getLastObject( self ) :
        """
        Get the last object in the objects list.
        """
        return self.objects[ -1 ]

    def getById( self, aUniqueId ) : # returns a PythonCardObject
        """
        Get an object by unique id.
        """
        return self.idIndex[ aUniqueId ]
    
    def getByName( self, aString ) :
        """
        Get an object by name.
        """
        assert aString in self.nameIndex, aString
        return self.nameIndex[ aString ]

    def getByNumber( self, aNumber ) :
        """
        Get an object by index.
        """
        aNumber = aNumber - 1 
        return self.objects[ aNumber ]

    def getIndexOfObject( self, aObject ) :
        """
        Return the index of aObject.
        """
        i = 1
        for object in self.objects :
            if object == aObject :
                return i
        return -1
    
    def getNumObjects( self ) :
        """
        Return the number of objects in this map.
        """
        return len( self.objects )

    def _addToIndexes( self, aPythonCardObject ) :
        """
        Add an object to the id and name indexes.
        """
        self.idIndex[ aPythonCardObject.getId() ] = aPythonCardObject
        self.nameIndex[ aPythonCardObject._getName() ] = aPythonCardObject

    def _deleteFromIndexes( self, aPythonCardObject ) :
        """
        Delete an object from the id and name indexes.
        """
        del self.idIndex[ aPythonCardObject.getId() ]
        del self.nameIndex[ aPythonCardObject._getName() ]
    
    def _deleteFromObjects( self, aPythonCardObject ) :
        """
        Delete the object from the object list.
        """
        uniqueId = aPythonCardObject.getId()
        for object in self.objects :
            if object.getId() == uniqueId :
                self.objects.remove( object )
                return

    def getObjects( self ) :
        return self.objects

# The number is a dynamic property, based on context.
# For example, the number of a Background is it's index
# in the enclosing Stack's list of Backgrounds.  And
# the number of a Card is it's index in the enclosing
# background's list of Cards.

    #def setNumber( self, number ) :
    #    self.number = number 

    #def getNumber( self ) :
    #    return self.number 

class Stack( PythonCardObject, Scriptable ) :
    """
    Models an application written for the PythonCard environment.
    """
   
    def __init__( self, aPythonCardApp, aResource ) :
        """
        Initialize this instance.
        """
        PythonCardObject.__init__( self )
        Scriptable.__init__( self, None )
        self.app = aPythonCardApp
        self.setName( aResource.stack.name )
        self.backgrounds = ObjectMap()
        self._initBackgrounds( aResource )
        self.curBg = self.backgrounds.getFirstObject()

    def _initBackgrounds( self, aResource ) :
        backgrounds = aResource.stack.backgrounds
        for bgRsrc in backgrounds :            
            #bg = self.app.frameClass( self, 1, aResource, bgRsrc )
            # KEA 2001-12-30
            # why was the id = 1 ???
            # we shouldn't even need to pass in the id
            bg = self.app.frameClass(self, None, bgRsrc)
            self.backgrounds.append(bg)

    def getBackgrounds(self):
        return self.backgrounds.getObjects()


#RDS-NEW-EVENTS: added EventSource

class Background(PythonCardObject, Scriptable, wx.wxFrame, event.EventSource):
    """
    A Background contains the Widgets
    that appear on the Background, and a list of Cards
    that contain data to be displayed in the Background.
    """

    def __init__(self, aStack, aParent, aBgRsrc):
        """
        Initialize this instance.
        """
        PythonCardObject.__init__(self )
        Scriptable.__init__(self, aStack)

        #RDS-NEW-EVENTS
        event.EventSource.__init__(self)

        self.stack = aStack
        self.resource = aBgRsrc
        self.id = wx.wxNewId()
        self.setName(aBgRsrc.name)
        #self.setForegroundColor(aBgRsrc.foregroundColor)
        #self.setBackgroundColor(aBgRsrc.backgroundColor)
        self.setImage(aBgRsrc.image)
        self.setTiled(aBgRsrc.tiled)
        self.components = WidgetDict(self)
        self.menuBar = None
        self.statusBar = None
        #RDS-NEW-EVENTS:
        self.dispatch = dispatch.EventDispatch(self, self)

        # override for application defined position
        position = config.getOption('defaultBackgroundPosition')
        if position is None:
            position = aBgRsrc.position

        # KEA 2004-01-18
        # have to explicitly declare the close box in wxPython 2.5
        #if wx.__version__ >= "2.5":
        if wx.wxVERSION > (2, 5):
            style = wx.wxMINIMIZE_BOX | wx.wxSYSTEM_MENU | wx.wxCAPTION | wx.wxCLOSE_BOX
        else:
            style = wx.wxMINIMIZE_BOX | wx.wxSYSTEM_MENU | wx.wxCAPTION
        if aBgRsrc.style == ['resizeable']:
            style = wx.wxDEFAULT_FRAME_STYLE
        # First, call the base class' __init__ method to create the frame
        wx.wxFrame.__init__(self, aParent,
                            self.id, 
                            #self.name,
                            aBgRsrc.title,
                            position,
                            aBgRsrc.size,
                            style | wx.wxNO_FULL_REPAINT_ON_RESIZE,
                            aBgRsrc.name)

        #RDS-NEW-EVENTS:
        #e = OpenBackgroundEvent( self )
        
        #EVT_OPEN_BACKGROUND(self, self.GetId(), self.OnOpenBackground)
        #EventBinding( self )
        #print "dispatching event"
        #evt = MyCustomEvent(myEVT_OPEN_BACKGROUND, self.GetId())
        #wxPostEvent(self, evt)
        #self.dispatch.eventOccurred( e )
        #print "dispatch completed"

        #RDS-EVEN-NEWER-EVENTS
        # NOTE: wxPython_SystemEventBinding should only be
        #       created once in the system?
        # KEA 2001-12-09
        # removed wxPython_binding.py module
        #system = wxPython_binding.wxPython_SystemEventBinding( self )
        system = binding.wxPython_SystemEventBinding( self )
        #print "dispatching event"
        system.postOpenBackgroundEvent()
        #print "dispatch completed"

        EVT_LATENT_BACKGROUNDBIND(self, self.OnLatentBackgroundBind)
        wx.wxPostEvent(self, wxLatentBackgroundBindEvent())

        self._initLayout(aBgRsrc.components)

        # KEA 2001-08-13
        # can't set the colors until after the panel
        # has been created. this initialization should probably work differently
        self.setForegroundColor(aBgRsrc.foregroundColor)
        self.setBackgroundColor(aBgRsrc.backgroundColor)

        self._createMenus(aBgRsrc)

        self._createStatusBar(aBgRsrc)

        # AJT 20.11.2001
        # Add icon creation
        self._setIcon(aBgRsrc)

        # 2001-11-08
        # hack to preserve the statusbar text
        if self.statusBar is not None and self.menuBar is not None:
            wx.EVT_MENU_HIGHLIGHT_ALL(self, self.menuHighlight)

        self._bindWindowEvents()

        if aParent is None:
            self.stack.app.SetTopWindow(self)

        # KEA 2002-04-26
        # allow background window to remain hidden 
        if aBgRsrc.visible:
            self.Show(1)

        # KEA 2002-06-10
        # attempt to hook up idle and other events
##        self._binding = binding.BackgroundEventBindingAdapter(self)
##        self._binding.bindEvents()
        self._closing = 0



    def OnLatentBackgroundBind(self, event):
        self._binding = binding.BackgroundEventBindingAdapter(self)
        self._binding.bindEvents()

    # KEA 2002-06-27
    # this is a way of loading the shell manually in an app
    # if the shell wasn't loaded at startup, so program
    # startup is quicker and take up less memory 
    # if the shell isn't needed
    def loadShell(self):
        if self.stack.app.shell is None:
            temp = self.stack.app._showDebugMenu
            self.stack.app._showDebugMenu = 1
            self.stack.app.showShell()
            self.stack.app._showDebugMenu = temp
            # KEA 2003-07-22
            # I don't think this is needed since showShell will
            # run the pycrustrc.py file(s)
            #self.stack.app.OnRunPycrustrc(None)

    def loadNamespace(self):
        self.loadShell()
        if self.stack.app.shell is None:
            # must have been a problem loading the shell
            return
        if self.stack.app.namespace is None:
            temp = self.stack.app._showDebugMenu
            self.stack.app._showDebugMenu = 1
            self.stack.app.showNamespace()
            self.stack.app._showDebugMenu = temp


    def setName( self, aString ) :
        self.name = aString

    def setBackgroundColor(self, aColor):
        self.panel.setBackgroundColor(aColor)

    def setForegroundColor(self, aColor):
        self.panel.setForegroundColor(aColor)

    def setImage(self, aPath):
        self.image = aPath
        # Call wxPython
        #raise NotImplementedError

    def setTiled(self, aBoolean):
        if isinstance(aBoolean, str):
            if aBoolean == 'false':
                aBoolean = False
            else:
                aBoolean = True
        self.tiled = aBoolean
        # Call wxPython
        #raise NotImplementedError

    def _getName(self):
        return self.name

    def getBackgroundColor(self):
        return self.panel.getBackgroundColor()

    def getForegroundColor(self):
        return self.panel.getForegroundColor()

    def getImage(self):
        return self.image

    def getTiled(self):
        return self.tiled

    def getPosition(self):
        return self.GetPositionTuple()

    def setPosition(self, aPosition):
        self.SetPosition(aPosition)

    def getSize(self):
        return self.GetSizeTuple()

    def setSize(self, aSize):
        self.SetSize(aSize)


    # KEA 2004-03-17
    # the get/set methods above will go away before PythonCard-1.0
    # so that we can just use new-style class properties
    
    def _getPosition(self):
        return self.GetPositionTuple()

    def _setPosition(self, aPosition):
        self.SetPosition(aPosition)

    def _getSize(self):
        return self.GetSizeTuple()

    def _setSize(self, aSize):
        self.SetSize(aSize)

    def _getBackgroundColor(self):
        return self.panel.getBackgroundColor()

    def _setBackgroundColor(self, aColor):
        self.panel.setBackgroundColor(aColor)

    def _getForegroundColor(self):
        return self.panel.getForegroundColor()

    def _setForegroundColor(self, aColor):
        self.panel.setForegroundColor(aColor)


    def enableCommand(self, aString):
        """
        Fined every component with a 'command' attribute
        that matches aString, and enable the component.
        """
        self.menuBar.enableCommand(aString)

        for component in self.components.itervalues():
            if component._getCommand() is aString:
                component.setEnabled(1)

    def disableCommand(self, aString):
        """
        Fined every component with a 'command' attribute
        that matches aString, and disable the component.
        """
        self.menuBar.disableCommand(aString)

        for component in self.components.itervalues():
            if component._getCommand() is aString:
                component.setEnabled(0)

    
    def _initLayout(self, aResourceList):
        """
        Create the gui Widgets for this Background and lay
        them out in a Frame.
        """
        self.panel = widget.Panel(self, self.image, self.tiled)

        for resource in aResourceList :
            self.components[resource.name] = resource

    # KEA 2002-05-02
    # always create at least a File menu with Quit on the Mac
    # so we automatically get the Apple menu...
    def _createMacMenu(self):
        mnu = wx.wxMenu()
        id = wx.wxNewId()
        mnu.Append(id, 'E&xit\tAlt+X')

        menubar = self.GetMenuBar()
        if menubar is None:
            menubar = wx.wxMenuBar()
            self.SetMenuBar(menubar)
        menubar.Append(mnu, 'File')
        wx.EVT_MENU(self, id, self.on_menuFileExit_select)

    # this might be a good or bad method name
    # it should be good and the user code shouldn't even have to define
    # this event handler, so Minimal becomes really minimal :)
    def on_menuFileExit_select(self, evt):
        self.Close()

    def _createMenus(self, aResource):
        # RDS - Only create a menubar if one is defined
        #       in the stack's resource file.
        #       This is a hack, I shouldn't be accessing
        #       the stack resource's __dict)__ directly.
        if ('menubar' in aResource.__dict__) and (aResource.menubar is not None):
            self.menuBar = menu.MenuBar(self, aResource.menubar)
        elif wx.wxPlatform == '__WXMAC__' and self.GetParent() is None:
            # always create at least a File menu with Quit on the Mac
            # so we automatically get the Apple menu...
            # KEA 2004-03-01
            # the elif was updated to make sure we only create a menubar
            # if the background has no parent, aka is the primary app window
            self._createMacMenu()

        # KEA and as a further hack, I now add a Debug menu
        # to the menubar. createMenu will create a menubar
        # if one doesn't already exist
        if self.stack.app._showDebugMenu and self.GetParent() == wx.NULL:
            self.stack.app._debugMenu = debug.DebugMenu(self.stack.app)
            self.stack.app._debugMenu.createMenu(self)
            self.stack.app._debugMenu.bindMenuEvents(self)

    # 2001-11-08
    # hack to keep the statusbar text from being wiped out
    def menuHighlight(self, event):
        self.statusBar.text = self.statusBar.text

    # KEA 2001-12-25
    # method now removes any existing statusbar if the resource
    # doesn't specify one
    # this is mostly for the resourceEditor and should have a clearer API
    def _createStatusBar( self, aResource ) :
        bar = self.GetStatusBar()
        if ('statusBar' in aResource.__dict__) and aResource.statusBar:
            if bar is None:
                self.statusBar = statusbar.StatusBar(self)
                self.SetStatusBar(self.statusBar._delegate)
        else:
            if bar is not None:
                self.SetStatusBar(None)
                bar.Destroy()
                # the statusbar changes the window size
                # so this will for it back
                #self.SetSize(self.GetSizeTuple())
                self.Fit()
            self.statusBar = None
            

    def _setIcon( self, aResource ) :
        """Set icon based on resource values"""
        if ('icon' in aResource.__dict__) and (aResource.icon is not None):
            try:
                icon = wx.wxIcon(aResource.icon, wx.wxBITMAP_TYPE_ICO)
                self.SetIcon(icon)
            except:
                pass
            

    def _bindWindowEvents( self ) :
        # Associate some events with methods of this class
        #wx.EVT_SIZE(self, self.OnSize)
        #wx.EVT_MOVE(self, self.OnMove)
        #wx.EVT_ICONIZE(self, self.OnMinimize)
        #wx.EVT_MAXIMIZE(self, self.OnMaximize)
        #wx.EVT_ACTIVATE(self, self.on_activate)
        #wx.EVT_CLOSE(self, self.on_close)
        wx.EVT_WINDOW_DESTROY(self, self.OnDestroy)

    """
    # KEA 2001-08-13
    # not just deprecated, but eradicated
    def find( self, target ) :
        warnings.warn("use components instead", DeprecationWarning)
        return self.components[target]

    def findByName( self, targetPath ) :
        # Find the widget that matches the name
        # identified in targetPath.
        warnings.warn("use components instead", DeprecationWarning)
        return self.components[targetPath]
    """
    
    def findId( self, targetPath ) :
        # Find the widget that matches the name
        # identified in targetPath.
        return self.getIDbyName( targetPath )

    def getIDbyName( self, widgetName ) :
        try:
            return self.components[ widgetName ].getId()
        except:
            return -1

    def getObjectByName( self, widgetName ) :
        try:
            return self.components[ widgetName ]
        except:
            return -1

#    def postEvent( self, aEvent ) : 
#        self.eventQueue.postEvent( aEvent )

    # KEA 2002-06-10
    # I don't think we actually need this anymore
    # the Destroy happens automatically?!
    #def OnCloseWindow(self, evt):
    def on_close2(self, evt):
        self._closing = 1
        """
        This method is called automatically when the CLOSE event is
        sent to this window.
        """
        """
        if self.stack.app.pw is not None:
            #print "closing property editor window"
            self.stack.app.pw.Destroy()
        #if self.stack.app.mw is not None:
            #print "closing message watcher window"
        #    self.stack.app.mw.Destroy()
        if self.stack.app.shellFrame is not None:
            #print "closing shell window"
            self.stack.app.shellFrame.Destroy()
        if self.stack.app.namespaceFrame is not None:
            #print "closing namespace window"
            self.stack.app.namespaceFrame.Destroy()
        """
        print "destroying main window"
        # tell the window to kill itself
        self.Destroy()

    # KEA 2002-07-09
    # make sure wxSTC text, bitmaps, etc. aren't lost
    # when the app exits
    def OnDestroy(self, evt):
        wx.wxTheClipboard.Flush()
        evt.Skip()

    def GetRestoredPosition(self):
        if self.IsIconized():
            return self._restoredPosition
        else:
            return self.GetPositionTuple()

    def GetRestoredSize(self):
        if self.IsIconized():
            return self._restoredSize
        else:
            return self.GetSizeTuple()

    def on_minimize(self, evt):
        #print "minimize", evt.Iconized()
        #print evt
        #print evt.GetTimestamp()
        #print "iconized", evt.Iconized()
        #print self.GetPositionTuple()
        #print self.GetSizeTuple()
        if evt.Iconized() and self.GetPositionTuple() != (-32000, -32000):
            self._restoredPosition = self.GetPositionTuple()
            self._restoredSize = self.GetSizeTuple()
        #print self.restoredPosition, self.restoredSize
        evt.Skip()

    def OnExit(self, evt):
        self.Close(1)

    def findAllComponents( self ) :
        """
        Return a copy of the list of Components in this
        Background.  We're not just returning 
        self.components.values because we don't want
        someone to inadvertently whack the internal list
        of Components.
        """
        components = []
        for component in self.components.itervalues() :
            components.append( component )
        return components

    def findComponentsByClass( self, aComponentClass ) :
        """
        Return a list of Component's that are instances
        of the specified Component class.
        """
        components = []
        for component in self.components.itervalues() :
            if isinstance( component, aComponentClass ) :
                components.append( component )
        return components

    # KEA 2001-07-31
    # we may want to put this someplace else, but we do need access
    # to the componenet list
    def findFocus( self ):
        widgetWX = wx.wxWindow_FindFocus() # the wxPython widget that has focus
        if widgetWX is None:
            return None
        else:
            id = widgetWX.GetId()
            components = self.findAllComponents()
            for widget in components:
                if id == widget.GetId():
                    return widget
        return None # is this even possible? focus in another window maybe?

    # KEA 2004-03-17
    # mixedCase aliases
    getParent = wx.wxFrame.GetParent
    
    # KEA 2004-03-17
    # define Python 2.2 new-style class properties
    if wx.wxVERSION > (2, 5):
        position = property(_getPosition, _setPosition, doc="position of the background") 
        size = property(_getSize, _setSize, doc="size of the background") 
        foregroundColor = property(_getForegroundColor, _setForegroundColor, doc="foregroundColor of the background") 
        backgroundColor = property(_getBackgroundColor, _setBackgroundColor, doc="backgroundColor of the background") 
        visible = property(wx.wxFrame.IsShown, wx.wxFrame.Show, doc="whether the background window is visible") 

class CustomDialog(PythonCardObject, Scriptable, wx.wxDialog, event.EventSource):
    """The dialog class used by all custom dialogs."""

    def __init__(self, aBg, aDialogRsrc=None):
        """
        Initialize this instance.
        """
        PythonCardObject.__init__( self )
        Scriptable.__init__( self, aBg.stack )

        #RDS-NEW-EVENTS
        ###event.EventSource.__init__( self )

        self.parent = aBg

        # KEA 2002-09-13
        # if a resource isn't provided, try and load
        # a default based on the name
        #print self.__class__
        #print self.__class__.__module__
        if aDialogRsrc is None:
            filename = sys.modules[self.__class__.__module__].__file__
            # chop the .pyc or .pyo from the end
            base, ext = os.path.splitext(filename)
            filename = internationalResourceName(base)
            aDialogRsrc = res.ResourceFile(filename).getResource()
        else:
            if isinstance(aDialogRsrc, dict):
                aDialogRsrc = res.Resource(aDialogRsrc)
        
        self.resource = aDialogRsrc

        self.id = wx.wxNewId()
        self.setName( aDialogRsrc.name )
        #self.setForegroundColor( aBgRsrc.foregroundColor )
        #self.setBackgroundColor( aBgRsrc.backgroundColor )
        #self.setImage( aDialogRsrc.image )
        #self.setTiled( aDialogRsrc.tiled )
        ###self.map = ObjectMap()
        ###self.newCard( '', None )
        #self.components = {}
        self.components = WidgetDict(self)
        ###self.menuBar = None
        ###self.statusBar = None
        #RDS-NEW-EVENTS:
        ###self.dispatch = dispatch.EventDispatch( self, self )

        # First, call the base class' __init__ method to create the frame
        #wxFrame.__init__( self, None,   
        wx.wxDialog.__init__( self, None,   
                          -1, 
                          aDialogRsrc.title,
                          aDialogRsrc.position, 
                          aDialogRsrc.size )

        self._delegate = self
        self._initLayout( aDialogRsrc.components )

        # KEA 2001-08-13
        # can't set the colors until after the panel
        # has been created. this initialization should probably work differently
        ###self.setForegroundColor( aBgRsrc.foregroundColor )
        ###self.setBackgroundColor( aBgRsrc.backgroundColor )

        ###self._createMenus( aStackRsrc )

        ###self._createStatusBar( aStackRsrc )

        ###self._bindWindowEvents()

        ###self.stack.app.SetTopWindow( self )
 
        #RDS-NEW-EVENTS:
        #e = OpenBackgroundEvent( self )
        
        #EVT_OPEN_BACKGROUND(self, self.GetId(), self.OnOpenBackground)
        #EventBinding( self )
        #print "dispatching event"
        #evt = MyCustomEvent(myEVT_OPEN_BACKGROUND, self.GetId())
        #wxPostEvent(self, evt)
        #self.dispatch.eventOccurred( e )
        #print "dispatch completed"

        #RDS-EVEN-NEWER-EVENTS
        # NOTE: wxPython_SystemEventBinding should only be
        #       created once in the system?
        ###system = wxPython_binding.wxPython_SystemEventBinding( self )
        #print "dispatching event"
        ###system.postOpenBackgroundEvent()
        #print "dispatch completed"


    #def _getDelegate( self ) :
    #    return self._delegate


    # KEA 2001-10-14
    # this is from ModalDialog in dialog.py
    def showModal(self):
        # KEA added wxID_YES to accepted condition
        # and added a returned value
        #self.Show(true)
        #self.MakeModal(true)
        ###self.parent.stack.app.SetTopWindow( self )
        ###self._returned = wxID_OK #self.ShowModal()
        """"""
        self._accepted = 0
        #print "wxID_OK", wxID_OK, wxID_CANCEL, wxID_YES, wxID_NO
        self._returned = self.ShowModal()
        #print "self._returned", self._returned
        if self._returned == wx.wxID_OK or self._returned == wx.wxID_YES:
            self._accepted = 1
        """"""
        ###self.MakeModal(false)
        # KEA don't destroy until after we get the results
        # so self._destroy() added to each dialog class below
        #self._destroy()

    # KEA should these be getAccepted, getReturned?
    def accepted( self ) :
        return self._accepted

    # KEA added accessor for self._returned
    # should we just return numeric values instead?
    # should the the strings all be lowercase
    # Ok is actually displayed as OK in dialogs
    def returned( self ) :
        ret = self._returned
        for w in self.components.itervalues():
            if ret == w.getId():
                return w.label

    def destroy( self ) :
        self.Destroy()


    def setName( self, aString ) :
        self.name = aString

    """
    def setBackgroundColor(self, aColor):
        self.panel.setBackgroundColor(aColor)

    def setForegroundColor(self, aColor):
        self.panel.setForegroundColor(aColor)
    """
    
    def _getName( self ) :
        return self.name

    """
    def getBackgroundColor(self):
        return self.panel.getBackgroundColor()

    def getForegroundColor(self):
        return self.panel.getForegroundColor()
    """
    
    def getPosition( self ) :
        return self.GetPositionTuple()

    def setPosition( self, aPosition ) :
        self.SetPosition(aPosition)

    def getSize( self ) :
        return self.GetSizeTuple()

    def setSize( self, aSize ) :
        self.SetSize(aSize)


    # KEA 2004-03-17
    # the get/set methods above will go away before PythonCard-1.0
    # so that we can just use new-style class properties
    
    def _getPosition(self):
        return self.GetPositionTuple()

    def _setPosition(self, aPosition):
        self.SetPosition(aPosition)

    def _getSize(self):
        return self.GetSizeTuple()

    def _setSize(self, aSize):
        self.SetSize(aSize)


    def enableCommand( self, aString ) :
        """
        Fined every component with a 'command' attribute
        that matches aString, and enable the component.
        """
        self.menuBar.enableCommand( aString )

        for component in self.components.itervalues() :
            if component._getCommand() is aString :
                component.setEnabled( 1 )

    def disableCommand( self, aString ) :
        """
        Fined every component with a 'command' attribute
        that matches aString, and disable the component.
        """
        self.menuBar.disableCommand( aString )

        for component in self.components.itervalues() :
            if component._getCommand() is aString :
                component.setEnabled( 0 )

    
    def _initLayout( self, aResourceList ) :
        """
        Create the gui Widgets for this Dialog and lay
        them out in the panel.
        """
        self.panel = self
        for resource in aResourceList :
            self.components[resource.name] = resource

    def _createStatusBar( self, aResource ) :
        if ('statusBar' in aResource.stack.__dict__) and aResource.stack.statusBar:
            self.statusBar = statusbar.StatusBar(self)
            self.SetStatusBar(self.statusBar._delegate)


    def _bindWindowEvents( self ) :
        # Associate some events with methods of this class
        # KEA 2002-06-10
        # this shouldn't be bound, should it?!
        #EVT_CLOSE(self, self.OnCloseWindow) # KEA 2001-08-06
        pass


    def findId( self, targetPath ) :
        # Find the widget that matches the name
        # identified in targetPath.
        return self.getIDbyName( targetPath )


    def getIDbyName( self, widgetName ) :
        try:
            return self.components[ widgetName ].getId()
        except:
            return -1

    def getObjectByName( self, widgetName ) :
        try:
            return self.components[ widgetName ]
        except:
            return -1


    def findAllComponents( self ) :
        """
        Return a copy of the list of Components in this
        Background.  We're not just returning 
        self.components.values because we don't want
        someone to inadvertently whack the internal list
        of Components.
        """
        components = []
        for component in self.components.itervalues() :
            components.append( component )
        return components

    def findComponentsByClass( self, aComponentClass ) :
        """
        Return a list of Component's that are instances
        of the specified Component class.
        """
        components = []
        for component in self.components.itervalues() :
            if isinstance( component, aComponentClass ) :
                components.append( component )
        return components

    # KEA 2001-07-31
    # we may want to put this someplace else, but we do need access
    # to the componenet list
    def findFocus( self ):
        widgetWX = wx.wxWindow_FindFocus() # the wxPython widget that has focus
        id = widgetWX.GetId()
        components = self.findAllComponents()
        for widget in components:
            if id == widget.GetId():
                return widget
        return None # is this even possible? focus in another window maybe?

    # these shouldn't be necessary
    # but I haven't taken the time to figure out what is messed up in
    # the event dispatch that keeps event.Skip from being called automatically
    # there might be a problem specific to wxDialog
    def on_mouseClick(self, event):
        event.Skip()

    # KEA 2004-03-17
    # mixedCase aliases
    getParent = wx.wxDialog.GetParent

    # KEA 2004-03-17
    # define Python 2.2 new-style class properties
    if wx.wxVERSION > (2, 5):
        position = property(_getPosition, _setPosition, doc="position of the dialog") 
        size = property(_getSize, _setSize, doc="size of the dialog") 
        visible = property(wx.wxDialog.IsShown, wx.wxDialog.Show, doc="whether the dialog is visible") 

##    def on_btnOK_mouseClick(self, event):
##        event.Skip()
##
##    def on_btnCancel_mouseClick(self, event):
##        event.Skip()
