#!/usr/bin/python

"""
__version__ = "$Revision: 1.4 $"
__date__ = "$Date: 2004/04/07 23:41:09 $"
"""

from wxPython import wx
print "wxPython", wx.__version__

from PythonCardPrototype import model

class Minimal(model.Background):

    # background events
    
    def on_openBackground(self, event):
        print "openBackground"
        self.num_idles = 0

    def on_initialize(self, event):
        print "initialize", event.GetEventObject()
        self.num_idles = 0
        event.Skip()

    def on_activate(self, event):
        print "activate", event.target.name
        event.Skip()

    def on_close(self, event):
        print "close", event.target.name
        event.Skip()

    def on_idle(self, event):
        # prevent idle message flood
        self.num_idles += 1
        if self.num_idles < 5:
            print "idle", event.target.name
        event.Skip()

    def on_maximize(self, event):
        print "maximize", event.target.name
        event.Skip()

    def on_minimize(self, event):
        print "minimize", event.target.name
        event.Skip()

    def on_move(self, event):
        print "move", event.target.name
        event.Skip()

    def on_size(self, event):
        print "size", event.target.name
        event.Skip()

    # component events
    # try using lowercase skip alias
    def on_gainFocus(self, event):
        print "gainFocus", event.target.name
        event.skip()

    def on_loseFocus(self, event):
        print "loseFocus", event.target.name
        event.skip()

    def on_keyPress(self, event):
        print "keyPress", event.target.name
        event.skip()

    def on_mouseDown(self, event):
        print "mouseDown", event.target.name
        event.skip()

    def on_mouseUp(self, event):
        print "mouseUp", event.target.name
        event.skip()

    def on_mouseClick(self, event):
        print "mouseClick", event.target.name
        event.skip()

    def on_menuFileExit_select(self, event):
        self.Close()


if __name__ == '__main__':
    app = model.PythonCardApp(Minimal)
    app.MainLoop()
