\input texinfo   @c -*- mode: texinfo; sentence-end-double-space: t; -*-
@c %**start of header
@setfilename pyxmms-remote.info
@settitle _prg Manual
@c %**end of header

@c @include version.texi

@dircategory Sound
@direntry
* PyXMMS-remote: (pyxmms-remote). A command-line interface to XMMS.
@end direntry

@ifnottex
This file documents _prg.

Copyright (c) 2002, 2003 Florent Rougon.

This document is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2, as
published by the Free Software Foundation.

This document is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

A copy of the GNU General Public License is included in the section
entitled ``GNU General Public License''.
@end ifnottex

@titlepage
@title _prg
@subtitle A command-line interface for _xmms
@author Florent Rougon
@page
@vskip 0pt plus 1filll
Copyright @copyright{} 2002, 2003 Florent Rougon.

This document is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2, as
published by the Free Software Foundation.

This document is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
General Public License for more details.

A copy of the GNU General Public License is included in the section
entitled ``GNU General Public License''.
@end titlepage

@ifnottex
@node Top, Introduction, (dir), (dir)
@top _prg

_prg is a @uref{http://www.python.org/, Python} program using _bd to
control an _xmms session.

This manual documents _prg.
@end ifnottex

@menu
* Introduction::                
* Invoking _prg::               
* Command reference::           
* Environment variables::       
* Setup tips::                  
* Copying::                     
* Index::                       

@detailmenu
 --- The Detailed Node Listing ---

Command reference

* Commands from libxmms::       
* Commands specific to _bd::    

Setup tips

* Midnight commander::          
* MIME support::                

@end detailmenu
@end menu

@node Introduction, Invoking _prg, Top, Top
@unnumbered Introduction

_prg is a @uref{http://www.python.org/, Python} program using _bd to
control an _xmms session. _prg is free software. _prg is licensed
under the GNU GPL version 2.

Notes:
@itemize
@item
@cindex _xmms
_xmms (the _xmmslong) is a multimedia player written for the
_xwindowsytem. _xmms provides a library (libxmms) that contains
functions providing full control over an _xmms session from an
external program. The official _xmms home page is located at
@uref{http://www.xmms.org/}.

@item 
@cindex _bd
_bd is a set of Python bindings for libxmms, including higher-level
interfaces than that provided by libxmms.
@end itemize

With _prg, you can tell or retrieve quite a lot of things to/from an
_xmms session with shell commands (or shell scripts or whatever you
want, but if what you want to do is @emph{really} complex, you'd
better use _bd directly).

The following command tells the _xmms session 0 (default) to start
playing the current playlist entry:

@example
_prgcmd play
@end example

The following command tells the _xmms session number 2 to stop playing:

@example
_prgcmd -s 2 stop
@end example

Here is a way to:
@itemize
@item
start _xmms if necessary

@item
add some entries (files or URLs) to the playlist

@item
start playing from the first entry added
@end itemize

@example
_prgcmd E entry...
@end example

@noindent
equivalent to the not-so-short following command:

@example
_prgcmd enqueue_and_play_launch_if_session_not_started entry...
@end example

@node Invoking _prg, Command reference, Introduction, Top
@chapter How to use this program

@cindex invoking _prg
@cindex synopsis
The general form of a valid invocation of _prg is:

@example
_prgcmd [@var{option}]@dots{} @var{command} [@var{command_argument}]@dots{}
@end example

@noindent
where the valid options are:

@table @samp
@item -s @var{session}
@itemx --session=@var{session}
The _xmms session to control. If you simply launched one instance of
_xmms, it should be your session 0 (each Unix user has its own session
numbering scheme). This setting defaults to 0.

@item -p @var{prg}
@itemx --program=@var{prg}
The executable to invoke with the command
@samp{enqueue_and_play_launch_if_session_not_started} (or @samp{E}) if
the selected _xmms session (as defined by the @samp{-s} option) is not
already running. The default is @samp{xmms}. The PATH variable is
searched if necessary.

@item -f @var{decimals}
@itemx --floats-precision=@var{decimals}
The number of decimals displayed for floats by commands such as
@samp{get_eq}. The default is 2.

@item --help
Display usage information and exit.
@end table

@node Command reference, Environment variables, Invoking _prg, Top
@chapter Command reference
@cindex command reference
@cindex reference of the available commands
@cindex list of the available commands

@menu
* Commands from libxmms::       
* Commands specific to _bd::    
@end menu

@node Commands from libxmms, Commands specific to _bd, Command reference, Command reference
@section Commands from libxmms
@cindex libxmms functions' bindings

The following commands are direct bindings to the @samp{xmms_remote_*}
functions of libxmms.

@table @code
@item playlist @var{file_or_url}@dots{} @var{enqueue}
Set the playlist contents or enqueue files/URLs in it.

@c XXXwatch
@var{enqueue} should be a boolean (0 = false, 1 = true); false does
not work in _xmms 1.2.6.

@item playlist_add @var{file_or_url}@dots{}
Add files/URLs to the playlist.

@item playlist_delete @var{entry_number}
Delete the playlist entry number @var{entry_number} (starting at 0).

@item playlist_clear
Clear the playlist.

@item playlist_add_url_string @var{string}
@itemx add_url_to_playlist @var{string}
Add @var{string} (file or URL) to the playlist.

@item playlist_ins_url_string @var{string} @var{pos}
@itemx insert_url_into_playlist_at_pos @var{string} @var{pos}
Insert @var{string} (file or URL) at position @var{pos} (index
starting at 0) in the playlist.

@item get_playlist_length
Get the playlist length (number of files/URLs).

@item get_playlist_pos
Get the current playlist position (index starting at 0).

@item set_playlist_pos @var{pos}
Set the current playlist position to @var{pos} (index starting at 0).

@item get_playlist_file @var{entry}
Get the absolute file name corresponding to the entry @var{entry}
(index starting at 0) in the playlist.

@item get_playlist_title @var{entry}
Get the title of the entry @var{entry} (index starting at 0) in the
playlist.

@item get_playlist_time @var{entry}
Get the duration in milliseconds of a the entry @var{entry} in the playlist.

@item play
Play the current playlist entry.

@item pause
Pause.

@item play_pause
Play or pause (toggle).

@item stop
Stop.

@item eject
Show the eject dialog box.

@item playlist_prev
Jump to the previous entry in the playlist.

@item playlist_next
Jump to the next entry in the playlist.

@item jump_to_time @var{milliseconds}
Jump to the given time since the beginning of the current playlist
entry.

Note: at least in _xmms 1.2.7, the resolution seems to be 1 second
although the time to jump to is given in milliseconds.

@item is_running
Tell whether the selected _xmms session is running (0 means ``no'', 1
means ``yes'').

@item is_playing
Tell whether the selected _xmms session is playing (0 means ``no'', 1
means ``yes''). When in pause, _xmms is considered to be playing for
this command.

@item is_paused
Tell whether the selected _xmms session is paused (0 means ``no'', 1
means ``yes'').

@item get_output_time
Get the time in milliseconds since the beginning of the current
playlist entry.

@item get_info
Get information about the current playlist entry, namely its rate (in
bps), its frequency (in Hz) and its number of channels (1=mono,
2=stereo@dots{}).

@item get_volume
Get left and right volumes.

@item set_volume @var{left_volume} @var{right_volume}
Set left and right volumes.

@item get_main_volume
Get the greater of left and right volumes.

@item set_main_volume @var{volume}
Set the ``main'' volume. The left and right volumes are calculated
(and set) from the supplied @var{volume} argument and the current
balance.

@item get_balance
Get the balance value.

@item set_balance @var{value}
Set the balance according to @var{value} (-100 means ``100% left'', 0
means ``centered'', 100 means ``100% right'').

@item get_eq
Get the equalizer settings (preamp and gain in dB for the ten frequency
bands defined in _xmms).

@item set_eq @var{preamp} @var{band0} @var{band1}@dots{} @var{band9}
Set the equalizer settings (preamp and gain in dB for the ten
frequency bands defined in _xmms). @var{band0} corresponds to the
lowest frequency and @var{band9} to the highest frequency.

@item get_eq_preamp
Get the equalizer preamp value in dB.

@item set_eq_preamp @var{gain}
Set the equalizer preamp value to @var{gain} (in dB).

@item get_eq_band @var{band_number}
Get the gain (in dB) for band @var{band_number} (between 0 and 9, both
inclusive).

@item set_eq_band @var{band_number} @var{gain}
Set the gain for band @var{band_number} (between 0 and 9, both
inclusive) to @var{gain} (in dB).

@item get_skin
Get the current skin absolute file name.

@item set_skin @var{absolute_file_name}
Set the skin from @var{absolute_file_name}.

@item main_win_toggle @var{display}
@itemx main_win_set_visible @var{display}
Hide (if @var{display} is 0) or show (if @var{display} is 1) the main
window (yes, this is not a real @emph{toggle} function).

@item pl_win_toggle @var{display}
@itemx playlist_win_set_visible @var{display}
Hide (if @var{display} is 0) or show (if @var{display} is 1) the playlist
window (yes, this is not a real @emph{toggle} function).

@item eq_win_toggle @var{display}
@itemx equalizer_win_set_visible @var{display}
Hide (if @var{display} is 0) or show (if @var{display} is 1) the equalizer
window (yes, this is not a real @emph{toggle} function).

@item is_main_win
Tell whether the main window is visible (0 means ``no'', 1 means
``yes'').

@item is_pl_win
Tell whether the playlist window is visible (0 means ``no'', 1 means
``yes'').

@item is_eq_win
Tell whether the equalizer window is visible (0 means ``no'', 1 means
``yes'').

@item show_prefs_box
Show the preferences dialog box.

@item show_about_box
Show about box. Does not to work in _xmms 1.2.6 and 1.2.8 (at least).

@item toggle_aot @var{always}
@itemx set_always_on_top_state @var{always}
@c XXX weird XMMS code to watch
Set the always-on-top flag for the main window. @var{always} should be
a boolean (0 or 1), but the implementation of this function in _xmms
1.2.6 looks weird to me, so I cannot tell you more about @var{always}
than ``it seems not to be used''. This function still does not seem to
work in _xmms 1.2.8.

@item toggle_repeat
Toggle repeat mode.

@item toggle_shuffle
Toggle shuffle mode.

@item is_repeat
Tell whether repeat mode is active (0 means ``no'', 1 means ``yes'').

@item is_shuffle
Tell whether shuffle mode is active (0 means ``no'', 1 means ``yes'').

@item get_version
Get version (of what?).

@noindent
The code fragment that answers this request in _xmms 1.2.6 is:

@example
  case CMD_GET_VERSION:
          ctrl_write_gint(pkt->fd, 0x09a3);
          ...
@end example

@noindent
I suspect it is the version of the protocol in use through the _xmms
control socket (which is how libxmms talks to _xmms, by the way). If
you understand this better than I, please let me know.

@item quit
Quit the selected _xmms session.

@item play_files @var{file_or_url}@dots{} (@strong{deprecated in libxmms})
Clear the playlist, add the specified files/URLs to it and start
playing. This function is deprecated. Use a combination of
@code{playlist} and @code{play} instead.
@end table

@node Commands specific to _bd,  , Commands from libxmms, Command reference
@section Commands specific to _bd
@cindex _bd specific functions

The following commands are bindings to functions of _bd which are not
defined in libxmms---but very likely to be implemented with functions
of libxmms.

@table @code
@item a @var{file_or_url}@dots{}
@itemx playlist_add_allow_relative @var{file_or_url}@dots{}
Add files/URLs to the playlist, allowing relative file names.

@item e @var{file_or_url}@dots{}
@itemx enqueue_and_play @var{file_or_url}@dots{}
Add files/URLs to the playlist and start playing from the first one
(that is, the first @var{file_or_url} argument specified).

@item E @var{file_or_url}@dots{}
@itemx enqueue_and_play_launch_if_session_not_started @var{file_or_url}@dots{}
Add files/URLs to the playlist and start playing from the first one
(that is, the first @var{file_or_url} argument specified). This
command is identical to enqueue_and_play except that it spawns an
_xmms process if the selected session is not running.

@item fade_out [@var{action} [@var{nb_steps} [@var{step_duration} [@var{restore_volume}]]]]
Progressively decrease the main volume, then stop or pause (depending
on @var{action}), then optionally restore the original main volume
setting.

@table @code
@item action
Whether to stop or pause the playback after the fade out. Valid values
are @code{stop} and @code{pause}. Default is @code{stop}.

@item nb_steps
Number of decrease-volume steps to use (default is 20)

@item step_duration
Duration of a step (floating point number, in seconds; default is 0.5)

@item restore_volume
Whether to restore the main volume after the fade out. Valid values
are @code{1} to have the volume restored and @code{0} to have it
remain at 0. Default is @code{1}.

@end table
@end table

@node Environment variables, Setup tips, Command reference, Top
@chapter Environment variables
@cindex Environment variables

There is currently one environment variable specific to _prg:
PYXMMS_REMOTE_XMMS_PRG. This sets the _xmms executable name (absolute
or relative) just as the @samp{-p} option.

Note: command-line options take precedence over environment variables.

@node Setup tips, Copying, Environment variables, Top
@chapter Setup tips

@menu
* Midnight commander::          
* MIME support::                
@end menu

@node Midnight commander, MIME support, Setup tips, Setup tips
@section Midnight commander

You can use a rule like:

@example
regex/\.([mM][pP]3|[oO][gG][gG]|[mM]3[uU])$
        Open=_prgcmd E %s
        View=_prgcmd E %s
	Icon=sound.xpm
@end example

in your @file{~/.mc/bindings} (personal) or @file{/etc/mc/mc.ext}
(system-wide, and might be located elsewhere in your system---this is
the @uref{http://www.debian.org/, Debian} location).

This way, you will enqueue and play (as well as launch _xmms before if
necessary) the selected file(s) when you press @kbd{Enter} or
@kbd{F3}.

@node MIME support,  , Midnight commander, Setup tips
@section MIME support

You can associate a _prg invocation with the MIME types
``application/ogg'' (cf. RFC 3534), ``application/x-ogg'' (used when
``application/ogg'' was not yet registered as an official MIME type),
``audio/mpeg'' and ``audio/x-mpegurl''. On a
@uref{http://www.debian.org/, Debian} system (with the mime-support
package), this can be done with the following lines in your
@file{~/.mailcap} or the system-wide @file{/etc/mailcap} (if for some
reason you did not install the Debian package for _prg):

@example
application/ogg; _prgcmd E "%s"; test=test -n "$DISPLAY"
application/x-ogg; _prgcmd E "%s"; test=test -n "$DISPLAY"
audio/mpeg; _prgcmd E "%s"; test=test -n "$DISPLAY"
audio/x-mpegurl; _prgcmd E "%s"; test=test -n "$DISPLAY"
@end example

@node Copying, Index, Setup tips, Top
@appendix GNU GENERAL PUBLIC LICENSE
@cindex GNU GPL
@center Version 2, June 1991

@display
Copyright @copyright{} 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.
@end display

@unnumberedsec Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software---to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

@iftex
@unnumberedsec TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
@end iftex
@ifinfo
@center TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
@end ifinfo

@enumerate 0
@item
This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The ``Program,'' below,
refers to any such program or work, and a ``work based on the Program''
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term ``modification.'')  Each licensee is addressed as ``you.''

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

@item
You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

@item
You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

@enumerate a
@item
You must cause the modified files to carry prominent notices
stating that you changed the files and the date of any change.

@item
You must cause any work that you distribute or publish, that in
whole or in part contains or is derived from the Program or any
part thereof, to be licensed as a whole at no charge to all third
parties under the terms of this License.

@item
If the modified program normally reads commands interactively
when run, you must cause it, when started running for such
interactive use in the most ordinary way, to print or display an
announcement including an appropriate copyright notice and a
notice that there is no warranty (or else, saying that you provide
a warranty) and that users may redistribute the program under
these conditions, and telling the user how to view a copy of this
License.  (Exception: if the Program itself is interactive but
does not normally print such an announcement, your work based on
the Program is not required to print an announcement.)
@end enumerate

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

@item
You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

@enumerate a
@item
Accompany it with the complete corresponding machine-readable
source code, which must be distributed under the terms of Sections
1 and 2 above on a medium customarily used for software interchange; or,

@item
Accompany it with a written offer, valid for at least three
years, to give any third party, for a charge no more than your
cost of physically performing source distribution, a complete
machine-readable copy of the corresponding source code, to be
distributed under the terms of Sections 1 and 2 above on a medium
customarily used for software interchange; or,

@item
Accompany it with the information you received as to the offer
to distribute corresponding source code.  (This alternative is
allowed only for noncommercial distribution and only if you
received the program in object code or executable form with such
an offer, in accord with Subsection b above.)
@end enumerate

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

@item
You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

@item
You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

@item
Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

@item
If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

@item
If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

@item
The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and ``any
later version,'' you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

@item
If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

@iftex
@heading NO WARRANTY
@end iftex
@ifinfo
@center NO WARRANTY
@end ifinfo

@item
BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW@.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM ``AS IS'' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE@.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU@.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

@item
IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.
@end enumerate

@iftex
@heading END OF TERMS AND CONDITIONS
@end iftex
@ifinfo
@center END OF TERMS AND CONDITIONS
@end ifinfo

@page
@unnumberedsec How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the ``copyright'' line and a pointer to where the full notice is found.

@smallexample
@var{one line to give the program's name and an idea of what it does.}
Copyright (C) 19@var{yy}  @var{name of author}

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE@.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
@end smallexample

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

@smallexample
Gnomovision version 69, Copyright (C) 20@var{yy} @var{name of author}
Gnomovision comes with ABSOLUTELY NO WARRANTY; for details
type `show w'.  This is free software, and you are welcome
to redistribute it under certain conditions; type `show c' 
for details.
@end smallexample

The hypothetical commands @samp{show w} and @samp{show c} should show
the appropriate parts of the General Public License.  Of course, the
commands you use may be called something other than @samp{show w} and
@samp{show c}; they could even be mouse-clicks or menu items---whatever
suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a ``copyright disclaimer'' for the program, if
necessary.  Here is a sample; alter the names:

@smallexample
@group
Yoyodyne, Inc., hereby disclaims all copyright
interest in the program `Gnomovision'
(which makes passes at compilers) written 
by James Hacker.

@var{signature of Ty Coon}, 1 April 1989
Ty Coon, President of Vice
@end group
@end smallexample

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.

@node Index,  , Copying, Top
@unnumbered Index

@printindex cp

@contents
@bye
