/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QALCULATE_KDE_UTILS_H
#define QALCULATE_KDE_UTILS_H

#include <libqalculate/qalculate.h>
#undef insertItem
#undef addItem
#undef setItem
#undef getItem

#include <qstring.h>

class QLabel;
class QLineEdit;

struct tree_struct {
	string item;
	list<tree_struct> items;
	list<tree_struct>::iterator it;
	list<tree_struct>::reverse_iterator rit;
	vector<void*> objects;	
	tree_struct *parent;
	void sort() {
		items.sort();
		for(list<tree_struct>::iterator it = items.begin(); it != items.end(); ++it) {
			it->sort();
		}
	}
	bool operator < (tree_struct &s1) const {
		return item < s1.item;	
	}	
};
struct mode_struct {
	PrintOptions po;
	EvaluationOptions eo;
	AssumptionType at;
	AssumptionSign as;
	int precision;
	QString name;
};

void insert_text_in_expression(const QString  &str);
bool is_answer_variable(Variable *v);
QString get_value_string(const MathStructure &mstruct_, bool rlabel = false, Prefix *prefix = NULL);
void set_name_label_and_entry(ExpressionItem *item, QLineEdit *entry, QLabel *label);
bool can_display_unicode_string_function(const char *str, void *arg);
void generate_units_tree_struct();
void generate_functions_tree_struct();
void generate_variables_tree_struct();
size_t save_mode_as(QString name, bool *new_mode = NULL);

#endif
