/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateinsertfunctiondialog.h"
#include "qalculate_kde_utils.h"
#include <qvbox.h>
#include <kactivelabel.h>
#include <klineedit.h>
#include <qlabel.h>
#include <qgrid.h>
#include <qhbox.h>
#include <klocale.h>
#include <qspinbox.h>
#include <kcombobox.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <kdatepicker.h>
#include <kfiledialog.h>
#include <kdeversion.h>
#include <kstdguiitem.h>
#include "buttonwithindexsignal.h"
#include "qalculateinsertmatrixvectordialog.h"

extern QWidget *expressionWidget;
extern PrintOptions printops;

QalculateInsertFunctionDialog::QalculateInsertFunctionDialog(MathFunction *f, QWidget *parent, const QString &selected_text, const char *name) : KDialogBase(parent, name, true, f->title(true).c_str(), Ok|Apply|Cancel, Ok) {

#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 2
	setButtonOKText(i18n("Insert"));
	setButtonApplyText(i18n("Execute"));
#else
#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 3
	setButtonOK(KGuiItem(i18n("Insert")));
#else
	setButtonOK(KStdGuiItem::insert());	
#endif
	setButtonApply(KGuiItem(i18n("Execute")));
#endif	
	mathFunction = f;
	QVBox *box = makeVBoxMainWidget();
	box->setSpacing(12);
	QString titlestr = "<font size=\"5\">";
	titlestr += mathFunction->title(true).c_str();
	titlestr += "</font>";
	new QLabel(titlestr, box);
	int args = 0;
	bool has_vector = false;
	if(mathFunction->args() > 0) {
		args = mathFunction->args();
	} else if(mathFunction->minargs() > 0) {
		args = mathFunction->minargs() + 1;
		has_vector = true;
	} else {
		args = 1;
		has_vector = true;
	}
	QGrid *table = new QGrid(3, box);
	table->setSpacing(6);
	table->setMargin(12);
	table->setFrameStyle(QFrame::Sunken | QFrame::GroupBoxPanel);
	label.resize(args);
	entry.resize(args);
	type_label.resize(args);
	QString argstr, typestr, defstr, argtype;
	//create argument entries
	Argument *arg;
	for(int i = 0; i < args; i++) {
		arg = mathFunction->getArgumentDefinition(i + 1);
		if(!arg || arg->name().empty()) {
			if(args == 1) {
				argstr = i18n("Value:");
			} else {
				argstr = i18n("Argument");
				argstr += " ";
				argstr += QString::number(i + 1);
				argstr += ":";
			}
		} else {
			argstr = arg->name().c_str();
			argstr += ":";
		}
		typestr = "";
		argtype = "";
		defstr = mathFunction->getDefaultValue(i + 1).c_str();
		if(arg && (arg->suggestsQuotes() || arg->type() == ARGUMENT_TYPE_TEXT) && defstr.length() >= 2 && defstr[0] == '\"' && defstr[defstr.length() - 1] == '\"') {
			defstr.remove(0, 1);
			defstr.truncate(defstr.length() - 1);
		}
		label[i] = new QLabel(argstr, table);
		if(arg) {
			switch(arg->type()) {
				case ARGUMENT_TYPE_INTEGER: {
					IntegerArgument *iarg = (IntegerArgument*) arg;
					int min = -1000000, max = 1000000;
					if(iarg->min()) {
						min = iarg->min()->intValue();
					}
					if(iarg->max()) {
						max = iarg->max()->intValue();
					}
					QSpinBox *qsp = new QSpinBox(min, max, 1, table);
					entry[i] = qsp;
					qsp->setButtonSymbols(QSpinBox::PlusMinus);
					int selected_value = 0;
					bool convok = false;
					if(i == 0 && !selected_text.isEmpty()) {
						selected_value = selected_text.toInt(&convok);
					}
					if(convok && selected_value >= min && selected_value <= max) {
						qsp->setValue(selected_value);
					} else if(!mathFunction->getDefaultValue(i + 1).empty()) {
						qsp->setValue(QString(mathFunction->getDefaultValue(i + 1).c_str()).toInt());
					} else if(!arg->zeroForbidden() && min <= 0 && max >= 0) {
						qsp->setValue(0);
					} else {
						if(max < 0) {
							qsp->setValue(max);
						} else if(min <= 1) {
							qsp->setValue(1);
						} else {
							qsp->setValue(min);
						}
					}
					break;
				}
				case ARGUMENT_TYPE_BOOLEAN: {
					QHButtonGroup *bg = new QHButtonGroup(table);
					entry[i] = bg;
					bg->setFrameStyle(QFrame::Plain | QFrame::NoFrame);
					bg->setMargin(0);
					bg->setRadioButtonExclusive(TRUE);
					bg->insert(new QRadioButton(i18n("True"), bg), 1);
					bg->insert(new QRadioButton(i18n("False"), bg), 0);
					QString str = selected_text.stripWhiteSpace();
					if(i == 0 && str == "1") {
						bg->setButton(1);
					} else if(i == 0 && str == "0") {
						bg->setButton(0);
					} else if(defstr == "1") {
						bg->setButton(1);
					} else {
						bg->setButton(0);
					}
					break;
				}
				case ARGUMENT_TYPE_DATA_PROPERTY: {
					if(mathFunction->subtype() == SUBTYPE_DATA_SET) {
						KComboBox *cb = new KComboBox(table);
						entry[i] = cb;
						DataPropertyIter it;
						DataSet *ds = (DataSet*) mathFunction;
						DataProperty *dp = ds->getFirstProperty(&it);
						bool active_set = false;
						while(dp) {
							if(!dp->isHidden()) {
								cb->insertItem(dp->title().c_str());
								if(!active_set && defstr == dp->getName().c_str()) {
									cb->setCurrentItem(cb->count() - 1);
									active_set = true;
								}
							}
							dp = ds->getNextProperty(&it);
						}
						cb->insertItem(i18n("Info"));
						if(!active_set) {
							cb->setCurrentItem(cb->count() - 1);
						}						
						break;
					}
				}
				default: {
					if(i >= mathFunction->minargs() && !has_vector) {
						typestr = "(";
						typestr += i18n("optional");
					}
					argtype = arg->print().c_str();
					if(typestr.isEmpty()) {
						typestr = "(";
					} else if(!argtype.isEmpty()) {
						typestr += " ";
					}
					if(!argtype.isEmpty()) {
						typestr += argtype;
					}
					typestr += ")";		
					if(typestr.length() == 2) {
						typestr = "";
					}
					entry[i] = new KLineEdit(table);
					if(i == 0 && !selected_text.isEmpty()) {
						((KLineEdit*) entry[i])->setText(selected_text);
					} else {
						((KLineEdit*) entry[i])->setText(defstr);
					}
				}
			}
		} else {
			entry[i] = new KLineEdit(table);
			if(i == 0 && !selected_text.isEmpty()) {
				((KLineEdit*) entry[i])->setText(selected_text);
			} else {
				((KLineEdit*) entry[i])->setText(defstr);
			}
		}
		if(typestr.isEmpty() && i >= mathFunction->minargs() && !has_vector) {
			typestr = "(";
			typestr += i18n("optional");
			typestr += ")";			
		}
		if(arg) {
			switch(arg->type()) {		
				case ARGUMENT_TYPE_DATE: {
					typestr.remove(0, 1);
					typestr.remove(typestr.length() - 1, 1);
					type_label[i] = new ButtonWithIndexSignal(typestr, i, table);
					QObject::connect(type_label[i], SIGNAL(clickedWithIndex(int)), this, SLOT(selectDate(int)));
					break;
				}
				case ARGUMENT_TYPE_MATRIX: {
					typestr.remove(0, 1);
					typestr.remove(typestr.length() - 1, 1);
					type_label[i] = new ButtonWithIndexSignal(typestr, i, table);
					QObject::connect(type_label[i], SIGNAL(clickedWithIndex(int)), this, SLOT(insertMatrix(int)));
					break;
				}
				case ARGUMENT_TYPE_VECTOR: {
					typestr.remove(0, 1);
					typestr.remove(typestr.length() - 1, 1);
					type_label[i] = new ButtonWithIndexSignal(typestr, i, table);
					QObject::connect(type_label[i], SIGNAL(clickedWithIndex(int)), this, SLOT(insertVector(int)));
					break;
				}
				case ARGUMENT_TYPE_FILE: {
					typestr.remove(0, 1);
					typestr.remove(typestr.length() - 1, 1);
					type_label[i] = new ButtonWithIndexSignal(typestr, i, table);
					QObject::connect(type_label[i], SIGNAL(clickedWithIndex(int)), this, SLOT(selectFile(int)));
					break;
				}
				default: {
					type_label[i] = new QLabel(typestr, table);
				}
			}
		} else {
			type_label[i] = new QLabel(typestr, table);
		}
		if(i == 0) entry[0]->setFocus();
	}
	//display function description
	if(!mathFunction->description().empty()) {
		QString str = mathFunction->description().c_str();
		str.replace("<", "&lt;");
		str.replace(">", "&gt;");
		str.replace("\n", "<br>");
		KActiveLabel *descrLabel = new KActiveLabel(str, box);
		descrLabel->setAlignment(Qt::AlignJustify);
		enableButtonSeparator(true);
	}
}

QalculateInsertFunctionDialog::~QalculateInsertFunctionDialog() {
}

QString QalculateInsertFunctionDialog::functionExpression() {
	QString str = mathFunction->preferredInputName(printops.abbreviate_names, printops.use_unicode_signs, false, false, &can_display_unicode_string_function, (void*) expressionWidget).name.c_str(), str2;
	str += "(";
	int args = 0;
	if(mathFunction->args() > 0) {
		args = mathFunction->args();
	} else if(mathFunction->minargs() > 0) {
		args = mathFunction->minargs() + 1;
	} else {
		args = 1;
	}
	for(int i = 0; i < args; i++) {
		if(mathFunction->getArgumentDefinition(i + 1) && mathFunction->getArgumentDefinition(i + 1)->type() == ARGUMENT_TYPE_BOOLEAN) {
			if(((QButtonGroup*) entry[i])->id(((QButtonGroup*) entry[i])->selected()) == 1) {
				str2 = "1";
			} else {
				str2 = "0";
			}
		} else if(mathFunction->getArgumentDefinition(i + 1) && mathFunction->getArgumentDefinition(i + 1)->type() == ARGUMENT_TYPE_INTEGER) {
			str2 = ((QSpinBox*) entry[i])->text();
		} else if(mathFunction->subtype() == SUBTYPE_DATA_SET && mathFunction->getArgumentDefinition(i + 1) && mathFunction->getArgumentDefinition(i + 1)->type() == ARGUMENT_TYPE_DATA_PROPERTY) {
			int index = ((KComboBox*) entry[i])->currentItem();
			DataPropertyIter it;
			DataSet *ds = (DataSet*) mathFunction;
			DataProperty *dp = ds->getFirstProperty(&it);
			while(dp) {
				if(!dp->isHidden()) {
					if(index <= 0) break;
					index--;
				}
				dp = ds->getNextProperty(&it);
			}
			if(dp) {
				str2 = dp->getName().c_str();
			} else {
				str2 = "info";
			}
		} else {
			str2 = ((KLineEdit*) entry[i])->text();
		}
		//if the minimum number of function arguments have been filled, do not add anymore if entry is empty
		if(i >= mathFunction->minargs()) {
			str2 = str2.stripWhiteSpace();
		}
		if((i < mathFunction->minargs() || !str2.isEmpty()) && mathFunction->getArgumentDefinition(i + 1) && (mathFunction->getArgumentDefinition(i + 1)->suggestsQuotes() || (mathFunction->getArgumentDefinition(i + 1)->type() == ARGUMENT_TYPE_TEXT && str2.find(CALCULATOR->getComma().c_str()) >= 0))) {
			if(str2.length() < 1 || (str2[0] != '\"' && str[0] != '\'')) {
				str2.insert(0, "\"");
				str2 += "\"";
			}
		}
		if(i > 0) {
			str += CALCULATOR->getComma().c_str();
			str += " ";
		}
		str += str2;
	}
	str += ")";
	return str;
}

void QalculateInsertFunctionDialog::slotOk() {
	accept();
}

void QalculateInsertFunctionDialog::slotApply() {
	done(100);
}

void QalculateInsertFunctionDialog::selectDate(int index) {
	KDialogBase *dialog = new KDialogBase(this, 0, true, i18n("Date"), Ok|Cancel);
	KDatePicker *datePicker;
	QDate date(QDate::fromString(((KLineEdit*) entry[index])->text(), Qt::ISODate));
	if(date.isValid()) datePicker = new KDatePicker(dialog->makeVBoxMainWidget(), date);
	else datePicker = new KDatePicker(dialog->makeVBoxMainWidget());
	if(dialog->exec() == QDialog::Accepted) {
		((KLineEdit*) entry[index])->setText(datePicker->date().toString(Qt::ISODate));
	}
	dialog->deleteLater();
}
void QalculateInsertFunctionDialog::selectFile(int index) {
	QString filename = KFileDialog::getSaveFileName(((KLineEdit*) entry[index])->text(), QString::null, this, i18n("File"));
	if(!filename.isEmpty()) {
		((KLineEdit*) entry[index])->setText(filename);
	}
}
void QalculateInsertFunctionDialog::insertMatrix(int index) {
	QalculateInsertMatrixVectorDialog *d = new QalculateInsertMatrixVectorDialog(this);
	QString str = ((KLineEdit*) entry[index])->text();
	MathStructure mstruct;
	if(!str.isEmpty()) {
		CALCULATOR->parse(&mstruct, CALCULATOR->unlocalizeExpression(str.ascii()));
	}
	if(mstruct.isVector()) {
		str = d->editMatrixVector(&mstruct, false);
	} else {
		str = d->editMatrixVector(NULL, false);
	}
	if(!str.isEmpty()) {
		((KLineEdit*) entry[index])->setText(str);
	}
	d->deleteLater();
}
void QalculateInsertFunctionDialog::insertVector(int index) {
	QalculateInsertMatrixVectorDialog *d = new QalculateInsertMatrixVectorDialog(this);
	QString str = ((KLineEdit*) entry[index])->text();
	MathStructure mstruct;
	if(!str.isEmpty()) {
		CALCULATOR->parse(&mstruct, CALCULATOR->unlocalizeExpression(str.ascii()));
	}
	if(mstruct.isVector()) {
		str = d->editMatrixVector(&mstruct, true);
	} else {
		str = d->editMatrixVector(NULL, true);
	}
	if(!str.isEmpty()) {
		((KLineEdit*) entry[index])->setText(str);
	}
	d->deleteLater();
}

#include "qalculateinsertfunctiondialog.moc"
