/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateperiodictabledialog.h"
#include "qalculate_kde_utils.h"
#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qcolor.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qgrid.h>
#include "qalculatebuttonwithdata.h"
#include <kiconloader.h>
#include <qfontmetrics.h>
#include <kactivelabel.h>
#include <qlineedit.h>

extern PrintOptions printops;
extern QWidget *expressionWidget;

QalculatePeriodicTableDialog::QalculatePeriodicTableDialog(QWidget *parent, const char *name)
		: KDialogBase(parent, name, false, i18n("Periodic Table"), Close, Close, true) {

	actionButton(Close)->setAutoDefault(false);
	actionButton(Close)->setDefault(false);

	grid = new QGridLayout(makeMainWidget(), 11, 20, 0, 1);

	grid->addWidget(new QLabel("1", mainWidget()), 0, 1, Qt::AlignHCenter);
	grid->addWidget(new QLabel("2", mainWidget()), 0, 2, Qt::AlignHCenter);
	grid->addWidget(new QLabel("3", mainWidget()), 0, 4, Qt::AlignHCenter);
	grid->addWidget(new QLabel("4", mainWidget()), 0, 5, Qt::AlignHCenter);
	grid->addWidget(new QLabel("5", mainWidget()), 0, 6, Qt::AlignHCenter);
	grid->addWidget(new QLabel("6", mainWidget()), 0, 7, Qt::AlignHCenter);
	grid->addWidget(new QLabel("7", mainWidget()), 0, 8, Qt::AlignHCenter);
	grid->addWidget(new QLabel("8", mainWidget()), 0, 9, Qt::AlignHCenter);
	grid->addWidget(new QLabel("9", mainWidget()), 0, 10, Qt::AlignHCenter);
	grid->addWidget(new QLabel("10", mainWidget()), 0, 11, Qt::AlignHCenter);
	grid->addWidget(new QLabel("11", mainWidget()), 0, 12, Qt::AlignHCenter);
	grid->addWidget(new QLabel("12", mainWidget()), 0, 13, Qt::AlignHCenter);
	grid->addWidget(new QLabel("13", mainWidget()), 0, 14, Qt::AlignHCenter);
	grid->addWidget(new QLabel("14", mainWidget()), 0, 15, Qt::AlignHCenter);
	grid->addWidget(new QLabel("15", mainWidget()), 0, 16, Qt::AlignHCenter);
	grid->addWidget(new QLabel("16", mainWidget()), 0, 17, Qt::AlignHCenter);
	grid->addWidget(new QLabel("17", mainWidget()), 0, 18, Qt::AlignHCenter);
	grid->addWidget(new QLabel("18", mainWidget()), 0, 19, Qt::AlignHCenter);

	grid->addWidget(new QLabel("1 ", mainWidget()), 1, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("2 ", mainWidget()), 2, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("3 ", mainWidget()), 3, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("4 ", mainWidget()), 4, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("5 ", mainWidget()), 5, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("6 ", mainWidget()), 6, 0, Qt::AlignRight);
	grid->addWidget(new QLabel("7 ", mainWidget()), 7, 0, Qt::AlignRight);

	grid->addWidget(new QLabel("*", mainWidget()), 6, 3, Qt::AlignRight);
	grid->addWidget(new QLabel("**", mainWidget()), 7, 3, Qt::AlignRight);
	grid->addWidget(new QLabel("*", mainWidget()), 9, 3, Qt::AlignRight);
	grid->addWidget(new QLabel("**", mainWidget()), 10, 3, Qt::AlignRight);
	grid->addWidget(new QLabel(" ", mainWidget()), 8, 0);

	DataSet *dc = CALCULATOR->getDataSet("atom");
	if(!dc) {
		return;
	}
	DataObject *e;
	QalculateButtonWithData *e_button;
	QString tip;
	DataProperty *p_xpos = dc->getProperty("x_pos");
	DataProperty *p_ypos = dc->getProperty("y_pos");
	DataProperty *p_weight = dc->getProperty("weight");
	DataProperty *p_number = dc->getProperty("number");
	DataProperty *p_symbol = dc->getProperty("symbol");
	DataProperty *p_class = dc->getProperty("class");
	DataProperty *p_name = dc->getProperty("name");
	int x_pos = 0, y_pos = 0, group = 0;
	QString weight;
	int w = -1;
	for(size_t i = 1; i < 120; i++) {
		e = dc->getObject(i2s(i));
		if(e) {
			x_pos = s2i(e->getProperty(p_xpos));
			y_pos = s2i(e->getProperty(p_ypos));
		}
		if(e && x_pos > 0 && x_pos <= 18 && y_pos > 0 && y_pos <= 10) {
			e_button = new QalculateButtonWithData((void*) e, e->getProperty(p_symbol).c_str(), mainWidget());
			e_button->setFlat(true);
			group = s2i(e->getProperty(p_class));
			switch(group) {
				case 1: {
					e_button->setPaletteBackgroundColor(QColor(0xee, 0xcc, 0xee));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 2: {
					e_button->setPaletteBackgroundColor(QColor(0xdd, 0xcc, 0xee));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 3: {
					e_button->setPaletteBackgroundColor(QColor(0xdd, 0xdd, 0xff));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 4: {
					e_button->setPaletteBackgroundColor(QColor(0xdd, 0xee, 0xff));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 5: {
					e_button->setPaletteBackgroundColor(QColor(0xcc, 0xee, 0xee));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 6: {
					e_button->setPaletteBackgroundColor(QColor(0xbb, 0xff, 0xbb));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 7: {
					e_button->setPaletteBackgroundColor(QColor(0xee, 0xff, 0xdd));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 8: {
					e_button->setPaletteBackgroundColor(QColor(0xff, 0xff, 0xaa));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 9: {
					e_button->setPaletteBackgroundColor(QColor(0xff, 0xdd, 0xaa));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 10: {
					e_button->setPaletteBackgroundColor(QColor(0xff, 0xcc, 0xdd));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
				case 11: {
					e_button->setPaletteBackgroundColor(QColor(0xaa, 0xee, 0xdd));
					e_button->setPaletteForegroundColor(QColor(0, 0, 0));
					break;
				}
			}
			if(w < 0) {
				w = e_button->fontMetrics().width("Uuo") + 12;
			}
			e_button->setFixedWidth(w);
			e_button->setFixedHeight(w);
			if(x_pos > 2) {
				grid->addWidget(e_button, y_pos, x_pos + 1);
			} else {
				grid->addWidget(e_button, y_pos, x_pos);
			}
			tip = e->getProperty(p_number).c_str();
			tip += " ";
			tip += e->getProperty(p_name).c_str();
			weight = e->getPropertyDisplayString(p_weight).c_str();
			if(!weight.isEmpty() && weight != "-") {
				tip += "\n";
				tip += weight;
			}
			QToolTip::add(e_button, tip);
			QObject::connect(e_button, SIGNAL(clickedWithData(void*)), this, SLOT(showElementInfo(void*)));
		}
	}

}
QalculatePeriodicTableDialog::~QalculatePeriodicTableDialog() {}
void QalculatePeriodicTableDialog::showElementInfo(void *e) {
	DataObject *o = (DataObject*) e;
	QalculateElementInfoDialog *dialog = new QalculateElementInfoDialog(o, this);
	dialog->show();
}

QalculateElementInfoDialog::QalculateElementInfoDialog(DataObject *element, QWidget *parent, const char *name) : KDialogBase(parent, name, false, i18n("Element Data"), Close, Close, true) {

	setWFlags(getWFlags() | Qt::WDestructiveClose);
	e = element;
	DataSet *ds = e->parentSet();
	if(!ds) {
		close();
		return;
	}
	QVBox *vbox = makeVBoxMainWidget();
	QVBox *vbox2 = new QVBox(vbox);
	DataProperty *p_number = ds->getProperty("number");
	DataProperty *p_symbol = ds->getProperty("symbol");
	DataProperty *p_class = ds->getProperty("class");
	DataProperty *p_name = ds->getProperty("name");
	QString str = "<div align=\"right\"><font size=4>"; str += e->getProperty(p_number).c_str(); str += "</font></div>";
	new KActiveLabel(str, vbox2);
	str = "<font size=6>"; str += e->getProperty(p_symbol).c_str(); str += "</font>";
	new KActiveLabel(str, vbox2);
	str = "<font size=5>"; str += e->getProperty(p_name).c_str(); str += "</font>  ";
	new KActiveLabel(str, vbox2);

	QalculateButtonWithData *button;
	QGrid *grid = new QGrid(3, Qt::Horizontal, vbox);
	int group = s2i(e->getProperty(p_class));
	if(group > 0) {
		str = "<b>"; str += i18n("Classification"); str += ":"; str += "</b>";
		new QLabel(str, grid);
		switch(group) {
			case ALKALI_METALS: {str = i18n("Alkali Metal"); break;}
			case ALKALI_EARTH_METALS: {str = i18n("Alkaline-Earth Metal"); break;}
			case LANTHANIDES: {str = i18n("Lanthanide"); break;}
			case ACTINIDES: {str = i18n("Actinide"); break;}
			case TRANSITION_METALS: {str = i18n("Transition Metal"); break;}
			case METALS: {str = i18n("Metal"); break;}
			case METALLOIDS: {str = i18n("Metalloid"); break;}
			case NONMETALS: {str = i18n("Non-Metal"); break;}
			case HALOGENS: {str = i18n("Halogen"); break;}
			case NOBLE_GASES: {str = i18n("Noble Gas"); break;}
			case TRANSACTINIDES: {str = i18n("Transactinide"); break;}
			default: {str = i18n("Unknown"); break;}
		}
		new KActiveLabel(str, grid);
		new QFrame(grid);
	}
		
	DataPropertyIter it;
	DataProperty *dp = ds->getFirstProperty(&it);
	QString sval;
	while(dp) {
		if(!dp->isHidden() && dp != p_number && dp != p_class && dp != p_symbol && dp != p_name) {
			sval = e->getPropertyDisplayString(dp).c_str();
			if(!sval.isEmpty()) {
				str = "<b>"; str += dp->title().c_str(); str += ":"; str += "</b>";
				new QLabel(str, grid);
				new KActiveLabel(sval, grid);
				button = new QalculateButtonWithData((void*) dp, QIconSet(SmallIcon("editpaste")), "", grid);
				QObject::connect(button, SIGNAL(clickedWithData(void*)), SLOT(insertElementData(void*)));
			}
		}
		dp = ds->getNextProperty(&it);
	}
}
QalculateElementInfoDialog::~QalculateElementInfoDialog() {}

void QalculateElementInfoDialog::insertElementData(void *data) {
	DataProperty *dp = (DataProperty*) data;
	DataSet *ds = ds = dp->parentSet();
	if(ds) {
		QString str = ds->preferredInputName(printops.abbreviate_names, printops.use_unicode_signs, false, false, &can_display_unicode_string_function, (void*) expressionWidget).name.c_str();
		str += "(";
		str += e->getProperty(ds->getPrimaryKeyProperty()).c_str();
		str += CALCULATOR->getComma().c_str();
		str += " ";
		str += dp->getName().c_str();
		str += ")";
		insert_text_in_expression(str);
	}
}


#include "qalculateperiodictabledialog.moc"
