/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateprecisiondialog.h"

#include <qlabel.h>
#include <qspinbox.h>
#include <klocale.h>
#include <qhbox.h>
#include <kguiitem.h>
#include <qlayout.h>
#include <kpushbutton.h>
#include <kdeversion.h>

QalculatePrecisionDialog::QalculatePrecisionDialog(QWidget *parent, const char *name) : KDialogBase(parent, name, false, i18n("Precision"), Apply | Close, Close, true) {

#if KDE_VERSION_MAJOR < 4 && KDE_VERSION_MINOR < 2
	setButtonApplyText(i18n("Recalculate"));
#else
	setButtonApply(KGuiItem(i18n("Recalculate")));
#endif	
	setMainWidget(new QWidget(this));
	QHBoxLayout *box = new QHBoxLayout(mainWidget());
	box->setSpacing(spacingHint());
	box->addWidget(new QLabel(i18n("Precision:"), mainWidget()));
	precisionBox = new QSpinBox(1, 100000, 1, mainWidget());
	precisionBox->setButtonSymbols(QSpinBox::PlusMinus);
	box->addWidget(precisionBox);

	resize(QSize(300, minimumSizeHint().height()).expandedTo(minimumSizeHint()));

}


QalculatePrecisionDialog::~QalculatePrecisionDialog() {}


#include "qalculateprecisiondialog.moc"
