/***************************************************************************
 $RCSfile: selectprofile.cpp,v $
                             -------------------
    cvs         : $Id: selectprofile.cpp,v 1.3 2005/08/08 14:18:35 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "selectprofile.h"
#include <qbanking/qbplugindescrlist.h>

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#include <gwenhywfar/debug.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif


SelectProfile::SelectProfile(KBanking *kb,
                             const QString &title,
                             GWEN_DB_NODE *profiles,
                             const char *name,
                             QWidget* parent,
                             const char* wname,
                             bool modal,
                             WFlags fl)
:SelectProfileUI(parent, wname, modal, fl)
,_app(kb)
,_profiles(profiles){
  GWEN_DB_NODE *dbT;

  okButton->setEnabled(false);

  dbT=GWEN_DB_GetFirstGroup(_profiles);
  while(dbT) {
    const char *n;
    const char *d;
    QListViewItem *qv=new QListViewItem(profileList);

    n=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
    assert(n);
    d=GWEN_DB_GetCharValue(dbT, "shortDescr", 0, "");
    qv->setText(0, n);
    qv->setText(1, d);
    if (name && n) {
      if (strcasecmp(n, name)==0) {
        profileList->setSelected(qv, TRUE);
        profileList->setCurrentItem(qv);
        okButton->setEnabled(true);
      }
    }
    dbT=GWEN_DB_GetNextGroup(dbT);
  } // while */

  connect((QObject*)profileList, SIGNAL(selectionChanged()),
          this, SLOT(slotSelectionChanged()));

}



SelectProfile::~SelectProfile(){
}



GWEN_DB_NODE *SelectProfile::getSelectedProfile(){
  QListViewItemIterator it(profileList);

  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      QString qs;
      GWEN_DB_NODE *dbT;
      const char *name;

      // got it
      qs=it.current()->text(0);
      name=qs.latin1(); // FIXME: Why doesn't utf8() work here ?
      dbT=GWEN_DB_GetFirstGroup(_profiles);
      while(dbT) {
        const char *n;

        n=GWEN_DB_GetCharValue(dbT, "name", 0, 0);
        assert(n);
        DBG_ERROR(0, "Comparing against: %s", n);
        if (name) {
          if (strcasecmp(n, name)==0) {
            return dbT;
          }
        }
        dbT=GWEN_DB_GetNextGroup(dbT);
      } // while */
    }
  } // for
  return 0;
}



void SelectProfile::slotSelectionChanged(){
  QListViewItemIterator it(profileList);

  for (;it.current();++it) {
    if (it.current()->isSelected()) {
      okButton->setEnabled(true);
      return;
    }
  } // for
  okButton->setEnabled(false);
}








