/***************************************************************************
 $RCSfile: standingorder.h,v $
                             -------------------
    cvs         : $Id: standingorder.h,v 1.2 2005/07/09 16:11:20 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_STANDINGORDER_H
#define KBANKING_STANDINGORDER_H


#include <string>
#include <list>

#include <gwenhywfar/db.h>

#include <aqbanking/transaction.h>

class StandingOrder;


#include "transaction.h"



class StandingOrder: public Transaction {
public:
  StandingOrder();
  StandingOrder(const AB_TRANSACTION *t);
  StandingOrder(const StandingOrder &t);
  StandingOrder(GWEN_DB_NODE *db);
  virtual ~StandingOrder();

  bool toDb(GWEN_DB_NODE *db) const;
  bool fromDb(GWEN_DB_NODE *db);

  AB_TRANSACTION *toBankingTransaction();

  AB_TRANSACTION_PERIOD getPeriod() const ;
  void setPeriod(AB_TRANSACTION_PERIOD p) ;

  int getCycle() const ;
  void setCycle(int i);

  int getExecutionDay() const ;
  void setExecutionDay(int i);

  const GWEN_TIME *getFirstExecutionDate() const;
  void setFirstExecutionDate(const GWEN_TIME *ti);

  const GWEN_TIME *getLastExecutionDate() const;
  void setLastExecutionDate(const GWEN_TIME *ti);

  const GWEN_TIME *getNextExecutionDate() const;
  void setNextExecutionDate(const GWEN_TIME *ti);

private:
  AB_TRANSACTION_PERIOD _period;
  int _cycle;
  int _executionDay;
  GWEN_TIME *_firstExecutionDate;
  GWEN_TIME *_lastExecutionDate;
  GWEN_TIME *_nextExecutionDate;
};








#endif /* KBANKING_STANDINGORDER_H */
