/***************************************************************************
 $RCSfile: report.h,v $
                             -------------------
    cvs         : $Id: report.h,v 1.3 2005/09/01 07:27:38 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef QBANKMANAGER_REPORT_H
#define QBANKMANAGER_REPORT_H


class KBanking;
class Account;
class QWidget;
class Category;

#include <gwenhywfar/db.h>
#include <qstring.h>

#include "transaction.h"
#include "refpointer.h"


/**
 *
 */
class Report {
private:
  KBanking *_app;
  QString _name;

protected:
  static QString tr(const char *s1, const char *s2=0);

public:
  class Day {
  private:
    int _year; int _month; int _day;
    std::list<RefPointer<Transaction> > _transactions;
  public:
    Day(int y, int m, int d);
    ~Day(){};
    int getDay() const { return _day;};
    int getMonth() const { return _month;};
    int getYear() const { return _year;};
    std::list<RefPointer<Transaction> > &transactions();
    void addTransaction(RefPointer<Transaction> t);
    bool operator<(const Day &d);
  };

  class Month {
  public:
  private:
    int _year; int _month;
    std::list<Day*> _days;
  public:
    Month(int y, int m);
    ~Month();
    int getMonth() const { return _month;};
    int getYear() const { return _year;};
    std::list<Day*> &days() {return _days;} ;
    void addDay(Day *d);
    void addTransaction(RefPointer<Transaction> t);
    void gatherTransactions(std::list<RefPointer<Transaction> > &tl);
    bool operator<(const Month &m);
  };

  class Year {
  public:
  private:
    int _year;
    std::list<Month*> _months;
  public:
    Year(int y);
    ~Year();
    int getYear() const { return _year;};
    std::list<Month*> &months() { return _months;};
    void addMonth(Month *m);
    void addTransaction(RefPointer<Transaction> t);
    void gatherTransactions(std::list<RefPointer<Transaction> > &tl);
    bool operator<(const Year &y);
  };

  class AccountData {
  public:
  private:
    Account *_account;
    std::list<Year*> _years;
  public:
    AccountData(Account *a);
    ~AccountData();
    std::list<Year*> &years() { return _years;};
    void addTransaction(RefPointer<Transaction> t);
    void gatherTransactions(std::list<RefPointer<Transaction> > &tl);
    void addYear(Year *y);
    Account *getAccount() { return _account;};
  };

  class CategoryData {
  public:
  private:
    Category *_category;
    std::list<Year*> _years;
    std::string _path;
    AB_VALUE *_value;
  public:
    CategoryData(Category *cat);
    ~CategoryData();
    std::list<Year*> &years() { return _years;};
    void addTransaction(RefPointer<Transaction> t);
    void gatherTransactions(std::list<RefPointer<Transaction> > &tl);
    void addYear(Year *y);
    Category *getCategory() { return _category;};
    const AB_VALUE *getValue() const { return _value;};
    const std::string &getPath() const { return _path;};
  };

  Report(KBanking *app, const QString &name);
  virtual ~Report();

  const QString &name() const;
  KBanking *app() const;

  virtual QString shortDescription();
  virtual QString longDescription();

  virtual bool initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  virtual bool editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  virtual bool useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);

  void addTransaction(std::list<AccountData*> &adl,
                      RefPointer<Transaction> t,
                      bool mixAccounts);
  void freeAccountDataList(std::list<AccountData*> &adl);
  void gatherTransactions(std::list<AccountData*> &adl,
                          std::list<RefPointer<Transaction> > &tl);

  void addTransaction(std::list<CategoryData*> &cdl,
                      RefPointer<Transaction> t);
  void freeCategoryDataList(std::list<CategoryData*> &cdl);
  void gatherTransactions(std::list<CategoryData*> &cdl,
                          std::list<RefPointer<Transaction> > &tl);

  void sortYears(std::list<Report::Year*> &yl);
  void sortMonths(std::list<Report::Month*> &ml);
  void sortDays(std::list<Report::Day*> &dl);
  void sortTransactions(std::list<RefPointer<Transaction> > &tl);
  void sortCategories(std::list<CategoryData*> &dl);

};




#endif // QBANKMANAGER_REPORT_H


