/***************************************************************************
 $RCSfile: categorywidget.cpp,v $
                             -------------------
    cvs         : $Id: categorywidget.cpp,v 1.6 2005/08/31 07:34:26 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "categorywidget.h"
#include "categorylist.h"
#include "category.h"
#include "kbanking.h"
#include "editcategory.h"

#include <qlistview.h>



CategoryWidget::CategoryWidget(QWidget* parent,
                               const char* name,
                               WFlags fl)
:CategoryWidgetUi(parent, name, fl)
,_app(0) {
  categoryListView->setRootIsDecorated(true);
  categoryListView->setSelectionMode(QListView::Single);
  categoryListView->setAllColumnsShowFocus(true);
}



CategoryWidget::~CategoryWidget() {
}





void CategoryWidget::init(KBanking *kb) {
  _app=kb;

  QObject::connect((QObject*)newButton, SIGNAL(clicked()),
                   this, SLOT(slotNew()));
  QObject::connect((QObject*)editButton, SIGNAL(clicked()),
                   this, SLOT(slotEdit()));
  QObject::connect((QObject*)delButton, SIGNAL(clicked()),
                   this, SLOT(slotDelete()));
}




void CategoryWidget::slotNew() {
  Category *cat;

  cat=EditCategory::createCategory(_app, this);
  if (cat) {
    DBG_ERROR(0, "Created new category");
    updateList();
  }
}



void CategoryWidget::updateList() {
  std::string cid;
  Category *cat=categoryListView->getCurrentCategory();
  if (cat)
    cid=cat->getId();

  categoryListView->beginModify();
  categoryListView->clear();
  categoryListView->addCategories(_app->getCategories());
  categoryListView->expandAll();
  if (!cid.empty())
    categoryListView->setCurrentCategory(cid.c_str());
  categoryListView->endModify();
}



void CategoryWidget::slotEdit() {
  Category *cat=categoryListView->getCurrentCategory();
  if (!cat) {
    DBG_ERROR(0, "No selection");
    return;
  }
  if (cat->getParent()==0) {
    DBG_ERROR(0, "Cannot modify firstlevel category");
    return;
  }
  if (EditCategory::editCategory(_app, cat, this)) {
    DBG_ERROR(0, "Modified new category");
    updateList();
  }
}



void CategoryWidget::slotDelete() {
  Category *cat=categoryListView->getCurrentCategory();
  if (!cat) {
    DBG_ERROR(0, "No selection");
    return;
  }
  if (cat->getParent()==0) {
    DBG_ERROR(0, "Cannot modify firstlevel category");
    return;
  }
  _app->removeCategory(cat);
  updateList();
  delete cat;
}



