/***************************************************************************
 $RCSfile: main.cpp,v $
                             -------------------
    cvs         : $Id: main.cpp,v 1.17 2005/08/24 16:52:02 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "mainwindow.h"
#include "kbanking.h"

#include "splash.inc"


#include <qapplication.h>
#include <qmessagebox.h>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/gwenhywfar.h>

#include <qregexp.h>
#include <qvalidator.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include <qpixmap.h>
#include <qsplashscreen.h>



int main(int argc, char **argv) {
  QApplication a(argc, argv);
  MainWindow *mw;
  KBanking *kb;
  int rv;
  const char *s;
  GWEN_ERRORCODE err;
  QTranslator *translator;
  QPixmap splashPixMap(aquamaniac_xpm);
  QSplashScreen *splash=new QSplashScreen(splashPixMap);

  err=GWEN_Init();
  if (!GWEN_Error_IsOk(err)) {
    DBG_ERROR_ERR(0, err);
    return 2;
  }

  GWEN_Logger_Open(0,
                   "QBankManager", 0,
                   GWEN_LoggerTypeConsole,
                   GWEN_LoggerFacilityUser);

  // set loglevels
  s=getenv("LOGLEVEL");
  if (s) {
    GWEN_LOGGER_LEVEL ll;

    ll=GWEN_Logger_Name2Level(s);
    if (ll!=GWEN_LoggerLevelUnknown) {
      GWEN_Logger_SetLevel(0, ll);
      DBG_WARN(0,
               "Overriding loglevel for QBankManager with \"%s\"",
               s);
    }
    else {
      DBG_ERROR(0, "Unknown loglevel \"%s\"",
                s);
    }
  }
  else {
    GWEN_Logger_SetLevel(0, GWEN_LoggerLevelNotice);
  }

  s=getenv("GWEN_LOGLEVEL");
  if (s) {
    GWEN_LOGGER_LEVEL l;

    l=GWEN_Logger_Name2Level(s);
    if (l!=GWEN_LoggerLevelUnknown)
      GWEN_Logger_SetLevel(GWEN_LOGDOMAIN, l);
  }

  splash->show();
  translator=new QTranslator(0);
  QString pkgdatadir = PKGDATADIR;
  if (translator->load(QTextCodec::locale()+QString(".qm"),
                       QString(pkgdatadir + "/" "i18n" "/"))) {
    DBG_INFO(0, "I18N available for your language");
    qApp->installTranslator(translator);
  }
  else {
    DBG_WARN(0, "Internationalisation is not available for your language");
    delete translator;
    translator=0;
  }

  kb=new KBanking("QBankManager");

  splash->message(QWidget::tr("Initializing KBanking..."));
  qApp->processEvents();
  rv=kb->init();
  if (rv) {
    DBG_ERROR(0, "Error on KBanking::init: %d", rv);
    // splash->finish(mw); -- mw not yet assigned
    delete splash;
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }
  mw=new MainWindow(kb);
  splash->message(QWidget::tr("Initializing Main Window..."));
  qApp->processEvents();
  if (!mw->init()) {
    splash->finish(mw);
    delete splash;
    QMessageBox::critical(0,
                          QWidget::tr("Initialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not initialize GUI."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 2;
  }
  kb->setMainWindow(mw);
  mw->setCaption(QWidget::tr("QBankManager - Online Banking (c) 2004 Martin Preuss"));
  splash->message(QWidget::tr("Finishing Display..."));
  while(qApp->hasPendingEvents())
    qApp->processEvents();
  mw->show();
  splash->finish(mw);
  delete splash;
  a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
  rv=a.exec();
  if (!mw->fini()) {
    QMessageBox::critical(0,
                          QWidget::tr("Deinitialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not deinitialize GUI."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 3;
  }
  if (kb->fini()) {
    QMessageBox::critical(0,
                          QWidget::tr("Deinitialization Error"),
                          QWidget::tr("<qt>"
                                      "Could not deinitialize KBanking."
                                      "</qt>"
                                     ),
                          QWidget::tr("Dismiss"));
    return 3;
  }
}


