/***************************************************************************
 $RCSfile: transfer.h,v $
                             -------------------
    cvs         : $Id: transfer.h,v 1.2 2005/03/27 06:52:32 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_TRANSFER_H
#define KBANKING_TRANSFER_H


#include <string>
#include <list>

#include <gwenhywfar/db.h>


class Transfer;


#include "transaction.h"



class Transfer: public Transaction {
public:
  typedef enum {
    StatusUnknown=0,
    StatusEnqueued,
    StatusPending,
    StatusOk,
    StatusError,
    StatusManualOk,
    StatusManualError
  } Status;

  typedef enum {
    TransferType_Unknown=-1,
    TransferType_Simple=0,
    TransferType_DebitNote,
    TransferType_EuTransfer
  } TransferType;

public:
  Transfer(TransferType ty=TransferType_Simple);
  Transfer(const AB_TRANSACTION *t, TransferType ty=TransferType_Simple);
  Transfer(const Transfer &t);
  Transfer(const Transaction &t, TransferType ty=TransferType_Simple);
  Transfer(GWEN_DB_NODE *db);
  virtual ~Transfer();

  GWEN_TYPE_UINT32 getJobId() const;
  void setJobId(GWEN_TYPE_UINT32 id);

  bool toDb(GWEN_DB_NODE *db) const;
  bool fromDb(GWEN_DB_NODE *db);

  static const char *typeToString(TransferType t);
  static TransferType typeFromString(const char *s);

  Status getStatus() const;
  void setStatus(Status st);

  TransferType getTransferType() const;
  void setTransferType(TransferType t);

private:
  GWEN_TYPE_UINT32 _jobId;
  Status _status;
  TransferType _transferType;
  GWEN_TIME *_lastStatusChange;
};








#endif /* KBANKING_TRANSFER_H */
