/***************************************************************************
 $RCSfile: graphreport.h,v $
                             -------------------
    cvs         : $Id: graphreport.h,v 1.7 2006/01/27 06:59:24 aquamaniac Exp $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef QBANKMANAGER_GRAPHREPORT_H
#define QBANKMANAGER_GRAPHREPORT_H


#include "report.h"

#include <qdatetime.h>
#include <qpainter.h>


#define GRAPHREPORT_FLAGS_MARK_X   0x00000001
#define GRAPHREPORT_FLAGS_MARK_Y   0x00000002
#define GRAPHREPORT_FLAGS_CUMULATE 0x00000004
#define GRAPHREPORT_FLAGS_RASTER_Y 0x00000008
#define GRAPHREPORT_FLAGS_ASK_DATA 0x00000010


class GraphReport: public Report {
public:
  static GWEN_TYPE_UINT32 flagsFromDb(GWEN_DB_NODE *db, const char *name);
  static void flagsToDb(GWEN_DB_NODE *db, const char *name,
                        GWEN_TYPE_UINT32 fl);

  typedef enum {
    UnitsDays=0,
    UnitsMonths,
    UnitsYears,
    UnitsUnknown=999
  } Units;
  static Units unitsFromString(const char *s);
  static const char *unitsToString(Units u);

  typedef enum {
    GraphTypePoints=0,
    GraphTypeLines,
    GraphTypeBars,
    GraphTypeUnknown=999
  } GraphType;
  static GraphType graphTypeFromString(const char *s);
  static const char *graphTypeToString(GraphType t);


  typedef enum {
    ValueModeNormal=0,
    ValueModeAbsolute,
    ValueModeUnknown=999
  } ValueMode;
  static ValueMode valueModeFromString(const char *s);
  static const char *valueModeToString(ValueMode m);


  class DsElement {
  private:
    QDate _date;
    QString _text;
    AB_VALUE *_value;
  public:
    DsElement(const QDate &date,
	      const QString &text=QString::null,
              const AB_VALUE *value=0);
    DsElement(const DsElement &e);
    ~DsElement();
    const QDate &getDate() const;
    const QString &getText() const;
    const AB_VALUE *getValue() const;
    void addValue(const AB_VALUE *v);

    void reset();
  };


  class DsDay {
  private:
    DsElement _me;
    std::list<DsElement*> _elements;

  public:
    DsDay(const QDate &date,
	  const QString &text=QString::null);
    ~DsDay();

    void getMinMaxValues(double &minValue, double &maxValue);

    const DsElement &getItsElement() const;
    void addElement(DsElement *e);
    const std::list<DsElement*> &getElements() const;
    void reset();
  };



  class DsMonth {
  private:
    DsElement _me;
    std::list<DsDay*> _days;

  public:
    DsMonth(const QDate &date,
	    const QString &text=QString::null);
    ~DsMonth();

    const DsElement &getItsElement() const;
    void addElement(DsElement *e);

    void getMinMaxValues(double &minValue, double &maxValue);
    void getMinMaxDayValues(double &minValue, double &maxValue);

    DsDay *findDay(const QDate &date);
    DsDay *getDay(const QDate &date);
    void addDay(DsDay *d);
    const std::list<DsDay*> &getDays() const;
    void reset();
  };


  class DsYear {
  private:
    DsElement _me;
    std::list<DsMonth*> _months;

  public:
    DsYear(const QDate &date,
	   const QString &text=QString::null);
    ~DsYear();

    const DsElement &getItsElement() const;
    void addElement(DsElement *e);

    DsMonth *findMonth(const QDate &date);
    DsMonth *getMonth(const QDate &date);
    void addMonth(DsMonth *m);
    const std::list<DsMonth*> &getMonths() const;

    void getMinMaxValues(double &minValue, double &maxValue);
    void getMinMaxDayValues(double &minValue, double &maxValue);
    void getMinMaxMonthValues(double &minValue, double &maxValue);

    DsDay *findDay(const QDate &date);
    DsDay *getDay(const QDate &date);
    void addDay(DsDay *d);
    void reset();
  };


  class DsSet {
  private:
    DsElement _me;
    std::list<DsYear*> _years;
    QDate _firstDate;
    QDate _lastDate;
    AB_VALUE *_minValue;
    AB_VALUE *_maxValue;

  public:
    DsSet(const QString &text);
    ~DsSet();

    const DsElement &getItsElement() const;
    void addElement(DsElement *e);

    const QDate &getFirstDate() const;
    const QDate &getLastDate() const;

    void getMinMaxValues(double &minValue, double &maxValue);
    void getMinMaxDayValues(double &minValue, double &maxValue);
    void getMinMaxMonthValues(double &minValue, double &maxValue);
    void getMinMaxYearValues(double &minValue, double &maxValue);

    DsYear *findYear(const QDate &date);
    DsYear *getYear(const QDate &date);
    void addYear(DsYear *y);
    const std::list<DsYear*> getYears() const;

    DsMonth *findMonth(const QDate &date);
    DsMonth *getMonth(const QDate &date);
    void addMonth(DsMonth *m);

    DsDay *findDay(const QDate &date);
    DsDay *getDay(const QDate &date);
    void addDay(DsDay *d);
    void reset();

  };

private:
  /* from profile */
  int _width;
  int _height;
  Units _units;
  ValueMode _valueMode;
  GraphType _graphType;
  GWEN_TYPE_UINT32 _flags;

  /* calculated */
  double _minValue;
  double _maxValue;

  QDate _firstDate;
  QDate _lastDate;

  int _nullX;
  int _nullY;

  double _yStep;

  double _stretchY;
  double _ptsPerUnit;
  int _unitWidth;
  int _unitOffset;
  int _unitCount;

public:
  GraphReport(KBanking *app);
  ~GraphReport();

  QString shortDescription();
  QString longDescription();

  bool initProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool editProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);
  bool useProfile(GWEN_DB_NODE *dbProfile, QWidget *parent);

protected:
  int dateToX(const QDate &d);
  int valueToY(double d);
  void addDataSet(GraphReport::DsSet &ds);
  void setup();

  void drawCoordSystem(QPainter *qp);
  void drawCoordXMarksDays(QPainter *qp);
  void drawCoordXMarksMonths(QPainter *qp);

  void drawDataSet(QPainter *qp, DsSet &ds);
};



#endif // QBANKMANAGER_GRAPHREPORT_H

