/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: editsummaryreport.cpp 365 2006-01-24 01:01:49Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editsummaryreport.h"
#include "kbanking.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>




EditSummaryReport::EditSummaryReport(KBanking *kb,
                                     GWEN_DB_NODE *dbProfile,
                                     QWidget* parent,
                                     const char* name,
                                     bool modal,
                                     Qt::WFlags fl)
:EditSummaryReportUi(parent, name, modal, fl)
,_dbProfile(dbProfile) {
  _profileToGui(_dbProfile);
}



EditSummaryReport::~EditSummaryReport(){
}



void EditSummaryReport::_profileToGui(GWEN_DB_NODE *db){
  const char *s;
  int i;

  s=GWEN_DB_GetCharValue(db, "name", 0, 0);
  if (s)
    nameEdit->setText(QString::fromUtf8(s));

  s=GWEN_DB_GetCharValue(db, "shortDescr", 0, 0);
  if (s)
    descrEdit->setText(QString::fromUtf8(s));

  s=GWEN_DB_GetCharValue(db, "defaultCurrency", 0, 0);
  if (s)
    defaultCurrencyEdit->setText(QString::fromUtf8(s));

  i=GWEN_DB_GetIntValue(db, "sortByMonth", 0, 0);
  byMonthCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showAccountBalance", 0, 0);
  accountBalanceCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useColours", 0, 0);
  coloursCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "border", 0, 0);
  borderCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useAccountName", 0, 0);
  accountNameCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "useBankName", 0, 0);
  bankNameCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showDays", 0, 0);
  showDaysCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "mixAccounts", 0, 0);
  mixAccountsCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "calcRealBalance", 0, 0);
  calcRealBalanceCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showIncome", 0, 1);
  showIncomeCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showExpense", 0, 1);
  showExpenseCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showBalance", 0, 1);
  showBalanceCheck->setChecked(i);

  i=GWEN_DB_GetIntValue(db, "showSummedBalance", 0, 1);
  showSummedBalanceCheck->setChecked(i);

}



void EditSummaryReport::_guiToProfile(GWEN_DB_NODE *db){
  std::string s;

  s=KBanking::QStringToUtf8String(nameEdit->text());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "name", s.c_str());

  s=KBanking::QStringToUtf8String(descrEdit->text());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "shortDescr", s.c_str());

  s=KBanking::QStringToUtf8String(defaultCurrencyEdit->text());
  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "defaultCurrency", s.c_str());

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "sortByMonth",
                      (byMonthCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showAccountBalance",
                      (accountBalanceCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useColours",
                      (coloursCheck->isChecked())?1:0);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "border",
                      (borderCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useAccountName",
                      (accountNameCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "useBankName",
                      (bankNameCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showDays",
                      (showDaysCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "mixAccounts",
                      (mixAccountsCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "calcRealBalance",
                      (calcRealBalanceCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showIncome",
                      (showIncomeCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showExpense",
                      (showExpenseCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showBalance",
                      (showBalanceCheck->isChecked())?1:0);

  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                      "showSummedBalance",
                      (showSummedBalanceCheck->isChecked())?1:0);

}



void EditSummaryReport::accept(){
  std::string s;

  s=KBanking::QStringToUtf8String(nameEdit->text());
  if (s.empty()) {
  }
  s=KBanking::QStringToUtf8String(descrEdit->text());
  if (s.empty()) {
  }
  _guiToProfile(_dbProfile);
  return QDialog::accept();
}











