/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: transaction.h 438 2008-06-23 17:45:43Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_TRANSACTION_H
#define KBANKING_TRANSACTION_H


#include <string>
#include <list>

#include <gwenhywfar/db.h>


class Transaction;


#include <aqbanking/transaction.h>



class Transaction {
public:
  Transaction();
  Transaction(const AB_TRANSACTION *t);
  Transaction(const Transaction &t);
  Transaction(GWEN_DB_NODE *db);
  virtual ~Transaction();

  uint32_t getTransactionId() const;
  void setTransactionId(uint32_t id);

  virtual AB_TRANSACTION *toBankingTransaction();

  std::string toHtmlInfo() const;

  const std::string &getLocalCountry() const;
  void setLocalCountry(const std::string &s);

  const std::string &getLocalBankCode() const;
  void setLocalBankCode(const std::string &s);

  const std::string &getLocalAccountNumber() const;
  void setLocalAccountNumber(const std::string &s);

  const std::string &getLocalIban() const;
  void setLocalIban(const std::string &s);

  const std::string &getLocalBic() const;
  void setLocalBic(const std::string &s);

  const std::string &getLocalSuffix() const;
  void setLocalSuffix(const std::string &s);

  const std::string &getLocalName() const;
  void setLocalName(const std::string &s);

  const std::string &getRemoteCountry() const;
  void setRemoteCountry(const std::string &s);

  const std::string &getRemoteBankCode() const;
  void setRemoteBankCode(const std::string &s);

  const std::string &getRemoteBankName() const;
  void setRemoteBankName(const std::string &s);

  const std::string &getRemoteBankLocation() const;
  void setRemoteBankLocation(const std::string &s);

  const std::string &getRemoteIban() const;
  void setRemoteIban(const std::string &s);

  const std::string &getRemoteBic() const;
  void setRemoteBic(const std::string &s);

  const std::string &getRemoteAccountNumber() const;
  void setRemoteAccountNumber(const std::string &s);

  const std::string &getRemoteSuffix() const;
  void setRemoteSuffix(const std::string &s);

  const std::list<std::string> &getRemoteName() const;
  void clearRemoteName();
  void addRemoteName(const std::string &s);

  const GWEN_TIME *getValutaDate() const;
  void setValutaDate(const GWEN_TIME *d);

  const GWEN_TIME *getDate() const;
  void setDate(const GWEN_TIME *d);

  const AB_VALUE *getValue() const;
  void setValue(const AB_VALUE *v);

  const std::string &getTransactionKey() const;
  void setTransactionKey(const std::string &s);

  const std::string &getCustomerReference() const;
  void setCustomerReference(const std::string &s);

  const std::string &getBankReference() const;
  void setBankReference(const std::string &s);

  int getTransactionCode() const;
  void setTransactionCode(int i);

  int getTextKey() const;
  void setTextKey(int i);

  const std::string &getTransactionText() const;
  void setTransactionText(const std::string &s);

  const std::string &getPrimanota() const;
  void setPrimanota(const std::string &s);

  const std::list<std::string> &getPurpose() const;
  void clearPurpose();
  void addPurpose(const std::string &s);

  const std::string &getFiId() const;
  void setFiId(const std::string &s);

  const std::string &getCategory() const;
  void setCategory(const std::string &s);

  const std::string &getHash();

  std::string getHashData();

  const std::string &getPayee() const;
  void setPayee(const std::string &s);

  bool matchFuzzy(const Transaction &t);

  /* threshold 1024 is full match, 0 is complete mismatch */
  bool matchFuzzy(const Transaction &t, uint32_t threshold);

  /** tries to find remote bank code and account id */
  void gatherInfoFromPurpose();

  virtual bool toDb(GWEN_DB_NODE *db) const;
  virtual bool fromDb(GWEN_DB_NODE *db);

  bool modified();
  void setModified(bool m);

  bool operator<(const Transaction &t);

private:
  std::string _localCountry;
  std::string _localBankCode;
  std::string _localIban;
  std::string _localBic;
  std::string _localAccountNumber;
  std::string _localSuffix;
  std::string _localOwnerName;

  std::string _remoteCountry;
  std::string _remoteBankCode;
  std::string _remoteBankName;
  std::string _remoteBankLocation;
  std::string _remoteIban;
  std::string _remoteBic;
  std::string _remoteAccountNumber;
  std::string _remoteSuffix;
  std::list<std::string> _remoteName;

  GWEN_TIME *_valutaDate;
  GWEN_TIME *_date;

  AB_VALUE *_value;

  std::string _transactionKey;
  std::string _customerReference;
  std::string _bankReference;
  int _transactionCode;
  std::string _transactionText;
  std::string _primanota;
  std::list<std::string> _purpose;
  int _textKey;
  std::string _fiid;
  std::string _category;
  std::string _payee;

  std::string _hash;
  uint32_t _transactionId;

  bool _modified;

  std::string _makeHash();
  GWEN_TIME *_transformedDate(const GWEN_TIME *ti);

};








#endif /* KBANKING_TRANSACTION_H */



