/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_EXPORTEDIT_H
#define AQBANKING_KDE_EXPORTEDIT_H

class KBanking;

#include "exportedit.ui.h"
#include "refpointer.h"
#include "transaction.h"

#include <gwenhywfar/db.h>


class ExportEdit: public ExportEditUI {
  Q_OBJECT
public:
  ExportEdit(KBanking *app,
             const char *ruleName=0,
	     QWidget* parent=0,
	     const char* name=0,
	     bool modal=FALSE,
	     WFlags fl=0);
  ExportEdit(KBanking *app,
             GWEN_DB_NODE *dbRule,
             QWidget* parent=0,
             const char* name=0,
             bool modal=FALSE,
             WFlags fl=0);

  ~ExportEdit();

  bool init();
  bool fini();

  GWEN_DB_NODE *getRules();
  GWEN_DB_NODE *getRule();

  const std::list<RefPointer<Transaction> > &getTransactions();

public slots:
  void accept();
  void reject();

  void slotRuleActivated(int idx);

  void slotNewClicked();
  void slotSaveClicked();
  void slotDeleteClicked();

  void slotTransactionsClicked();
  void slotExporterClicked();
  void slotProfileClicked();
  void slotFileClicked();

  void slotFileNameChanged(const QString &qs);

private:
  KBanking *_app;
  GWEN_DB_NODE *_dbRules;
  GWEN_DB_NODE *_dbRule;
  GWEN_DB_NODE *_dbFilter;
  GWEN_DB_NODE *_dbProfile;
  bool _activeRule;
  bool _modifying;
  bool _isShort;
  std::list<RefPointer<Transaction> > _transactions;

  bool _fromDb(GWEN_DB_NODE *db);
  bool _toDb(GWEN_DB_NODE *db);
  void _resetRule();
  void _saveRule();
  void _addRule(GWEN_DB_NODE *dbT);
  void _validate();

};







#endif // AQBANKING_KDE_EXPORTEDIT_H


