/***************************************************************************
  resource.h
  -------------------
  Global application resources. Constants, enumerations and strings.
  -------------------
  Copyright 2006-2007 David Johnson
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <QString>

#define PACKAGE "qbrew"
#define VERSION "0.3.10"

// some stuff to differentiate between platforms
#if defined(Q_WS_X11)
#define QDIR_HOME   QDir::homePath()
#elif defined(Q_WS_MACX)
#define QDIR_HOME   QDir::homePath()
#else
#define QDIR_HOME   QDir::currentPath()
#endif

namespace Resource {

///////////////////////////////////////////////////////////////////
// general application values

const QString TITLE           = "QBrew";
const QString DESCRIPTION     = "A Homebrewer's Recipe Calculator";
const QString COPYRIGHT       = "Copyright 1999-2007";
const QString AUTHOR          = "David Johnson";
const QString AUTHOR_EMAIL    = "david@usermode.org";
const QString CONTRIBUTORS    = "Lee Henderson, "
                                "Rob Hudson, "
                                "Abe Kabakoff, "
                                "Stephen Lowrie, "
                                "Michal Palczewski, "
                                "Kevin Pullin";

const QString READY           = "Ready";

const QChar DEGREE            = QChar(0xB0);  // ISO 8859-1

///////////////////////////////////////////////////////////////////
// file locations and stuff

const QString FILE_EXT           = "qbrew";
const QString FILE_FILTER        = "QBrew files (*.qbrew)";
const QString TEXT_FILTER        = "Text files (*.txt)";
const QString HTML_FILTER        = "HTML files (*.html *htm)";
const QString BEERXML_FILTER     = "BeerXML recipes (*.xml)";
const QString PDF_FILTER         = "PDF files (*.pdf)";
const QString ALL_FILTER         = "All files (*)";
const QString OPEN_FILTER        = FILE_FILTER + ";;"
//                                 + BEERXML_FILTER + ";;"
                                   + ALL_FILTER;
const QString SAVE_FILTER        = FILE_FILTER + ";;"
                                   + ALL_FILTER;
const QString EXPORT_EXT         = "html";
const QString EXPORT_FILTER      = HTML_FILTER + ";;"
                                   + BEERXML_FILTER + ";;"
                                   + PDF_FILTER + ";;"
                                   + TEXT_FILTER;

const QString DATA_FILE           = "qbrewdata";
const QString HELP_FILE          = "handbook-index.html";
const QString PRIMER_FILE        = "primer.html";
const QString DEFAULT_FILE       = "untitled";

// previous valid data formats
const QString RECIPE_PREVIOUS    = "0.1.7";
const QString DATA_PREVIOUS      = "0.3.0";

///////////////////////////////////////////////////////////////////
// configuration strings

const QString CONFGROUP_WINDOW      = "/window";
const QString CONF_WIN_STATUSBAR    = "/statusbar";
const QString CONF_WIN_MAINWINDOW   = "/mainwindow";
const QString CONF_WIN_SIZE         = "/size";

const QString CONFGROUP_GENERAL     = "/general";
const QString CONF_GEN_LOOK_FEEL    = "/lookfeel";
const QString CONF_GEN_SHOW_SPLASH  = "/showsplash";
const QString CONF_GEN_AUTOSAVE     = "/autosave";
const QString CONF_GEN_SAVEINTERVAL = "/saveinterval";
const QString CONF_GEN_AUTOBACKUP   = "/autobackup";
const QString CONF_GEN_LOADLAST     = "/loadlast";
const QString CONF_GEN_RECENTFILES  = "/recentfiles";
const QString CONF_GEN_RECENTNUM    = "/recentnum";

const QString CONFGROUP_RECIPE       = "/recipedefaults";
const QString CONF_RECIPE_BATCH      = "/batch";
const QString CONF_RECIPE_STYLE      = "/style";
const QString CONF_RECIPE_HOPFORM    = "/hopform";
const QString CONF_RECIPE_MASH       = "/mash";

const QString CONFGROUP_CALC         = "/calc";
const QString CONF_CALC_EFFICIENCY   = "/efficiency";
const QString CONF_CALC_MOREY        = "/morey";
const QString CONF_CALC_TINSETH      = "/tinseth";
const QString CONF_CALC_UNITS        = "/units";

//////////////////////////////////////////////////////////////////////////////
// XML Format Strings

const QString tagRecipe             = "recipe";
const QString attrApplication       = "application";
const QString attrGenerator         = "generator";
const QString tagTitle              = "title";
const QString tagBrewer             = "brewer";
const QString tagBatch              = "batch";
const QString attrMash              = "mash";
const QString tagNotes              = "notes";
const QString attrClass             = "class";
const QString classRecipe           = tagRecipe;
const QString classBatch            = tagBatch;

const QString tagDoc                = "qbrewdata"; 
const QString attrVersion           = "version";
const QString tagStyles             = "styles";
const QString tagStyle              = "style";
const QString attrOGLow             = "oglow";
const QString attrOGHigh            = "oghigh";
const QString attrFGLow             = "fglow";
const QString attrFGHigh            = "fghigh";
const QString attrIBULow            = "ibulow";
const QString attrIBUHigh           = "ibuhigh";
const QString attrSRMLow            = "srmlow";
const QString attrSRMHigh           = "srmhigh";
const QString tagGrains             = "grains";
const QString tagGrain              = "grain";
const QString attrQuantity          = "quantity";
const QString attrExtract           = "extract";
const QString attrColor             = "color";
const QString attrUse               = "use";
const QString tagHops               = "hops";
const QString tagHop                = "hop";
const QString attrForm              = "form";
const QString attrAlpha             = "alpha";
const QString attrTime              = "time";
const QString tagMiscIngredients    = "miscingredients"; // TODO: rename
const QString tagMiscIngredient     = "miscingredient";
const QString attrNotes             = "notes";
const QString tagUtilization        = "utilization";
const QString tagEntry              = "entry";
const QString attrUtil              = "util";

// BeerXML Format Strings

// TODO: see if I can use lowercase, converting on the fly during import/export
const QString beerXMLVersion        = "1";
const QString tagRECIPES            = "RECIPES";
const QString tagRECIPE             = "RECIPE";
const QString tagNAME               = "NAME";
const QString tagVERSION            = "VERSION";
const QString tagTYPE               = "TYPE";
const QString tagSTYLE              = "STYLE";
const QString tagBREWER             = "BREWER";
const QString tagBATCHSIZE          = "BATCH_SIZE";
const QString tagEFFICIENCY         = "EFFICIENCY";
const QString tagFERMENTABLES       = "FERMENTABLES";
const QString tagFERMENTABLE        = "FERMENTABLE";
const QString tagHOPS               = "HOPS";
const QString tagHOP                = "HOP";
const QString tagYEASTS             = "YEASTS";
const QString tagYEAST              = "YEAST";
const QString tagMISCS              = "MISCS";
const QString tagMISC               = "MISC";
const QString tagNOTES              = "NOTES";
const QString tagWATERS             = "WATERS";

const QString tagOGMIN              = "OG_MIN";
const QString tagOGMAX              = "OG_MAX";
const QString tagFGMIN              = "FG_MIN";
const QString tagFGMAX              = "FG_MAX";
const QString tagIBUMIN             = "IBU_MIN";
const QString tagIBUMAX             = "IBU_MAX";
const QString tagCOLORMIN           = "COLOR_MIN";
const QString tagCOLORMAX           = "COLOR_MAX";

const QString tagAMOUNT             = "AMOUNT";
const QString tagYIELD              = "YIELD";
const QString tagCOLOR              = "COLOR";

const QString tagALPHA              = "ALPHA";
const QString tagUSE                = "USE";
const QString tagTIME               = "TIME";
const QString tagFORM               = "FORM";

const QString TYPE_EXTRACT          = "Extract";
const QString TYPE_PARTIAL          = "Partial Mash";
const QString TYPE_ALLGRAIN         = "All Grain";

///////////////////////////////////////////////////////////////////
// Misc

const QString UNIT_METRIC           = "Metric";
const QString UNIT_US               = "US";

const QString HOP_PELLET            = "pellet";
const QString HOP_PLUG              = "plug";
const QString HOP_WHOLE             = "whole";

const QString GRAIN_EXTRACT         = "extract";
const QString GRAIN_MASHED          = "mashed";
const QString GRAIN_STEEPED         = "steeped";
const QString GRAIN_OTHER           = "other";

}; // namespace Resource

#endif // RESOURCE_H
